/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mbsa.abc.ban;

import com.dassault.cecilia.lib.ban.BanProcess;
import com.dassault.cecilia.lib.ban.BanProcessException;
import com.dassault.cecilia.lib.ban.Unit;
import com.dassault.cecilia.lib.ban.UnitValued;
import com.dassault.cecilia.lib.ban.launcher.DestinationOutputStream;
import com.dassault.cecilia.lib.ban.launcher.LogExecLayoutSimple;
import com.dassault.cecilia.lib.ban.launcher.LogExecLayoutXML;
import com.dassault.cecilia.lib.ban.launcher.LogExecRecord;
import com.dassault.cecilia.lib.ban.launcher.LogExecRecorder;
import com.dassault.cecilia.lib.ban.type.LayoutDefiner;
import com.dassault.cecilia.lib.ban.type.Param;
import com.dassault.cecilia.lib.ban.type.destination;
import com.dassault.cecilia.lib.ban.util.UtilFileSrc;
import com.dassault.cecilia.lib.ban.util.UtilLaunch;
import com.dassault.cecilia.lib.util.ControllableAction;
import com.dassault.cecilia.lib.util.destination.Destination;
import com.dassault.cecilia.lib.util.destination.DestinationConsole;
import com.dassault.cecilia.lib.util.destination.Layout;
import com.dassault.cecilia.lib.util.io.ProcessLauncher;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public abstract class AltaEngine
extends Unit
implements UnitValued,
LayoutDefiner,
LogExecRecorder,
ControllableAction {
    private static Logger _LOG = Logger.getLogger(AltaEngine.class.getPackage().getName());
    UtilFileSrc _src = new UtilFileSrc();
    String _node = "main";
    UtilLaunch _launch = new UtilLaunch();
    String _failOnError;
    protected List<Param> _params = new ArrayList<Param>();
    protected List<destination> _destinations = new ArrayList<destination>();
    List<Destination> _Dests;
    protected Object _lockerLauncher = new Object();
    protected ProcessLauncher _launcher = null;
    int _result;

    @Override
    public void setProcess(BanProcess process) {
        super.setProcess(process);
        this._src.setProcess(process);
        this._launch.setProcess(process);
    }

    public void setSrcfile(String value) {
        this._src.setFile("srcfile", value);
    }

    public void setSrcref(String value) {
        this._src.setRef("srcref", value);
    }

    public void setNode(String value) {
        this._node = value;
    }

    public File getDir() {
        return this._launch.getDir();
    }

    public long getPriority() {
        return this._launch.getPriority();
    }

    public long getTimeout() {
        return this._launch.getTimeout();
    }

    public void setDir(String value) {
        this._launch.setDir(value);
    }

    public void setExecutable(String value) {
        this._launch.setExecutable(value);
    }

    public void setMemoryout(String value) {
        this._launch.setMemoryout(value);
    }

    public void setPriority(String value) {
        this._launch.setPriority(value);
    }

    public void setTimeout(String value) {
        this._launch.setTimeout(value);
    }

    public void setFailonerror(String value) {
        this._failOnError = value;
    }

    protected boolean failOnError() {
        boolean result = true;
        if (this._failOnError != null) {
            result = this.castBool(this.expanse(this._failOnError), "failonerror");
        }
        return result;
    }

    public Param createParam() {
        Param param = new Param();
        this._params.add(param);
        return param;
    }

    protected Map<String, String> getParams() {
        return Param.mapParams(this._params);
    }

    protected String findOption(Map<String, String> params, String key, String def) {
        String value = null;
        if (params != null) {
            value = params.get(key);
        }
        if (value == null) {
            value = this.getParams().get(key);
        }
        if (value == null) {
            value = def;
        }
        return value;
    }

    public void endValid() {
        this._src.endValid();
        this._launch.endValid();
        if (this._destinations.size() == 0) {
            destination dest = this.createDestination();
            dest.setProcess(this.getProcess());
            dest.setClass(DestinationConsole.class.getName());
        }
    }

    public destination createDestination() {
        destination app = new destination();
        this._destinations.add(app);
        return app;
    }

    @Override
    public Class<? extends Layout> configureLayout(String key, Map<String, String> params) {
        if (key.equals("default") || key.equals("txt")) {
            return LogExecLayoutSimple.class;
        }
        if (key.equals("xml")) {
            return LogExecLayoutXML.class;
        }
        throw new BanProcessException("layout unknow for diff unit : " + key);
    }

    protected void openDestination() {
        this._Dests = new ArrayList<Destination>();
        for (destination dest : this._destinations) {
            this._Dests.add(dest.constructDestination(this));
        }
    }

    @Override
    public void addRecord(LogExecRecord record) {
        if (this._Dests == null) {
            return;
        }
        for (Destination dest : this._Dests) {
            dest.publish(record);
        }
    }

    protected void closeDestination() {
        if (this._Dests == null) {
            return;
        }
        for (Destination dest : this._Dests) {
            dest.close();
        }
        this._Dests = null;
    }

    protected abstract String getIDRoot();

    protected abstract File createXMLScript(File var1) throws IOException;

    protected abstract void findExecutable(ArrayList<String> var1);

    public void executeStdBefore() throws IOException {
    }

    public void executeStdAfter() throws IOException {
    }

    public void executeStdFinally() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeStd() {
        this._result = -1;
        long timeOut = this._launch.getTimeout();
        File dir = this._launch.getDir();
        String id = this.getIDRoot();
        File filemodel = this._src.getSrcFile();
        ArrayList<String> cmds = new ArrayList<String>();
        this.findExecutable(cmds);
        this.openDestination();
        try {
            File filecmd = this.createXMLScript(filemodel);
            cmds.add(filecmd.getAbsolutePath());
            System.out.println(cmds);
            this.executeStdBefore();
            this.addRecord(new LogExecRecord(LogExecRecord.LogType.INFO, "Launch [" + id + "] at " + DateFormat.getDateTimeInstance().format(new Date()) + "\n"));
            this.addRecord(new LogExecRecord(LogExecRecord.LogType.INFO, "//------------------------------------------\n//Trace " + id + " : \n"));
            String[] cmdsArray = new String[1];
            if (cmds.size() > 0) {
                _LOG.fine("Launch execute for " + this.getClass().getSimpleName() + ": " + cmds.get(0).toString());
            }
            Object object = this._lockerLauncher;
            synchronized (object) {
                this._launcher = new ProcessLauncher((OutputStream)new DestinationOutputStream(this, true), (OutputStream)new DestinationOutputStream(this, false), timeOut);
            }
            this._result = this._launcher.exec(cmds.toArray(cmdsArray), null, dir);
            this.addRecord(new LogExecRecord(LogExecRecord.LogType.INFO, "\n//------------------------------------------\n"));
            this.addRecord(new LogExecRecord(LogExecRecord.LogType.INFO, "ExitValue : " + this._result + " at " + DateFormat.getDateTimeInstance().format(new Date()) + "\n\n"));
            if (this._result != 0 && this.failOnError()) {
                throw new BanProcessException(id + " fail on error [result=" + this._result + "]");
            }
            this.executeStdAfter();
        }
        catch (IOException e) {
            this.addRecord(new LogExecRecord(LogExecRecord.LogType.INFO, "//------------------------------------------\n"));
            this.addRecord(new LogExecRecord(e));
            if (this.failOnError()) {
                throw new BanProcessException(id + " : IOException", e);
            }
        }
        finally {
            this.executeStdFinally();
            Object object = this._lockerLauncher;
            synchronized (object) {
                this._launcher = null;
            }
            this.closeDestination();
        }
    }

    @Override
    public void freeResult() {
    }

    @Override
    public Object getResult() {
        return this._result;
    }

    @Override
    public void requestSuspend() {
    }

    @Override
    public void requestResume() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestStop() {
        Object object = this._lockerLauncher;
        synchronized (object) {
            if (this._launcher != null) {
                this._launcher.destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getInfo(String key) {
        if (key.equals("process.msg") || key.equals("process.msg.high")) {
            Object object = this._lockerLauncher;
            synchronized (object) {
                if (this._launcher != null) {
                    return "Current process exec";
                }
            }
        }
        return null;
    }
}

