/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mbsa.inference.ban;

import com.dassault.cecilia.lib.mbsa.StepperException;
import com.dassault.cecilia.lib.mbsa.inference.StepperInference;
import com.dassault.cecilia.lib.mbsa.inference.ban.IEngineWithStepper;
import com.dassault.cecilia.lib.mbsa.stepper.ban.BanTarget;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;

public class IEngineTree
extends IEngineWithStepper {
    @Override
    protected boolean launchEngine(StepperInference stepper, File dst, BanTarget tgt, boolean append) throws StepperException {
        StringWriter writer = new StringWriter(256);
        try {
            writer.write("<");
            this.writeCmdOptions(writer, dst, tgt, append);
            writer.write(">");
            writer.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!stepper.goInitialState()) {
            this.log("Error during initial state", 0);
            return false;
        }
        return stepper.generateTree(writer.toString());
    }

    protected void writeCmdOptions(Writer writer, File dst, BanTarget tgt, boolean append) throws IOException {
        boolean opt;
        Map<String, String> opts = this.getOptions();
        writer.write(" output.file=\"");
        writer.write(tgt.getDstFile().getAbsolutePath());
        writer.write("\" info.file=\"");
        writer.write(dst.getAbsolutePath());
        writer.write("\" info.append=\"");
        writer.write(Boolean.toString(append));
        writer.write("\" target.length=\"1");
        writer.write("\" target.name.1=\"");
        writer.write(tgt.getName());
        writer.write("\" target.value.1=\"");
        writer.write(tgt.getValue());
        boolean rewrite = this.getOpt(opts, "rewrite", "true").equals("true");
        if (rewrite) {
            writer.write("\" rewrite=\"true");
            opt = this.getOpt(opts, "rewrite.not", "false").equals("true");
            writer.write("\" rewrite.not=\"");
            writer.write(Boolean.toString(opt));
            opt = this.getOpt(opts, "rewrite.cardinality", "false").equals("true");
            writer.write("\" rewrite.cardinality=\"");
            writer.write(Boolean.toString(opt));
            opt = this.getOpt(opts, "rewrite.neg", "false").equals("true");
            writer.write("\" rewrite.neg=\"");
            writer.write(Boolean.toString(opt));
        }
        opt = this.getOpt(opts, "generator.loop", "false").equals("true");
        writer.write("\" generator.loop=\"");
        writer.write(opt ? "control" : "none");
        writer.write("\"");
    }

    @Override
    protected void writeCmdExtern(Writer writer, File src, File dst, String model, BanTarget tgt, boolean append) throws IOException {
        writer.write("< action=\"tree");
        writer.write("\" input.file=\"");
        writer.write(src.getAbsolutePath());
        writer.write("\" model=\"");
        writer.write(model);
        writer.write("\" language=\"");
        writer.write("english");
        writer.write("\"");
        this.writeCmdOptions(writer, dst, tgt, append);
        writer.write(">");
    }
}

