/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mbsa.jstepper.v1;

import com.dassault.cecilia.lib.mbsa.jstepper.MsgJStep;
import com.dassault.cecilia.lib.mbsa.jstepper.v1.JCreateException;
import com.dassault.cecilia.lib.mbsa.jstepper.v1.JDefNode;
import com.dassault.cecilia.lib.mbsa.jstepper.v1.JDomain;
import com.dassault.cecilia.lib.mbsa.jstepper.v1.JEnumDomain;
import com.dassault.cecilia.lib.mbsa.jstepper.v1.JRangeDomain;
import com.dassault.cecilia.lib.util.loader.JarClassLoader;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public abstract class JDefArchitecture {
    ArrayList _jDomains = new ArrayList();
    HashMap _jHashEnum2Idx = new HashMap();
    ArrayList _jListEnum = new ArrayList();
    ArrayList _jEnums = new ArrayList();
    ArrayList _jRanges = new ArrayList();
    HashMap _jNameds = new HashMap();
    Map<String, Double> _mapFlowInit = null;
    String _keyIdentify;
    private TreeMap _models = new TreeMap();
    private String _lastKey = null;
    private Class _parentClass = null;

    public JDefArchitecture() {
        this.defineModel();
    }

    protected abstract void defineDomain();

    protected abstract long getUID();

    void addDomain(JDomain dom) {
        this._jDomains.add(dom);
        dom._idx = 10 + this._jDomains.size();
    }

    public JDomain getDomain(int idx) {
        switch (idx) {
            case 0: {
                return JDomain.JBool();
            }
            case 1: {
                return JDomain.JInt();
            }
            case 2: {
                return JDomain.JFloat();
            }
        }
        assert ((idx -= 10) >= 0 && idx <= this._jDomains.size());
        return (JDomain)this._jDomains.get(idx - 1);
    }

    public int getEnumValue(String value) {
        Integer idx = (Integer)this._jHashEnum2Idx.get(value);
        if (idx == null) {
            return -1;
        }
        return idx;
    }

    protected String toEnumString(int idx) {
        if (idx < 0 || idx >= this._jListEnum.size()) {
            return "UndefEnum[" + idx + "]";
        }
        return (String)this._jListEnum.get(idx);
    }

    public JDomain createEnum(String[] enums) {
        int i;
        int[] values = new int[enums.length];
        for (i = 0; i < enums.length; ++i) {
            int val = this.getEnumValue(enums[i]);
            if (val == -1) {
                this._jListEnum.add(enums[i]);
                val = this._jListEnum.size() - 1;
                this._jHashEnum2Idx.put(enums[i], val);
            }
            values[i] = val;
        }
        for (i = 0; i < this._jEnums.size(); ++i) {
            JEnumDomain jDom = (JEnumDomain)this._jEnums.get(i);
            if (!jDom.equivalent(values)) continue;
            return jDom;
        }
        JEnumDomain jDom = new JEnumDomain(this, values);
        this._jEnums.add(jDom);
        this.addDomain(jDom);
        return jDom;
    }

    public JDomain createRange(long min, long max) {
        for (int i = 0; i < this._jRanges.size(); ++i) {
            JRangeDomain jDom = (JRangeDomain)this._jRanges.get(i);
            if (!jDom.equivalent(min, max)) continue;
            return jDom;
        }
        JRangeDomain jDom = new JRangeDomain(min, max);
        this._jRanges.add(jDom);
        this.addDomain(jDom);
        return jDom;
    }

    public void createNamed(String name, JDomain jDom) {
        this._jNameds.put(name, jDom);
    }

    public JDomain getNamed(String name) {
        return (JDomain)this._jNameds.get(name);
    }

    public Map<String, Double> getFlowInit() {
        return this._mapFlowInit;
    }

    public String getIdentify() {
        return this._keyIdentify;
    }

    protected void setIdentify(String ID) {
        this._keyIdentify = ID;
    }

    protected abstract void defineModel();

    protected void addClassModel(String name, Class model) {
        this._models.put(name, model);
        this._lastKey = name;
    }

    public Set getNameModels() {
        return this._models.keySet();
    }

    protected void setClassParent(Class parent) {
        this._parentClass = parent;
    }

    public JDefNode getInstance(String type) throws JCreateException {
        Class myClass;
        if (type == null || type.length() == 0) {
            type = this._lastKey;
        }
        if ((myClass = (Class)this._models.get(type)) == null) {
            throw new JCreateException(MsgJStep.msgFormat("EXC_NODE_UNKNOW", type));
        }
        try {
            this.defineDomain();
            Class[] types = new Class[]{this._parentClass, String.class};
            Object[] parms = new Object[]{this, "main"};
            Constructor myConstruct = myClass.getConstructor(types);
            return (JDefNode)myConstruct.newInstance(parms);
        }
        catch (InvocationTargetException e) {
            StringBuffer sb = new StringBuffer(128);
            sb.append(MsgJStep.msgFormat("EXC_NODE_CREATE", type));
            sb.append("\n\t");
            sb.append(e.getCause().getMessage());
            throw new JCreateException(sb.toString());
        }
        catch (Exception e) {
            throw new JCreateException(e.getClass().getName() + " : " + e.getMessage());
        }
    }

    private static String getMainName(JarClassLoader loader) throws IOException {
        String result;
        Attributes attrs;
        Manifest manifest = loader.getManifest();
        if (manifest != null && (attrs = manifest.getAttributes("JStepper")) != null && (result = attrs.getValue("JStepper-ClassName")) != null) {
            return result;
        }
        throw new IOException("No JStepper-ClassName in manifest");
    }

    public static JDefArchitecture createInstance(String jarPath) throws JCreateException {
        JarClassLoader loader = new JarClassLoader(jarPath, JDefArchitecture.class.getClassLoader());
        return JDefArchitecture.createInstance(loader);
    }

    static JDefArchitecture createInstance(JarClassLoader loader) throws JCreateException {
        try {
            String name = JDefArchitecture.getMainName(loader);
            Class cl = loader.loadClass(name);
            Object obj = cl.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            JDefArchitecture result = (JDefArchitecture)obj;
            InputStream flowInitStream = loader.getResourceAsStream("InitFlow.bin");
            if (flowInitStream != null) {
                DataInputStream input = new DataInputStream(flowInitStream);
                result._mapFlowInit = new LinkedHashMap<String, Double>();
                try {
                    while (true) {
                        String key = input.readUTF();
                        double value = input.readDouble();
                        result._mapFlowInit.put(key, value);
                    }
                }
                catch (EOFException eOFException) {
                    // empty catch block
                }
            }
            return result;
        }
        catch (Exception e) {
            throw new JCreateException(e.getClass().getName() + " - " + e.getMessage());
        }
    }
}

