/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mbsa.jstepper.v1;

import com.dassault.cecilia.lib.mbsa.StepperViolatedAssertionException;
import com.dassault.cecilia.lib.mbsa.jstepper.MsgJStep;
import com.dassault.cecilia.lib.mbsa.jstepper.v1.JCreateException;
import com.dassault.cecilia.lib.mbsa.jstepper.v1.JDefEquipment;
import com.dassault.cecilia.lib.mbsa.jstepper.v1.JEvent;
import com.dassault.cecilia.lib.mbsa.jstepper.v1.JFlowIn;
import com.dassault.cecilia.lib.mbsa.jstepper.v1.JSimulator;
import com.dassault.cecilia.lib.mbsa.jstepper.v1.JTrans;
import com.dassault.cecilia.lib.mbsa.jstepper.v1.JVariable;
import com.dassault.cecilia.lib.util.io.IndentWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public abstract class JDefNode {
    private String _name;
    private JDefEquipment _parent;
    private HashMap _flows;
    private HashMap _events;
    private ArrayList _transs;
    private JSimulator _simulator;
    private String _pathName;
    public int _flag;

    public JDefNode(String name) throws JCreateException {
        this(name, null);
    }

    public JDefNode(String name, JDefEquipment parent) throws JCreateException {
        this._name = name;
        this._parent = parent;
        this._pathName = null;
        this._flag = 0;
        this.create();
        this.defineData();
    }

    protected void create() {
        this._flows = new HashMap();
        this._events = new HashMap();
        this._transs = new ArrayList(3);
    }

    protected abstract void defineData() throws JCreateException;

    public abstract void doAssert() throws StepperViolatedAssertionException;

    public abstract int doInitAssert() throws StepperViolatedAssertionException;

    public abstract void print(IndentWriter var1) throws IOException;

    public String getNodeName() {
        String result = this.getClass().getName();
        int pos = result.indexOf(36);
        if (pos != -1) {
            result = result.substring(pos + 1);
        }
        return result;
    }

    public String getName() {
        return this._name;
    }

    public JDefNode getNode() {
        return this._parent;
    }

    public void getPathName(StringBuffer sb) {
        if (this._parent != null) {
            this._parent.getPathName(sb);
            sb.append(this._name);
            sb.append(".");
        }
    }

    public String getPathName() {
        if (this._simulator == null) {
            StringBuffer sb = new StringBuffer(128);
            if (this._parent != null) {
                this._parent.getPathName(sb);
            }
            sb.append(this.getName());
            return sb.toString();
        }
        return this._pathName;
    }

    public void addFlow(JVariable var) {
        this._flows.put(var.getName(), var);
    }

    public JVariable getFlow(String name) {
        return (JVariable)this._flows.get(name);
    }

    protected void printFlows(IndentWriter out) throws IOException {
        if (this._flows.size() > 0) {
            out.write("Flow\n");
            out.addIndent(1);
            Iterator i = this._flows.values().iterator();
            while (i.hasNext()) {
                ((JVariable)i.next()).print(out);
            }
            out.addIndent(-1);
        }
    }

    public JVariable getState(String name) {
        throw new UnsupportedOperationException();
    }

    public void addEvent(JEvent evt) {
        this._events.put(evt.getName(), evt);
    }

    public JEvent getEvent(String name) {
        return (JEvent)this._events.get(name);
    }

    public void removeEvent(JEvent evt) {
        this._events.remove(evt.getName());
    }

    protected void printEvents(IndentWriter out) throws IOException {
        if (this._events.size() > 0) {
            out.write("Event\n");
            out.addIndent(1);
            Iterator i = this._events.values().iterator();
            while (i.hasNext()) {
                ((JEvent)i.next()).print(out);
            }
            out.addIndent(-1);
        }
    }

    public void addTrans(JTrans tr) {
        this._transs.add(tr);
    }

    public void removeTrans(JTrans tr) {
        this._transs.remove(tr);
    }

    protected void printTranss(IndentWriter out) throws IOException {
        if (this._transs.size() > 0) {
            out.write("Trans\n");
            out.addIndent(1);
            Iterator i = this._transs.iterator();
            while (i.hasNext()) {
                ((JTrans)i.next()).print(out);
            }
            out.addIndent(-1);
        }
    }

    public JVariable getVariable(String name) {
        return this.getFlow(name);
    }

    public JSimulator getSimulator() {
        return this._simulator;
    }

    public void compile(JSimulator simulator) {
        this._simulator = null;
        this._pathName = this.getPathName();
        this._simulator = simulator;
        for (JTrans tr : this._transs) {
            this._simulator.addTrans(tr);
        }
        Iterator<Object> i = this._flows.values().iterator();
        while (i.hasNext()) {
            this._simulator.addFlow((JVariable)i.next());
        }
    }

    public boolean hasFlowInNaN() {
        for (JVariable flow : this._flows.values()) {
            if (!(flow instanceof JFlowIn) || !Double.isNaN(flow.getValue())) continue;
            return true;
        }
        return false;
    }

    public void init(boolean withIn) throws StepperViolatedAssertionException {
        for (JVariable flow : this._flows.values()) {
            flow.init();
            if (!(flow instanceof JFlowIn)) continue;
            withIn = true;
        }
        this.getSimulator().addSimulNode(this);
    }

    public void addSimul() {
        this._simulator.addSimulNode(this);
        if (this._parent != null) {
            this._parent.addSimul();
        }
    }

    public void propageFlag(int value) {
        this._flag = value;
    }

    protected static double not(double arg0) {
        if (Double.isNaN(arg0)) {
            return Double.NaN;
        }
        return 1.0 - arg0;
    }

    protected static double or(double arg0, double arg1) {
        if (Double.isNaN(arg0)) {
            if (Double.isNaN(arg1)) {
                return Double.NaN;
            }
            if (arg1 != 0.0) {
                return 1.0;
            }
            return Double.NaN;
        }
        if (arg0 != 0.0) {
            return 1.0;
        }
        return arg1;
    }

    protected static double and(double arg0, double arg1) {
        if (Double.isNaN(arg0)) {
            if (Double.isNaN(arg1)) {
                return Double.NaN;
            }
            if (arg1 == 0.0) {
                return 0.0;
            }
            return Double.NaN;
        }
        if (arg0 == 0.0) {
            return 0.0;
        }
        return arg1;
    }

    protected static double imply(double arg0, double arg1) {
        if (Double.isNaN(arg0)) {
            return Double.NaN;
        }
        if (arg0 == 0.0) {
            return 1.0;
        }
        return arg1;
    }

    protected static double neg(double arg0) {
        if (Double.isNaN(arg0)) {
            return Double.NaN;
        }
        return -arg0;
    }

    protected static double add(double arg0, double arg1) {
        if (Double.isNaN(arg0) || Double.isNaN(arg1)) {
            return Double.NaN;
        }
        return arg0 + arg1;
    }

    protected static double sub(double arg0, double arg1) {
        if (Double.isNaN(arg0) || Double.isNaN(arg1)) {
            return Double.NaN;
        }
        return arg0 - arg1;
    }

    protected static double mul(double arg0, double arg1) {
        if (Double.isNaN(arg0) || Double.isNaN(arg1)) {
            return Double.NaN;
        }
        return arg0 * arg1;
    }

    protected static double div(double arg0, double arg1) throws StepperViolatedAssertionException {
        if (Double.isNaN(arg0) || Double.isNaN(arg1)) {
            return Double.NaN;
        }
        if (arg1 == 0.0) {
            throw new StepperViolatedAssertionException(MsgJStep.getString("EXC_STEP_DIVISE_0"));
        }
        return arg0 / arg1;
    }

    protected static double Div(double arg0, double arg1) throws StepperViolatedAssertionException {
        if (arg1 == 0.0) {
            throw new StepperViolatedAssertionException(MsgJStep.getString("EXC_STEP_DIVISE_0"));
        }
        return arg0 / arg1;
    }

    protected static double mod(double arg0, double arg1) throws StepperViolatedAssertionException {
        if (Double.isNaN(arg0) || Double.isNaN(arg1)) {
            return Double.NaN;
        }
        if (arg1 == 0.0) {
            throw new StepperViolatedAssertionException(MsgJStep.getString("EXC_STEP_DIVISE_0"));
        }
        return (long)arg0 % (long)arg1;
    }

    protected static double Mod(long arg0, long arg1) throws StepperViolatedAssertionException {
        if (arg1 == 0L) {
            throw new StepperViolatedAssertionException(MsgJStep.getString("EXC_STEP_DIVISE_0"));
        }
        return arg0 % arg1;
    }

    protected static double eq(double arg0, double arg1) {
        if (Double.isNaN(arg0) || Double.isNaN(arg1)) {
            return Double.NaN;
        }
        return arg0 == arg1 ? 1.0 : 0.0;
    }

    protected static double neq(double arg0, double arg1) {
        if (Double.isNaN(arg0) || Double.isNaN(arg1)) {
            return Double.NaN;
        }
        return arg0 != arg1 ? 1.0 : 0.0;
    }

    protected static double leq(double arg0, double arg1) {
        if (Double.isNaN(arg0) || Double.isNaN(arg1)) {
            return Double.NaN;
        }
        return arg0 <= arg1 ? 1.0 : 0.0;
    }

    protected static double geq(double arg0, double arg1) {
        if (Double.isNaN(arg0) || Double.isNaN(arg1)) {
            return Double.NaN;
        }
        return arg0 >= arg1 ? 1.0 : 0.0;
    }

    protected static double lt(double arg0, double arg1) {
        if (Double.isNaN(arg0) || Double.isNaN(arg1)) {
            return Double.NaN;
        }
        return arg0 < arg1 ? 1.0 : 0.0;
    }

    protected static double gt(double arg0, double arg1) {
        if (Double.isNaN(arg0) || Double.isNaN(arg1)) {
            return Double.NaN;
        }
        return arg0 > arg1 ? 1.0 : 0.0;
    }

    protected static double min(double arg0, double arg1) {
        if (Double.isNaN(arg0) || Double.isNaN(arg1)) {
            return Double.NaN;
        }
        return arg0 < arg1 ? arg0 : arg1;
    }

    protected static double max(double arg0, double arg1) {
        if (Double.isNaN(arg0) || Double.isNaN(arg1)) {
            return Double.NaN;
        }
        return arg0 > arg1 ? arg0 : arg1;
    }

    protected static double ite(double arg0, double arg1, double arg2) {
        if (Double.isNaN(arg0)) {
            return Double.NaN;
        }
        if (arg0 != 0.0) {
            return arg1;
        }
        return arg2;
    }
}

