/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mbsa.jstepper.v1;

import com.dassault.cecilia.lib.mbsa.jstepper.v1.JValue;
import java.util.ArrayList;

class JSimulStep {
    private ArrayList<JValue> _jvalues;
    private double[] _values;
    private int _lastIdx;

    public JSimulStep(int size) {
        this._jvalues = new ArrayList(size);
        this._values = new double[size];
        this._lastIdx = 0;
    }

    public void add(JValue jval, double val) {
        int idx = this._jvalues.indexOf(jval);
        if (idx == -1) {
            this._jvalues.add(jval);
            if (this._lastIdx >= this._values.length) {
                double[] vals = new double[(this._values.length + 1) * 3 / 2];
                System.arraycopy(this._values, 0, vals, 0, this._values.length);
                this._values = vals;
            }
            this._values[this._lastIdx++] = val;
        }
    }

    public void unplay() {
        assert (this._jvalues.size() == this._lastIdx);
        for (int i = 0; i < this._lastIdx; ++i) {
            JValue jval = this._jvalues.get(i);
            jval.setDirectValue(this._values[i]);
        }
    }
}

