/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mbsa.stepuser.error;

import com.dassault.cecilia.lib.mbsa.stepuser.MsgStepUser;
import com.dassault.cecilia.lib.mbsa.translator.MsgTrans;
import com.dassault.cecilia.lib.util.destination.Record;
import java.text.MessageFormat;

public class LogGenRecord
implements Record {
    LogType _type;
    String _keyFormat;
    Object[] _arguments;
    String _msg;
    Exception _exc;

    LogGenRecord() {
    }

    public LogGenRecord(String key, Object ... args) {
        this._type = LogType.INFO;
        this._keyFormat = key;
        this._arguments = args;
    }

    public LogGenRecord(boolean error, String key, Object ... args) {
        this._type = error ? LogType.ERR : LogType.WARN;
        this._keyFormat = key;
        this._arguments = args;
    }

    public LogGenRecord(Exception exc) {
        this._type = LogType.EXC;
        this._exc = exc;
    }

    public LogGenRecord(Exception exc, String key, Object ... args) {
        this._type = LogType.EXC;
        this._exc = exc;
        this._keyFormat = key;
        this._arguments = args;
    }

    public String getMessage() {
        if (this._msg != null) {
            return this._msg;
        }
        if (this._keyFormat != null) {
            try {
                return MessageFormat.format(MsgStepUser.getString(this._keyFormat), this._arguments);
            }
            catch (IllegalArgumentException e) {
                MsgStepUser.LOG.warning(new StringBuffer(512).append("IllegalArgumentException from MessageFormat\nCode : ").append(this._keyFormat).append("\nString : ").append(MsgTrans.getString(this._keyFormat)).toString());
                return MsgTrans.getString(this._keyFormat);
            }
        }
        if (this._exc != null) {
            return this._exc.getMessage();
        }
        return null;
    }

    public String getCodeMsg() {
        return this._keyFormat;
    }

    public Object[] getArgsMsg() {
        return this._arguments;
    }

    public Exception getException() {
        return this._exc;
    }

    public LogType getType() {
        return this._type;
    }

    public static enum LogType {
        INFO,
        WARN,
        ERR,
        EXC;

    }
}

