/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mbsa.stepuser.fmea;

import com.dassault.cecilia.lib.mbsa.Stepper;
import com.dassault.cecilia.lib.mbsa.StepperException;
import com.dassault.cecilia.lib.mbsa.stepuser.StepperInterruptException;
import com.dassault.cecilia.lib.mbsa.stepuser.error.LogGenRecord;
import com.dassault.cecilia.lib.mbsa.stepuser.fmea.TriggerManager;
import com.dassault.cecilia.lib.mbsa.stepuser.model.ModelTargetVar;
import com.dassault.cecilia.lib.mbsa.stepuser.model.ModelTrans;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;

public class Propagate
extends TriggerManager {
    static final int PROP_DEF_ALTALIB_PROPAGE_MAXERROR = 5;
    static final String PROP_ALTALIB_PROPAGE_MAXERROR = "cecilia.mbsa.propagate.MaxError";
    double _maxDelay = 1.0;
    int _maxRank = 100;
    boolean _merge = true;

    public Propagate(Stepper stepper, String title, File result) {
        super(stepper, title, result);
    }

    public void setMaxDelay(double value) {
        this._maxDelay = value;
        if (this._maxDelay < 0.0) {
            this._maxDelay = 0.0;
        }
    }

    public void setMaxRank(int value) {
        this._maxRank = value;
        if (this._maxRank < 1) {
            this._maxRank = 1;
        }
    }

    public void setInstantaneousMerge(boolean value) {
        this._merge = value;
    }

    @Override
    protected void verifyModel() throws StepperException {
        if (this._fmodel != null) {
            super.verifyModel();
        }
    }

    @Override
    protected void printDefine() throws IOException {
        super.printDefine();
        this._writeResult.write("<param name=\"limit.delay\" value=\"");
        this._writeResult.write(Double.toString(this._maxDelay));
        this._writeResult.write("\" />\n");
        this._writeResult.write("<param name=\"limit.rank\" value=\"");
        this._writeResult.write(Integer.toString(this._maxRank));
        this._writeResult.write("\" />\n");
        if (!this._merge) {
            this._writeResult.write("<param name=\"instantaneous.merge\" value=\"false\" />\n");
        }
    }

    private void printBegin() throws IOException {
        this._writeResult.write(this.getXMLHeader());
        this._writeResult.write("<propagategen>\n");
        this._writeResult.addIndent(1);
        this._writeResult.write("<define>\n");
        this._writeResult.addIndent(1);
        this.printDefine();
        this._writeResult.addIndent(-1);
        this._writeResult.write("</define>\n");
        this._writeResult.write("<result>\n");
        this._writeResult.addIndent(1);
    }

    private void printEnd() throws IOException {
        this._writeResult.addIndent(-1);
        this._writeResult.write("</result>\n");
        this.printErrorList();
        this.printDataNode();
        this._writeResult.addIndent(-1);
        this._writeResult.write("</propagategen>\n");
    }

    @Override
    protected void work() throws InterruptedException, IOException, StepperException {
        this.printBegin();
        Iterator iTr = this._transs.iterator();
        ModelTrans tr = null;
        int nbrError = 0;
        int maxError = Integer.getInteger(PROP_ALTALIB_PROPAGE_MAXERROR, 5);
        if (maxError < 1) {
            maxError = 1;
        }
        while (nbrError < maxError && iTr.hasNext()) {
            try {
                while (!this.checkStopped() && iTr.hasNext()) {
                    this.checkSuspended();
                    this._curSeq += 1.0;
                    tr = (ModelTrans)iTr.next();
                    this.printTransBegin(tr);
                    this._stepper.goForward(tr.getIdx());
                    this.propagate();
                    this._stepper.goBackward(1);
                    Iterator iVar = this._states.iterator();
                    while (iVar.hasNext()) {
                        ((ModelTargetVar)iVar.next()).resetMemValue();
                    }
                    iVar = this._flows.iterator();
                    while (iVar.hasNext()) {
                        ((ModelTargetVar)iVar.next()).resetMemValue();
                    }
                    this.printTransEnd(tr);
                }
            }
            catch (StepperException e) {
                this._writeResult.write("<error nbr=\"");
                this._writeResult.write(Integer.toString(nbrError + 1));
                this._writeResult.write("\" msg=\"");
                this._writeResult.write(this.toXML(e.getMessage()));
                this._writeResult.write("\"/>\n");
                this.printTransEnd(tr);
                this.addRecord(new LogGenRecord(e, "PRV_CMD_FMEA_EXC_GEN", nbrError + 1, tr.getName(), tr.getDesc(), e.getMessage()));
                this._stepper.goInitialState();
                Iterator iVar = this._states.iterator();
                while (iVar.hasNext()) {
                    ((ModelTargetVar)iVar.next()).resetMemValue();
                }
                iVar = this._flows.iterator();
                while (iVar.hasNext()) {
                    ((ModelTargetVar)iVar.next()).resetMemValue();
                }
                ++nbrError;
            }
        }
        this.printEnd();
        this._writeResult.close(true);
        this._writeResult = null;
        if (nbrError >= maxError) {
            this.addRecord(new LogGenRecord(true, "PRV_CMD_FMEA_EXC_GEN", nbrError));
            throw new StepperInterruptException();
        }
    }

    protected int nextTransition() {
        int[] scheduler = this._stepper.getSheduler();
        if (scheduler[0] <= 0) {
            return -1;
        }
        return scheduler[1];
    }

    protected void propagate() throws IOException, StepperException {
        int rank = 1;
        int nbrStep = 0;
        do {
            double currentTime = this._stepper.getCurrentTime();
            this._writeResult.write("<rank idx=\"");
            this._writeResult.write(Integer.toString(rank));
            this._writeResult.write("\" time=\"");
            this._writeResult.write(Double.toString(currentTime));
            this._writeResult.write("\" >\n");
            this._writeResult.addIndent(1);
            int nextTr = this.nextTransition();
            while (nextTr != -1 && !(this._stepper.isValidTransition(nextTr) - currentTime > 0.0)) {
                if (!this._merge) {
                    // empty if block
                }
                this._stepper.goForward(nextTr);
                ++nbrStep;
                nextTr = this.nextTransition();
            }
            if (this._merge) {
                Iterator<ModelTargetVar> iVar = this._states.iterator();
                this.printValidTarget(iVar);
                iVar = this._flows.iterator();
                this.printValidTarget(iVar);
            }
            this._writeResult.addIndent(-1);
            this._writeResult.write("</rank>\n");
            if (nextTr == -1 || this._stepper.isValidTransition(nextTr) - currentTime > this._maxDelay) break;
            if (++rank > this._maxRank) {
                throw new StepperException("Current rank is greater than max rank [" + this._maxRank + "]");
            }
            this._stepper.goForward(nextTr);
            ++nbrStep;
        } while (rank <= this._maxRank);
        this._stepper.goBackward(nbrStep);
    }

    @Override
    protected void printValidTarget(Iterator<ModelTargetVar> iVar) throws IOException {
        while (iVar.hasNext()) {
            ModelTargetVar var = iVar.next();
            if (this._chgVal && var.isActive(this._stepper)) continue;
            if (var.getVarType() == 1) {
                this._writeResult.write("<state name=\"");
            } else {
                this._writeResult.write("<flow  name=\"");
            }
            this._writeResult.write(this.toXML(var.getName()));
            this._writeResult.write("\" \tvalue=\"");
            this._writeResult.write(this.toXML(var.getCurStrValue(this._stepper)));
            this._writeResult.write("\"/>\n");
            var.changeMemValue(var.getCurDblValue(this._stepper));
        }
    }
}

