/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mbsa.stepuser.model;

import com.dassault.cecilia.lib.mbsa.Stepper;
import com.dassault.cecilia.lib.mbsa.StepperException;
import com.dassault.cecilia.lib.mbsa.stepuser.MsgStepUser;
import com.dassault.cecilia.lib.mbsa.stepuser.model.ModelTarget;
import java.util.Iterator;

public abstract class ModelTargetVar
implements ModelTarget {
    protected int _idx;
    protected String _name;
    protected String _tgtStrvalue;
    private double _tgtDblValue;
    private double _memValue;

    public ModelTargetVar(String name, int idx) {
        this._name = name;
        this._idx = idx;
        this._tgtStrvalue = null;
        this._tgtDblValue = Double.NaN;
        this._memValue = Double.NaN;
    }

    public void setStrValue(String value) {
        this._tgtStrvalue = value;
    }

    public String getStrValue() {
        return this._tgtStrvalue;
    }

    protected void setTgtValue(double value) {
        this._tgtDblValue = value;
        this._memValue = value;
    }

    public void changeMemValue(double value) {
        this._memValue = value;
    }

    public void resetMemValue() {
        this._memValue = this._tgtDblValue;
    }

    protected double getMemValue() {
        return this._memValue;
    }

    protected double getTgtValue() {
        return this._tgtDblValue;
    }

    @Override
    public String export() {
        return this._name + "." + this._tgtStrvalue;
    }

    public String getName() {
        return this._name;
    }

    public int getIdx() {
        return this._idx;
    }

    public abstract String getCurStrValue(Stepper var1);

    public abstract double getCurDblValue(Stepper var1);

    public abstract int getVarType();

    protected abstract int getDomain(Stepper var1);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void verifyValue(Stepper stepper) throws StepperException {
        if (!stepper.withDomain()) throw new StepperException("Warning : Stepper without Domain : value not verify");
        int idxDom = this.getDomain(stepper);
        if (idxDom < 0) {
            throw new StepperException(MsgStepUser.msgFormat("ERR_INVALID_DOMAIN", this._name));
        }
        if (idxDom == 0) {
            if (this._tgtStrvalue.equalsIgnoreCase("true")) {
                this.setTgtValue(1.0);
                return;
            } else {
                if (!this._tgtStrvalue.equalsIgnoreCase("false")) throw new StepperException(MsgStepUser.msgFormat("ERR_DOMAIN_VALUE", this._name, this._tgtStrvalue, "bool"));
                this.setTgtValue(0.0);
            }
            return;
        } else if (idxDom == 1) {
            try {
                this.setTgtValue(Integer.parseInt(this._tgtStrvalue));
                return;
            }
            catch (NumberFormatException e) {
                throw new StepperException(MsgStepUser.msgFormat("ERR_DOMAIN_VALUE", this._name, this._tgtStrvalue, "int"));
            }
        } else if (idxDom == 2) {
            try {
                this.setTgtValue(Double.parseDouble(this._tgtStrvalue));
                return;
            }
            catch (NumberFormatException e) {
                throw new StepperException(MsgStepUser.msgFormat("ERR_DOMAIN_VALUE", this._name, this._tgtStrvalue, "float"));
            }
        } else {
            Iterator<String> i = stepper.getValuesOfDomain(idxDom).iterator();
            while (i.hasNext()) {
                if (!this._tgtStrvalue.equals(i.next())) continue;
                return;
            }
            throw new StepperException(MsgStepUser.msgFormat("ERR_DOMAIN_VALUE", this._name, this._tgtStrvalue, "Enum || Interval]"));
        }
    }
}

