/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mbsa.stepuser.seqgen;

import com.dassault.cecilia.lib.mbsa.stepuser.error.LogGenLayoutSimple;
import com.dassault.cecilia.lib.mbsa.stepuser.error.LogGenRecord;
import com.dassault.cecilia.lib.mbsa.stepuser.model.ModelTrans;
import com.dassault.cecilia.lib.mbsa.stepuser.seqgen.FormatSeqs;
import com.dassault.cecilia.lib.mbsa.stepuser.seqgen.ResultSet;
import com.dassault.cecilia.lib.mbsa.stepuser.seqgen.SeqGenTarget;
import com.dassault.cecilia.lib.mbsa.stepuser.seqgen.SeqGenerator;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;

public class FormatSeqsMCS
implements FormatSeqs {
    static Map<String, String> __LayoutConfig = new HashMap<String, String>();

    @Override
    public void printResult(ResultSet set, Writer out, SeqGenTarget tgt, SeqGenerator generator) throws IOException {
        Map<Integer, Integer> orders;
        boolean error = false;
        if (generator != null) {
            Iterator<LogGenRecord> iError = generator.getErrorList().iterator();
            if (iError.hasNext()) {
                out.write("/* Errors : \n");
                LogGenLayoutSimple layout2 = new LogGenLayoutSimple();
                layout2.configure(__LayoutConfig);
                while (iError.hasNext()) {
                    out.write(layout2.format(iError.next()));
                }
                out.write("*/\n\n");
                error = true;
            }
            if (Boolean.getBoolean("cecilia.mbsa.seqgen.DisplayResultsWithError")) {
                error = false;
            }
        }
        if (!error && (orders = set.getOrders()) != null && orders.size() > 0) {
            out.write("/*\n");
            out.write("orders(");
            out.write(set.getShortName());
            out.write("('");
            out.write(tgt.toString());
            out.write("')) = \n");
            out.write("orders\tproduct-number\n");
            int total = 0;
            for (Integer order : new TreeSet<Integer>(orders.keySet())) {
                int nbr = orders.get(order);
                out.write(Integer.toString(order));
                out.write("\t");
                out.write(Integer.toString(nbr));
                out.write("\n");
                total += nbr;
            }
            out.write("total\t");
            out.write(Integer.toString(total));
            out.write("\n");
            out.write("end\n");
            out.write("*/\n");
        }
        out.write("products(");
        out.write(set.getShortName());
        out.write("('");
        out.write(tgt.toString());
        out.write("')) = \n");
        if (error) {
            out.write("{}\n");
        } else {
            Iterator iTrs = set.getSeqIterator();
            while (iTrs.hasNext()) {
                ModelTrans[] cut = (ModelTrans[])iTrs.next();
                out.write("{");
                for (int j = 0; j < cut.length; ++j) {
                    if (j > 0) {
                        out.write(", ");
                    }
                    out.write(cut[j].toString());
                }
                out.write("}\n");
            }
        }
        out.write("end\n");
    }

    static {
        __LayoutConfig.put("Compute", "false");
        __LayoutConfig.put("Info", "false");
        __LayoutConfig.put("Warning", "false");
    }
}

