/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mbsa.stepuser.seqgen;

import com.dassault.cecilia.lib.distrib.entityinfo.InfoAppList;
import com.dassault.cecilia.lib.distrib.entityinfo.InfoPeerApp;
import com.dassault.cecilia.lib.distrib.entityinfo.InfoServerApp;
import com.dassault.cecilia.lib.distrib.jxtautility.JXTARuntimeException;
import com.dassault.cecilia.lib.distrib.peers.CECILIAClient;
import com.dassault.cecilia.lib.distrib.request.ReqAutomatonClient;
import com.dassault.cecilia.lib.distrib.request.ReqState;
import com.dassault.cecilia.lib.distrib.request.Request;
import com.dassault.cecilia.lib.mbsa.StepperException;
import com.dassault.cecilia.lib.mbsa.stepper.BanStepper;
import com.dassault.cecilia.lib.mbsa.stepuser.MsgStepUser;
import com.dassault.cecilia.lib.mbsa.stepuser.StepperInterruptException;
import com.dassault.cecilia.lib.mbsa.stepuser.error.LogGenComputeRecord;
import com.dassault.cecilia.lib.mbsa.stepuser.error.LogGenLayoutXML;
import com.dassault.cecilia.lib.mbsa.stepuser.error.LogGenRecord;
import com.dassault.cecilia.lib.mbsa.stepuser.model.ModelTrans;
import com.dassault.cecilia.lib.mbsa.stepuser.seqgen.SeqFinder;
import com.dassault.cecilia.lib.mbsa.stepuser.seqgen.SeqGame;
import com.dassault.cecilia.lib.mbsa.stepuser.seqgen.SeqGenAbstract;
import com.dassault.cecilia.lib.mbsa.stepuser.seqgen.SeqGenTarget;
import com.dassault.cecilia.lib.mbsa.stepuser.seqgen.SeqGenerator;
import com.dassault.cecilia.lib.mbsa.stepuser.seqgen.StepperInterruptInternalException;
import com.dassault.cecilia.lib.mbsa.translator.model.IndentWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.zip.ZipInputStream;

public class SeqGeneratorDistributed
extends SeqGenAbstract {
    private static final int MAX_GAME_NUMBER = Integer.MAX_VALUE;
    static final String PROP_SEQGEN_DISTRIB_INTERNAL = "cecilia.mbsa.seqgen.distrib.internal";
    static final String PROP_SEQGEN_DISTRIB_KEEP_RESULTS = "cecilia.mbsa.seqgen.distrib.keepresults";
    static final String PROP_SEQGEN_DISTRIB_KEEP_RECORDS = "cecilia.mbsa.seqgen.distrib.keeprecords";
    private BanStepper _srcStepper;
    private SeqGenerator _srcGenerator;
    private File _subSriptFile;
    private ArrayList<File> _subResults;
    private ArrayList<File> _subRecords;
    private Collection<SeqGenTarget> _targets;
    private int _nbTrans;
    private char[] _states;
    private int _nbrMerged;
    private int _nbrFinnished;
    private int _nbrServer;
    private JXTARuntimeException _mergeException;
    private Request[] _requests;
    private int _result = 0;
    private CECILIAClient _distributedClient;
    private static final String BAN_ERRHEADER = "Ban computor Exception : ";

    public SeqGeneratorDistributed(SeqGenerator srcGen, BanStepper stepper) throws IOException {
        this._srcGenerator = srcGen;
        this._targets = new ArrayList<SeqGenTarget>();
        this._srcGenerator.getTarget().getTargets(this._targets);
        this._srcStepper = stepper;
        this._nbTrans = this._srcStepper.getNbrTransition();
        this._subSriptFile = File.createTempFile("tmp", ".subscript");
        this._subSriptFile.deleteOnExit();
        this._subResults = new ArrayList();
        this._subRecords = new ArrayList();
    }

    private void verifyServers() {
        this._distributedClient = CECILIAClient.getCECILIAClient((boolean)true);
        this._nbrServer = this._distributedClient.numberServer();
        if (this._nbrServer == 0) {
            this._distributedClient.refreshNetwork();
            this._nbrServer = this._distributedClient.numberServer();
            if (this._nbrServer == 0) {
                int nbrRefusedServeur = this._distributedClient.getConnexionRefusedPeer().size();
                if (nbrRefusedServeur > 0) {
                    throw new JXTARuntimeException("No compatible server available");
                }
                throw new JXTARuntimeException("No server available");
            }
        }
        boolean internalBan = Boolean.getBoolean(PROP_SEQGEN_DISTRIB_INTERNAL);
        this._nbrServer = 0;
        InfoAppList infoApps = this._distributedClient.getRemoteAppList();
        for (InfoPeerApp app : infoApps) {
            if (!(app instanceof InfoServerApp)) continue;
            InfoServerApp srv = (InfoServerApp)app;
            if (!srv.hasEngine(internalBan ? "iBAN" : "BAN")) continue;
            if (srv.getVersion().equals("1.8.1")) {
                srv.setToBeUSed(false);
                continue;
            }
            if (srv.getVersion().equals("1.8.0")) {
                srv.setToBeUSed(false);
                continue;
            }
            if (!srv.canBeUsedForComputation()) continue;
            ++this._nbrServer;
        }
        if (this._nbrServer == 0) {
            throw new JXTARuntimeException("No compatible server available (version 1.8.2 or more)");
        }
    }

    @Override
    public int execute() throws IOException, StepperException {
        if (this._nbTrans == 0) {
            throw new StepperException("0 transition");
        }
        try {
            File stepperJarFile = this._srcStepper.getSrcFile();
            if (!stepperJarFile.isFile() || !stepperJarFile.canRead()) {
                throw new StepperException("Compiled stepper file not accessible !!");
            }
            this.verifyServers();
            this.createSubScriptSeqGenStepper();
            this.executeSubScriptBanRemote();
            int n = this._result;
            return n;
        }
        finally {
            this.trashTemp();
            this._distributedClient = null;
        }
    }

    @Override
    public void callbackRequestSuspend() {
        if (this._distributedClient != null) {
            this._distributedClient.pauseDistribution();
        }
    }

    @Override
    public void callbackRequestResume() {
        if (this._distributedClient != null) {
            this._distributedClient.resumeDistribution();
        }
    }

    private void createSubScriptSeqGenStepper() throws IOException {
        StringBuffer sb = new StringBuffer();
        IndentWriter writer = new IndentWriter(sb, "\t");
        writer.write("<?xml version=\"1.0\" encoding=\"iso-8859-15\"?>\n");
        writer.write("<process name=\"Distrib.Process\" basedir=\".\">\n");
        writer.addIndent(1);
        writer.write("<stepper class=\"");
        writer.write(this._srcStepper.getSrcReader().getClass().getName());
        writer.write("\"\n");
        writer.addIndent(1);
        writer.write(" srcfile=\"${dban.basedir}/${dban.stepper.jarsrc}\"\n");
        writer.write(" id=\"distribStepper\">\n");
        Map<String, String> stepperParams = this._srcStepper.getSrcParams();
        for (Map.Entry<String, String> entry : stepperParams.entrySet()) {
            writer.write("<param name=\"");
            writer.write(entry.getKey());
            writer.write("\" value=\"");
            writer.write(entry.getValue());
            writer.write("\"/>\n");
        }
        writer.addIndent(-1);
        writer.write("</stepper>\n");
        for (int i = 0; i < this._targets.size(); ++i) {
            writer.write("<set name=\"temp.seqgen.output.");
            writer.write(Integer.toString(i));
            writer.write("\"> <ftemp id=\"temp.seqgen.id.");
            writer.write(Integer.toString(i));
            writer.write("\" prefix=\"dban_seqgen\" suffix=\".res\"/> </set>\n");
        }
        writer.write("<set name=\"seqgen.result\">\n");
        writer.addIndent(1);
        writer.write("<seqgenstepper stepper=\"");
        writer.write("distribStepper");
        writer.write("\" initlist=\"${dban.seqgen.initlist}\" playlist=\"${dban.seqgen.playlist}\">\n");
        writer.addIndent(1);
        int cptTgt = 0;
        for (SeqGenTarget tgt : this._targets) {
            writer.write("<target name=\"");
            writer.write(tgt.getName());
            writer.write("\" value=\"");
            writer.write(tgt.getValue());
            writer.write("\" fileref=\"temp.seqgen.id." + cptTgt + "\">\n");
            writer.addIndent(1);
            writer.addIndent(-1);
            writer.write("</target>\n");
            ++cptTgt;
        }
        Map<String, String> map = this._srcGenerator.getParams().getParams();
        String finder = map.get("finder");
        for (Map.Entry<String, String> param : map.entrySet()) {
            String key = param.getKey();
            if (key.equals("distrib")) continue;
            writer.write("<param name=\"");
            writer.write(param.getKey());
            writer.write("\" value=\"");
            if (key.equals(finder + ".order")) {
                int oldOder = Integer.valueOf(param.getValue());
                if (this._nbTrans > 1) {
                    writer.write(String.valueOf(oldOder - 1));
                } else {
                    writer.write(String.valueOf(oldOder));
                }
            } else {
                writer.write(param.getValue());
            }
            writer.write("\"/>\n");
        }
        writer.write("<destination file=\"${dban.basedir}/${dban.stepper.record}\"/>\n");
        writer.addIndent(-1);
        writer.write("</seqgenstepper>\n");
        writer.addIndent(-1);
        writer.write("</set>\n");
        writer.write("<zip destfile=\"${dban.basedir}/${dban.seqgen.results}\" comment=\"Generate by Ban\">\n");
        writer.addIndent(1);
        for (int i = 0; i < this._targets.size(); ++i) {
            writer.write("<zipfileset file=\"%{temp.seqgen.output.");
            writer.write(Integer.toString(i));
            writer.write("}\" fullpath=\"ResultTarget");
            writer.write(Integer.toString(i));
            writer.write(".res\"/>\n");
        }
        writer.addIndent(-1);
        writer.write("</zip>\n");
        writer.addIndent(-1);
        writer.write("</process>\n");
        if (MsgStepUser.LOG.isLoggable(Level.FINEST)) {
            MsgStepUser.LOG.finest(sb.toString());
        }
        FileWriter fw = new FileWriter(this._subSriptFile);
        fw.write(sb.toString());
        fw.flush();
        fw.close();
    }

    private void executeSubScriptBanRemote() throws IOException, StepperException {
        this._srcGenerator.addRecord(new LogGenRecord("MSG_CMD_COMPUTE_LINE", new Object[0]));
        this._srcGenerator.addRecord(new LogGenRecord("MSG_CMD_COMPUTE_TARGET", this._srcGenerator.getTarget().toString()));
        this._srcGenerator._seqFinder.printHeader();
        this._srcGenerator.addRecord(new LogGenRecord("MSG_CMD_COMPUTE_LINE2", new Object[0]));
        final CECILIAClient client = CECILIAClient.getCECILIAClient();
        for (int i = 0; i < this._nbTrans; ++i) {
            File subRes = File.createTempFile("distribRemote_Tr" + i + "_", ".subresult");
            subRes.deleteOnExit();
            this._subResults.add(subRes);
            File subRec = File.createTempFile("distribRemote_Tr" + i + "_", ".subrecord");
            subRec.deleteOnExit();
            this._subRecords.add(subRec);
        }
        File stepperJarFile = this._srcStepper.getSrcFile();
        String jarUniqueName = client.makeUniqueFileID(stepperJarFile.getAbsolutePath(), true);
        client.diffuseFile(stepperJarFile, jarUniqueName);
        String subScriptUniqueName = client.makeUniqueFileID(this._subSriptFile.getAbsolutePath(), true);
        client.diffuseFile(this._subSriptFile, subScriptUniqueName);
        int nbGames = this._srcGenerator._seqFinder.getNbGame(1);
        if (nbGames > Integer.MAX_VALUE) {
            // empty if block
        }
        this._requests = new Request[1];
        if (this._nbTrans > 1) {
            Iterator<SeqGame> games = this._srcGenerator._seqFinder.getGames(1);
            int index = 0;
            ArrayList<Request> requests = new ArrayList<Request>(this._nbTrans);
            while (games.hasNext()) {
                SeqGame game = games.next();
                Request req = this.createBanReq(client, index, subScriptUniqueName, jarUniqueName, game.getPlayString(), game.getInitString());
                req.setPriority(Integer.getInteger("cecilia.jxta.prio_delta_seq", 0).intValue());
                requests.add(req);
                ++index;
            }
            this._requests = requests.toArray(this._requests);
        } else {
            Request req;
            this._requests[0] = req = this.createBanReq(client, 0, subScriptUniqueName, jarUniqueName, this.createFullTransListString(), "\t");
        }
        this._states = new char[this._requests.length];
        for (int i = 0; i < this._states.length; ++i) {
            this._states[i] = '\u0000';
        }
        this._nbrFinnished = 0;
        this._nbrMerged = 0;
        long timer = new Date().getTime();
        Thread finnishThread = new Thread("SeqGeneratorDistrib-Finnish"){

            @Override
            public void run() {
                try {
                    while (SeqGeneratorDistributed.this._nbrFinnished != SeqGeneratorDistributed.this._states.length) {
                        for (int i = 0; i < SeqGeneratorDistributed.this._states.length; ++i) {
                            if (SeqGeneratorDistributed.this._states[i] != '\u0001' || !SeqGeneratorDistributed.this._requests[i].isFinished()) continue;
                            SeqGeneratorDistributed.this._nbrFinnished++;
                            char[] cArray = SeqGeneratorDistributed.this._states;
                            int n = i;
                            cArray[n] = (char)(cArray[n] + '\u0001');
                            SeqGeneratorDistributed.this.requestStop();
                        }
                        1.sleep(100L);
                        SeqGeneratorDistributed.this.requestStop();
                    }
                }
                catch (StepperInterruptException i) {
                }
                catch (InterruptedException e) {
                    SeqGeneratorDistributed.this._mergeException = new JXTARuntimeException("Merging Error :" + e.getMessage(), (Exception)e);
                }
                catch (Exception e) {
                    SeqGeneratorDistributed.this._mergeException = new JXTARuntimeException("Merging Exception :" + e.getMessage(), e);
                }
            }
        };
        finnishThread.setPriority(1);
        finnishThread.start();
        Thread mergeThread = new Thread("SeqGeneratorDistrib-Merge"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    ArrayList<ModelTrans> transs = SeqGeneratorDistributed.this._srcGenerator.getTranss();
                    while (SeqGeneratorDistributed.this._nbrMerged != SeqGeneratorDistributed.this._states.length) {
                        for (int i = 0; i < SeqGeneratorDistributed.this._requests.length; ++i) {
                            if (SeqGeneratorDistributed.this._states[i] != '\u0002' || !SeqGeneratorDistributed.this._requests[i].isFinished()) continue;
                            if (!SeqGeneratorDistributed.hasLoadableResult(SeqGeneratorDistributed.this._requests[i])) {
                                throw new JXTARuntimeException("Request [" + i + "] don't finnish with success : " + SeqGeneratorDistributed.this._requests[i].getState());
                            }
                            File subFile = (File)SeqGeneratorDistributed.this._subResults.get(i);
                            if (!subFile.canRead()) {
                                throw new IOException("SeqGen result file not be loadable for distrib resquest " + i);
                            }
                            try (ZipInputStream stream = null;){
                                stream = new ZipInputStream(new FileInputStream(subFile));
                                int nbrResult = SeqGeneratorDistributed.this._srcGenerator.loadResultSet(stream);
                                if (nbrResult != SeqGeneratorDistributed.this._targets.size()) {
                                    MsgStepUser.LOG.warning("NbrResult error : " + nbrResult);
                                }
                            }
                            if (!Boolean.getBoolean(SeqGeneratorDistributed.PROP_SEQGEN_DISTRIB_KEEP_RESULTS)) {
                                subFile.delete();
                            }
                            try {
                                File recordFile = (File)SeqGeneratorDistributed.this._subRecords.get(i);
                                if (!recordFile.canRead() || recordFile.length() == 0L) continue;
                                InfoPeerApp remoteInfoPeerApp = client.getRemoteAppList().getRemoteInfoPeerApp(SeqGeneratorDistributed.this._requests[i].getServerID());
                                String serveur = remoteInfoPeerApp != null ? remoteInfoPeerApp.getName() : "";
                                String nameTrans = "{}";
                                if (i < transs.size()) {
                                    nameTrans = transs.get(i).getName();
                                }
                                SeqGeneratorDistributed.this._srcGenerator.addRecord(new LogGenComputeRecord("MSG_CMD_SEQ_DISTRIB", SeqGeneratorDistributed.this._requests[i].getShortNumber(), nameTrans, serveur));
                                if (SeqGeneratorDistributed.this._requests[i].getState() != ReqState.FINISHED_SUCCESFULY) {
                                    List<LogGenRecord> records = LogGenLayoutXML.parseLogFile(recordFile);
                                    for (LogGenRecord logGenRecord : records) {
                                        switch (logGenRecord.getType()) {
                                            case ERR: 
                                            case EXC: {
                                                SeqGeneratorDistributed.this._srcGenerator.addError(logGenRecord);
                                            }
                                        }
                                    }
                                }
                            }
                            catch (StepperInterruptInternalException stepperInterruptInternalException) {
                                // empty catch block
                            }
                            char[] cArray = SeqGeneratorDistributed.this._states;
                            int n = i;
                            cArray[n] = (char)(cArray[n] + '\u0001');
                            SeqGeneratorDistributed.this._nbrMerged++;
                            SeqGeneratorDistributed.this.requestStop();
                        }
                        2.sleep(100L);
                        SeqGeneratorDistributed.this.requestStop();
                    }
                }
                catch (StepperInterruptException transs) {
                }
                catch (InterruptedException e) {
                    SeqGeneratorDistributed.this._mergeException = new JXTARuntimeException("Merging Error :" + e.getMessage(), (Exception)e);
                }
                catch (IOException ioe) {
                    SeqGeneratorDistributed.this._mergeException = new JXTARuntimeException("Merging IOError :" + ioe.getMessage(), (Exception)ioe);
                }
                catch (Exception e) {
                    SeqGeneratorDistributed.this._mergeException = new JXTARuntimeException("Merging Exception :" + e.getMessage(), e);
                }
            }
        };
        mergeThread.setPriority(1);
        mergeThread.start();
        try {
            int curIdxDistribReq = 0;
            int maxDistribReq = this._nbrServer * 10;
            while (this._nbrMerged != this._states.length) {
                if (this._mergeException != null) {
                    throw this._mergeException;
                }
                while (curIdxDistribReq >= 0 && curIdxDistribReq - this._nbrFinnished < maxDistribReq) {
                    client.addRequestToStock(this._requests[curIdxDistribReq]);
                    int n = curIdxDistribReq++;
                    this._states[n] = (char)(this._states[n] + '\u0001');
                    if (curIdxDistribReq < this._requests.length) continue;
                    curIdxDistribReq = -1;
                }
                this.requestStopOrResume();
                Thread.sleep(100L);
            }
        }
        catch (StepperInterruptInternalException siie) {
            Request reqTmp = null;
            while ((reqTmp = client.getRequestStock().getNextRequest()) != null) {
                ReqAutomatonClient.fireEvent((Request)reqTmp, (ReqAutomatonClient.EvtClient)ReqAutomatonClient.EvtClient.CANCEL_BY_USER);
            }
            client.remoteStopRequests();
        }
        catch (StepperInterruptException sie) {
            Request reqTmp = null;
            while ((reqTmp = client.getRequestStock().getNextRequest()) != null) {
                ReqAutomatonClient.fireEvent((Request)reqTmp, (ReqAutomatonClient.EvtClient)ReqAutomatonClient.EvtClient.CANCEL_BY_USER);
            }
            client.remoteStopRequests();
            throw sie;
        }
        catch (JXTARuntimeException jre) {
            Request reqTmp = null;
            while ((reqTmp = client.getRequestStock().getNextRequest()) != null) {
                ReqAutomatonClient.fireEvent((Request)reqTmp, (ReqAutomatonClient.EvtClient)ReqAutomatonClient.EvtClient.CANCEL_BY_SOFTWARE);
            }
            client.remoteStopRequests();
            throw jre;
        }
        catch (InterruptedException jre) {
            // empty catch block
        }
        client.removeDiffusedFiles(jarUniqueName);
        client.removeDiffusedFiles(subScriptUniqueName);
        if (this._srcGenerator.getNbrError() < this._srcGenerator.getMaxError()) {
            StringBuffer sb = new StringBuffer(128);
            int nbrFatalError = 0;
            for (Request req : this._requests) {
                if (!SeqGeneratorDistributed.hasRealError(req)) continue;
                if (nbrFatalError == 0) {
                    this._srcGenerator.addRecord(new LogGenRecord("MSG_CMD_SEQ_FINDER_LN", new Object[0]));
                    this._srcGenerator.addRecord(new LogGenRecord("MSG_CMD_COMPUTE_LINE2", new Object[0]));
                }
                if (++nbrFatalError >= 10) continue;
                sb.append("\nRequest Error ").append(nbrFatalError);
                sb.append("\n----------------------------\n");
                sb.append(req.getHistoString(client.getPeerJXTA()));
                sb.append("----------------------------\n");
            }
            if (nbrFatalError > 0) {
                sb.append("Fatal Error : error(s)=").append(nbrFatalError).append("\n");
                throw new JXTARuntimeException(sb.toString());
            }
        }
        this._result = this._srcGenerator.getNbrError();
        timer = new Date().getTime() - timer;
        this._srcGenerator.addRecord(new LogGenRecord("MSG_CMD_SEQ_FINDER_LN", new Object[0]));
        this._srcGenerator.addRecord(new LogGenRecord("MSG_CMD_COMPUTE_LINE2", new Object[0]));
        this._srcGenerator.addRecord(new LogGenRecord("MSG_CMD_SEQ_FINDER_ENDAT", new Date()));
        this._srcGenerator.getTarget().setTransitionsFlag(true);
        int nbrTransUsed = 0;
        for (ModelTrans tr : this._srcGenerator.getTranss()) {
            if (!tr._flag) continue;
            ++nbrTransUsed;
        }
        this._srcGenerator.addRecord(new LogGenRecord("MSG_CMD_SEQ_FINDER_NBRTRANS", nbrTransUsed));
        this._srcGenerator.addRecord(new LogGenRecord("MSG_CMD_COMPUTE_LINE", new Object[0]));
        SeqFinder.displayTime(timer, "MSG_CMD_SEQ_FINDER_DELAY", this._srcGenerator);
        this._srcGenerator.addRecord(new LogGenRecord("MSG_CMD_SEQ_FINDER_LN", new Object[0]));
    }

    private static boolean hasRealError(Request req) {
        if (req.getState() == ReqState.FINISHED_SUCCESFULY) {
            return false;
        }
        if (req.getState() == ReqState.CANCEL_BY_USER) {
            return false;
        }
        if (req.getState() == ReqState.TOO_MANY_ERRORS) {
            return !SeqGeneratorDistributed.isGoodEngineError(req);
        }
        return true;
    }

    private static boolean hasLoadableResult(Request req) {
        if (req.getState() == ReqState.FINISHED_SUCCESFULY) {
            return true;
        }
        return SeqGeneratorDistributed.isGoodEngineError(req);
    }

    private static boolean isGoodEngineError(Request req) {
        if (req.getState() == ReqState.TOO_MANY_ERRORS) {
            int histoSize = req.getHisto().size();
            ReqState prevState = req.getHisto().getIemeState(histoSize - 2);
            if (prevState == ReqState.ENGINE_ERROR) {
                if (req.getInfo().contains(BAN_ERRHEADER)) {
                    return false;
                }
                if (req.getNumberOfErr() > 0) {
                    return true;
                }
            }
        }
        return false;
    }

    private Request createBanReq(CECILIAClient client, int idxReq, String subScriptUniqueName, String jarUniqueName, String playList, String initList) {
        Request req = client.getNewRequest();
        if (Boolean.getBoolean(PROP_SEQGEN_DISTRIB_INTERNAL)) {
            req.setEngine("iBAN");
        } else {
            req.setEngine("BAN");
        }
        StringBuffer userProps = new StringBuffer();
        userProps.append("COMMAND").append("=");
        userProps.append(subScriptUniqueName).append(",");
        userProps.append("dban.seqgen.playlist=");
        userProps.append(playList).append(",");
        userProps.append("dban.seqgen.initlist=");
        userProps.append(initList).append(",");
        userProps.append("dban.stepper.jarsrc=");
        userProps.append(jarUniqueName).append(",");
        File subFileResult = this._subResults.get(idxReq);
        String subresult = client.makeUniqueFileID(subFileResult.getAbsolutePath(), false);
        req.addResultFile(subresult);
        userProps.append("dban.seqgen.results=");
        userProps.append(subresult).append(",");
        File subFileRecord = this._subRecords.get(idxReq);
        String subrecord = client.makeUniqueFileID(subFileRecord.getAbsolutePath(), false);
        req.addResultFile(subrecord);
        userProps.append("dban.stepper.record=");
        userProps.append(subrecord);
        req.setEngineOptions(userProps.toString());
        return req;
    }

    private void trashTemp() {
        if (!Boolean.getBoolean(PROP_SEQGEN_DISTRIB_KEEP_RESULTS)) {
            for (File subResult : this._subResults) {
                subResult.delete();
            }
        }
        if (!Boolean.getBoolean(PROP_SEQGEN_DISTRIB_KEEP_RECORDS)) {
            for (File subRecord : this._subRecords) {
                subRecord.delete();
            }
        }
        this._subSriptFile.delete();
    }

    private String createFullTransListString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 1; i <= this._nbTrans; ++i) {
            if (i != 1) {
                sb.append("\t");
            }
            sb.append(String.valueOf(i));
        }
        return sb.toString();
    }

    @Override
    public String getInfo(String key) {
        if (this._states == null) {
            return null;
        }
        if (key.equals("process.msg.high")) {
            StringBuffer msg = new StringBuffer(10);
            msg.append(this._nbrMerged);
            msg.append("/");
            msg.append(this._states.length);
            return msg.toString();
        }
        if (key.equals("process.p1000")) {
            return Integer.toString((int)((double)this._nbrMerged / (double)this._states.length * 1000.0));
        }
        return null;
    }

    @Override
    protected void requestStop() throws StepperInterruptException {
        super.requestStop();
        if (this._srcGenerator.getNbrError() >= this._srcGenerator.getMaxError()) {
            throw new StepperInterruptInternalException();
        }
    }

    @Override
    protected void requestStopOrResume() throws StepperInterruptException {
        super.requestStopOrResume();
        if (this._srcGenerator.getNbrError() >= this._srcGenerator.getMaxError()) {
            throw new StepperInterruptInternalException();
        }
    }
}

