/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mbsa.stepuser.seqgen;

import com.dassault.cecilia.lib.mbsa.Stepper;
import com.dassault.cecilia.lib.mbsa.StepperException;
import com.dassault.cecilia.lib.mbsa.stepper.BanStepper;
import com.dassault.cecilia.lib.mbsa.stepuser.MsgStepUser;
import com.dassault.cecilia.lib.mbsa.stepuser.StepperInterruptException;
import com.dassault.cecilia.lib.mbsa.stepuser.error.LogGenRecord;
import com.dassault.cecilia.lib.mbsa.stepuser.model.ModelTrans;
import com.dassault.cecilia.lib.mbsa.stepuser.seqgen.ResultSet;
import com.dassault.cecilia.lib.mbsa.stepuser.seqgen.ResultSetFactory;
import com.dassault.cecilia.lib.mbsa.stepuser.seqgen.SeqFinder;
import com.dassault.cecilia.lib.mbsa.stepuser.seqgen.SeqGame;
import com.dassault.cecilia.lib.mbsa.stepuser.seqgen.SeqGenAbstract;
import com.dassault.cecilia.lib.mbsa.stepuser.seqgen.SeqGenerator;
import com.dassault.cecilia.lib.mbsa.stepuser.seqgen.SeqParameters;
import com.dassault.cecilia.lib.mbsa.stepuser.seqgen.StepperInterruptInternalException;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class SeqGeneratorThreaded
extends SeqGenAbstract {
    private BanStepper _srcStepper;
    private SeqGenerator _srcGenerator;
    private Object _lockAddRecord = new Object();
    int _idxThread = 1;
    List<Stepper> _availableSteppers = new ArrayList<Stepper>();
    int _maxGenerators = 2;
    List<SubGenerator> _currentGenerators = new LinkedList<SubGenerator>();
    final Object _syncWait = new Object();
    int _nbrGame = 0;
    int _maxGame = -1;

    public SeqGeneratorThreaded(SeqGenerator srcGen, BanStepper stepper) {
        this._srcGenerator = srcGen;
        this._srcStepper = stepper;
    }

    private Stepper getAvailableStepper() throws StepperException {
        int nbrStepper = this._availableSteppers.size();
        if (nbrStepper > 0) {
            return this._availableSteppers.remove(nbrStepper - 1);
        }
        BanStepper stepper = new BanStepper();
        stepper.configure(this._srcStepper.getSrcFile(), this._srcStepper.getSrcReader(), this._srcStepper.getSrcParams());
        return stepper.getOwnerStepper();
    }

    private int waitAvailableGenerators(boolean all) throws InterruptedException, StepperException {
        int curResult = 0;
        ListIterator<SubGenerator> iter = null;
        while (this._currentGenerators.size() > 0) {
            if (!all && this._currentGenerators.size() < this._maxGenerators) {
                return curResult;
            }
            Thread.sleep(100L);
            this.requestStopOrResume();
            iter = this._currentGenerators.listIterator();
            while (iter.hasNext()) {
                SubGenerator subGen = iter.next();
                if (subGen.isAlive()) continue;
                if (subGen._subException != null) {
                    throw subGen._subException;
                }
                curResult += subGen._subResult;
                ++this._nbrGame;
                this._availableSteppers.add(subGen._subStepper);
                iter.remove();
            }
        }
        return curResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int execute() throws StepperException {
        try {
            File stepperJarFile = this._srcStepper.getSrcFile();
            if (stepperJarFile == null || !stepperJarFile.isFile() || !stepperJarFile.canRead()) {
                throw new StepperException("Compiled stepper file not accessible !!");
            }
            String strMaxGenerator = this._srcGenerator.getParams().getParam("threaded.max");
            if (strMaxGenerator != null && strMaxGenerator.trim().length() > 0) {
                try {
                    this._maxGenerators = Integer.parseInt(strMaxGenerator);
                    if (this._maxGenerators < 1) {
                        throw new NumberFormatException("Number generator must be greater than 0");
                    }
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                    this._maxGenerators = 2;
                }
            }
            this.computeResultSet();
            int n = this._srcGenerator.getNbrError();
            return n;
        }
        finally {
            for (Stepper stepper : this._availableSteppers) {
                stepper.dispose();
            }
        }
    }

    private int computeResultSet() throws StepperException {
        switch (this._srcStepper.getNbrTransition()) {
            case 0: {
                throw new StepperException("0 transition");
            }
            case 1: {
                this._srcGenerator.InitFinder();
                return this._srcGenerator.SeqFinder();
            }
        }
        this._srcGenerator.addRecord(new LogGenRecord("MSG_CMD_COMPUTE_LINE", new Object[0]));
        this._srcGenerator.addRecord(new LogGenRecord("MSG_CMD_COMPUTE_TARGET", this._srcGenerator.getTarget().toString()));
        this._srcGenerator._seqFinder.printHeader();
        this._srcGenerator.addRecord(new LogGenRecord("MSG_CMD_COMPUTE_LINE2", new Object[0]));
        int curResult = 0;
        long timer = new Date().getTime();
        try {
            this._maxGame = this._srcGenerator._seqFinder.getNbGame(1);
            this._nbrGame = 0;
            Iterator<SeqGame> games = this._srcGenerator._seqFinder.getGames(1);
            while (games.hasNext()) {
                SeqGame game = games.next();
                curResult += this.waitAvailableGenerators(false);
                MsgStepUser.LOG.finer(game.toString());
                SubGenerator subGen = new SubGenerator(this.getAvailableStepper(), game.getInitList(), game.getPlaySet());
                subGen.setPriority(1);
                this._srcGenerator.addRecord(new LogGenRecord("MSG_CMD_SEQ_THREADED", subGen._initTrs.toString()));
                subGen.start();
                this._currentGenerators.add(subGen);
            }
            curResult += this.waitAvailableGenerators(true);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (StepperInterruptInternalException e) {
            // empty catch block
        }
        timer = new Date().getTime() - timer;
        this._srcGenerator.addRecord(new LogGenRecord("MSG_CMD_SEQ_FINDER_LN", new Object[0]));
        this._srcGenerator.addRecord(new LogGenRecord("MSG_CMD_COMPUTE_LINE2", new Object[0]));
        this._srcGenerator.addRecord(new LogGenRecord("MSG_CMD_SEQ_FINDER_ENDAT", new Date()));
        this._srcGenerator.getTarget().setTransitionsFlag(true);
        int nbrTransUsed = 0;
        for (ModelTrans tr : this._srcGenerator.getTranss()) {
            if (!tr._flag) continue;
            ++nbrTransUsed;
        }
        this._srcGenerator.addRecord(new LogGenRecord("MSG_CMD_SEQ_FINDER_NBRTRANS", nbrTransUsed));
        this._srcGenerator.addRecord(new LogGenRecord("MSG_CMD_COMPUTE_LINE", new Object[0]));
        SeqFinder.displayTime(timer, "MSG_CMD_SEQ_FINDER_DELAY", this._srcGenerator);
        this._srcGenerator.addRecord(new LogGenRecord("MSG_CMD_SEQ_FINDER_LN", new Object[0]));
        return curResult;
    }

    @Override
    public String getInfo(String key) {
        if (this._maxGame == -1) {
            return this._srcGenerator.getInfo(key);
        }
        if (key.equals("process.msg.high")) {
            StringBuffer msg = new StringBuffer(10);
            msg.append(this._nbrGame);
            msg.append("/");
            msg.append(this._maxGame);
            return msg.toString();
        }
        if (key.equals("process.p1000")) {
            return Integer.toString((int)((double)this._nbrGame / (double)this._maxGame * 1000.0));
        }
        return null;
    }

    @Override
    protected void requestStopOrResume() throws StepperInterruptException {
        super.requestStopOrResume();
        if (this._srcGenerator.getNbrError() >= this._srcGenerator.getMaxError()) {
            throw new StepperInterruptInternalException();
        }
    }

    class SubGenerator
    extends Thread
    implements ResultSetFactory {
        Stepper _subStepper;
        SeqGenerator _subGenerator;
        List<ModelTrans> _initTrs;
        int _orderMax;
        List<ResultSet> _rsetToFlush;
        StepperException _subException;
        int _subResult;

        SubGenerator(Stepper stepper, Collection<Integer> initList, Collection<Integer> playList) throws StepperException {
            super("Cecilia-SeqGen-Thread-" + ++SeqGeneratorThreaded.this._idxThread);
            this._subException = null;
            this._subResult = 0;
            this._rsetToFlush = new ArrayList<ResultSet>();
            this._subStepper = stepper;
            this._subGenerator = new SubSeqGenerator(this._subStepper);
            this._subGenerator.setControllableProcess(SeqGeneratorThreaded.this.getControllableProcess());
            HashMap<String, String> params = new HashMap<String, String>(SeqGeneratorThreaded.this._srcGenerator.getParams().getParams());
            String finder = params.get("finder");
            if (finder == null || finder.length() == 0) {
                throw new StepperException("Finder not define");
            }
            String order = params.get(finder + ".order");
            if (order == null || order.length() == 0) {
                throw new StepperException("Order not define");
            }
            this._orderMax = Integer.valueOf(order);
            if (this._orderMax <= 1) {
                throw new StepperException("Order must be greather 1");
            }
            params.put(finder + ".order", Integer.toString(this._orderMax - 1));
            this._subGenerator.setParams(new SeqParameters(params));
            this._initTrs = this._subGenerator.setInitTrans(initList);
            this._subGenerator.setPlayTrans(playList);
            this._subGenerator.setTarget(SeqGeneratorThreaded.this._srcGenerator.getTarget().cloneTarget(this));
        }

        @Override
        public ResultSet createResultSet(ResultSet src) {
            ModelTrans[] initTrs = new ModelTrans[this._initTrs.size()];
            ResultSetThreaded result = new ResultSetThreaded(src, this._initTrs.toArray(initTrs), this._orderMax);
            this._rsetToFlush.add(result);
            return result;
        }

        @Override
        public void run() {
            try {
                this._subGenerator.InitFinder();
                this._subResult = this._subGenerator.SeqFinder();
                for (ResultSet rset : this._rsetToFlush) {
                    rset.flush();
                }
            }
            catch (StepperException exc) {
                this._subException = exc;
            }
        }
    }

    class SubSeqGenerator
    extends SeqGenerator {
        public SubSeqGenerator(Stepper stepper) {
            super(stepper);
        }

        @Override
        public void addRecord(LogGenRecord record) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void addError(LogGenRecord record) throws StepperInterruptInternalException {
            Object object = SeqGeneratorThreaded.this._lockAddRecord;
            synchronized (object) {
                SeqGeneratorThreaded.this._srcGenerator.addError(record);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void addError(Exception se, String currentSeq) throws StepperInterruptInternalException {
            Object object = SeqGeneratorThreaded.this._lockAddRecord;
            synchronized (object) {
                SeqGeneratorThreaded.this._srcGenerator.addError(se, currentSeq);
            }
        }

        @Override
        protected Map<Integer, ModelTrans> getTransitionsMap() {
            return SeqGeneratorThreaded.this._srcGenerator.getTransitionsMap();
        }

        @Override
        void printNbrTransUsed() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected int getNbrError() {
            Object object = SeqGeneratorThreaded.this._lockAddRecord;
            synchronized (object) {
                return SeqGeneratorThreaded.this._srcGenerator.getNbrError();
            }
        }

        @Override
        protected int getMaxError() {
            return SeqGeneratorThreaded.this._srcGenerator.getMaxError();
        }
    }

    static class ResultSetThreaded
    implements ResultSet {
        static final int __MIN_STACK = 100;
        static final int __MAX_STACK = 1000;
        Lock _addSeqLock;
        ModelTrans[][] _cacheSeq;
        int _idxCacheSeq;
        ResultSet _delegate;
        int _initLength;
        ModelTrans[] _initTrs;

        ResultSetThreaded(ResultSet delegate, ModelTrans[] initTrs, int maxOrder) {
            this._delegate = delegate;
            this._initLength = initTrs.length;
            this._initTrs = new ModelTrans[initTrs.length];
            for (int i = 0; i < initTrs.length; ++i) {
                this._initTrs[i] = initTrs[i];
            }
            this._cacheSeq = new ModelTrans[1000][];
            this._idxCacheSeq = -1;
            this._addSeqLock = new ReentrantLock();
        }

        @Override
        public Lock getLockAvailable() {
            return this._addSeqLock;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void flushCache(boolean wait) {
            Lock lock = this._delegate.getLockAvailable();
            assert (lock != null);
            if (wait) {
                lock.lock();
            } else {
                wait = lock.tryLock();
            }
            if (wait) {
                this._addSeqLock.lock();
                try {
                    MsgStepUser.LOG.finest("" + this._idxCacheSeq + "  " + wait);
                    for (int i = 0; i <= this._idxCacheSeq; ++i) {
                        this._delegate.addSeq(this._cacheSeq[i]);
                        this._cacheSeq[i] = null;
                    }
                    this._idxCacheSeq = -1;
                }
                finally {
                    this._addSeqLock.unlock();
                    lock.unlock();
                }
            }
        }

        protected void addCacheSeq(ModelTrans[] trs) {
            this._cacheSeq[++this._idxCacheSeq] = trs;
            while (this._idxCacheSeq + 1 == 1000) {
                this.flushCache(true);
            }
            if (this._idxCacheSeq >= 100 && (this._idxCacheSeq + 1) % 100 == 0) {
                this.flushCache(false);
            }
        }

        @Override
        public void addSeq(ModelTrans[] trs) {
            this._delegate.addSeq(trs);
        }

        @Override
        public void addSeq(ModelTrans[] trs, int order) {
            int i;
            ModelTrans[] add = new ModelTrans[order + this._initLength];
            for (i = 0; i < this._initLength; ++i) {
                add[i] = this._initTrs[i];
            }
            for (i = 0; i < order; ++i) {
                add[i + this._initLength] = trs[i];
            }
            this.addCacheSeq(add);
        }

        @Override
        public void addSeq(List<ModelTrans> trs, boolean error) {
            if (error) {
                int order = trs.size();
                ModelTrans[] add = new ModelTrans[order];
                for (int i = 0; i < order; ++i) {
                    add[i] = trs.get(i);
                }
                this.addCacheSeq(add);
            } else {
                int i;
                int order = trs.size();
                ModelTrans[] add = new ModelTrans[order + this._initLength];
                for (i = 0; i < this._initLength; ++i) {
                    add[i] = this._initTrs[i];
                }
                for (i = 0; i < order; ++i) {
                    add[i + this._initLength] = trs.get(i);
                }
                this.addCacheSeq(add);
            }
        }

        @Override
        public void flush() {
            this.flushCache(true);
        }

        @Override
        public Map<Integer, Integer> getOrders() {
            return this._delegate.getOrders();
        }

        @Override
        public String getSeqAbstract() {
            return this._delegate.getSeqAbstract();
        }

        @Override
        public Iterator getSeqIterator() {
            return this._delegate.getSeqIterator();
        }

        @Override
        public String getShortName() {
            return this._delegate.getShortName();
        }
    }
}

