/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mbsa.translator.model;

import com.dassault.cecilia.lib.mbsa.translator.model.Expr;
import com.dassault.cecilia.lib.mbsa.translator.model.ExprParent;
import com.dassault.cecilia.lib.mbsa.translator.model.ExprVar;
import com.dassault.cecilia.lib.mbsa.translator.model.Node;
import com.dassault.cecilia.lib.mbsa.translator.model.Var;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;

public class StoreExpr
implements Externalizable {
    private static final boolean DEBUG = false;
    Node _owner;
    IStore _iStore;
    Type _type;

    public Type getType() {
        return this._type;
    }

    public StoreExpr() {
        this(null, Type.EXPR);
    }

    public StoreExpr(Node owner, Type type) {
        this._owner = owner;
        this._type = type;
        this._iStore = this.createInternalStore(type);
    }

    IStore createInternalStore(Type type) {
        switch (type) {
            case NONE: {
                return new StoreByPass();
            }
            case VAR: {
                return new StoreUniqueVar();
            }
            case EXPR: {
                return new StoreUniqueExpr();
            }
        }
        return new StoreByPass();
    }

    public Expr addExpr(Expr src) {
        return this._iStore.addExpr(src);
    }

    public void delExpr(Expr expr) {
        this._iStore.delExpr(expr);
    }

    public void garbageCollect() {
        this._iStore.garbageCollect();
    }

    public Expr get(Expr expr) {
        return this._iStore.get(expr);
    }

    public Collection<? extends Expr> getExpressions() {
        return this._iStore.getExpressions();
    }

    public int size() {
        return this._iStore.size();
    }

    public void setFlag(char value) {
        Collection<? extends Expr> exprs = this.getExpressions();
        if (exprs == null) {
            return;
        }
        for (Expr expr : exprs) {
            expr.setFlag(value);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this._owner);
        switch (this._type) {
            default: {
                out.writeShort(0);
                break;
            }
            case VAR: {
                out.writeShort(1);
                break;
            }
            case EXPR: {
                out.writeShort(2);
            }
        }
        Collection<? extends Expr> exprs = this.getExpressions();
        out.writeInt(exprs == null ? 0 : exprs.size());
        for (Expr expr : exprs) {
            out.writeObject(expr);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._owner = (Node)in.readObject();
        short type = in.readShort();
        switch (type) {
            default: {
                this._type = Type.NONE;
                break;
            }
            case 1: {
                this._type = Type.VAR;
                break;
            }
            case 2: {
                this._type = Type.EXPR;
            }
        }
        this._iStore = this.createInternalStore(this._type);
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            this._iStore.addExpr((Expr)in.readObject());
        }
    }

    public String toString() {
        return this._iStore.toString();
    }

    private class StoreUniqueExpr
    implements IStore {
        Map<Expr, Expr> _exprs = new HashMap<Expr, Expr>();

        private StoreUniqueExpr() {
        }

        @Override
        public Expr addExpr(Expr src) {
            Expr dst = this._exprs.get(src);
            if (dst != null) {
                return dst;
            }
            this._exprs.put(src, src);
            return src;
        }

        @Override
        public void delExpr(Expr src) {
            this._exprs.remove(src);
        }

        @Override
        public Expr get(Expr expr) {
            return this._exprs.get(expr);
        }

        @Override
        public void garbageCollect() {
            for (Expr expr : this._exprs.keySet()) {
                expr._flag = '\u0000';
            }
            StoreExpr.this._owner.setFlagPropage('c');
            Iterator<Map.Entry<Expr, Expr>> iEntry = this._exprs.entrySet().iterator();
            while (iEntry.hasNext()) {
                Map.Entry<Expr, Expr> entry = iEntry.next();
                if (entry.getKey()._flag != '\u0000') continue;
                iEntry.remove();
            }
            for (Expr expr : this._exprs.keySet()) {
                Iterator<ExprParent> iParent = expr.getParents();
                while (iParent.hasNext()) {
                    ExprParent parent = iParent.next();
                    if (parent._flag != '\u0000') continue;
                    iParent.remove();
                }
            }
        }

        public Collection<Expr> getExpressions() {
            return this._exprs.keySet();
        }

        public String toString() {
            TreeSet<String> lines = new TreeSet<String>();
            for (Expr expr : this.getExpressions()) {
                if (expr instanceof ExprVar) {
                    Var var = ((ExprVar)expr).getVar();
                    if (var.isAlias()) continue;
                    lines.add("Var  : " + var.getSimular().toString());
                    continue;
                }
                lines.add("Expr : " + expr.toString());
            }
            StringBuffer sb = new StringBuffer();
            for (String line : lines) {
                sb.append(line).append("\n");
            }
            return sb.toString();
        }

        @Override
        public int size() {
            return this._exprs.size();
        }
    }

    private class StoreUniqueVar
    implements IStore {
        Map<ExprVar, ExprVar> _vars = new HashMap<ExprVar, ExprVar>();

        private StoreUniqueVar() {
        }

        @Override
        public Expr addExpr(Expr src) {
            if (src instanceof ExprVar) {
                ExprVar var = (ExprVar)src;
                Expr dst = this._vars.get(src);
                if (dst != null) {
                    return dst;
                }
                this._vars.put(var, var);
            }
            return src;
        }

        @Override
        public void delExpr(Expr src) {
            if (src instanceof ExprVar) {
                ExprVar var = (ExprVar)src;
                this._vars.remove(var);
            }
        }

        @Override
        public void garbageCollect() {
            for (Expr expr : this._vars.keySet()) {
                expr._flag = '\u0000';
            }
            StoreExpr.this._owner.setFlagPropage('c');
            Iterator<ExprVar> iVar = this._vars.keySet().iterator();
            while (iVar.hasNext()) {
                ExprVar exprVar = iVar.next();
                if (exprVar._flag != '\u0000') continue;
                iVar.remove();
            }
        }

        @Override
        public Collection<? extends Expr> getExpressions() {
            return this._vars.keySet();
        }

        @Override
        public int size() {
            return this._vars.size();
        }

        @Override
        public Expr get(Expr expr) {
            return this._vars.get(expr);
        }
    }

    private class StoreByPass
    implements IStore {
        private StoreByPass() {
        }

        @Override
        public Expr addExpr(Expr src) {
            return src;
        }

        @Override
        public void delExpr(Expr src) {
        }

        @Override
        public void garbageCollect() {
        }

        @Override
        public Collection<? extends Expr> getExpressions() {
            return null;
        }

        @Override
        public int size() {
            return -1;
        }

        @Override
        public Expr get(Expr expr) {
            return null;
        }
    }

    private static interface IStore {
        public Expr addExpr(Expr var1);

        public void delExpr(Expr var1);

        public Expr get(Expr var1);

        public void garbageCollect();

        public Collection<? extends Expr> getExpressions();

        public int size();
    }

    public static enum Type {
        NONE,
        EXPR,
        VAR;

    }
}

