/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia;

import com.dassault.cecilia.DocProperty;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;
import javax.tools.StandardLocation;

@SupportedAnnotationTypes(value={"*"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
public class DocPropertyProcessorTxt
extends AbstractProcessor {
    @Override
    public boolean process(Set<? extends TypeElement> set, RoundEnvironment roundEnvironment) {
        Filer filer = this.processingEnv.getFiler();
        Messager messager = this.processingEnv.getMessager();
        Elements elements = this.processingEnv.getElementUtils();
        int n = 0;
        if (!roundEnvironment.processingOver()) {
            TypeElement typeElement = elements.getTypeElement(DocProperty.class.getName());
            Set<? extends Element> set2 = roundEnvironment.getElementsAnnotatedWith(typeElement);
            if (!set2.isEmpty()) {
                n = this.GenerateTxtFile(messager, filer, set2);
            } else {
                messager.printMessage(Diagnostic.Kind.NOTE, "DocProperty: Rien a faire");
            }
        }
        messager.printMessage(Diagnostic.Kind.NOTE, "DocProperty: Nombre d'annotation: " + n);
        return true;
    }

    int GenerateTxtFile(Messager messager, Filer filer, Set<? extends Element> set) {
        int n = 0;
        try {
            Object object;
            messager.printMessage(Diagnostic.Kind.NOTE, "DocProperty: Generation du fichier 'Launch.ini'");
            PrintWriter printWriter = new PrintWriter(filer.createResource(StandardLocation.SOURCE_OUTPUT, "", "Launch.ini", new Element[0]).openOutputStream());
            printWriter.println("# Liste des proprietes du projet Cecilia :");
            printWriter.println();
            PrintWriter printWriter2 = new PrintWriter(filer.createResource(StandardLocation.SOURCE_OUTPUT, "", "Launch.DA.ini", new Element[0]).openOutputStream());
            printWriter2.println("# Liste de toutes les proprietes du projet Cecilia :");
            printWriter2.println();
            TreeMap<String, Element> treeMap = new TreeMap<String, Element>();
            for (Element object2 : set) {
                if (object2 instanceof VariableElement) {
                    object = ((VariableElement)object2).getConstantValue();
                    if (object != null) {
                        treeMap.put(object.toString(), object2);
                        continue;
                    }
                    messager.printMessage(Diagnostic.Kind.WARNING, "DocProperty: No valuate for '" + object2.getSimpleName() + "'");
                    continue;
                }
                messager.printMessage(Diagnostic.Kind.WARNING, "DocProperty: No VariableElement for '" + object2.getSimpleName() + "'");
            }
            for (Map.Entry entry : treeMap.entrySet()) {
                object = (Element)entry.getValue();
                DocProperty docProperty = object.getAnnotation(DocProperty.class);
                this.printDocProperty(printWriter2, (String)entry.getKey(), docProperty);
                if (!docProperty.intern()) {
                    this.printDocProperty(printWriter, (String)entry.getKey(), docProperty);
                }
                ++n;
            }
            printWriter.close();
            printWriter2.close();
        }
        catch (IOException iOException) {
            messager.printMessage(Diagnostic.Kind.ERROR, iOException.getMessage());
        }
        return n;
    }

    void printDocProperty(PrintWriter printWriter, String string, DocProperty docProperty) {
        String string2;
        Object object = new StringTokenizer(docProperty.comment(), "\r\n");
        while (((StringTokenizer)object).hasMoreTokens()) {
            printWriter.println("# " + ((StringTokenizer)object).nextToken());
        }
        object = new StringBuilder();
        if (docProperty.intern()) {
            if (((StringBuilder)object).length() > 0) {
                ((StringBuilder)object).append(", ");
            }
            ((StringBuilder)object).append("Intern");
        }
        if (!docProperty.dynamic()) {
            if (((StringBuilder)object).length() > 0) {
                ((StringBuilder)object).append(", ");
            }
            ((StringBuilder)object).append("Static");
        }
        if (!"<5.1".equals(docProperty.version())) {
            if (((StringBuilder)object).length() > 0) {
                ((StringBuilder)object).append(", ");
            }
            ((StringBuilder)object).append("Version:").append(docProperty.version());
        }
        if (!"N/A".equals(docProperty.ref())) {
            if (((StringBuilder)object).length() > 0) {
                ((StringBuilder)object).append(", ");
            }
            ((StringBuilder)object).append("Ref:").append(docProperty.ref());
        }
        if (((StringBuilder)object).length() > 0) {
            printWriter.println("#     Informations= " + ((StringBuilder)object).toString());
        }
        if (docProperty.oldNames().length > 0) {
            object = new StringBuilder();
            ((StringBuilder)object).append("#     OldNames= ");
            for (int i = 0; i < docProperty.oldNames().length; ++i) {
                if (i > 0) {
                    ((StringBuilder)object).append(", ");
                }
                ((StringBuilder)object).append(docProperty.oldNames()[i]);
            }
            printWriter.println(((StringBuilder)object).toString());
        }
        if (!((String)(object = docProperty.def())).equalsIgnoreCase("<null>")) {
            printWriter.println("# DefaultValue=" + (String)object);
        }
        if ((string2 = docProperty.ini()).length() > 0) {
            printWriter.println(string + "=" + string2);
        } else if (!((String)object).equalsIgnoreCase("<null>")) {
            printWriter.println(string + "=" + (String)object);
        } else {
            printWriter.println("#" + string + "=");
        }
        printWriter.println();
    }
}

