/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.cecilia.dbgui;

import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.core.cecilia.error.GeneralError;
import com.dassault.cecilia.core.cecilia.error.MsgType;
import com.dassault.cecilia.db.DBFactory;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.dao.DAOFactory;
import com.dassault.cecilia.db.dao.DAOFolder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;

public class DAOTools {
    static Logger _LOG = Logger.getLogger(DAOTools.class.getPackage().getName());
    DAOFactory _daoFactory;
    List<GeneralError<DBFolder>> _dbErrors;
    boolean _bWithError;

    public DAOTools(DAOFactory daoFactory) {
        this._daoFactory = daoFactory;
        this._dbErrors = new ArrayList<GeneralError<DBFolder>>();
        this._bWithError = false;
    }

    protected DAOFactory getDAOFactory() {
        return this._daoFactory;
    }

    public List<GeneralError<DBFolder>> getErrors() {
        return this._dbErrors;
    }

    public boolean appendFatalError(DBFolder dbFolder, String msg) {
        if (dbFolder == null) {
            dbFolder = this._daoFactory.createFolderDAO().getRootID("ROOT");
        }
        this._dbErrors.add(0, new GeneralError<DBFolder>(dbFolder, msg, MsgType.FATAL));
        _LOG.severe(msg);
        this._bWithError = true;
        return false;
    }

    protected boolean appendSystemError(DBFolder dbFolder, String code) {
        String msg = "SystemError (" + code + ") at " + (dbFolder == null ? "<null>" : this.toString(dbFolder));
        this._dbErrors.add(new GeneralError<DBFolder>(dbFolder, msg, MsgType.FATAL));
        _LOG.warning(msg);
        this._bWithError = true;
        return false;
    }

    protected boolean appendError(DBFolder dbFolder, String msg) {
        this._dbErrors.add(new GeneralError<DBFolder>(dbFolder, msg, MsgType.ERROR));
        _LOG.info(msg);
        this._bWithError = true;
        return false;
    }

    protected boolean appendWarning(DBFolder dbFolder, String msg) {
        this._dbErrors.add(new GeneralError<DBFolder>(dbFolder, msg, MsgType.WARNING));
        _LOG.fine(msg);
        return false;
    }

    protected boolean appendInfo(DBFolder dbFolder, String msg) {
        this._dbErrors.add(new GeneralError<DBFolder>(dbFolder, msg, MsgType.INFO));
        _LOG.finest(msg);
        return true;
    }

    protected String toString(DBFolder dbFolder) {
        StringBuilder sb = new StringBuilder();
        sb.append("<").append(dbFolder.getFamily().toString().toLowerCase()).append(">");
        dbFolder.getPathUntilSystem(sb);
        return sb.toString();
    }

    protected boolean verifyFolder(DBFolder dbFolder) {
        String description;
        if (dbFolder.isSystem()) {
            return true;
        }
        boolean result = true;
        if (dbFolder.isVersion()) {
            switch (dbFolder.getFamily()) {
                case BTP_APPLICATION: 
                case BTP_AUTHOR: 
                case BTP_SUBSTANTIATION: {
                    break;
                }
                default: {
                    if (dbFolder.getObject() != null) break;
                    result &= this.appendWarning(dbFolder, ResMsgCore.msgFormat("MSG_ERR_DAOTOOL_FOL_NO_OBJ", this.toString(dbFolder)));
                }
            }
        }
        if (dbFolder.getDateCreate() == null) {
            result &= this.appendError(dbFolder, ResMsgCore.msgFormat("MSG_ERR_DAOTOOL_FOL_DATE_CREATE", this.toString(dbFolder)));
        }
        if (dbFolder.getDateModify() == null) {
            result &= this.appendError(dbFolder, ResMsgCore.msgFormat("MSG_ERR_DAOTOOL_FOL_DATE_MODIFY", this.toString(dbFolder)));
        }
        if ((description = dbFolder.getDescription()) != null && !DBFactory.verifyDescription(description)) {
            result &= this.appendError(dbFolder, ResMsgCore.msgFormat("MSG_ERR_DAOTOOL_FOL_DESCR", this.toString(dbFolder)));
        }
        if (dbFolder.isVersion()) {
            if (!DBFactory.verifyVersion(dbFolder.getName(), dbFolder.getFamily(), dbFolder.getFamilyFlag())) {
                result &= this.appendError(dbFolder, ResMsgCore.msgFormat("MSG_ERR_DAOTOOL_FOL_NAME", this.toString(dbFolder)));
            }
        } else if (!DBFactory.verifyName(dbFolder.getName(), dbFolder.getFamily())) {
            result &= this.appendError(dbFolder, ResMsgCore.msgFormat("MSG_ERR_DAOTOOL_FOL_NAME", this.toString(dbFolder)));
        }
        return result;
    }

    protected boolean verifyFolderDepth(DBFolder dbFolder, int depth) {
        if (depth <= 0) {
            return dbFolder.isSystem();
        }
        switch (dbFolder.getFamily()) {
            case BTP_APPLICATION: 
            case BTP_AUTHOR: 
            case BTP_SUBSTANTIATION: {
                return depth == 1 && dbFolder.isVersion();
            }
            case CCF_MODEL: 
            case FMEA_MODEL: {
                if (depth == 1) {
                    return dbFolder.isModel();
                }
                if (depth == 2) {
                    return dbFolder.isVersion();
                }
                return false;
            }
            case ATTRIBUTE: 
            case PARAMETER: 
            case IMAG: {
                if (depth == 1) {
                    return dbFolder.isFolder();
                }
                if (depth == 2) {
                    return dbFolder.isModel();
                }
                if (depth == 3) {
                    return dbFolder.isVersion();
                }
                return false;
            }
            case TYPE: {
                short FF;
                if (depth == 4 && (FF = dbFolder.getFamilyFlag()) != 1 && FF != 2) {
                    this.appendError(dbFolder, ResMsgCore.msgFormat("MSG_ERR_DAOTOOL_FOL_BAD_FF", this.toString(dbFolder)));
                }
            }
            case OPERATOR: 
            case COMPONENT: 
            case EQUIPMENT: {
                if (depth < 3) {
                    return dbFolder.isFolder();
                }
                if (depth == 3) {
                    return dbFolder.isModel();
                }
                if (depth == 4) {
                    return dbFolder.isVersion();
                }
                return false;
            }
            case PROJECT: {
                if (depth == 1) {
                    short FF = dbFolder.getFamilyFlag();
                    if (FF != 8) {
                        this.appendError(dbFolder, ResMsgCore.msgFormat("MSG_ERR_DAOTOOL_FOL_BAD_FF", this.toString(dbFolder)));
                    }
                    if (dbFolder.getObject() == null) {
                        this.appendWarning(dbFolder, ResMsgCore.msgFormat("MSG_ERR_DAOTOOL_FOL_NO_OBJ", this.toString(dbFolder)));
                    }
                    return dbFolder.isFolder();
                }
                if (depth == 2) {
                    return dbFolder.isFolder();
                }
                if (depth == 3) {
                    return dbFolder.isModel();
                }
                if (depth == 4) {
                    short FF = dbFolder.getFamilyFlag();
                    if (FF != 5 && FF != 3 && FF != 4 && FF != 1 && FF != 2) {
                        this.appendError(dbFolder, ResMsgCore.msgFormat("MSG_ERR_DAOTOOL_FOL_BAD_FF", this.toString(dbFolder)));
                    }
                    return dbFolder.isVersion();
                }
                return false;
            }
            case BTP_MODEL: {
                if (depth < 5) {
                    return dbFolder.isFolder();
                }
                if (depth == 5) {
                    return dbFolder.isModel();
                }
                if (depth == 6) {
                    return dbFolder.isVersion();
                }
                return false;
            }
        }
        return this.appendSystemError(dbFolder, "D1");
    }

    protected boolean verifyFolders(DBFolder dbFolder, int depth) {
        if (!this.verifyFolderDepth(dbFolder, depth)) {
            return this.appendError(dbFolder, ResMsgCore.msgFormat("MSG_ERR_DAOTOOL_FOL_BAD_DEPTH", this.toString(dbFolder)));
        }
        boolean result = this.verifyFolder(dbFolder);
        List<DBFolder> dbChildren = dbFolder.getChildren();
        if (dbChildren == null) {
            dbChildren = this._daoFactory.createFolderDAO().findChildren(dbFolder);
        }
        if (dbFolder.isModel() && (dbChildren == null || dbChildren.isEmpty())) {
            return this.appendError(dbFolder, ResMsgCore.msgFormat("MSG_ERR_DAOTOOL_FOL_MOD_WITHOUT_VER", this.toString(dbFolder)));
        }
        if (dbChildren != null && !dbChildren.isEmpty()) {
            Collections.sort(dbChildren, DBFolder.getComparator());
            String previousName = null;
            for (DBFolder dbChild : dbChildren) {
                result &= this.verifyFolders(dbChild, depth + 1);
                String name = dbChild.getName();
                if (previousName != null && previousName.equalsIgnoreCase(name)) {
                    result = this.appendError(dbFolder, ResMsgCore.msgFormat("MSG_ERR_DAOTOOL_FOL_CHILDREN", this.toString(dbFolder), name));
                }
                previousName = name;
            }
        }
        return result;
    }

    private boolean verifyFolderApplication(DBFolder dbFolder) {
        DAOFolder daoFolder = this._daoFactory.createFolderDAO();
        if (dbFolder.getFamily() != DBFolder.Family.APPLICATION) {
            return this.appendSystemError(dbFolder, "A1");
        }
        List<DBFolder> dbChildren = dbFolder.getChildren();
        if (dbChildren == null) {
            dbChildren = daoFolder.findChildren(dbFolder);
        }
        if (dbChildren == null) {
            return this.appendSystemError(dbFolder, "A2");
        }
        boolean result = true;
        for (DBFolder dbChild : dbChildren) {
            if (!dbChild.isSystem()) {
                result = this.appendSystemError(dbFolder, "A3");
                continue;
            }
            DBFolder dbTest = daoFolder.getRootID(dbChild.getName());
            if (dbTest == null) {
                result = this.appendSystemError(dbFolder, "A4");
                continue;
            }
            if (dbTest != dbChild) {
                result = this.appendSystemError(dbFolder, "A5");
                continue;
            }
            if (dbChild.getFamily() == DBFolder.Family.APPLICATION) {
                result &= this.verifyFolderApplication(dbChild);
                continue;
            }
            result &= this.verifyFolders(dbChild, 0);
        }
        return result;
    }

    private boolean verifyFolderRoot() {
        DAOFolder daoFolder = this._daoFactory.createFolderDAO();
        DBFolder dbRoot = daoFolder.getRootID("ROOT");
        if (dbRoot == null) {
            return this.appendSystemError(dbRoot, "R1");
        }
        if (!dbRoot.isSystem()) {
            return this.appendSystemError(dbRoot, "R2");
        }
        return this.verifyFolderApplication(dbRoot);
    }

    public boolean verify() {
        boolean result = true;
        result &= this.verifyFolderRoot();
        return result &= !this._bWithError;
    }
}

