/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.cecilia.dependencies;

import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.core.cecilia.dependencies.Recup;
import com.dassault.cecilia.core.cecilia.error.GeneralError;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBRelation;
import com.dassault.cecilia.db.dao.DAOFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;

public abstract class Generate<T> {
    private static Logger _LOG = Logger.getLogger(Generate.class.getPackage().getName());
    Map<DBFolder.Family, Recup<T>> _recups;
    Object _recupsLocker = new Object();
    List<GeneralError<DBFolder>> _errors;
    Direction _direction = Direction.DOWN;
    protected DAOFactory _daoFactory;

    public Collection<DBFolder.Family> getKeys() {
        return this._recups.keySet();
    }

    public Collection<? extends T> getValues(DBFolder.Family key) {
        Recup<T> recup = this._recups.get((Object)key);
        return recup == null ? null : recup.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Recup<T> findOrCreateRecup(DBFolder.Family key) {
        Recup<T> result = this._recups.get((Object)key);
        if (result == null) {
            Object object = this._recupsLocker;
            synchronized (object) {
                Recup<T> create;
                result = this._recups.get((Object)key);
                if (result == null && (create = this.makeRecup(key)) != null) {
                    this._recups.put(key, create);
                    result = create;
                }
            }
        }
        if (result == null) {
            _LOG.finer("Pas de recuperateur pour la famille suivante : " + (Object)((Object)key));
        }
        return result;
    }

    public List<GeneralError<DBFolder>> getErrors() {
        return this._errors;
    }

    public Generate<T> setDirection(Direction value) {
        this._direction = value;
        return this;
    }

    protected abstract Recup<T> makeRecup(DBFolder.Family var1);

    protected abstract T findOrCreate(DBFolder var1, DBFolder.Family var2);

    public Generate(DAOFactory daoFactory) {
        this._daoFactory = daoFactory;
        this._recups = new TreeMap<DBFolder.Family, Recup<T>>(DBFolder.Family.getComparator());
        this._errors = new ArrayList<GeneralError<DBFolder>>();
    }

    protected boolean dontTreatThisFamily(DBFolder.Family family) {
        switch (family) {
            case BTP_AUTHOR: 
            case BTP_APPLICATION: 
            case BTP_SUBSTANTIATION: {
                return true;
            }
        }
        return false;
    }

    protected DBFolder.Family convertRelationType(String type) {
        if (type == null) {
            return null;
        }
        if (type.equals("OA_TYPE")) {
            return DBFolder.Family.TYPE;
        }
        if (type.equals("OA_OPER")) {
            return DBFolder.Family.OPERATOR;
        }
        if (type.equals("OA_COMP")) {
            return DBFolder.Family.COMPONENT;
        }
        if (type.equals("OA_EQUIP")) {
            return DBFolder.Family.EQUIPMENT;
        }
        if (type.equals("OA_SYST")) {
            return DBFolder.Family.PROJECT;
        }
        if (type.equals("LAW_MODEL")) {
            return DBFolder.Family.BTP_MODEL;
        }
        if (type.equals("ATTRIBUTE")) {
            return DBFolder.Family.ATTRIBUTE;
        }
        if (type.equals("PARAMETER")) {
            return DBFolder.Family.PARAMETER;
        }
        if (type.equals("DSF_V")) {
            return DBFolder.Family.PROJECT;
        }
        if (type.equals("TREE_V")) {
            return DBFolder.Family.PROJECT;
        }
        if (type.equals("CCF_MODEL")) {
            return DBFolder.Family.CCF_MODEL;
        }
        if (type.equals("FMEA_V")) {
            return DBFolder.Family.PROJECT;
        }
        if (type.equals("FMEA_MODEL")) {
            return DBFolder.Family.FMEA_MODEL;
        }
        if (type.equals("OA_IMAG")) {
            return DBFolder.Family.IMAG;
        }
        if (type.equals("FRB_AUTHOR")) {
            return DBFolder.Family.BTP_AUTHOR;
        }
        if (type.equals("FRB_APPL")) {
            return DBFolder.Family.BTP_APPLICATION;
        }
        if (type.equals("FRB_SUBST")) {
            return DBFolder.Family.BTP_SUBSTANTIATION;
        }
        _LOG.finer("Pas de famille pour la relation suivante : " + type);
        return null;
    }

    static boolean isGoodRelation(DBRelation relation, DBFolder dbFolder, Direction direction) {
        switch (direction) {
            default: {
                return relation.getSource().equals(dbFolder);
            }
            case UP: {
                return relation.getDestination().equals(dbFolder);
            }
            case BOTH: 
        }
        return true;
    }

    private final boolean doAddRelations(DBFolder dbFolder, boolean downDirection, Collection<DBRelation> relations) {
        boolean result = true;
        for (DBRelation relation : relations) {
            DBFolder.Family family;
            DBFolder dbOther;
            String typeOther;
            if (downDirection) {
                if (!relation.getSource().equals(dbFolder)) continue;
                typeOther = relation.getTypeDestination();
                dbOther = relation.getDestination();
            } else {
                if (!relation.getDestination().equals(dbFolder)) continue;
                typeOther = relation.getTypeSource();
                dbOther = relation.getSource();
            }
            if (this.recupFolder(family = this.convertRelationType(typeOther), dbOther)) continue;
            result = false;
        }
        return result;
    }

    protected boolean recupFolder(DBFolder.Family family, DBFolder dbOther) {
        if (family == null) {
            return true;
        }
        if (this.dontTreatThisFamily(family)) {
            return true;
        }
        Recup<T> recup = this.findOrCreateRecup(family);
        if (recup == null) {
            return true;
        }
        if (recup.find(dbOther)) {
            return true;
        }
        T t = this.findOrCreate(dbOther, family);
        if (t == null) {
            this._errors.add(new GeneralError<DBFolder>(dbOther, ResMsgCore.getString("MSG_ERR_LOAD_MODEL")));
            _LOG.info("Probleme lors de la lecture d'un " + (Object)((Object)family) + " : " + dbOther.getRefPath());
            return false;
        }
        return recup.add(dbOther, t, null);
    }

    protected Collection<DBRelation> filterWorkingRelations(Collection<DBRelation> relations) {
        boolean withWorking = false;
        for (DBRelation dbRelation : relations) {
            if (!"WORKING".equals(dbRelation.getTypeSource())) continue;
            withWorking = true;
            break;
        }
        if (withWorking) {
            ArrayList<DBRelation> filterRelations = new ArrayList<DBRelation>(relations.size());
            for (DBRelation dbRelation : relations) {
                if ("WORKING".equals(dbRelation.getTypeSource())) continue;
                filterRelations.add(dbRelation);
            }
            return filterRelations;
        }
        return relations;
    }

    protected boolean addRelations(DBFolder dbFolder, Collection<DBRelation> relations) {
        if (relations == null) {
            switch (this._direction) {
                default: {
                    return this.doAddRelations(dbFolder, true, this.filterWorkingRelations(this._daoFactory.createRelationDAO().getDestinationRelations(dbFolder)));
                }
                case UP: {
                    return this.doAddRelations(dbFolder, false, this.filterWorkingRelations(this._daoFactory.createRelationDAO().getSourceRelations(dbFolder)));
                }
                case BOTH: 
            }
            if (!this.doAddRelations(dbFolder, true, this.filterWorkingRelations(this._daoFactory.createRelationDAO().getDestinationRelations(dbFolder)))) {
                return false;
            }
            return this.doAddRelations(dbFolder, false, this.filterWorkingRelations(this._daoFactory.createRelationDAO().getSourceRelations(dbFolder)));
        }
        switch (this._direction) {
            default: {
                return this.doAddRelations(dbFolder, true, relations);
            }
            case UP: {
                return this.doAddRelations(dbFolder, false, relations);
            }
            case BOTH: 
        }
        if (!this.doAddRelations(dbFolder, true, relations)) {
            return false;
        }
        return this.doAddRelations(dbFolder, false, relations);
    }

    public boolean prepare(DBFolder dbFolder, T data, Collection<DBRelation> relations) {
        DBFolder.Family family = dbFolder.getFamily();
        Recup<T> recup = this.findOrCreateRecup(family);
        if (recup == null) {
            return false;
        }
        if (recup.find(dbFolder)) {
            return true;
        }
        boolean result = recup.add(dbFolder, data, relations);
        return result && this._errors.isEmpty();
    }

    public static enum Direction {
        DOWN,
        UP,
        BOTH;

    }
}

