/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.cecilia.folder;

import com.dassault.cecilia.core.cecilia.access.AccessRightRenderer;
import com.dassault.cecilia.core.cecilia.folder.DBFolderTreeNode;
import com.dassault.cecilia.core.cecilia.folder.DBFolderTreeRenderer;
import com.dassault.cecilia.core.cecilia.folder.FolderTreeTableModel;
import com.dassault.cecilia.core.cecilia.user.GroupRenderer;
import com.dassault.cecilia.core.cecilia.user.UserRenderer;
import com.dassault.cecilia.core.swing.tree.TreeTable;
import com.dassault.cecilia.db.DBAccess;
import com.dassault.cecilia.db.IGroup;
import com.dassault.cecilia.db.IUser;
import com.dassault.cecilia.lib.util.ResIcoAbstract;
import java.awt.Component;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class FolderTreeTable
extends TreeTable<DBFolderTreeNode> {
    FolderTreeTableModel _treeTableModel;
    DateFormat _frmDate;
    TableCellRenderer _timeUpdateRenderer;

    public FolderTreeTable(FolderTreeTableModel treeTableModel) {
        super(treeTableModel);
        this._treeTableModel = treeTableModel;
        this.make();
    }

    private void make() {
        this.setFillsViewportHeight(true);
        this.getTree().setRootVisible(true);
        this.getTree().setCellRenderer(new DBFolderTreeRenderer());
        this.setRowHeight(ResIcoAbstract.getIconSize());
        this._frmDate = SimpleDateFormat.getDateTimeInstance(3, 3);
        this._timeUpdateRenderer = new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                Long val = (Long)value;
                this.setText(FolderTreeTable.this._frmDate.format(new Date(val)));
                this.setToolTipText(Long.toString(val));
                return this;
            }
        };
        this.setDefaultRenderer(Integer.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                Integer val = (Integer)value;
                this.setText(String.format("0x%1$08X", val));
                this.setHorizontalAlignment(4);
                return this;
            }
        });
        this.setDefaultRenderer(DBAccess.Right.class, new AccessRightRenderer().setWithText(false));
        this.setDefaultRenderer(Date.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                Date val = (Date)value;
                this.setText(FolderTreeTable.this._frmDate.format(val));
                if (FolderTreeTable.this._treeTableModel.isDebugMode()) {
                    this.setToolTipText(Long.toString(val.getTime()));
                }
                return this;
            }
        });
        this.setDefaultRenderer(IGroup.class, new GroupRenderer());
        this.setDefaultRenderer(IUser.class, new UserRenderer().setWithIcon(false));
        TableColumnModel colModel = this.getColumnModel();
        for (int i = 0; i < colModel.getColumnCount(); ++i) {
            TableColumn tcol = colModel.getColumn(i);
            tcol.setPreferredWidth(this.definePreferredWidth(this._treeTableModel.convertColIndexToColID(i)));
        }
    }

    protected int definePreferredWidth(FolderTreeTableModel.IDCol colID) {
        switch (colID) {
            case NAME: {
                return 300;
            }
            case DESC: {
                return 100;
            }
            case CREATE: {
                return 100;
            }
            case MODIF: {
                return 100;
            }
            case LAST_USER: {
                return 100;
            }
            case OWNER: {
                return 100;
            }
            case GROUP: {
                return 100;
            }
            case ACCESS_GROUP: {
                return 75;
            }
            case ACCESS_OTHER: {
                return 75;
            }
            case FLAGS: {
                return 125;
            }
            case ID: {
                return 50;
            }
            case TIME_UPT: {
                return 150;
            }
        }
        return 100;
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        if (this._treeTableModel.convertColIndexToColID(column) == FolderTreeTableModel.IDCol.TIME_UPT) {
            return this._timeUpdateRenderer;
        }
        return super.getCellRenderer(row, column);
    }
}

