/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.cecilia.pref;

import com.dassault.cecilia.core.ResIcoCore;
import com.dassault.cecilia.core.cecilia.pref.PrefFieldAbstract;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JColorChooser;

public class PrefFieldColor
extends PrefFieldAbstract {
    Color _color;
    Color _defaultColor;
    List<JButton> _listButton;

    public Color getColor() {
        return this._color;
    }

    public PrefFieldColor setColor(Color value) {
        this._color = value;
        if (this._listButton != null) {
            for (JButton check : this._listButton) {
                check.setBackground(this._color);
            }
        }
        return this;
    }

    public Color getDefaultColor() {
        return this._defaultColor;
    }

    public PrefFieldColor setDefaultColor(Color value) {
        this._defaultColor = value;
        return this;
    }

    public PrefFieldColor(String lbl, String code) {
        this(lbl, code, Color.white);
    }

    public PrefFieldColor(String lbl, String code, Color defaultColor) {
        super(lbl, code);
        this._color = this._defaultColor = defaultColor;
    }

    @Override
    public PrefFieldColor getCopy() {
        PrefFieldColor result = new PrefFieldColor("", "");
        result.copy(this);
        return result;
    }

    @Override
    protected void copy(PrefFieldAbstract abstractsrc) {
        super.copy(abstractsrc);
        PrefFieldColor src = (PrefFieldColor)abstractsrc;
        this._color = src._color;
        this._defaultColor = src._defaultColor;
    }

    public synchronized JButton createButton() {
        if (this._listButton == null) {
            this._listButton = new ArrayList<JButton>();
        }
        JButton button = new JButton();
        button.setIcon(ResIcoCore.getImageIcon("PALETTE"));
        button.setToolTipText(this.getTooltip());
        button.setBackground(this.getColor());
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color color = JColorChooser.showDialog((Component)e.getSource(), PrefFieldColor.this.getLabel(), PrefFieldColor.this.getColor());
                if (color != null) {
                    PrefFieldColor.this.setColor(color);
                }
            }
        });
        this._listButton.add(button);
        return button;
    }
}

