/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.cecilia.pref;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.CAppl;
import com.dassault.cecilia.core.cecilia.pref.PrefFieldsCategory;
import com.dassault.cecilia.core.cecilia.pref.Preferencies;
import com.dassault.cecilia.core.plugin.PluginWithOptions;
import com.dassault.cecilia.core.swing.JDialogCecilia;
import com.dassault.cecilia.core.swing.other.PrintPreviewCanvas;
import com.dassault.cecilia.core.swing.other.PrintPreviewDlg;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JPanel;

public abstract class PrintPreviewPrefsDlg
extends PrintPreviewDlg {
    protected PageFormat _format;
    protected PreferenciesDelegate _preferencies;
    PrefFieldsCategory _prefField = null;
    JButton _ctrlFormat;
    JButton _ctrlPreferences;
    ChangePreferenciesDlg _dlg = null;

    public PrintPreviewPrefsDlg(Window owner, Pageable pageable, CAppl appl, PrefFieldsCategory ... prefFields) {
        super(owner, pageable);
        this._format = appl.getPageFormat();
        this._preferencies = new PreferenciesDelegate(appl.getPreferencies());
        if (prefFields != null && prefFields.length > 0) {
            this._prefField = prefFields[0];
            if (this._prefField != null) {
                this._prefField = this._prefField.getCopy();
            }
            if (this._prefField != null) {
                this._preferencies.addPrefFieldsCategorie(this._prefField);
            }
        } else {
            this._ctrlPreferences.setEnabled(false);
        }
    }

    public Preferencies getPreferencies() {
        return this._preferencies;
    }

    public abstract void updatePreferencies();

    public final PageFormat getFormat() {
        return this._format;
    }

    public void setBook(Pageable pageable) {
        this._book = pageable;
        this._ctrlPreview.setBook(this._book);
    }

    public Pageable getBook() {
        return this._book;
    }

    @Override
    protected Component createCenter() {
        this._ctrlPreview = new PrintPreviewCanvas(this._book){

            @Override
            public PageFormat getPageFormat() {
                return PrintPreviewPrefsDlg.this._format;
            }
        };
        return super.createCenter();
    }

    @Override
    protected Component createSouth() {
        JPanel resultPanel = new JPanel(new GridBagLayout());
        this._ctrlPrint = new JButton(ResMsgVoc.getString("VOC_PRINT"));
        this._ctrlPrint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PrintPreviewPrefsDlg.this.doPrintAction();
            }
        });
        this._ctrlFormat = new JButton(ResMsgVoc.getString("VOC_FORMAT"));
        this._ctrlFormat.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PrintPreviewPrefsDlg.this.doFormatAction();
            }
        });
        this._ctrlPreferences = new JButton(ResMsgVoc.getString("VOC_PREFERENCE"));
        this._ctrlPreferences.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PrintPreviewPrefsDlg.this.doPreferenciesAction();
            }
        });
        AbstractAction actClose = new AbstractAction(this.getLabelClose()){

            @Override
            public void actionPerformed(ActionEvent e) {
                PrintPreviewPrefsDlg.this.doCloseAction();
            }
        };
        this._ctrlClose = new JButton(ResMsgVoc.getString("VOC_CLOSE"));
        this._ctrlClose.addActionListener(actClose);
        this.putAction("CECILIA_ENTER", actClose);
        this.putAction("CECILIA_CANCEL", actClose);
        int idxX = 0;
        resultPanel.add((Component)this._ctrlPrint, new GridBagConstraints(idxX++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 2, 2, 2), 0, 0));
        resultPanel.add((Component)this._ctrlFormat, new GridBagConstraints(idxX++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 2, 2, 2), 0, 0));
        resultPanel.add((Component)this._ctrlPreferences, new GridBagConstraints(idxX++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 2, 2, 2), 0, 0));
        resultPanel.add((Component)this._ctrlClose, new GridBagConstraints(idxX++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 2, 2, 2), 0, 0));
        return resultPanel;
    }

    @Override
    protected void doPrintAction() {
        PrinterJob job = PrinterJob.getPrinterJob();
        job.setPageable(this._book);
        if (job.printDialog()) {
            try {
                job.print();
            }
            catch (PrinterException pe) {
                pe.printStackTrace();
            }
        }
    }

    protected void doFormatAction() {
        PrinterJob job = PrinterJob.getPrinterJob();
        PageFormat format = job.pageDialog(this._format);
        if (format == this._format) {
            return;
        }
        this._format = format;
        this.updatePreferencies();
        this._ctrlBrowseFirst.doClick();
        this._ctrlPreview.paintComponent(this.getGraphics());
        this._scrollView.revalidate();
        this.repaint();
    }

    protected synchronized void doPreferenciesAction() {
        if (this._prefField == null) {
            return;
        }
        PrefFieldsCategory prefField = this._prefField.getCopy();
        if (this._dlg == null) {
            this._dlg = new ChangePreferenciesDlg((Window)this, prefField.getPanel());
            StringBuilder sb = new StringBuilder().append(ResMsgVoc.getString("VOC_PREFERENCE")).append(" - ").append(this._prefField.getInfo("plugin.name"));
            this._dlg.setTitle(sb.toString());
        } else {
            this._dlg.setCenterComponent(prefField.getPanel());
        }
        this._dlg.setVisible(true);
        if (this._dlg.getResult()) {
            this._prefField = prefField;
            this._preferencies.addPrefFieldsCategorie(this._prefField);
            this._currentPage = 0;
            this.updatePreferencies();
            this.updateBrowse();
            this._ctrlPreview.paintComponent(this.getGraphics());
            this.repaint();
        }
    }

    static class PreferenciesDelegate
    extends Preferencies {
        Preferencies _delegate;
        Map<String, PrefFieldsCategory> _privatePrefs = new HashMap<String, PrefFieldsCategory>();

        PreferenciesDelegate(Preferencies source) {
            this._delegate = source;
        }

        PreferenciesDelegate addPrefFieldsCategorie(PrefFieldsCategory pref) {
            String key = pref.getInfo("plugin.key");
            this._privatePrefs.put(key, pref);
            return this;
        }

        @Override
        public PluginWithOptions getOptions(String key) {
            PrefFieldsCategory privatePref = this._privatePrefs.get(key);
            if (privatePref != null) {
                return privatePref;
            }
            return this._delegate.getOptions(key);
        }
    }

    static class ChangePreferenciesDlg
    extends JDialogCecilia {
        Component _centerComponent;

        public ChangePreferenciesDlg(Window owner, Component preferencyPanel) {
            super(owner, true);
            this._centerComponent = preferencyPanel;
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add(preferencyPanel, "Center");
            this.getContentPane().add((Component)this.createButPanel(), "South");
            this.init();
            this.pack();
            this.setLocationRelativeTo(owner);
            this.setResizable(false);
        }

        public void setCenterComponent(Component preferencyPanel) {
            this.getContentPane().remove(this._centerComponent);
            this.getContentPane().add(preferencyPanel, "Center");
            this._centerComponent = preferencyPanel;
        }

        @Override
        protected boolean verifyParameters() {
            return true;
        }
    }
}

