/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.cecilia.print;

import com.dassault.cecilia.core.cecilia.print.ListProcessorJava;
import com.dassault.cecilia.core.cecilia.print.PrintableLine;
import com.dassault.cecilia.core.cecilia.print.PrintableWordGroup;
import com.dassault.cecilia.core.cecilia.print.SrbInputStream;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.ImageIcon;

class TableJavaProcessor {
    private Vector _markTable = new Vector();
    private ListProcessorJava _listProcessorJava;
    private Table _currentTable;
    private int _columnCount = 0;
    public char antislash = (char)92;
    public PrintableLine _currentTabHeader = null;
    private Vector _lines = new Vector();
    private boolean _rtfSort = false;

    private int searchMark(String line) {
        int index = 0;
        Enumeration en = this._markTable.elements();
        while (en.hasMoreElements()) {
            String mark2 = (String)en.nextElement();
            if (line.indexOf(mark2) == 0) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public TableJavaProcessor(ListProcessorJava listProcessorJava) {
        this._listProcessorJava = listProcessorJava;
        this._markTable.addElement("<TABLEAU>");
        this._markTable.addElement("<TABTIT>");
        this._markTable.addElement("<TABCOL>");
        this._markTable.addElement("<TABDEF");
        this._markTable.addElement("<TABLINE>");
        this._markTable.addElement("<C>");
        this._markTable.addElement("<ETABLEAU>");
    }

    public void setRtfSort(boolean isRtf) {
        this._rtfSort = isRtf;
    }

    public boolean checkWidth() {
        return !this._rtfSort;
    }

    public void treatment(SrbInputStream inData, Vector outLines) {
        String inLine;
        this._currentTable = new Table();
        if (this._lines.size() != 0) {
            this._lines.removeAllElements();
        }
        block9: while ((inLine = inData.readLine()) != null) {
            switch (this.searchMark(inLine)) {
                case 0: {
                    this._currentTable = new Table();
                    continue block9;
                }
                case 1: {
                    this._currentTable.setTitle(inLine.substring(8));
                    continue block9;
                }
                case 2: {
                    this._currentTable.addColumn(new Column(inLine.substring(8)));
                    continue block9;
                }
                case 3: {
                    int position = inLine.indexOf("'");
                    inLine = inLine.substring(position + 1);
                    position = inLine.indexOf("'");
                    this._currentTable.setColumnWidth(inLine.substring(0, position));
                    inLine = inLine.substring(position + 1);
                    position = inLine.indexOf("'");
                    inLine = inLine.substring(position + 1);
                    position = inLine.indexOf("'");
                    this._currentTable.setColumnAlignment(inLine.substring(0, position));
                    this._currentTable.formatTitle();
                    continue block9;
                }
                case 4: {
                    this._currentTable.drawSeparator(this._lines);
                    continue block9;
                }
                case 5: {
                    Column column = this._currentTable.getColumnAt(this._columnCount++);
                    column.setCellValue(inLine.substring(3));
                    if (this._columnCount != this._currentTable.getColumnCount()) continue block9;
                    int maxHeight = this._currentTable.getMaxCellHeight();
                    for (int i = 0; i < maxHeight; ++i) {
                        Vector<String> oneLine = new Vector<String>();
                        for (int j = 0; j < this._currentTable.getColumnCount(); ++j) {
                            column = this._currentTable.getColumnAt(j);
                            String cellValueAt = column.getCellValueAt(i);
                            if (cellValueAt != null) {
                                oneLine.addElement(cellValueAt);
                                continue;
                            }
                            oneLine.addElement("");
                        }
                        this._lines.addElement(oneLine);
                    }
                    this._columnCount = 0;
                    continue block9;
                }
                case 6: {
                    if (!this._rtfSort) {
                        outLines.addElement(new PrintableLine("", 8));
                    }
                    this._currentTable.drawTitle(outLines);
                    if (!this._rtfSort || this._rtfSort && this._currentTable.hasVisibleHeader()) {
                        this._currentTable.drawHeader(outLines);
                    }
                    Enumeration enumLine = this._lines.elements();
                    while (enumLine.hasMoreElements()) {
                        Object object = enumLine.nextElement();
                        if (object instanceof PrintableLine) {
                            outLines.addElement(object);
                            continue;
                        }
                        Vector oneLine = (Vector)object;
                        this._currentTable.drawDataLine(outLines, oneLine);
                    }
                    if (!this._rtfSort) {
                        this._currentTable.drawEnd(outLines);
                        outLines.addElement(new PrintableLine("", 8));
                    }
                    return;
                }
            }
        }
    }

    public class Table {
        private Vector _columns = new Vector();
        private String _title = "";
        private Vector _multiLineTitle = new Vector();
        private int _width = 0;
        private boolean _hasVisibleHeader = true;

        public String rpad(String valeur, int taille, char padChar) {
            if (TableJavaProcessor.this._rtfSort) {
                return valeur;
            }
            String padString = new String("");
            String retour = new String(valeur);
            if (retour.length() < taille) {
                for (int i = 0; i < taille - retour.length(); ++i) {
                    padString = padString + padChar;
                }
                retour = retour + padString;
            } else if (retour.length() > taille) {
                retour = retour.substring(0, taille);
            }
            return retour;
        }

        public String sup_parenth(String stringin) {
            String stringout = new String("");
            char[] charArray = stringin.toCharArray();
            for (int i = 0; i < stringin.length(); ++i) {
                switch (charArray[i]) {
                    case '(': 
                    case ')': 
                    case '\\': {
                        stringout = stringout.concat("\\");
                    }
                }
                stringout = stringout.concat("" + charArray[i]);
            }
            return stringout;
        }

        public void drawHeader(Vector outLines) {
            PrintableWordGroup wordGroup;
            boolean first;
            int maxHeight = this.getMaxColumnNameHeight();
            PrintableLine pl = null;
            for (int r = 0; r < maxHeight; ++r) {
                first = true;
                Enumeration en = this._columns.elements();
                while (en.hasMoreElements()) {
                    int position;
                    Column column = (Column)en.nextElement();
                    String subName = column.getNameValueAt(r);
                    if (subName != null) {
                        position = (column.getWidth() - subName.length()) / 2;
                    } else {
                        subName = "";
                        position = 0;
                    }
                    if (first) {
                        pl = new PrintableLine(this.rpad(this.rpad("", position, ' ') + subName, column.getWidth(), ' '), 8);
                        pl.setTabLine(true);
                        if (r == 0) {
                            pl.setColumnHeaderTabLine(true);
                        }
                        wordGroup = pl.getGroupAt(0);
                        wordGroup.setAlignment(column.getAlignment());
                        wordGroup.setWidth(column.getWidth());
                        first = false;
                        continue;
                    }
                    wordGroup = pl.addGroup(this.rpad(this.rpad("", position, ' ') + subName, column.getWidth(), ' '));
                    wordGroup.setAlignment(column.getAlignment());
                    wordGroup.setWidth(column.getWidth());
                }
                if (TableJavaProcessor.this._currentTabHeader != null) {
                    TableJavaProcessor.this._currentTabHeader.addLine(pl);
                    continue;
                }
                TableJavaProcessor.this._currentTabHeader = pl;
                TableJavaProcessor.this._currentTabHeader.setHeaderTabLine(true);
                outLines.addElement(pl);
            }
            if (!TableJavaProcessor.this._rtfSort) {
                first = true;
                Enumeration en = this._columns.elements();
                while (en.hasMoreElements()) {
                    Column column = (Column)en.nextElement();
                    if (first) {
                        pl = new PrintableLine(this.rpad("", column.getWidth(), ' '), 8);
                        pl.setBoldAt(pl.groupCount() - 1, true);
                        pl.setTabLine(true);
                        if (maxHeight != 0) {
                            pl.setEmptyTabLine(true);
                        } else {
                            pl.setColumnHeaderTabLine(true);
                        }
                        first = false;
                        continue;
                    }
                    wordGroup = pl.addGroup(this.rpad("", column.getWidth(), ' '));
                    wordGroup.setBold(true);
                    wordGroup.setAlignment(column.getAlignment());
                    wordGroup.setWidth(column.getWidth());
                }
                if (TableJavaProcessor.this._currentTabHeader != null) {
                    TableJavaProcessor.this._currentTabHeader.addLine(pl);
                } else {
                    TableJavaProcessor.this._currentTabHeader = pl;
                    TableJavaProcessor.this._currentTabHeader.setHeaderTabLine(true);
                    outLines.addElement(TableJavaProcessor.this._currentTabHeader);
                }
            }
        }

        public void drawSeparator(Vector outLines) {
            PrintableLine pl = null;
            boolean first = true;
            Enumeration en = this._columns.elements();
            while (en.hasMoreElements()) {
                Column column = (Column)en.nextElement();
                if (first) {
                    pl = new PrintableLine(this.rpad("", column.getWidth(), ' '), 8);
                    pl.setTabLine(true);
                    pl.setTabSeparatorLine();
                    first = false;
                    continue;
                }
                pl.addGroup(this.rpad("", column.getWidth(), ' '));
            }
            outLines.addElement(pl);
        }

        BufferedImage createMargedImage(BufferedImage img) {
            int width = img.getWidth() + 6;
            int height = img.getHeight() + 6;
            BufferedImage margedImag = new BufferedImage(width, height, 1);
            Graphics2D graph = margedImag.createGraphics();
            graph.setClip(0, 0, width, height);
            graph.setColor(Color.white);
            graph.fillRect(0, 0, width, height);
            graph.drawImage((Image)img, 3, 3, null);
            return margedImag;
        }

        public void drawDataLine(Vector outLines, Vector oneLine) {
            int index = 0;
            PrintableLine pl = null;
            boolean first = true;
            Enumeration en = this._columns.elements();
            while (en.hasMoreElements()) {
                BufferedImage img;
                String path;
                int position;
                Column column = (Column)en.nextElement();
                String subCellData = (String)oneLine.elementAt(index++);
                switch (column.getAlignment()) {
                    case 'L': 
                    case 'l': {
                        position = 0;
                        break;
                    }
                    case 'R': 
                    case 'r': {
                        position = column.getWidth() - subCellData.length();
                        break;
                    }
                    default: {
                        position = (column.getWidth() - subCellData.length()) / 2;
                    }
                }
                PrintableWordGroup wordGroup = null;
                if (first) {
                    if (subCellData.startsWith("<IMG>") && subCellData.length() > 5) {
                        pl = new PrintableLine(this.rpad("", position, ' '), 8);
                        wordGroup = pl.addGroup(this.rpad(" ", column.getWidth(), ' '));
                        path = subCellData.substring(5);
                        if (path.endsWith("<EIMG>")) {
                            path = path.substring(0, path.length() - 6);
                        }
                        if ((img = TableJavaProcessor.this._listProcessorJava.createBufferedImage(path)) != null) {
                            wordGroup.setImage(new ImageIcon(this.createMargedImage(img)));
                        }
                    } else {
                        pl = new PrintableLine(this.rpad(this.rpad("", position, ' ') + subCellData, column.getWidth(), ' '), 8);
                        wordGroup = pl.getGroupAt(0);
                        if (TableJavaProcessor.this._rtfSort) {
                            wordGroup.setWordsOfGroup(this.treatCellAsText(subCellData));
                        }
                    }
                    pl.setTabLine(true);
                    first = false;
                } else if (subCellData.startsWith("<IMG>") && subCellData.length() > 5) {
                    wordGroup = pl.addGroup(this.rpad(" ", column.getWidth(), ' '));
                    path = subCellData.substring(5);
                    if (path.endsWith("<EIMG>")) {
                        path = path.substring(0, path.length() - 6);
                    }
                    if ((img = TableJavaProcessor.this._listProcessorJava.createBufferedImage(path)) != null) {
                        wordGroup.setImage(new ImageIcon(this.createMargedImage(img)));
                    }
                } else {
                    wordGroup = pl.addGroup(this.rpad(this.rpad("", position, ' ') + subCellData, column.getWidth(), ' '));
                    if (TableJavaProcessor.this._rtfSort) {
                        wordGroup.setWordsOfGroup(this.treatCellAsText(subCellData));
                    }
                }
                if (wordGroup == null) continue;
                wordGroup.setAlignment(column.getAlignment());
                wordGroup.setWidth(column.getWidth());
            }
            outLines.addElement(pl);
        }

        public void drawTitle(Vector outLines) {
            PrintableLine pl = null;
            TableJavaProcessor.this._currentTabHeader = null;
            Enumeration en = this._multiLineTitle.elements();
            while (en.hasMoreElements()) {
                String subTitle = (String)en.nextElement();
                int position = (this._width - subTitle.length()) / 2;
                pl = new PrintableLine(this.rpad(this.rpad("", position, ' ') + subTitle, this._width, ' '), 8);
                pl.setTabLine(true);
                if (TableJavaProcessor.this._currentTabHeader == null) {
                    TableJavaProcessor.this._currentTabHeader = pl;
                    TableJavaProcessor.this._currentTabHeader.setHeaderTabLine(true);
                    outLines.addElement(pl);
                    continue;
                }
                TableJavaProcessor.this._currentTabHeader.addLine(pl);
            }
            if (TableJavaProcessor.this._currentTabHeader != null && !TableJavaProcessor.this._rtfSort) {
                pl = new PrintableLine(this.rpad("", this._width, ' '), 8);
                pl.setTabLine(true);
                TableJavaProcessor.this._currentTabHeader.addLine(pl);
            }
        }

        public void drawEnd(Vector outLines) {
            boolean first = true;
            PrintableLine pl = null;
            Enumeration en = this._columns.elements();
            while (en.hasMoreElements()) {
                Column column = (Column)en.nextElement();
                if (first) {
                    pl = new PrintableLine(this.rpad("", column.getWidth(), ' '), 8);
                    pl.setBoldAt(pl.groupCount() - 1, true);
                    pl.setTabLine(true);
                    pl.setEndTabLine(true);
                    first = false;
                    continue;
                }
                PrintableWordGroup wordGroup = pl.addGroup(this.rpad("", column.getWidth(), ' '));
                wordGroup.setBold(true);
            }
            outLines.addElement(pl);
        }

        public Vector treatCellAsText(String line) {
            boolean bold = false;
            boolean underline = false;
            boolean strike = false;
            Vector<PrintableWordGroup> wordsOfGroup = new Vector<PrintableWordGroup>();
            while (line.length() != 0) {
                PrintableWordGroup wordGroup;
                int position;
                String token = line;
                line = "";
                block23: while ((position = ListProcessorJava.findMark(token)) != -1 && token.length() != 0) {
                    if (position == 0) {
                        switch (ListProcessorJava.treatMark(token)) {
                            case 21: {
                                underline = true;
                                token = token.substring(token.indexOf(">") + 1);
                                continue block23;
                            }
                            case 22: {
                                underline = false;
                                token = token.substring(token.indexOf(">") + 1);
                                continue block23;
                            }
                            case 23: {
                                bold = true;
                                token = token.substring(token.indexOf(">") + 1);
                                continue block23;
                            }
                            case 24: {
                                bold = false;
                                token = token.substring(token.indexOf(">") + 1);
                                continue block23;
                            }
                            case 25: {
                                continue block23;
                            }
                            case 26: {
                                continue block23;
                            }
                            case 27: {
                                strike = true;
                                token = token.substring(token.indexOf(">") + 1);
                                continue block23;
                            }
                            case 28: {
                                strike = false;
                                token = token.substring(token.indexOf(">") + 1);
                                continue block23;
                            }
                            case -1: {
                                if (token.length() == 0) continue block23;
                                wordGroup = new PrintableWordGroup(token.substring(0, token.indexOf(">") + 1));
                                wordGroup.setBold(bold);
                                wordGroup.setUnderline(underline);
                                wordGroup.setStrike(strike);
                                wordsOfGroup.addElement(wordGroup);
                                token = token.substring(token.indexOf(">") + 1);
                                continue block23;
                            }
                        }
                        continue;
                    }
                    wordGroup = new PrintableWordGroup(token.substring(0, position));
                    wordGroup.setBold(bold);
                    wordGroup.setUnderline(underline);
                    wordGroup.setStrike(strike);
                    wordsOfGroup.addElement(wordGroup);
                    token = token.substring(position);
                    switch (ListProcessorJava.treatMark(token)) {
                        case 21: {
                            underline = true;
                            token = token.substring(token.indexOf(">") + 1);
                            continue block23;
                        }
                        case 22: {
                            underline = false;
                            token = token.substring(token.indexOf(">") + 1);
                            continue block23;
                        }
                        case 23: {
                            bold = true;
                            token = token.substring(token.indexOf(">") + 1);
                            continue block23;
                        }
                        case 24: {
                            bold = false;
                            token = token.substring(token.indexOf(">") + 1);
                            continue block23;
                        }
                        case 25: {
                            continue block23;
                        }
                        case 26: {
                            continue block23;
                        }
                        case 27: {
                            strike = true;
                            token = token.substring(token.indexOf(">") + 1);
                            continue block23;
                        }
                        case 28: {
                            strike = false;
                            token = token.substring(token.indexOf(">") + 1);
                            continue block23;
                        }
                        case -1: {
                            if (token.length() == 0) continue block23;
                            wordGroup = new PrintableWordGroup(token.substring(0, token.indexOf(">") + 1));
                            wordGroup.setBold(bold);
                            wordGroup.setUnderline(underline);
                            wordGroup.setStrike(strike);
                            wordsOfGroup.addElement(wordGroup);
                            token = token.substring(token.indexOf(">") + 1);
                            continue block23;
                        }
                    }
                }
                if (token.length() == 0) continue;
                wordGroup = new PrintableWordGroup(token);
                wordGroup.setBold(bold);
                wordGroup.setUnderline(underline);
                wordGroup.setStrike(strike);
                wordsOfGroup.addElement(wordGroup);
            }
            return wordsOfGroup;
        }

        public void setTitle(String title) {
            this._title = new String(title);
        }

        public String getTitle() {
            return this._title;
        }

        public void addColumn(Column column) {
            this._columns.addElement(column);
        }

        public Column getColumnAt(int index) {
            return (Column)this._columns.elementAt(index);
        }

        public Column getLastColumn() {
            return (Column)this._columns.lastElement();
        }

        public Column getFirstColumn() {
            return (Column)this._columns.firstElement();
        }

        public int getColumnCount() {
            return this._columns.size();
        }

        public void setColumnWidth(String line) {
            StringTokenizer stoken = new StringTokenizer(line, " ", false);
            int i = 0;
            while (stoken.hasMoreTokens()) {
                Column column;
                if (i == this.getColumnCount()) {
                    this.addColumn(new Column());
                    column = this.getColumnAt(i);
                    column.setWidth(Integer.parseInt(stoken.nextToken()));
                    this._hasVisibleHeader = false;
                } else {
                    column = this.getColumnAt(i);
                    column.setWidth(Integer.parseInt(stoken.nextToken()));
                    column.formatName();
                }
                ++i;
            }
        }

        public void setColumnAlignment(String line) {
            StringTokenizer stoken = new StringTokenizer(line, " ", false);
            int i = 0;
            while (stoken.hasMoreTokens()) {
                Column column;
                if (i == this.getColumnCount()) {
                    this.addColumn(new Column());
                    column = this.getColumnAt(i);
                    column.setAlignment(stoken.nextToken().toCharArray()[0]);
                } else {
                    column = this.getColumnAt(i);
                    column.setAlignment(stoken.nextToken().toCharArray()[0]);
                }
                ++i;
            }
        }

        public int computeWidth() {
            int width = 0;
            Enumeration en = this._columns.elements();
            while (en.hasMoreElements()) {
                width += ((Column)en.nextElement()).getWidth();
            }
            return width;
        }

        public int getMaxCellHeight() {
            int maxHeight = 0;
            Enumeration en = this._columns.elements();
            while (en.hasMoreElements()) {
                Column column = (Column)en.nextElement();
                if (column.getCellHeight() <= maxHeight) continue;
                maxHeight = column.getCellHeight();
            }
            return maxHeight;
        }

        public int getMaxColumnNameHeight() {
            int maxHeight = 0;
            Enumeration en = this._columns.elements();
            while (en.hasMoreElements()) {
                Column column = (Column)en.nextElement();
                if (column.getNameHeight() <= maxHeight) continue;
                maxHeight = column.getNameHeight();
            }
            return maxHeight;
        }

        public int getTitleHeight() {
            return this._multiLineTitle.size();
        }

        public void formatTitle() {
            if (!TableJavaProcessor.this._rtfSort) {
                this._width = this.computeWidth();
                if (this._width != 0 && this._title.length() != 0) {
                    String localString = new String(this._title);
                    while (localString.length() > this._width) {
                        String localSubString = localString.substring(0, this._width);
                        int position = localSubString.lastIndexOf(" ");
                        if (position != -1) {
                            this._multiLineTitle.addElement(localSubString.substring(0, position));
                            localString = localString.substring(position + 1);
                            continue;
                        }
                        this._multiLineTitle.addElement(localSubString);
                        localString = localString.substring(this._width);
                    }
                    this._multiLineTitle.addElement(localString);
                }
            } else if (this._title.length() != 0) {
                this._multiLineTitle.addElement(this._title);
            }
        }

        public boolean hasVisibleHeader() {
            return this._hasVisibleHeader;
        }

        public String toString() {
            String value = new String("[");
            Enumeration en = this._multiLineTitle.elements();
            while (en.hasMoreElements()) {
                String str = (String)en.nextElement();
                if (str != this._multiLineTitle.lastElement()) {
                    value = value.concat(str + ", ");
                    continue;
                }
                value = value.concat(str + "]\n");
            }
            for (int i = 0; i < this.getColumnCount(); ++i) {
                value = value.concat(this.getColumnAt(i).toString() + "\n");
            }
            return value;
        }
    }

    public class Column {
        private int _width = 0;
        private char _align = (char)76;
        private String _name = "";
        private int _tab = 0;
        private Vector _multiLineName = new Vector();
        private boolean _hasTitle;
        private Vector _multiLineCell = new Vector();

        public Column(String name) {
            this._name = new String(name);
            this._hasTitle = true;
        }

        public Column() {
            this._hasTitle = false;
        }

        public boolean hasTitle() {
            return this._hasTitle;
        }

        public String getName() {
            return this._name;
        }

        public void setTab(int tab) {
            this._tab = tab;
        }

        public int getTab() {
            return this._tab;
        }

        public void setWidth(int width) {
            this._width = width;
        }

        public int getWidth() {
            return this._width;
        }

        public int getHeight() {
            return this._multiLineName.size();
        }

        public void setAlignment(char align) {
            this._align = align;
        }

        public char getAlignment() {
            return this._align;
        }

        public void formatName() {
            this.formatString(this._name, this._multiLineName);
        }

        public void formatString(String str, Vector v) {
            block28: {
                if (!TableJavaProcessor.this.checkWidth()) {
                    v.addElement(str);
                    return;
                }
                if (str.startsWith("<IMG>")) {
                    v.addElement(str);
                    return;
                }
                int width = 0;
                if (this._width != 0) {
                    width = this._width - 1;
                }
                if (width == 0) break block28;
                String localString = new String(str);
                boolean fin = false;
                String concatString = "";
                while (!fin) {
                    block26: {
                        int position;
                        String localSubString;
                        String fullString;
                        block27: {
                            fullString = "";
                            localSubString = "";
                            while (true) {
                                int positionFin;
                                int positionDebut;
                                if ((positionDebut = localString.indexOf("<HP1>")) == 0) {
                                    fullString = fullString.concat("<HP1>");
                                    localString = localString.substring(positionDebut + 5);
                                    positionFin = localString.indexOf("<EHP1>");
                                    concatString = localString.substring(0, positionFin);
                                    if (localSubString.length() + concatString.length() > width) {
                                        position = (concatString = concatString.substring(0, width - localSubString.length())).lastIndexOf(" ");
                                        if (position != -1 && position != 0) {
                                            concatString = concatString.substring(0, position);
                                        }
                                        fullString = fullString.concat(concatString + "<EHP1>");
                                        v.addElement(fullString);
                                        localString = "<HP1>" + localString.substring(concatString.length());
                                    } else {
                                        localSubString = localSubString.concat(concatString);
                                        fullString = fullString.concat(concatString + "<EHP1>");
                                        if (!(localString = localString.substring(positionFin + 6)).equals("")) continue;
                                        v.addElement(fullString);
                                    }
                                    break block26;
                                }
                                positionDebut = localString.indexOf("<HP2>");
                                if (positionDebut == 0) {
                                    fullString = fullString.concat("<HP2>");
                                    localString = localString.substring(positionDebut + 5);
                                    positionFin = localString.indexOf("<EHP2>");
                                    concatString = localString.substring(0, positionFin);
                                    if (localSubString.length() + concatString.length() > width) {
                                        position = (concatString = concatString.substring(0, width - localSubString.length())).lastIndexOf(" ");
                                        if (position != -1 && position != 0) {
                                            concatString = concatString.substring(0, position);
                                        }
                                        fullString = fullString.concat(concatString + "<EHP2>");
                                        v.addElement(fullString);
                                        localString = "<HP2>" + localString.substring(concatString.length());
                                    } else {
                                        localSubString = localSubString.concat(concatString);
                                        fullString = fullString.concat(concatString + "<EHP2>");
                                        if (!(localString = localString.substring(positionFin + 6)).equals("")) continue;
                                        v.addElement(fullString);
                                    }
                                    break block26;
                                }
                                positionDebut = localString.indexOf("<HP3>");
                                if (positionDebut == 0) {
                                    fullString = fullString.concat("<HP3>");
                                    localString = localString.substring(positionDebut + 5);
                                    positionFin = localString.indexOf("<EHP3>");
                                    concatString = localString.substring(0, positionFin);
                                    if (localSubString.length() + concatString.length() > width) {
                                        position = (concatString = concatString.substring(0, width - localSubString.length())).lastIndexOf(" ");
                                        if (position != -1 && position != 0) {
                                            concatString = concatString.substring(0, position);
                                        }
                                        fullString = fullString.concat(concatString + "<EHP3>");
                                        v.addElement(fullString);
                                        localString = "<HP3>" + localString.substring(concatString.length());
                                    } else {
                                        localSubString = localSubString.concat(concatString);
                                        fullString = fullString.concat(concatString + "<EHP3>");
                                        if (!(localString = localString.substring(positionFin + 6)).equals("")) continue;
                                        v.addElement(fullString);
                                    }
                                    break block26;
                                }
                                positionDebut = localString.indexOf("<HP4>");
                                if (positionDebut == 0) {
                                    fullString = fullString.concat("<HP4>");
                                    localString = localString.substring(positionDebut + 5);
                                    positionFin = localString.indexOf("<EHP4>");
                                    concatString = localString.substring(0, positionFin);
                                    if (localSubString.length() + concatString.length() > width) {
                                        position = (concatString = concatString.substring(0, width - localSubString.length())).lastIndexOf(" ");
                                        if (position != -1 && position != 0) {
                                            concatString = concatString.substring(0, position);
                                        }
                                        fullString = fullString.concat(concatString + "<EHP4>");
                                        v.addElement(fullString);
                                        localString = "<HP4>" + localString.substring(concatString.length());
                                    } else {
                                        localSubString = localSubString.concat(concatString);
                                        fullString = fullString.concat(concatString + "<EHP4>");
                                        if (!(localString = localString.substring(positionFin + 6)).equals("")) continue;
                                        v.addElement(fullString);
                                    }
                                    break block26;
                                }
                                positionDebut = this.minIntPositif(localString.indexOf("<HP1>"), localString.indexOf("<HP2>"), localString.indexOf("<HP3>"), localString.indexOf("<HP4>"));
                                if (positionDebut == -1) break block27;
                                concatString = localString.substring(0, positionDebut);
                                if (localSubString.length() + concatString.length() > width) {
                                    position = (concatString = concatString.substring(0, width - localSubString.length())).lastIndexOf(" ");
                                    if (position != -1 && position != 0) {
                                        concatString = concatString.substring(0, position);
                                    }
                                    fullString = fullString.concat(concatString);
                                    v.addElement(fullString);
                                    localString = localString.substring(concatString.length());
                                    break block26;
                                }
                                localSubString = localSubString.concat(concatString);
                                fullString = fullString.concat(concatString);
                                if ((localString = localString.substring(positionDebut)).equals("")) break;
                            }
                            v.addElement(fullString);
                            break block26;
                        }
                        concatString = localString;
                        if (localSubString.length() + concatString.length() > width) {
                            position = (concatString = concatString.substring(0, width - localSubString.length())).lastIndexOf(" ");
                            if (position != -1 && position != 0) {
                                concatString = concatString.substring(0, position);
                            }
                            fullString = fullString.concat(concatString);
                            v.addElement(fullString);
                            localString = localString.substring(concatString.length());
                        } else {
                            v.addElement(fullString + concatString);
                            localString = "";
                        }
                    }
                    fin = localString.equals("");
                }
            }
        }

        public int minIntPositif(int ... values) {
            int pos = Integer.MAX_VALUE;
            boolean atLeastOneValue = false;
            for (int i = values.length - 1; i >= 0; --i) {
                int val = values[i];
                if (val == -1) continue;
                if (val < pos) {
                    val = pos;
                }
                atLeastOneValue = true;
            }
            if (atLeastOneValue) {
                return pos;
            }
            return -1;
        }

        public void setCellValue(String value) {
            if (this._multiLineCell.size() != 0) {
                this._multiLineCell.removeAllElements();
            }
            if (this._width != 0) {
                this.formatString(value, this._multiLineCell);
            } else {
                this._multiLineCell.addElement(value);
            }
        }

        public int getCellHeight() {
            return this._multiLineCell.size();
        }

        public int getNameHeight() {
            return this._multiLineName.size();
        }

        public String getNameValueAt(int index) {
            try {
                String value = (String)this._multiLineName.elementAt(index);
                return value;
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                return null;
            }
        }

        public String getCellValueAt(int index) {
            try {
                String value = (String)this._multiLineCell.elementAt(index);
                return value;
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                return null;
            }
        }

        public String toString() {
            String value = new String("[");
            Enumeration en = this._multiLineName.elements();
            while (en.hasMoreElements()) {
                String str = (String)en.nextElement();
                if (str != this._multiLineName.lastElement()) {
                    value = value.concat(str + ", ");
                    continue;
                }
                value = value.concat(str + "]");
            }
            value = value.concat(" width = " + this._width + " align = " + this._align);
            return value;
        }
    }
}

