/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.cecilia.stepper.view;

import com.dassault.cecilia.core.cecilia.stepper.SimStepper;
import com.dassault.cecilia.core.cecilia.stepper.ViewData;
import com.dassault.cecilia.core.cecilia.stepper.ViewDomain;
import com.dassault.cecilia.core.cecilia.stepper.ViewFolder;
import com.dassault.cecilia.core.cecilia.stepper.ViewListener;
import com.dassault.cecilia.core.cecilia.stepper.ViewNode;
import com.dassault.cecilia.core.cecilia.stepper.ViewRoot;
import com.dassault.cecilia.core.cecilia.stepper.ViewStepper;
import com.dassault.cecilia.core.cecilia.stepper.ViewTransition;
import com.dassault.cecilia.core.cecilia.stepper.ViewVariable;
import com.dassault.cecilia.core.cecilia.stepper.view.TreeRenderedNode;
import com.dassault.cecilia.lib.util.ResIcoAbstract;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class TreeModelNode
implements TreeModel,
ViewListener {
    private Class _type;
    private boolean _select;
    private ViewStepper _stepper = null;
    private ViewFolder _selectRoot = null;
    private EventListenerList listeners = new EventListenerList();
    private JTree _connectTree;
    private ViewTransition _trSelect = null;

    public TreeModelNode() {
        this(ViewData.class, false);
    }

    public TreeModelNode(Class type, boolean select) {
        this._type = type;
        this._select = select;
    }

    public ViewRoot getViewRoot() {
        return this._stepper == null ? null : this._stepper.getRoot();
    }

    @Override
    public Object getRoot() {
        return this._selectRoot;
    }

    @Override
    public Object getChild(Object arg0, int idx) {
        ViewDomain dom;
        assert (arg0 instanceof ViewNode);
        ViewNode parent = (ViewNode)arg0;
        ViewRoot root = this.getViewRoot();
        if (parent instanceof ViewVariable && root.withDomain() && (dom = ((ViewVariable)parent).getDomain(root)) != null) {
            return dom.getChildAt(idx);
        }
        if (this._type == ViewData.class) {
            return parent.getChildAt(idx);
        }
        for (int i = 0; i < parent.getChildCount(); ++i) {
            ViewNode child = parent.getChildAt(i);
            if (child.isFolder()) {
                if (child.findWithInstance(this._type)) {
                    --idx;
                }
            } else if (this._type.isInstance(child)) {
                --idx;
            }
            if (idx >= 0) continue;
            return child;
        }
        return null;
    }

    @Override
    public int getChildCount(Object arg0) {
        ViewDomain dom;
        ViewNode parent = (ViewNode)arg0;
        ViewRoot root = this.getViewRoot();
        if (parent instanceof ViewVariable && root.withDomain() && (dom = ((ViewVariable)parent).getDomain(root)) != null) {
            return dom.getChildCount();
        }
        if (this._type == ViewData.class) {
            return parent.getChildCount();
        }
        int cpt = 0;
        for (int i = 0; i < parent.getChildCount(); ++i) {
            ViewNode child = parent.getChildAt(i);
            if (child.isFolder()) {
                if (!child.findWithInstance(this._type)) continue;
                ++cpt;
                continue;
            }
            if (!this._type.isInstance(child)) continue;
            ++cpt;
        }
        return cpt;
    }

    @Override
    public boolean isLeaf(Object arg0) {
        ViewDomain dom;
        ViewNode parent = (ViewNode)arg0;
        ViewRoot root = this.getViewRoot();
        if (root == null) {
            return false;
        }
        if (parent instanceof ViewVariable && root.withDomain() && (dom = ((ViewVariable)parent).getDomain(root)) != null) {
            return dom.getChildCount() == 0;
        }
        return ((ViewNode)arg0).getChildCount() == 0;
    }

    @Override
    public void valueForPathChanged(TreePath arg0, Object arg1) {
    }

    @Override
    public int getIndexOfChild(Object arg0, Object arg1) {
        if (arg0 == null || arg1 == null) {
            return -1;
        }
        ViewData parent = (ViewData)arg0;
        int cpt = 0;
        for (int i = 0; i < parent.getChildCount(); ++i) {
            ViewNode child = parent.getChildAt(i);
            if (!child.isFolder() ? !this._type.isInstance(child) : !child.findWithInstance(this._type)) continue;
            if (child == arg1) {
                return cpt;
            }
            ++cpt;
        }
        return -1;
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.listeners.add(TreeModelListener.class, l);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.listeners.add(TreeModelListener.class, l);
    }

    protected void fireStructureChanged() {
        Object root = this.getRoot();
        TreeModelEvent e = root == null ? new TreeModelEvent((Object)this, (TreePath)null) : new TreeModelEvent((Object)this, new TreePath(root));
        Object[] lists = this.listeners.getListenerList();
        for (int i = lists.length - 2; i >= 0; i -= 2) {
            if (lists[i] != TreeModelListener.class) continue;
            ((TreeModelListener)lists[i + 1]).treeStructureChanged(e);
        }
    }

    protected void fireNodesChanged(ViewData node) {
        TreePath path = null;
        path = this._select ? node.getParent().getTreePathUntil(this._selectRoot) : node.getParent().getTreePath();
        if (path == null) {
            return;
        }
        TreeModelEvent e = new TreeModelEvent((Object)this, path, new int[]{this.getIndexOfChild(node.getParent(), node)}, new Object[]{node});
        Object[] lists = this.listeners.getListenerList();
        for (int i = lists.length - 2; i >= 0; i -= 2) {
            if (lists[i] != TreeModelListener.class) continue;
            ((TreeModelListener)lists[i + 1]).treeNodesChanged(e);
        }
    }

    public void connectTree(JTree tree) {
        this._connectTree = tree;
        this._connectTree.setCellRenderer(new TreeRenderedNode());
        this._connectTree.getSelectionModel().setSelectionMode(1);
        this._connectTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                TreePath path = TreeModelNode.this._connectTree.getSelectionPath();
                if (path == null) {
                    return;
                }
                ViewNode sel = (ViewNode)path.getLastPathComponent();
                TreeModelNode.this._trSelect = null;
                if (sel instanceof ViewTransition) {
                    TreeModelNode.this._trSelect = (ViewTransition)sel;
                }
            }
        });
        this._connectTree.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                if (evt.getKeyCode() != 32) {
                    return;
                }
                TreeModelNode.this.triggerSelectTransition();
            }
        });
        this._connectTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (evt.getClickCount() < 2) {
                    return;
                }
                if (!SwingUtilities.isLeftMouseButton(evt)) {
                    return;
                }
                TreeModelNode.this.triggerSelectTransition();
            }
        });
        this._connectTree.setRowHeight(ResIcoAbstract.getIconSize());
    }

    private void triggerSelectTransition() {
        if (this._trSelect == null) {
            return;
        }
        if (this._stepper == null) {
            return;
        }
        if (!(this._stepper instanceof SimStepper)) {
            return;
        }
        if (this._trSelect.isValid()) {
            ((SimStepper)this._stepper).goForward(this._trSelect);
        }
    }

    public void setType(Class type) {
        this._type = type;
        this.fireStructureChanged();
    }

    public void setStepper(ViewStepper vwStep) {
        this._stepper = vwStep;
        if (this._stepper != null) {
            if (this._select) {
                // empty if block
            }
            this._selectRoot = this._stepper.getRoot();
        } else {
            this._selectRoot = null;
        }
        this.fireStructureChanged();
    }

    @Override
    public void altaModelChanged(ViewStepper vwStep) {
        this.setStepper(vwStep);
    }

    @Override
    public void altaTransitionUpdate(ViewTransition tr) {
        if (this._type.isInstance(tr)) {
            this.fireNodesChanged(tr);
        }
    }

    @Override
    public void altaStateUpdate(ViewVariable state) {
        if (this._type.isInstance(state)) {
            this.fireNodesChanged(state);
        }
    }

    @Override
    public void altaFlowUpdate(ViewVariable flow) {
        if (this._type.isInstance(flow)) {
            this.fireNodesChanged(flow);
        }
    }

    @Override
    public void altaOtherUpdate(int type, Object data) {
        if (type != 5) {
            return;
        }
        if (this._stepper == null) {
            return;
        }
        ViewData selectData = this._stepper.getRoot();
        if (data != null) {
            String path = data.toString();
            selectData = this._stepper.getRoot().getData(path, false);
        }
        if (selectData == null) {
            return;
        }
        if (this._select) {
            if (selectData != null && selectData instanceof ViewFolder && selectData != this._selectRoot) {
                this._selectRoot = (ViewFolder)selectData;
                this.fireStructureChanged();
            } else {
                this._selectRoot = this._stepper.getRoot();
            }
        } else if (this._connectTree != null) {
            ViewNode child;
            TreePath selectPath = selectData.getTreePath();
            this._connectTree.expandPath(selectPath);
            int childCount = selectData.getChildCount();
            if (childCount > 0 && (child = selectData.getChildAt(childCount - 1)) != null && child instanceof ViewData) {
                TreePath childPath = ((ViewData)child).getTreePath();
                this._connectTree.scrollPathToVisible(childPath);
            }
            this._connectTree.scrollPathToVisible(selectPath);
            this._connectTree.setSelectionPath(selectPath);
        }
    }
}

