/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.plugin;

import com.dassault.cecilia.core.plugin.Plugable;

public class UtilityPlugable {
    public static boolean isBooleanInfo(Plugable launcher, String infoKey, boolean defaultValue) {
        String resultKey = launcher.getInfo(infoKey);
        if (resultKey == null) {
            return defaultValue;
        }
        if (resultKey.equals("true")) {
            return true;
        }
        if (resultKey.equals("false")) {
            return false;
        }
        return defaultValue;
    }

    public static boolean getBooleanOption(Plugable launcher, String optionKey, boolean defaultValue) {
        String resultKey = launcher.getOption(optionKey);
        if (resultKey == null) {
            return defaultValue;
        }
        if (resultKey.equals("true")) {
            return true;
        }
        if (resultKey.equals("false")) {
            return false;
        }
        return defaultValue;
    }

    public static void setBooleanOption(Plugable launcher, String optionKey, boolean value) {
        launcher.setOption(optionKey, Boolean.toString(value));
    }

    public static long getLongOption(Plugable launcher, String optionKey, long defaultValue) {
        String resultKey = launcher.getOption(optionKey);
        if (resultKey == null) {
            return defaultValue;
        }
        if (resultKey.isEmpty()) {
            return defaultValue;
        }
        try {
            return Long.parseLong(resultKey);
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }
}

