/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.swing.table;

import com.dassault.cecilia.core.ResIcoCore;
import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.core.swing.CeciliaAction;
import com.dassault.cecilia.core.swing.table.CeciliaTable;
import com.dassault.cecilia.core.swing.table.TableDecoredItem;
import com.dassault.cecilia.core.swing.table.TableDecoredModel;
import com.dassault.cecilia.core.swing.table.TableDecoredRenderer;
import com.dassault.cecilia.lib.util.logging.LogUtility;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class TableDecoredPanel<E extends TableDecoredItem>
extends JPanel {
    TableDecoredModel<E> _modelTable;
    protected CeciliaTable _ctrlTable;
    CeciliaAction _ctrlAdd;
    CeciliaAction _ctrlDel;
    CeciliaAction _ctrlUp;
    CeciliaAction _ctrlDown;
    JPopupMenu _popupList;

    public TableDecoredPanel(TableDecoredModel<E> model) {
        super(new BorderLayout());
        this._modelTable = model;
        this.initialise();
    }

    protected void initialise() {
        this._ctrlAdd = new CeciliaAction(ResIcoCore.getImageIcon("BUT_ADD"), ResMsgVoc.getString("VOC_ADD"), ResMsgCore.getString("ACTION_ADD_TTIP")){

            @Override
            public void actionPerformed(ActionEvent e) {
                int idx = TableDecoredPanel.this._ctrlTable.getSelectedRow();
                if (idx == -1) {
                    TableDecoredPanel.this._modelTable.addData(null);
                    idx = TableDecoredPanel.this._modelTable.getRowCount() - 1;
                } else {
                    TableDecoredPanel.this._modelTable.insertData(null, idx);
                }
                TableDecoredPanel.this._ctrlTable.editCellAt(idx, 0);
                TableDecoredPanel.this.refreshCtrl();
            }
        };
        this._ctrlDel = new CeciliaAction(ResIcoCore.getImageIcon("BUT_DEL"), ResMsgVoc.getString("VOC_DELETE"), ResMsgCore.getString("ACTION_DEL_TTIP")){

            @Override
            public void actionPerformed(ActionEvent e) {
                int idx = TableDecoredPanel.this._ctrlTable.getSelectedRow();
                if (idx != -1) {
                    TableDecoredPanel.this._modelTable.removeData(idx);
                    TableDecoredPanel.this.refreshCtrl();
                } else {
                    LogUtility.logStackTrace((Logger)LogUtility.getLog(TableDecoredPanel.class), (Level)Level.FINER, (String)"Idx no correct");
                }
            }
        };
        this._ctrlUp = new CeciliaAction(ResIcoCore.getImageIcon("BUT_UP"), ResMsgVoc.getString("VOC_UP"), ResMsgCore.getString("ACTION_UP_TTIP")){

            @Override
            public void actionPerformed(ActionEvent e) {
                int idx = TableDecoredPanel.this._ctrlTable.getSelectedRow();
                if (idx != -1 && idx > 0) {
                    TableDecoredPanel.this._modelTable.down(idx);
                    TableDecoredPanel.this._ctrlTable.setRowSelectionInterval(idx - 1, idx - 1);
                    TableDecoredPanel.this.refreshCtrl();
                } else {
                    LogUtility.logStackTrace((Logger)LogUtility.getLog(TableDecoredPanel.class), (Level)Level.FINER, (String)"Idx no correct");
                }
            }
        };
        this._ctrlDown = new CeciliaAction(ResIcoCore.getImageIcon("BUT_DOWN"), ResMsgVoc.getString("VOC_DOWN"), ResMsgCore.getString("ACTION_DOWN_TTIP")){

            @Override
            public void actionPerformed(ActionEvent e) {
                int idx = TableDecoredPanel.this._ctrlTable.getSelectedRow();
                if (idx != -1 && idx < TableDecoredPanel.this._modelTable.getRowCount() - 1) {
                    TableDecoredPanel.this._modelTable.up(idx);
                    TableDecoredPanel.this._ctrlTable.setRowSelectionInterval(idx + 1, idx + 1);
                    TableDecoredPanel.this.refreshCtrl();
                } else {
                    LogUtility.logStackTrace((Logger)LogUtility.getLog(TableDecoredPanel.class), (Level)Level.FINER, (String)"Idx no correct");
                }
            }
        };
        JToolBar toolbar = new JToolBar();
        toolbar.setBorder(CeciliaAction.STANDARD_BORDER);
        this.createBoxActions(toolbar);
        toolbar.setFloatable(false);
        this.add((Component)toolbar, "North");
        this._popupList = this.createMenuActions();
        this._ctrlTable = this.createTable(this._modelTable);
        this._ctrlTable.putClientProperty("JTable.autoStartsEdit", Boolean.FALSE);
        TableDecoredRenderer rendered = new TableDecoredRenderer();
        this._ctrlTable.setDefaultRenderer(String.class, rendered);
        this._ctrlTable.setPreferredScrollableViewportSize(this.getPreferredScrollableViewportSize());
        JScrollPane scrTable = new JScrollPane(this._ctrlTable);
        scrTable.setComponentPopupMenu(this._popupList);
        ListSelectionModel selMod = this._ctrlTable.getSelectionModel();
        selMod.setSelectionMode(0);
        selMod.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                TableDecoredPanel.this.refreshCtrl();
            }
        });
        TableColumnModel colModel = this._ctrlTable.getColumnModel();
        for (int i = 0; i < this._modelTable.getColumnCount(); ++i) {
            int width;
            TableColumn column = colModel.getColumn(i);
            TableCellEditor edit = this._modelTable._defTgt.getEditor(i);
            if (edit != null) {
                column.setCellEditor(edit);
            }
            if ((width = this._modelTable._defTgt.getDefaultWidth(i)) <= 0) continue;
            column.setPreferredWidth(width);
        }
        this._modelTable.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                TableDecoredPanel.this.refreshCtrl();
            }
        });
        this.add((Component)scrTable, "Center");
        this.refreshCtrl();
    }

    protected CeciliaTable createTable(TableModel model) {
        return new CeciliaTable(model);
    }

    private JPopupMenu createMenuActions() {
        JPopupMenu popupList = new JPopupMenu();
        popupList.add(this._ctrlAdd);
        popupList.add(this._ctrlDel);
        popupList.add(this._ctrlUp);
        popupList.add(this._ctrlDown);
        return popupList;
    }

    protected Dimension getPreferredScrollableViewportSize() {
        return new Dimension(400, 100);
    }

    protected void createBoxActions(Container aPanel) {
        aPanel.add(Box.createGlue());
        aPanel.add(this._ctrlAdd.createButton(CeciliaAction.BorderStyle.LIGHT));
        aPanel.add(Box.createRigidArea(CeciliaAction.RIGID_AREA));
        aPanel.add(this._ctrlDel.createButton(CeciliaAction.BorderStyle.LIGHT));
        aPanel.add(Box.createRigidArea(CeciliaAction.RIGID_AREA));
        aPanel.add(this._ctrlUp.createButton(CeciliaAction.BorderStyle.LIGHT));
        aPanel.add(Box.createRigidArea(CeciliaAction.RIGID_AREA));
        aPanel.add(this._ctrlDown.createButton(CeciliaAction.BorderStyle.LIGHT));
    }

    protected void refreshCtrl() {
        boolean isEnabled = this.isEnabled();
        int idx = this._ctrlTable.getSelectedRow();
        int nbr = this._ctrlTable.getRowCount();
        this._ctrlAdd.setEnabled(isEnabled);
        this._ctrlDel.setEnabled(isEnabled && idx != -1);
        this._ctrlUp.setEnabled(isEnabled && idx != -1 && idx > 0);
        this._ctrlDown.setEnabled(isEnabled && idx != -1 && idx < nbr - 1);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this._ctrlTable.setEnabled(enabled);
        this.refreshCtrl();
    }
}

