/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.taskmanager;

import com.dassault.cecilia.core.ResIcoCore;
import com.dassault.cecilia.core.plugin.PlugPanel;
import com.dassault.cecilia.core.plugin.PlugTask;
import com.dassault.cecilia.core.swing.CeciliaAction;
import com.dassault.cecilia.core.swing.table.CeciliaTable;
import com.dassault.cecilia.core.taskmanager.ResTask;
import com.dassault.cecilia.core.taskmanager.TableRenderedPlugTask;
import com.dassault.cecilia.core.taskmanager.TableRenderedProgress;
import com.dassault.cecilia.core.taskmanager.TableRenderedTaskThreadState;
import com.dassault.cecilia.core.taskmanager.TableRenderedTimes;
import com.dassault.cecilia.core.taskmanager.TaskList;
import com.dassault.cecilia.core.taskmanager.TaskState;
import com.dassault.cecilia.core.taskmanager.TaskThread;
import com.dassault.cecilia.lib.util.ResIcoAbstract;
import com.dassault.cecilia.lib.util.logging.LogUtility;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumnModel;

public class TasksPanel
extends JPanel
implements PlugPanel {
    TaskList _modelTable;
    JTable _ctrlTable;
    CeciliaAction _ctrlSuspend;
    CeciliaAction _ctrlResume;
    CeciliaAction _ctrlStop;
    CeciliaAction _ctrlRemove;
    CeciliaAction _ctrlUp;
    CeciliaAction _ctrlDown;
    CeciliaAction _ctrlClear;
    JPopupMenu _popupList;

    public TasksPanel(TaskList model) {
        super(new BorderLayout());
        this._modelTable = model;
        this.initialise();
    }

    @Override
    public void trash() {
    }

    protected void initialise() {
        JPanel root = new JPanel(new BorderLayout());
        root.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this._ctrlClear = new CeciliaAction(ResIcoCore.getImageIcon("TASK_CLEAR"), ResTask.getString("PAN_CLEAR_MENU"), ResTask.getString("PAN_CLEAR_TTIP")){

            @Override
            public void actionPerformed(ActionEvent e) {
                int size = TasksPanel.this._modelTable.getRowCount();
                boolean change = false;
                for (int i = size - 1; i >= 0; --i) {
                    TaskThread task = TasksPanel.this._modelTable.get(i);
                    if (task.state() != TaskState.FINISH) continue;
                    TasksPanel.this._modelTable.remove(i);
                    change = true;
                }
                if (change) {
                    TasksPanel.this.refreshCtrl();
                }
            }
        };
        this._ctrlSuspend = new CeciliaAction(ResIcoCore.getImageIcon("TASK_SUSPEND"), ResTask.getString("PAN_SUSPEND_MENU"), ResTask.getString("PAN_SUSPEND_TTIP")){

            @Override
            public void actionPerformed(ActionEvent e) {
                int size = TasksPanel.this._modelTable.getRowCount();
                boolean change = false;
                for (int i = 0; i < size; ++i) {
                    if (!TasksPanel.this._ctrlTable.isRowSelected(i)) continue;
                    TaskThread task = TasksPanel.this._modelTable.get(i);
                    switch (task.state()) {
                        case INIT: 
                        case RUN: {
                            task.requestSuspend(false);
                            TasksPanel.this._modelTable.fireTableRowsUpdated(i, i);
                            change = true;
                        }
                    }
                }
                if (change) {
                    TasksPanel.this.refreshCtrl();
                }
            }
        };
        this._ctrlResume = new CeciliaAction(ResIcoCore.getImageIcon("TASK_RESUME"), ResTask.getString("PAN_RESUME_MENU"), ResTask.getString("PAN_RESUME_TTIP")){

            @Override
            public void actionPerformed(ActionEvent e) {
                int size = TasksPanel.this._modelTable.getRowCount();
                boolean change = false;
                for (int i = 0; i < size; ++i) {
                    TaskThread task;
                    if (!TasksPanel.this._ctrlTable.isRowSelected(i) || (task = TasksPanel.this._modelTable.get(i)).state() != TaskState.PAUSE) continue;
                    task.requestResume(false);
                    TasksPanel.this._modelTable.fireTableRowsUpdated(i, i);
                    change = true;
                }
                if (change) {
                    TasksPanel.this.refreshCtrl();
                }
            }
        };
        this._ctrlStop = new CeciliaAction(ResIcoCore.getImageIcon("TASK_STOP"), ResTask.getString("PAN_STOP_MENU"), ResTask.getString("PAN_STOP_TTIP")){

            @Override
            public void actionPerformed(ActionEvent e) {
                int size = TasksPanel.this._modelTable.getRowCount();
                boolean change = false;
                for (int i = 0; i < size; ++i) {
                    if (!TasksPanel.this._ctrlTable.isRowSelected(i)) continue;
                    TaskThread task = TasksPanel.this._modelTable.get(i);
                    switch (task.state()) {
                        case INIT: 
                        case RUN: 
                        case PAUSE: {
                            task.requestStop();
                            TasksPanel.this._modelTable.fireTableRowsUpdated(i, i);
                            change = true;
                        }
                    }
                }
                if (change) {
                    TasksPanel.this.refreshCtrl();
                }
            }
        };
        this._ctrlRemove = new CeciliaAction(ResIcoCore.getImageIcon("BUT_DEL"), ResTask.getString("PAN_REMOVE_MENU"), ResTask.getString("PAN_REMOVE_TTIP")){

            @Override
            public void actionPerformed(ActionEvent e) {
                int size = TasksPanel.this._modelTable.getRowCount();
                boolean change = false;
                for (int i = size - 1; i >= 0; --i) {
                    TaskThread task;
                    if (!TasksPanel.this._ctrlTable.isRowSelected(i) || (task = TasksPanel.this._modelTable.get(i)).state() != TaskState.FINISH) continue;
                    TasksPanel.this._modelTable.remove(i);
                    change = true;
                }
                if (change) {
                    TasksPanel.this.refreshCtrl();
                }
            }
        };
        this._ctrlUp = new CeciliaAction(ResIcoCore.getImageIcon("BUT_UP"), ResTask.getString("PAN_UP_MENU"), ResTask.getString("PAN_UP_TTIP")){

            @Override
            public void actionPerformed(ActionEvent e) {
                int idx = TasksPanel.this._ctrlTable.getSelectedRow();
                if (idx != -1 && idx > 0) {
                    TasksPanel.this._modelTable.down(idx);
                    TasksPanel.this._ctrlTable.setRowSelectionInterval(idx - 1, idx - 1);
                    TasksPanel.this.refreshCtrl();
                } else {
                    LogUtility.logStackTrace((Logger)LogUtility.getLog(TasksPanel.class), (Level)Level.FINER, (String)"Idx no correct");
                }
            }
        };
        this._ctrlDown = new CeciliaAction(ResIcoCore.getImageIcon("BUT_DOWN"), ResTask.getString("PAN_DOWN_MENU"), ResTask.getString("PAN_DOWN_TTIP")){

            @Override
            public void actionPerformed(ActionEvent e) {
                int idx = TasksPanel.this._ctrlTable.getSelectedRow();
                if (idx != -1 && idx < TasksPanel.this._modelTable.getRowCount() - 1) {
                    TasksPanel.this._modelTable.up(idx);
                    TasksPanel.this._ctrlTable.setRowSelectionInterval(idx + 1, idx + 1);
                    TasksPanel.this.refreshCtrl();
                } else {
                    LogUtility.logStackTrace((Logger)LogUtility.getLog(TasksPanel.class), (Level)Level.FINER, (String)"Idx no correct");
                }
            }
        };
        JToolBar aPanel = new JToolBar();
        aPanel.setBorder(CeciliaAction.STANDARD_BORDER);
        aPanel.add(this._ctrlClear.createButton(CeciliaAction.BorderStyle.LIGHT));
        aPanel.add(Box.createHorizontalGlue());
        aPanel.add(this._ctrlSuspend.createButton(CeciliaAction.BorderStyle.LIGHT));
        aPanel.add(Box.createRigidArea(CeciliaAction.RIGID_AREA));
        aPanel.add(this._ctrlResume.createButton(CeciliaAction.BorderStyle.LIGHT));
        aPanel.add(Box.createRigidArea(CeciliaAction.RIGID_AREA));
        aPanel.add(this._ctrlStop.createButton(CeciliaAction.BorderStyle.LIGHT));
        aPanel.add(Box.createRigidArea(CeciliaAction.RIGID_AREA));
        aPanel.add(this._ctrlRemove.createButton(CeciliaAction.BorderStyle.LIGHT));
        aPanel.add(Box.createRigidArea(CeciliaAction.RIGID_AREA));
        aPanel.add(this._ctrlUp.createButton(CeciliaAction.BorderStyle.LIGHT));
        aPanel.add(Box.createRigidArea(CeciliaAction.RIGID_AREA));
        aPanel.add(this._ctrlDown.createButton(CeciliaAction.BorderStyle.LIGHT));
        aPanel.setFloatable(false);
        root.add((Component)aPanel, "North");
        this._popupList = new JPopupMenu();
        this._popupList.add(this._ctrlClear);
        this._popupList.addSeparator();
        this._popupList.add(this._ctrlSuspend);
        this._popupList.add(this._ctrlResume);
        this._popupList.add(this._ctrlStop);
        this._popupList.add(this._ctrlRemove);
        this._popupList.addSeparator();
        this._popupList.add(this._ctrlUp);
        this._popupList.add(this._ctrlDown);
        this._ctrlTable = new CeciliaTable(this._modelTable);
        this._ctrlTable.putClientProperty("JTable.autoStartsEdit", Boolean.FALSE);
        this._ctrlTable.setDefaultRenderer(PlugTask.class, new TableRenderedPlugTask());
        this._ctrlTable.setDefaultRenderer(TaskState.class, new TableRenderedTaskThreadState());
        this._ctrlTable.setDefaultRenderer(Float.class, new TableRenderedProgress());
        this._ctrlTable.setDefaultRenderer(Long.class, new TableRenderedTimes());
        this._ctrlTable.setRowHeight(ResIcoAbstract.getIconSize());
        ListSelectionModel selMod = this._ctrlTable.getSelectionModel();
        selMod.setSelectionMode(2);
        selMod.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                TasksPanel.this.refreshCtrl();
            }
        });
        this._modelTable.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                TasksPanel.this.refreshCtrl();
                if (e.getType() == 0 && e.getColumn() == -2) {
                    TasksPanel.this._ctrlTable.clearSelection();
                    TasksPanel.this._ctrlTable.addRowSelectionInterval(e.getFirstRow(), e.getLastRow());
                    int rowsHeight = TasksPanel.this._ctrlTable.getRowHeight() * e.getFirstRow();
                    TasksPanel.this._ctrlTable.scrollRectToVisible(new Rectangle(0, rowsHeight, TasksPanel.this._ctrlTable.getWidth(), TasksPanel.this._ctrlTable.getRowHeight()));
                }
            }
        });
        int[] size = new int[]{30, 75, 90, 110, 60, 60};
        boolean[] max = new boolean[]{true, false, false, false, false, false};
        TableColumnModel columns = this._ctrlTable.getColumnModel();
        for (int i = 0; i < columns.getColumnCount() && i < size.length; ++i) {
            columns.getColumn(i).setPreferredWidth(size[i]);
            if (!max[i]) continue;
            columns.getColumn(i).setMaxWidth(size[i]);
        }
        JScrollPane scrollTable = new JScrollPane(this._ctrlTable);
        scrollTable.setComponentPopupMenu(this._popupList);
        root.add((Component)scrollTable, "Center");
        this.add((Component)root, "Center");
        this.refreshCtrl();
    }

    protected void refreshCtrl() {
        int cptSus = 0;
        int cptRes = 0;
        int cptStp = 0;
        int cptRmv = 0;
        int cptClr = 0;
        int cptSel = 0;
        int idxSel = -1;
        int size = this._modelTable.getRowCount();
        block8: for (int i = 0; i < size; ++i) {
            TaskThread task = this._modelTable.get(i);
            boolean sel = this._ctrlTable.isRowSelected(i);
            if (sel) {
                ++cptSel;
                idxSel = i;
            }
            switch (task.state()) {
                case INIT: {
                    if (!sel) continue block8;
                    ++cptSus;
                    ++cptStp;
                    continue block8;
                }
                case RUN: {
                    if (!sel) continue block8;
                    ++cptSus;
                    ++cptStp;
                    continue block8;
                }
                case HPAUSE: {
                    if (!sel) continue block8;
                    ++cptRes;
                    continue block8;
                }
                case PAUSE: {
                    if (!sel) continue block8;
                    ++cptRes;
                    ++cptStp;
                    continue block8;
                }
                case STOPPED: {
                    continue block8;
                }
                case FINISH: {
                    if (sel) {
                        ++cptRmv;
                    }
                    ++cptClr;
                }
            }
        }
        this._ctrlSuspend.setEnabled(cptSus > 0);
        this._ctrlResume.setEnabled(cptRes > 0);
        this._ctrlStop.setEnabled(cptStp > 0);
        this._ctrlRemove.setEnabled(cptRmv > 0);
        this._ctrlClear.setEnabled(cptClr > 0);
        this._ctrlUp.setEnabled(cptSel == 1 && idxSel > 0);
        this._ctrlDown.setEnabled(cptSel == 1 && idxSel < size - 1);
    }

    @Override
    public Component getPanel() {
        return this;
    }

    @Override
    public String getInfo(String key) {
        if (key.equals("ppanel.title")) {
            return ResTask.getString("PAN_TASK_TITLE");
        }
        if (key.equals("ppanel.default.width")) {
            return "500";
        }
        if (key.equals("ppanel.default.height")) {
            return "200";
        }
        return null;
    }

    @Override
    public Icon getIcon(String key) {
        if (key.equals("ppanel.icon")) {
            return ResIcoCore.getImageIcon("TASK_ICON");
        }
        return null;
    }
}

