/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.db;

import com.dassault.cecilia.db.DBFactory;
import com.dassault.cecilia.db.DBItem;
import com.dassault.cecilia.db.DBObject;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.regex.Pattern;

public class DBObjModel
extends DBItem
implements Comparable<DBObjModel> {
    public static final String NAT_SYSTEM_LOCAL = "system.local";
    public static final String NAT_SYSTEM_COMPILED = "system.compiled";
    public static final String NAT_SYSTEM_COLORS = "system.colors";
    public static final String NAT_SYSTEM_STATES = "system.states";
    public static final String NAT_SYSTEM_STEPPER = "system.stepper";
    public static final String NAT_SYSTEM_LAW = "system.law";
    public static final String NAT_IMAGE = "image";
    public static final String NAT_COMPONENT = "component";
    public static final String NAT_EQUIPMENT = "equipment";
    public static final String NAT_TYPE_STRUCTURED = "type.structured";
    public static final String NAT_TYPE_ENUMERATED = "type.enumerated";
    public static final String NAT_OPERATOR = "operator";
    public static final String NAT_FMEA = "fmea";
    public static final String NAT_FMEA_HEAD = "fmea.head";
    public static final String NAT_FMEA_MODEL = "fmea.model";
    public static final String NAT_DSF_CONFIG = "dsf.config";
    public static final String NAT_DSF_DEF = "dsf.def";
    public static final String NAT_ASSOCIATED_FILE = "associated.file";
    public static final String NAT_TREE_DAG = "tree.dag";
    public static final String NAT_TREE_DEF = "tree.def";
    public static final String NAT_TREE_COMPUTE = "tree.compute";
    public static final String NAT_ATTRIBUTE = "attribute";
    public static final String NAT_PARAMETER = "parameter";
    public static final String NAT_FRB = "frb.def";
    public static final String NAT_CCF = "ccf.def";
    public static final String NAT_LOGS = "logs";
    public static final String NAT_PROJECT = "project.def";
    public static final String NAT_PROJECT_ADAA = "project.attribute.drive.average.approach";
    public static final String NAT_PROJECT_CRITICITY = "criticity.def";
    public static final String FORMAT_OCAS = "OCAS";
    public static final String FORMAT_ARBOR = "ARBOR";
    public static final String FORMAT_FRB = "FRB";
    public static final String FORMAT_RAW = "RAW";
    public static final String FORMAT_RAWTOHEX = "RAWTOHEX";
    public static final String FORMAT_ZML = "ZML";
    public static final Object FORMAT_IMAGE_GIF = "GIF";
    public static final Object FORMAT_IMAGE_JPG = "JPG";
    public static final Object FORMAT_IMAGE_PNG = "PNG";
    public static final String FORMAT_ZIP = "ZIP";
    public static final String FORMAT_XML = "XML";
    public static final String FORMAT_JOS = "JOS";
    public static final String ENCODING_OCAS = "ISO-8859-1";
    public static final String ENCODING_UTF8 = "UTF-8";
    DBObject _obj;
    String _nature;
    String _format;
    String _encoding;
    String _crc;
    long _size;
    InputStream _streamToBeSaved;
    public static final short LIMIT_NATURE = 255;
    public static final short LIMIT_FORMAT = 10;
    public static final short LIMIT_ENCODING = 20;
    public static final short LIMIT_CRC = 128;
    private static Set<String> NATURES = new HashSet<String>(Arrays.asList("logs", "image", "project.def", "project.attribute.drive.average.approach", "criticity.def", "attribute", "ccf.def", "frb.def", "parameter", "system.local", "system.law", "system.colors", "system.states", "component", "equipment", "operator", "type.enumerated", "type.structured", "tree.dag", "tree.def", "dsf.def", "dsf.config", "fmea", "fmea.head", "fmea.model"));
    public static final String _REGEX_CRC = "[0-9A-Fa-f]+";
    private static final Pattern _PATTERN_CRC = Pattern.compile("[0-9A-Fa-f]+");
    public static final String _REGEX_FORMAT = "[A-Z0-9]+";
    private static final Pattern _PATTERN_FORMAT = Pattern.compile("[A-Z0-9]+");
    public static final String _REGEX_ENCODING = "[0-9A-Za-z\\-]+";
    private static final Pattern _PATTERN_ENCODING = Pattern.compile("[0-9A-Za-z\\-]+");
    public static final int PROP_DEF_DB_XTRA_SAVEIFSIZEARELESSER = -1;
    public static final String PROP_DB_XTRA_SAVEIFSIZEARELESSER = "cecilia.db.LimitSizeXTra";
    public static final String PROP_DB_OCAS_ENCODING = "cecilia.db.OCASEncoding";
    static Charset __OcasCharset = null;
    static Object __OcasCharsetLocker = new Object();

    public DBObjModel() {
    }

    public DBObjModel(DBObjModel src) {
        this();
        this.copyFrom(src);
    }

    public void copyFrom(DBObjModel src) {
        super.copyFrom(src);
        this._nature = src.getNature();
        this._format = src.getFormat();
        this._encoding = src.getEncoding();
        this._crc = src.getCRC();
        this._size = src.getSize();
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        return obj instanceof DBObjModel;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ObjModel:").append(this._id);
        sb.append(",").append(this._nature).append(",").append(this._format);
        sb.append(",").append(this._encoding).append(",").append(this._crc);
        sb.append(",").append(this._size);
        return sb.toString();
    }

    @Override
    public int compareTo(DBObjModel o) {
        return this.getNature().compareTo(o.getNature());
    }

    public DBObject getObject() {
        return this._obj;
    }

    public DBObjModel setObject(DBObject obj) {
        if (this._obj != null && obj != null && !this._obj.equals(obj)) {
            _LOG.warning("ObjModel : affectation \u00e0 un nouvel objet.");
        }
        this._obj = obj;
        return this;
    }

    public String getNature() {
        return this._nature;
    }

    public DBObjModel setNature(String nature) {
        this._nature = nature;
        return this;
    }

    public String getFormat() {
        if (this._format == null) {
            return "";
        }
        return this._format;
    }

    public DBObjModel setFormat(String format) {
        this._format = format;
        return this;
    }

    public String getEncoding() {
        if (this._encoding == null) {
            return "";
        }
        return this._encoding;
    }

    public DBObjModel setEncoding(String encoding) {
        this._encoding = encoding;
        return this;
    }

    public String getCRC() {
        if (this._crc == null) {
            return "";
        }
        return this._crc;
    }

    public DBObjModel setCRC(String crc) {
        this._crc = crc;
        return this;
    }

    public long getSize() {
        return this._size;
    }

    public DBObjModel setSize(long size) {
        this._size = size;
        return this;
    }

    public void setStreamToSave(InputStream stream) {
        if (this._streamToBeSaved != null && stream != null) {
            _LOG.severe("Un stream ecrase un precedent stream");
        }
        this._streamToBeSaved = stream;
    }

    public InputStream getStreamToSave() {
        return this._streamToBeSaved;
    }

    public static boolean verifyNature(String value, boolean onlyCecilia) {
        if (value.isEmpty()) {
            return false;
        }
        if (value.length() > 255) {
            return false;
        }
        if (value.startsWith(NAT_SYSTEM_STEPPER)) {
            return true;
        }
        if (value.startsWith(NAT_TREE_COMPUTE)) {
            return true;
        }
        if (value.startsWith(NAT_ASSOCIATED_FILE)) {
            return DBFactory.verifyName(value) == 0;
        }
        if (NATURES.contains(value)) {
            return true;
        }
        if (onlyCecilia) {
            return false;
        }
        return DBFactory.verifyName(value) == 0;
    }

    public static boolean verifyCRC(String value) {
        if (value.isEmpty()) {
            return false;
        }
        if (value.length() > 128) {
            return false;
        }
        return _PATTERN_CRC.matcher(value).matches();
    }

    public static boolean verifyFormat(String value) {
        if (value.isEmpty()) {
            return false;
        }
        if (value.length() > 10) {
            return false;
        }
        return _PATTERN_FORMAT.matcher(value).matches();
    }

    public static boolean verifyEncoding(String value) {
        if (value.isEmpty()) {
            return false;
        }
        if (value.length() > 20) {
            return false;
        }
        return _PATTERN_ENCODING.matcher(value).matches();
    }

    public static final String constructNature(String ... codes) {
        int length = codes.length;
        for (int i = codes.length - 1; i >= 0; --i) {
            length += codes[i].length();
        }
        StringBuilder sb = new StringBuilder(length);
        for (int i = 0; i < codes.length; ++i) {
            if (i > 0) {
                sb.append(".");
            }
            sb.append(codes[i]);
        }
        return sb.toString();
    }

    public static boolean validXTraSize(int size) {
        if (size == 0) {
            return false;
        }
        int limitSizeSaved = Integer.getInteger(PROP_DB_XTRA_SAVEIFSIZEARELESSER, -1);
        if (limitSizeSaved < 0) {
            return true;
        }
        return size < limitSizeSaved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Charset getOcasCharset() {
        if (__OcasCharset == null) {
            Object object = __OcasCharsetLocker;
            synchronized (object) {
                String encodingName;
                Charset currentCharSet = null;
                if (currentCharSet == null && (encodingName = System.getProperty(PROP_DB_OCAS_ENCODING)) != null && !encodingName.isEmpty()) {
                    if (Charset.isSupported(encodingName)) {
                        try {
                            currentCharSet = Charset.forName(encodingName);
                        }
                        catch (UnsupportedCharsetException x) {
                            _LOG.log(Level.FINE, "Bad value '" + encodingName + "' for property : " + PROP_DB_OCAS_ENCODING, x);
                        }
                    } else {
                        _LOG.log(Level.WARNING, "Unsupported Charset '" + encodingName + "' for property : " + PROP_DB_OCAS_ENCODING);
                    }
                }
                if (currentCharSet == null && (encodingName = System.getProperty("file.encoding")) != null && !encodingName.isEmpty()) {
                    if (Charset.isSupported(encodingName)) {
                        try {
                            currentCharSet = Charset.forName(encodingName);
                        }
                        catch (UnsupportedCharsetException x) {
                            _LOG.log(Level.WARNING, "Bad value '" + encodingName + "' for property : " + "file.encoding", x);
                        }
                    } else {
                        _LOG.log(Level.SEVERE, "Unsupported Charset '" + encodingName + "' for property : " + "file.encoding");
                    }
                }
                if (currentCharSet == null) {
                    currentCharSet = StandardCharsets.ISO_8859_1;
                }
                __OcasCharset = currentCharSet;
            }
        }
        return __OcasCharset;
    }
}

