/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.db.dao.sql.def;

import com.dassault.cecilia.db.DBAccess;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBGroup;
import com.dassault.cecilia.db.DBObject;
import com.dassault.cecilia.db.DBRelation;
import com.dassault.cecilia.db.DBUser;
import com.dassault.cecilia.db.IGroup;
import com.dassault.cecilia.db.IUser;
import com.dassault.cecilia.db.dao.DAOFolder;
import com.dassault.cecilia.db.dao.sql.SQLTable;
import com.dassault.cecilia.db.dao.sql.def.DefaultFactory;
import com.dassault.cecilia.lib.util.logging.LogUtility;
import java.sql.Array;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DefaultFolder
extends DAOFolder {
    protected Connection _connect = null;
    protected DefaultFactory _factory = null;
    protected Map<String, DBFolder> _roots = null;
    private static final int UPDATE_FOLDER_IN_SIZE = 3;
    long _lastTimeUpdate = 0L;
    private Map<Long, DBFolder> _cacheFolder;
    boolean _bFreezeCache = false;

    public DefaultFolder(Connection connect, DefaultFactory factory) {
        this._connect = connect;
        this._factory = factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void loadRoots() {
        if (this._roots != null) {
            return;
        }
        this._roots = new HashMap<String, DBFolder>();
        try {
            long _rootID = -1L;
            PreparedStatement prepare = this._connect.prepareStatement("SELECT fol_id FROM " + SQLTable.FOLDERS + " WHERE fol_parent_id IS NULL AND fol_name = 'ROOT'", 1004, 1007);
            this._factory.initStatement(prepare);
            try {
                ResultSet resultSet = prepare.executeQuery();
                try {
                    if (resultSet.first()) {
                        _rootID = resultSet.getLong(1);
                    }
                }
                finally {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                try {
                    prepare.close();
                }
                catch (Exception resultSet) {}
            }
            if (_rootID == -1L) {
                throw new SQLException("Pas de racine pour la base de donnee Cecilia");
            }
            DBFolder dbRoot = this.find(_rootID);
            if (dbRoot == null) {
                throw new SQLException("Pas de racine pour la base de donnee Cecilia");
            }
            this._roots.put(dbRoot.getName(), dbRoot);
            ArrayList<DBFolder> stack = new ArrayList<DBFolder>();
            stack.add(dbRoot);
            while (!stack.isEmpty()) {
                DBFolder dbFolder = (DBFolder)stack.remove(stack.size() - 1);
                if (dbFolder.getFamily() != DBFolder.Family.APPLICATION) continue;
                List<DBFolder> children = dbFolder.getChildren();
                if (children == null) {
                    children = this.findChildren(dbFolder);
                }
                if (children == null) continue;
                for (int i = children.size() - 1; i >= 0; --i) {
                    DBFolder child = children.get(i);
                    this._roots.put(child.getName(), child);
                    stack.add(child);
                }
            }
        }
        catch (SQLException e) {
            this.logSQLException(e, "DefaultFolder::loadRoots()");
        }
        catch (Exception e) {
            this.logException(e, "DefaultFolder::loadRoots()");
        }
    }

    @Override
    public DBFolder getRootID(String rootKey) {
        if (this._roots == null) {
            this.loadRoots();
        }
        return this._roots.get(rootKey);
    }

    protected long createInTransaction(DBFolder fol) throws SQLException {
        Collection<DBRelation> relations;
        List<DBFolder> children;
        DBObject obj;
        IUser usr;
        long id = -1L;
        IGroup grp = fol.getGroupOwner();
        if (grp instanceof DBGroup && grp.getID() <= 0L) {
            this._factory.createGroupDAO().createGroupIntoTable((DBGroup)grp);
        }
        if ((usr = fol.getUserOwner()) instanceof DBUser && usr.getID() <= 0L) {
            this._factory.createUserDAO().createUserIntoTable((DBUser)usr);
        }
        if ((usr = fol.getUserModify()) instanceof DBUser && usr.getID() <= 0L) {
            this._factory.createUserDAO().createUserIntoTable((DBUser)usr);
        }
        if ((obj = fol.getObject()) != null && obj.getID() <= 0L) {
            this._factory.createObjectDAO().createInTransaction(obj);
        }
        this.createFolderIntoTable(fol);
        id = fol.getID();
        List<DBAccess> accesses = fol.getAccesses();
        if (accesses != null) {
            this.insertAccesses(fol, accesses);
        }
        if ((children = fol.getChildren()) != null && !children.isEmpty()) {
            for (int i = 0; i < children.size(); ++i) {
                DBFolder child = children.get(i);
                if (child.getID() != -1L) continue;
                this.createInTransaction(child);
            }
        }
        if ((relations = fol.getRelations()) != null) {
            this._factory.createRelationDAO().updateDestinationRelations(fol, null, relations);
        }
        return id;
    }

    @Override
    public DBFolder create(DBFolder fol) {
        DBFolder parent = fol.getParent();
        if (parent == null || parent.getID() == -1L) {
            DefaultFactory._LOG.log(Level.SEVERE, "Impossible de creer un dossier si le dossier parent n'existe pas : " + fol.getName());
            return null;
        }
        long id = -1L;
        try {
            this._factory.beginTransaction(false);
            id = this.createInTransaction(fol);
            this.updateTimeUpdate(fol.getParent());
            this._factory.endTransaction();
        }
        catch (Exception e) {
            id = -1L;
            try {
                this._factory.abortTransaction();
            }
            catch (Exception abortExc) {
                DefaultFactory._LOG.log(Level.SEVERE, "Exception during abort transaction operation: Risk of corruption of data", abortExc);
            }
            this.logException(e, "DefaultFolder::create(" + fol.getName() + ")");
        }
        if (id != -1L) {
            return this.find(id);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createFolderIntoTable(DBFolder obj) throws SQLException {
        boolean result;
        block22: {
            result = false;
            PreparedStatement prepare = this._connect.prepareStatement("INSERT INTO " + SQLTable.FOLDERS + "(fol_parent_id, fol_obj_id, fol_name, fol_description, fol_grp_id, fol_usr_id, fol_access_group, fol_access_other, fol_date_creation, fol_date_modification, fol_last_modifier_usr_id, fol_flags, fol_time_update) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, " + this._factory.getSQLFunctionNow() + ")", 1);
            this._factory.initStatement(prepare);
            try {
                int col = 1;
                DBFolder dbParent = obj.getParent();
                if (dbParent == null) {
                    prepare.setNull(col++, -5);
                } else {
                    prepare.setLong(col++, dbParent.getID());
                }
                DBObject dbObject = obj.getObject();
                if (dbObject == null) {
                    prepare.setNull(col++, -5);
                } else {
                    prepare.setLong(col++, dbObject.getID());
                }
                prepare.setString(col++, obj.getName());
                String strDescr = obj.getDescription();
                if (strDescr == null || strDescr.isEmpty()) {
                    prepare.setNull(col++, 12);
                } else {
                    prepare.setString(col++, strDescr);
                }
                prepare.setLong(col++, obj.getGroupOwner().getID());
                prepare.setLong(col++, obj.getUserOwner().getID());
                prepare.setInt(col++, DBAccess.formatRight(obj.getRightGroup()));
                prepare.setInt(col++, DBAccess.formatRight(obj.getRightOther()));
                prepare.setTimestamp(col++, new Timestamp(obj.getDateCreate().getTime()));
                prepare.setTimestamp(col++, new Timestamp(obj.getDateModify().getTime()));
                prepare.setLong(col++, obj.getUserModify().getID());
                prepare.setLong(col++, obj.getFlags());
                int nbrChg = prepare.executeUpdate();
                if (nbrChg != 1) break block22;
                ResultSet resultSet = prepare.getGeneratedKeys();
                try {
                    if (resultSet.next()) {
                        obj.setID(resultSet.getLong(1));
                        result = true;
                    }
                }
                finally {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                try {
                    prepare.close();
                }
                catch (Exception exception) {}
            }
        }
        if (!result) {
            throw new SQLException("Internal error during INSERT INTO " + SQLTable.FOLDERS + ": " + obj.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean deleteInTransaction(DBFolder folder) throws SQLException {
        if (folder.isSystem()) {
            throw new SQLException("Il n'est pas possible de supprimer un dossier syst\u00e8me : " + folder.getName());
        }
        boolean result = true;
        PreparedStatement prepare = this._connect.prepareStatement("DELETE FROM " + SQLTable.FOLDERS + " WHERE fol_id = ?");
        this._factory.initStatement(prepare);
        try {
            prepare.setLong(1, folder.getID());
            int nbrChg = prepare.executeUpdate();
            result = result && nbrChg == 1;
        }
        finally {
            try {
                prepare.close();
            }
            catch (Exception exception) {}
        }
        if (folder.getObject() != null) {
            this._factory.createObjectDAO().deleteInTransaction(folder.getObject());
        }
        this.updateTimeUpdate(folder.getParent());
        this.putCache(folder.getID(), null);
        return result;
    }

    @Override
    public boolean delete(DBFolder folder) {
        try {
            boolean result = true;
            this._factory.beginTransaction(false);
            result = this.deleteInTransaction(folder);
            this._factory.endTransaction();
            return result;
        }
        catch (Exception e) {
            try {
                this._factory.abortTransaction();
            }
            catch (Exception abortExc) {
                DefaultFactory._LOG.log(Level.SEVERE, "Exception during abort transaction operation: Risk of corruption of data", abortExc);
            }
            this.logException(e, "DefaultFolder::delete(" + folder.getID() + "," + folder.getName() + ")");
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateTimeUpdate(DBFolder obj) throws SQLException {
        PreparedStatement prepare = this._connect.prepareStatement("UPDATE " + SQLTable.FOLDERS + " SET fol_time_update = " + this._factory.getSQLFunctionNow() + " WHERE fol_id = ?");
        this._factory.initStatement(prepare);
        try {
            prepare.setLong(1, obj.getID());
            prepare.executeUpdate();
        }
        finally {
            try {
                prepare.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateInTransaction(DBFolder folder) throws SQLException {
        Collection<DBRelation> relations;
        if (this.isAutoUpdateObject() && folder.getObject() != null) {
            if (folder.getObject().getID() == -1L) {
                this._factory.createObjectDAO().createInTransaction(folder.getObject());
            } else {
                this._factory.createObjectDAO().updateInTransaction(folder.getObject());
            }
        }
        PreparedStatement prepare = this._connect.prepareStatement("UPDATE " + SQLTable.FOLDERS + " SET fol_parent_id = ?, fol_obj_id = ?, fol_name = ?, fol_description = ?, fol_grp_id = ?, fol_usr_id = ?, fol_access_group = ?, fol_access_other = ?, fol_date_creation = ?, fol_date_modification = ?, fol_last_modifier_usr_id = ?, fol_flags = ?, fol_time_update = " + this._factory.getSQLFunctionNow() + " WHERE fol_id = ?");
        this._factory.initStatement(prepare);
        try {
            int col = 1;
            DBFolder dbParent = folder.getParent();
            if (dbParent == null) {
                prepare.setNull(col++, -5);
            } else {
                prepare.setLong(col++, dbParent.getID());
            }
            DBObject dbObject = folder.getObject();
            if (dbObject == null) {
                prepare.setNull(col++, -5);
            } else {
                prepare.setLong(col++, dbObject.getID());
            }
            prepare.setString(col++, folder.getName());
            String strDescr = folder.getDescription();
            if (strDescr == null || strDescr.isEmpty()) {
                prepare.setNull(col++, 12);
            } else {
                prepare.setString(col++, strDescr);
            }
            prepare.setLong(col++, folder.getGroupOwner().getID());
            prepare.setLong(col++, folder.getUserOwner().getID());
            prepare.setInt(col++, DBAccess.formatRight(folder.getRightGroup()));
            prepare.setInt(col++, DBAccess.formatRight(folder.getRightOther()));
            prepare.setTimestamp(col++, new Timestamp(folder.getDateCreate().getTime()));
            prepare.setTimestamp(col++, new Timestamp(folder.getDateModify().getTime()));
            prepare.setLong(col++, folder.getUserModify().getID());
            prepare.setLong(col++, folder.getFlags());
            prepare.setLong(col++, folder.getID());
            prepare.executeUpdate();
        }
        finally {
            try {
                prepare.close();
            }
            catch (Exception col) {}
        }
        List<DBAccess> accesses = folder.getAccesses();
        if (accesses != null) {
            this.deleteAccesses(folder);
            this.insertAccesses(folder, accesses);
        }
        if (this.isAutoUpdateDepenties() && (relations = folder.getRelations()) != null) {
            this._factory.createRelationDAO().updateDestinationRelations(folder, null, relations);
        }
    }

    @Override
    public boolean update(DBFolder obj) {
        try {
            this._factory.beginTransaction(false);
            this.updateInTransaction(obj);
            this._factory.endTransaction();
            return true;
        }
        catch (Exception e) {
            try {
                this._factory.abortTransaction();
            }
            catch (Exception abortExc) {
                DefaultFactory._LOG.log(Level.SEVERE, "Exception during abort transaction operation: Risk of corruption of data", abortExc);
            }
            this.logException(e, "DefaultFolder::update(" + obj.getID() + "," + obj.getName() + ")");
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateVisibilityForGroups(Collection<? extends IGroup> groups) throws SQLException {
        int nbrGrp = groups.size();
        if (nbrGrp == 0) {
            return;
        }
        PreparedStatement prepare = this._connect.prepareStatement("UPDATE " + SQLTable.FOLDERS + " SET fol_time_update = " + this._factory.getSQLFunctionNow() + " WHERE fol_id IN (  SELECT DISTINCT fol_id FROM (    SELECT fol_id, grp_id      FROM " + SQLTable.FOLDERS + ", " + SQLTable.ACCESSSES + ", " + SQLTable.GROUPS + "      WHERE fol_id = acc_fol_id AND grp_id = acc_grp_id    UNION    SELECT fol_id, fol_grp_id AS grp_id FROM " + SQLTable.FOLDERS + "  ) tmp_union WHERE grp_id IN (?, ?, ?) )");
        this._factory.initStatement(prepare);
        try {
            Iterator<? extends IGroup> iterDel = groups.iterator();
            while (nbrGrp > 0) {
                int nbrStep = 1;
                while (nbrStep <= 3 && iterDel.hasNext()) {
                    prepare.setLong(nbrStep++, iterDel.next().getID());
                    --nbrGrp;
                }
                while (nbrStep <= 3) {
                    prepare.setNull(nbrStep++, 2);
                }
                prepare.executeUpdate();
            }
        }
        finally {
            try {
                prepare.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateFolders_WithArray(Collection<? extends IGroup> groups) throws SQLException {
        int nbrGrp = groups.size();
        if (nbrGrp == 0) {
            return;
        }
        PreparedStatement prepare = this._connect.prepareStatement("UPDATE " + SQLTable.FOLDERS + " SET fol_time_update = " + this._factory.getSQLFunctionNow() + " WHERE fol_id IN (  SELECT UNIQUE fol_id FROM (    SELECT fol_id, fol_name, fol_grp_id, grp_id      FROM " + SQLTable.FOLDERS + ", " + SQLTable.ACCESSSES + ", " + SQLTable.GROUPS + "      WHERE fol_id = acc_fol_id AND grp_id = acc_grp_id    UNION    SELECT fol_id, fol_name, fol_grp_id , fol_grp_id AS grp_id FROM " + SQLTable.FOLDERS + "  ) WHERE grp_id IN (?) )");
        this._factory.initStatement(prepare);
        try {
            ArrayList<Long> listID = new ArrayList<Long>(nbrGrp);
            for (IGroup iGroup : groups) {
                listID.add(iGroup.getID());
            }
            Array array = this._connect.createArrayOf("NUMBER", listID.toArray());
            prepare.setArray(1, array);
            prepare.executeUpdate();
        }
        finally {
            try {
                prepare.close();
            }
            catch (Exception exception) {}
        }
    }

    protected Date convertDateFromDB(ResultSet result, int col) throws SQLException {
        long time = this._factory.convertTimeStamp(result, col);
        return new Date(time / 1000L * 1000L);
    }

    protected void refreshFolder(DBFolder fol, ResultSet result, int col) throws SQLException {
        fol.setTimeUpdate(this._factory.convertTimeStamp(result, col++));
        long objId = result.getLong(col++);
        fol.setName(result.getString(col++));
        fol.setDescription(result.getString(col++));
        fol.setGroupOwner(new IGroup.MinimalGroup(result.getLong(col++), result.getString(col++), result.getInt(col++)));
        fol.setUserOwner(new IUser.MinimalUser(result.getLong(col++), result.getString(col++), result.getInt(col++)));
        fol.setRightGroup(DBAccess.parseRight(result.getInt(col++)));
        fol.setRightOther(DBAccess.parseRight(result.getInt(col++)));
        fol.setDateCreate(this.convertDateFromDB(result, col++));
        fol.setDateModify(this.convertDateFromDB(result, col++));
        fol.setUserModify(new IUser.MinimalUser(result.getLong(col++), result.getString(col++), result.getInt(col++)));
        fol.setFlags(result.getInt(col++));
        if (objId != 0L) {
            if (fol.getObject() != null) {
                this._factory.createObjectDAO().refresh(fol.getObject());
            } else {
                DBObject obj = this._factory.createObjectDAO().find(objId);
                fol.setObject(obj);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean read(DBFolder obj) throws SQLException {
        boolean result = false;
        PreparedStatement prepare = this._connect.prepareStatement("SELECT fol_parent_id, fol_time_update, fol_obj_id, fol_name, fol_description, fol_grp_id, fol_grp.grp_name, fol_grp.grp_flags, fol_usr_id, fol_usr.usr_login, fol_usr.usr_flags, fol_access_group, fol_access_other, fol_date_creation, fol_date_modification, fol_last_modifier_usr_id, fo_lusr.usr_login, fo_lusr.usr_flags, fol_flags FROM " + SQLTable.FOLDERS + ", " + SQLTable.GROUPS + " fol_grp, " + SQLTable.USERS + " fol_usr, " + SQLTable.USERS + " fo_lusr WHERE fol_id = ? AND fol_grp_id = fol_grp.grp_id AND fol_usr_id = fol_usr.usr_id AND fol_last_modifier_usr_id = fo_lusr.usr_id", 1004, 1007);
        this._factory.initStatement(prepare);
        try {
            prepare.setLong(1, obj.getID());
            long parentId = -1L;
            ResultSet resultSet = prepare.executeQuery();
            try {
                if (resultSet.first()) {
                    this.refreshFolder(obj, resultSet, 2);
                    parentId = resultSet.getLong(1);
                    result = true;
                }
            }
            finally {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {}
            }
            if (parentId > 0L && obj != null) {
                obj.setParent(this.find(parentId));
            }
        }
        finally {
            try {
                prepare.close();
            }
            catch (Exception exception) {}
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exist(long id) {
        boolean result = false;
        try {
            PreparedStatement prepare = this._connect.prepareStatement("SELECT fol_time_update FROM " + SQLTable.FOLDERS + " WHERE fol_id = ?", 1004, 1007);
            this._factory.initStatement(prepare);
            try {
                prepare.setLong(1, id);
                ResultSet resultSet = prepare.executeQuery();
                try {
                    if (resultSet.first()) {
                        result = true;
                    }
                }
                finally {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                try {
                    prepare.close();
                }
                catch (Exception exception) {}
            }
        }
        catch (SQLException e) {
            this.logSQLException(e, "DefaultFolder::exist(" + id + ")");
        }
        catch (Exception e) {
            this.logException(e, "DefaultFolder::exist(" + id + ")");
        }
        return result;
    }

    @Override
    public DBFolder find(long id) {
        DBFolder obj = this.findCache(id);
        if (obj != null) {
            return obj;
        }
        try {
            obj = new DBFolder(id);
            if (this.read(obj)) {
                this.putCache(id, obj);
                return obj;
            }
        }
        catch (SQLException e) {
            this.logSQLException(e, "DefaultFolder::find(" + id + ")");
        }
        catch (Exception e) {
            this.logException(e, "DefaultFolder::find(" + id + ")");
        }
        return null;
    }

    @Override
    public boolean refresh(DBFolder dbFolder) {
        try {
            return this.read(dbFolder);
        }
        catch (SQLException e) {
            this.logSQLException(e, "DefaultFolder::refresh(" + dbFolder.getID() + ")");
        }
        catch (Exception e) {
            this.logException(e, "DefaultFolder::refresh(" + dbFolder.getID() + ")");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DBFolder> findChildren(DBFolder parent) {
        ArrayList<DBFolder> result = new ArrayList<DBFolder>();
        try {
            PreparedStatement prepare = this._connect.prepareStatement("SELECT fol_id, fol_time_update, fol_obj_id, fol_name, fol_description, fol_grp_id, fol_grp.grp_name, fol_grp.grp_flags, fol_usr_id, fol_usr.usr_login, fol_usr.usr_flags, fol_access_group, fol_access_other, fol_date_creation, fol_date_modification, fol_last_modifier_usr_id, fo_lusr.usr_login, fo_lusr.usr_flags, fol_flags FROM " + SQLTable.FOLDERS + ", " + SQLTable.GROUPS + " fol_grp, " + SQLTable.USERS + " fol_usr, " + SQLTable.USERS + " fo_lusr WHERE fol_parent_id = ? AND fol_grp_id = fol_grp.grp_id AND fol_usr_id = fol_usr.usr_id AND fol_last_modifier_usr_id = fo_lusr.usr_id", 1004, 1007);
            this._factory.initStatement(prepare);
            try {
                prepare.setLong(1, parent.getID());
                ResultSet resultSet = prepare.executeQuery();
                try {
                    while (resultSet.next()) {
                        long id = resultSet.getLong(1);
                        DBFolder obj = this.findCache(id);
                        if (obj == null) {
                            obj = new DBFolder(id);
                            this.refreshFolder(obj, resultSet, 2);
                            obj.setParent(parent);
                            this.putCache(id, obj);
                        } else {
                            if (obj.mustBeUpdated(this._factory.convertTimeStamp(resultSet, 2))) {
                                this.refreshFolder(obj, resultSet, 2);
                            }
                            obj.setParent(parent);
                        }
                        result.add(obj);
                    }
                    Collections.sort(result, DBFolder.getComparator());
                    parent.setChildren(result);
                }
                finally {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                try {
                    prepare.close();
                }
                catch (Exception exception) {}
            }
        }
        catch (SQLException e) {
            this.logSQLException(e, "DefaultFolder::findChildren(" + parent.getID() + "," + parent.getName() + ")");
        }
        catch (Exception e) {
            this.logException(e, "DefaultFolder::findChildren(" + parent.getID() + "," + parent.getName() + ")");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void insertAccesses(DBFolder obj, List<DBAccess> accesses) throws SQLException {
        PreparedStatement prepare = this._connect.prepareStatement("INSERT INTO " + SQLTable.ACCESSSES + " (acc_fol_id, acc_grp_id, acc_rights) VALUES (?, ?, ?)");
        this._factory.initStatement(prepare);
        try {
            for (DBAccess acc : accesses) {
                prepare.setLong(1, obj.getID());
                prepare.setLong(2, acc.getGroup().getID());
                prepare.setInt(3, DBAccess.formatRight(acc.getRight()));
                prepare.executeUpdate();
            }
        }
        finally {
            try {
                prepare.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteAccesses(DBFolder obj) throws SQLException {
        PreparedStatement prepare = this._connect.prepareStatement("DELETE FROM " + SQLTable.ACCESSSES + " WHERE acc_fol_id = ?");
        this._factory.initStatement(prepare);
        try {
            prepare.setLong(1, obj.getID());
            prepare.executeUpdate();
        }
        finally {
            try {
                prepare.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DBAccess> findAccesses(DBFolder obj) {
        ArrayList<DBAccess> result = new ArrayList<DBAccess>();
        try {
            PreparedStatement prepare = this._connect.prepareStatement("SELECT grp_id, grp_name, grp_flags, acc_rights FROM " + SQLTable.ACCESSSES + ", " + SQLTable.GROUPS + " WHERE acc_fol_id = ? AND acc_grp_id = grp_id", 1004, 1007);
            this._factory.initStatement(prepare);
            try {
                prepare.setLong(1, obj.getID());
                ResultSet resultSet = prepare.executeQuery();
                try {
                    while (resultSet.next()) {
                        long idGrp = resultSet.getLong(1);
                        String name = resultSet.getString(2);
                        int flags = resultSet.getInt(3);
                        DBAccess acc = new DBAccess();
                        acc.setGroup(new IGroup.MinimalGroup(idGrp, name, flags));
                        acc.setRight(DBAccess.parseRight(resultSet.getInt(4)));
                        result.add(acc);
                    }
                    obj.setAccesses(result);
                }
                finally {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                try {
                    prepare.close();
                }
                catch (Exception exception) {}
            }
        }
        catch (SQLException e) {
            this.logSQLException(e, "DefaultFolder::findAccesses(" + obj.getID() + "," + obj.getName() + ")");
        }
        return result;
    }

    private DBFolder findCache(long id) {
        return this._cacheFolder.get(id);
    }

    private void putCache(long id, DBFolder folder) {
        this._cacheFolder.put(id, folder);
    }

    protected String getSQLQueryNow() {
        return "SELECT " + this._factory.getSQLFunctionNow() + " FROM dual";
    }

    @Override
    public void prepareCache() {
        this._cacheFolder = new HashMap<Long, DBFolder>();
        this.refreshLastTimeUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshLastTimeUpdate() {
        try {
            Statement statement = this._connect.createStatement();
            try {
                ResultSet resultSet = statement.executeQuery(this.getSQLQueryNow());
                try {
                    if (resultSet.next()) {
                        long lastTimeUpdate = this._factory.convertTimeStamp(resultSet, 1);
                        if (lastTimeUpdate >= 0L) {
                            this._lastTimeUpdate = lastTimeUpdate;
                        } else {
                            LogUtility.logStackTrace((Logger)DefaultFactory._LOG, (Level)Level.SEVERE, (String)("DefaultFolder::prepareCache lastTimeUpdate<=0\nUse an old value: " + this._lastTimeUpdate), (int)3);
                        }
                    } else {
                        LogUtility.logStackTrace((Logger)DefaultFactory._LOG, (Level)Level.SEVERE, (String)("DefaultFolder::prepareCache no result for 'lastTimeUpdate'\nUse an old value: " + this._lastTimeUpdate), (int)3);
                    }
                }
                finally {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                try {
                    statement.close();
                }
                catch (Exception exception) {}
            }
        }
        catch (SQLException e) {
            DefaultFactory._LOG.log(Level.SEVERE, "DefaultFolder::prepareCache Exception", e);
        }
    }

    @Override
    public void freezeCache(boolean bFreeze) {
        this._bFreezeCache = bFreeze;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateCache(DAOFolder.UpdateListener listener) {
        if (this._bFreezeCache) {
            DefaultFactory._LOG.finer("DefaultFolder::updateCache() No update when freeze");
            return;
        }
        if (this._factory.isDuringTransaction()) {
            DefaultFactory._LOG.finer("DefaultFolder::updateCache() No update during cumulatif transaction");
            return;
        }
        ArrayList<DBFolder> refresh = new ArrayList<DBFolder>();
        try {
            PreparedStatement prepare = this._connect.prepareStatement("SELECT " + this._factory.getSQLFunctionNow() + ", fol_id, fol_time_update, fol_obj_id, fol_name, fol_description, fol_grp_id, fol_grp.grp_name, fol_grp.grp_flags, fol_usr_id, fol_usr.usr_login, fol_usr.usr_flags, fol_access_group, fol_access_other, fol_date_creation, fol_date_modification, fol_last_modifier_usr_id, fo_lusr.usr_login, fo_lusr.usr_flags, fol_flags FROM " + SQLTable.FOLDERS + ", " + SQLTable.GROUPS + " fol_grp, " + SQLTable.USERS + " fol_usr, " + SQLTable.USERS + " fo_lusr WHERE fol_time_update > ? AND fol_grp_id = fol_grp.grp_id AND fol_usr_id = fol_usr.usr_id AND fol_last_modifier_usr_id = fo_lusr.usr_id ORDER BY fol_id", 1004, 1007);
            this._factory.initStatement(prepare);
            try {
                prepare.setTimestamp(1, new Timestamp(this._lastTimeUpdate));
                int nbrResult = 0;
                long lastTimeUpdate = Long.MAX_VALUE;
                ResultSet resultSet = prepare.executeQuery();
                try {
                    while (resultSet.next()) {
                        if (nbrResult == 0) {
                            lastTimeUpdate = this._factory.convertTimeStamp(resultSet, 1);
                        } else {
                            long curLastTimeUpdate = this._factory.convertTimeStamp(resultSet, 1);
                            if (curLastTimeUpdate < lastTimeUpdate) {
                                lastTimeUpdate = curLastTimeUpdate;
                            }
                        }
                        ++nbrResult;
                        long id = resultSet.getLong(2);
                        DBFolder obj = this.findCache(id);
                        if (obj == null || !obj.mustBeUpdated(this._factory.convertTimeStamp(resultSet, 3))) continue;
                        this.refreshFolder(obj, resultSet, 3);
                        refresh.add(obj);
                    }
                    if (lastTimeUpdate != Long.MAX_VALUE) {
                        if (lastTimeUpdate <= 0L) {
                            LogUtility.logStackTrace((Logger)DefaultFactory._LOG, (Level)Level.SEVERE, (String)("DefaultFolder::prepareCache lastTimeUpdate<=0\nUse an old value: " + this._lastTimeUpdate), (int)3);
                        } else {
                            this._lastTimeUpdate = lastTimeUpdate;
                        }
                    }
                }
                finally {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception) {}
                }
                if (refresh.size() > 0) {
                    DefaultFactory._LOG.fine("DefaultFolder::updateCache() for " + refresh.size() + " DBFolder");
                } else {
                    DefaultFactory._LOG.finest("DefaultFolder::updateCache(), but no folder must be update");
                }
            }
            finally {
                try {
                    prepare.close();
                }
                catch (Exception nbrResult) {}
            }
            if (refresh.size() > 0) {
                DefaultFactory._LOG.finer("DefaultFolder::updateCache()=>" + refresh);
                refresh.sort(DBFolder.getComparatorDepth());
                listener.changeBegin();
                for (int i = 0; i < refresh.size(); ++i) {
                    DBFolder obj = (DBFolder)refresh.get(i);
                    List<DBFolder> oldChildren = obj.getChildren();
                    if (oldChildren == null) {
                        DefaultFactory._LOG.finest("DefaultFolder::updateCache() call-1 for " + obj.getPathUntilSystem(new StringBuilder()).toString());
                        listener.changeState(obj);
                        continue;
                    }
                    List<DBFolder> newChildren = this.updateChildren(obj, oldChildren);
                    if (newChildren == null) {
                        DefaultFactory._LOG.finest("DefaultFolder::updateCache() call-2 for " + obj.getPathUntilSystem(new StringBuilder()).toString());
                        listener.changeState(obj);
                        continue;
                    }
                    DefaultFactory._LOG.finest("DefaultFolder::updateCache() call-3 for " + obj.getPathUntilSystem(new StringBuilder()).toString());
                    listener.changeStateAndChildren(obj, oldChildren);
                }
                listener.changeEnd();
            }
        }
        catch (SQLException e) {
            this.logSQLException(e, "DefaultFolder::updateCache() at " + new Date(this._lastTimeUpdate));
        }
        catch (Exception e) {
            this.logException(e, "DefaultFolder::updateCache() at " + new Date(this._lastTimeUpdate));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<DBFolder> updateChildren(DBFolder parent, List<DBFolder> oldChildren) {
        try {
            boolean change = false;
            ArrayList<DBFolder> result = new ArrayList<DBFolder>();
            PreparedStatement prepare = this._connect.prepareStatement("SELECT fol_id FROM " + SQLTable.FOLDERS + " WHERE fol_parent_id = ?", 1004, 1007);
            this._factory.initStatement(prepare);
            try {
                prepare.setLong(1, parent.getID());
                ResultSet resultSet = prepare.executeQuery();
                try {
                    while (resultSet.next()) {
                        long id = resultSet.getLong(1);
                        DBFolder obj = this.findCache(id);
                        if (obj == null) {
                            change = true;
                            obj = this.find(id);
                            obj.setParent(parent);
                            this.putCache(id, obj);
                        } else {
                            if (!oldChildren.remove(obj)) {
                                change = true;
                            }
                            obj.setParent(parent);
                        }
                        result.add(obj);
                    }
                    Collections.sort(result, DBFolder.getComparator());
                    parent.setChildren(result);
                    if (!change) {
                        change = oldChildren.size() != 0;
                    }
                }
                finally {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                try {
                    prepare.close();
                }
                catch (Exception exception) {}
            }
            if (change) {
                return result;
            }
        }
        catch (SQLException e) {
            this.logSQLException(e, "DefaultFolder::findChildren(" + parent.getID() + "," + parent.getName() + ")");
        }
        catch (Exception e) {
            this.logException(e, "DefaultFolder::findChildren(" + parent.getID() + "," + parent.getName() + ")");
        }
        return null;
    }
}

