/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.db.dao.sql.def;

import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBGlobEvent;
import com.dassault.cecilia.db.DBObject;
import com.dassault.cecilia.db.dao.DAOGlobEvent;
import com.dassault.cecilia.db.dao.sql.SQLTable;
import com.dassault.cecilia.db.dao.sql.def.DefaultFactory;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.logging.Level;

public class DefaultGlobEvent
extends DAOGlobEvent {
    protected Connection _connect = null;
    protected DefaultFactory _factory = null;

    public DefaultGlobEvent(Connection connect, DefaultFactory factory) {
        this._connect = connect;
        this._factory = factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doDeleteAll(DBFolder folder) throws SQLException {
        boolean result = false;
        PreparedStatement prepare = this._connect.prepareStatement("DELETE FROM " + SQLTable.EGLI + " WHERE egli_fol_id = ?");
        this._factory.initStatement(prepare);
        prepare.setQueryTimeout(0);
        try {
            prepare.setLong(1, folder.getID());
            int nbrChg = prepare.executeUpdate();
            result = nbrChg > 0;
        }
        finally {
            try {
                prepare.close();
            }
            catch (Exception exception) {}
        }
        return result;
    }

    @Override
    public boolean deleteAll(DBFolder folder) {
        boolean result = false;
        try {
            result = this.doDeleteAll(folder);
        }
        catch (SQLException e) {
            this.logSQLException(e, "DefaultGlobEvent::deleteAll(" + folder + ")");
        }
        catch (Exception e) {
            this.logException(e, "DefaultGlobEvent::deleteAll(" + folder + ")");
        }
        return result;
    }

    protected boolean createInTransaction(DBGlobEvent gEvt) throws SQLException {
        PreparedStatement prepare = this._connect.prepareStatement("INSERT INTO " + SQLTable.EGLI + " (egli_obj_id, egli_fol_id, egli_evt_name, egli_evt_comment, egli_evt_type, egli_evt_data) VALUES (?, ?, ?, ?, ?, ?)");
        this._factory.initStatement(prepare);
        try {
            prepare.setLong(1, gEvt.getObject().getID());
            prepare.setLong(2, gEvt.getFolder().getID());
            prepare.setString(3, gEvt.getName());
            prepare.setString(4, gEvt.getComment());
            prepare.setShort(5, gEvt.getCode());
            prepare.setBinaryStream(6, gEvt.getLObStream());
            boolean bl = prepare.executeUpdate() > 0;
            return bl;
        }
        catch (SQLException e) {
            DefaultFactory._LOG.fine("DefaultGlobEvent::insert(" + gEvt.getName() + ")");
            throw e;
        }
        finally {
            try {
                prepare.close();
            }
            catch (Exception exception) {}
        }
    }

    protected boolean insertAllIntoTransaction(DBFolder dbFolder, Collection<DBGlobEvent> events) throws SQLException {
        this.doDeleteAll(dbFolder);
        boolean result = true;
        for (DBGlobEvent evt : events) {
            result &= this.createInTransaction(evt);
        }
        return result;
    }

    @Override
    public boolean insertAll(DBFolder dbFolder, Collection<DBGlobEvent> events) {
        try {
            boolean result = true;
            this._factory.beginTransaction(false);
            result = this.insertAllIntoTransaction(dbFolder, events);
            this._factory.endTransaction();
            return result;
        }
        catch (Exception e) {
            try {
                this._factory.abortTransaction();
            }
            catch (Exception abortExc) {
                DefaultFactory._LOG.log(Level.SEVERE, "Exception during abort transaction operation: Risk of corruption of data", abortExc);
            }
            this.logException(e, "DefaultGlobEvent::insertAll(" + dbFolder + ")");
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<DBGlobEvent> findAll(DBFolder dbFolder) {
        if (dbFolder == null) {
            throw new NullPointerException();
        }
        if (dbFolder.getObject() == null) {
            throw new NullPointerException();
        }
        DBObject dbObj = dbFolder.getObject();
        LinkedHashMap<String, DBGlobEvent> result = new LinkedHashMap<String, DBGlobEvent>();
        try {
            PreparedStatement prepare = this._connect.prepareStatement("SELECT egli_evt_name, egli_evt_comment, egli_evt_type, egli_evt_data FROM " + SQLTable.EGLI + " WHERE egli_obj_id = ?", 1004, 1007);
            this._factory.initStatement(prepare);
            try {
                prepare.setLong(1, dbObj.getID());
                ResultSet resultSet = prepare.executeQuery();
                try {
                    while (resultSet.next()) {
                        DBGlobEvent dbGEvt = new DBGlobEvent(dbObj);
                        String name = resultSet.getString(1);
                        dbGEvt.setName(name);
                        dbGEvt.setComment(resultSet.getString(2));
                        short code = resultSet.getShort(3);
                        dbGEvt.setType(DBGlobEvent.convertCodeToType(code));
                        dbGEvt.setLink(DBGlobEvent.convertCodeToLink(code));
                        dbGEvt.setLOb(DBGlobEvent.convertBlobToLOb(resultSet.getBinaryStream(4)));
                        result.put(name, dbGEvt);
                    }
                }
                finally {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                try {
                    prepare.close();
                }
                catch (Exception exception) {}
            }
        }
        catch (SQLException e) {
            result = null;
            this.logSQLException(e, "DefaultGlobEvent::findAll(" + dbFolder + ")");
        }
        catch (Exception e) {
            result = null;
            this.logException(e, "DefaultGlobEvent::findAll(" + dbFolder + ")");
        }
        return result == null ? null : result.values();
    }
}

