/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.db.dao.sql.oracle;

import com.dassault.cecilia.db.dao.sql.SQLConnection;
import com.dassault.cecilia.db.dao.sql.def.DefaultLicense;
import com.dassault.cecilia.db.dao.sql.oracle.OracleLicense;
import com.dassault.cecilia.db.dao.sql.sync.SyncFactory;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OracleFactory
extends SyncFactory {
    static Logger _LOG = Logger.getLogger(OracleFactory.class.getPackage().getName());
    public static final String ORACLE_DATE_TIME_FORMAT_PATTERN = "DD/MM/YYYY HH24:MI:SS";

    public OracleFactory(SQLConnection sqlConnect) {
        super(sqlConnect);
    }

    @Override
    public void initConnection() {
        super.initConnection();
        try {
            Statement statement = this._connect.createStatement();
            try {
                statement.execute("alter session set nls_date_format = 'DD/MM/YYYY HH24:MI:SS'");
                statement.execute("alter session set NLS_SORT=GENERIC_BASELETTER");
            }
            finally {
                try {
                    statement.close();
                }
                catch (Exception exception) {}
            }
        }
        catch (SQLException e) {
            _LOG.log(Level.SEVERE, "Bad initialize Oracle connector", e);
        }
    }

    @Override
    public DefaultLicense createLicenseDAO() {
        if (this._daoLicense == null) {
            this._daoLicense = new OracleLicense(this._sqlConnect, this);
        }
        return this._daoLicense;
    }

    @Override
    public String getSQLFunctionNow() {
        return "SYSDATE";
    }

    @Override
    protected String createSequencesSQL(String seq) {
        StringBuilder sb = new StringBuilder();
        sb.append(seq).append("_pk_seq").append(".NEXTVAL");
        return sb.toString();
    }
}

