/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.db.dao.sql.seq;

import com.dassault.cecilia.db.DBObjModel;
import com.dassault.cecilia.db.dao.sql.SQLTable;
import com.dassault.cecilia.db.dao.sql.def.DefaultObjModel;
import com.dassault.cecilia.db.dao.sql.seq.SeqFactory;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;

public class SeqObjModel
extends DefaultObjModel {
    private static final String[] __GENERATED_KEYS = new String[]{"mod_id"};

    public SeqObjModel(Connection connect, SeqFactory factory) {
        super(connect, factory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean createInTransaction(DBObjModel obj) throws SQLException {
        if (SeqFactory._LOG.isLoggable(Level.FINEST)) {
            SeqFactory._LOG.finest("SeqObjModel::createInTransaction(" + obj + ")");
        }
        boolean result = false;
        StringBuilder sqlQuery = new StringBuilder(320).append("INSERT INTO " + SQLTable.OBJ_MODELS + " (mod_id, mod_obj_id, mod_nature, mod_format, mod_encoding, mod_crc, mod_data_size, mod_data)");
        sqlQuery.append(" VALUES (").append(((SeqFactory)this._factory).getSQLNextVal(SQLTable.OBJ_MODELS));
        sqlQuery.append(", ?, ?, ?, ?, ?, ?, ?)");
        PreparedStatement prepare = this._connect.prepareStatement(sqlQuery.toString(), __GENERATED_KEYS);
        this._factory.initStatement(prepare);
        try {
            prepare.setLong(1, obj.getObject().getID());
            prepare.setString(2, obj.getNature());
            prepare.setString(3, obj.getFormat());
            prepare.setString(4, obj.getEncoding());
            prepare.setString(5, obj.getCRC());
            prepare.setLong(6, obj.getSize());
            prepare.setBinaryStream(7, obj.getStreamToSave());
            int nbrChg = prepare.executeUpdate();
            if (nbrChg == 1) {
                ResultSet resultSet = prepare.getGeneratedKeys();
                try {
                    if (resultSet.next()) {
                        obj.setID(resultSet.getLong(1));
                        result = true;
                    }
                }
                finally {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception) {}
                }
            }
            obj.setStreamToSave(null);
        }
        catch (SQLException e) {
            sqlQuery.append("[").append(obj.getObject().getID());
            sqlQuery.append(",").append(obj.getNature());
            sqlQuery.append(",").append(obj.getFormat());
            sqlQuery.append(",").append(obj.getEncoding());
            sqlQuery.append(",").append(obj.getSize());
            sqlQuery.append(",!]");
            SeqFactory._LOG.fine("sqlQuery=" + sqlQuery.toString());
            throw e;
        }
        finally {
            try {
                prepare.close();
            }
            catch (Exception exception) {}
        }
        return result;
    }
}

