/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.faulttree.ccf.gui;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.core.cecilia.folder.gui.DBFolderDlgSelect;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.core.swing.other.CTextFieldWithCallback;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.dao.DAOFolder;
import com.dassault.cecilia.dbobj.faulttree.ccf.CCF;
import com.dassault.cecilia.dbobj.wrap.DBWrap;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class CCFPanelSelect
extends JPanel {
    CeciliaAppl _appl;
    String _oldInput;
    CCF _select;
    JTextField _ctrlInput;
    private static DBFolderDlgSelect _dbFolderChooser = null;
    private static Object _LockerDlgChooser = new Object();
    boolean _bModified = false;

    public CCFPanelSelect(CeciliaAppl appl) {
        super(new GridBagLayout());
        this._appl = appl;
        this.make();
    }

    public void setCCF(CCF dbCcf) {
        this._bModified = false;
        this._select = dbCcf;
        if (dbCcf != null) {
            this._oldInput = dbCcf.getDBFolder().getRefPath();
            this._ctrlInput.setText(this._oldInput);
            this._ctrlInput.setToolTipText(dbCcf.toString());
        } else {
            this._oldInput = "";
            this._ctrlInput.setText("");
            this._ctrlInput.setToolTipText(null);
        }
    }

    public CCF getCCF() {
        DBFolder dbSelect = this.getSelectFolder();
        return this.convertToCCF(dbSelect);
    }

    private void make() {
        this._ctrlInput = new CTextFieldWithCallback(35){

            @Override
            protected void notifyChange() {
                CCFPanelSelect.this.setModified(true);
            }

            @Override
            public void focusLost(FocusEvent e) {
                super.focusLost(e);
                CCF dbEvent = CCFPanelSelect.this.getCCF();
                if (dbEvent != null) {
                    CCFPanelSelect.this._ctrlInput.setToolTipText(dbEvent.toString());
                } else {
                    CCFPanelSelect.this._ctrlInput.setToolTipText(null);
                }
            }
        };
        JButton butEdit = new JButton("...");
        this.add((Component)new JLabel(ResMsgVoc.getString("VOC_CCF_MODELS")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 2, 2), 0, 0));
        this.add((Component)this._ctrlInput, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 5, 2, 5), 0, 0));
        this.add((Component)butEdit, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 2, 2, 5), 0, 0));
        butEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CCFPanelSelect.this.doClicAction();
            }
        });
    }

    protected DBFolder getSelectFolder() {
        String path = this._ctrlInput.getText();
        if (path == null) {
            return null;
        }
        if (path.isEmpty()) {
            return null;
        }
        DAOFolder daoFolder = this._appl.getDAOFactory().createFolderDAO();
        DBFolder rootPath = daoFolder.getRootID(DBFolder.Family.CCF_MODEL.getRootName());
        return daoFolder.findFolder(rootPath, path, false);
    }

    protected CCF convertToCCF(DBFolder dbSelect) {
        if (dbSelect == null) {
            return null;
        }
        if (dbSelect.getFamily() != DBFolder.Family.CCF_MODEL) {
            return null;
        }
        DBWrap dbWrap = this._appl.getDAOFactory().findOrCreateWrap(dbSelect);
        if (dbWrap == null) {
            return null;
        }
        return (CCF)dbWrap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static DBFolderDlgSelect getDlgChooser(Window win, CeciliaAppl appl) {
        if (_dbFolderChooser == null) {
            DBFolderDlgSelect dlg = null;
            Object object = _LockerDlgChooser;
            synchronized (object) {
                if (_dbFolderChooser == null) {
                    dlg = new DBFolderDlgSelect(win, appl, ResMsgVoc.getString("VOC_CCF_MODELS"), DBFolder.Family.CCF_MODEL);
                }
                if (_dbFolderChooser == null) {
                    _dbFolderChooser = dlg;
                }
            }
        }
        return _dbFolderChooser;
    }

    protected void doClicAction() {
        DBFolderDlgSelect dlg = CCFPanelSelect.getDlgChooser(SwingUtilities.getWindowAncestor(this), this._appl);
        DBFolder dbSelect = this.getSelectFolder();
        dlg.setSelectFolder(dbSelect);
        dlg.setVisible(true);
        if (!dlg.getResult()) {
            return;
        }
        dbSelect = dlg.getSelectFolder();
        if (dbSelect == null) {
            this._ctrlInput.setToolTipText(null);
        } else {
            this._ctrlInput.setText(dbSelect.getRefPath());
            CCF dbEvent = this.convertToCCF(dbSelect);
            if (dbEvent != null) {
                this._ctrlInput.setToolTipText(dbEvent.toString());
            } else {
                this._ctrlInput.setToolTipText(null);
            }
        }
        this.setModified(true);
    }

    public JComponent getFocusableComponent() {
        return this._ctrlInput;
    }

    public void setModified(boolean bModified) {
        this._bModified = bModified;
    }

    public boolean isModified() {
        return this._bModified;
    }

    public boolean verifyParameters(String title) {
        if ((this.isModified() || !this._oldInput.equals(this._ctrlInput.getText())) && this._ctrlInput.getText().trim().length() > 0 && this.getCCF() == null) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this._ctrlInput), ResMsgCore.getString("MSG_ERR_BAD_FIELD"), title, 0);
            this._ctrlInput.requestFocus();
            return false;
        }
        return true;
    }
}

