/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.faulttree.criticity;

import com.dassault.cecilia.core.cecilia.CAppl;
import com.dassault.cecilia.core.cecilia.export.DBKOutput;
import com.dassault.cecilia.core.cecilia.export.ExpBook;
import com.dassault.cecilia.core.cecilia.export.ExpContainer;
import com.dassault.cecilia.core.cecilia.export.ExpInfo;
import com.dassault.cecilia.core.cecilia.export.ExpSection;
import com.dassault.cecilia.core.cecilia.export.ExpTable;
import com.dassault.cecilia.core.cecilia.export.XPortCfgDependencies;
import com.dassault.cecilia.core.cecilia.export.XPortConfig;
import com.dassault.cecilia.core.cecilia.pref.GeneralTextPreferencies;
import com.dassault.cecilia.core.cecilia.pref.PrefFieldBoolean;
import com.dassault.cecilia.core.cecilia.pref.PrefFieldsCategory;
import com.dassault.cecilia.core.cecilia.pref.Preferencies;
import com.dassault.cecilia.core.plugin.PluginWithOptions;
import com.dassault.cecilia.dbobj.faulttree.ResMsgArbor;
import com.dassault.cecilia.dbobj.faulttree.criticity.ListCriticityGenerateCmd;
import com.dassault.cecilia.dbobj.faulttree.criticity.ListCriticityPrintPreferencies;
import com.dassault.cecilia.dbobj.faulttree.criticity.ListCriticityUtility;
import com.dassault.cecilia.dbobj.faulttree.gui.ItemAbstractTableModel;
import com.dassault.cecilia.dbobj.project.CriticityCriterion;
import com.dassault.cecilia.lib.util.format.DoubleFormat;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ExportCriticity
extends XPortCfgDependencies
implements XPortConfig<ItemAbstractTableModel<ListCriticityUtility.CriticityIdentifier>> {
    private final CAppl _cAppl;
    private final String _title;
    private final Preferencies _prefs;

    public ExportCriticity(CAppl cAppl, String title) {
        this._title = title;
        this._cAppl = cAppl;
        this._prefs = this._cAppl.getPreferencies();
    }

    @Override
    public void configBook(ExpBook expBook, ItemAbstractTableModel<ListCriticityUtility.CriticityIdentifier> model) {
        expBook.setInfo(new ExpInfoCriticity(this._title));
        this.addInternal(expBook, model);
    }

    @Override
    public void addInto(ExpContainer expContainer, ItemAbstractTableModel<ListCriticityUtility.CriticityIdentifier> model) {
    }

    private void addInternal(ExpContainer expContainer, ItemAbstractTableModel<ListCriticityUtility.CriticityIdentifier> model) {
        if (this.isPreferencySelectedByCode("Content.CriticityDef")) {
            expContainer.add(new ExpSectionTableDefinitionCriticity(model));
        }
        expContainer.add(new ExpSectionTableCriticity(model));
    }

    private static final String removeHTMLCode(String original) {
        String result = original.replace("<html>", "");
        result = result.replace("<br>", "\n");
        result = result.replace("</html>", "");
        return result;
    }

    private final List<PrefFieldBoolean> getListPreferencySelected() {
        PrefFieldsCategory fields = (PrefFieldsCategory)this._cAppl.getPreferencies().getOptions(ListCriticityPrintPreferencies.PREF_KEY);
        ArrayList<PrefFieldBoolean> listFields = new ArrayList<PrefFieldBoolean>();
        List<PrefFieldBoolean> allFields = fields.getBooleanFields();
        for (int i = 0; i < allFields.size() - 1; ++i) {
            PrefFieldBoolean field = allFields.get(i);
            if (!field.isSelected()) continue;
            listFields.add(field);
        }
        return listFields;
    }

    private final boolean isPreferencySelectedByCode(String code) {
        PrefFieldsCategory field = (PrefFieldsCategory)this._prefs.getOptions(ListCriticityPrintPreferencies.PREF_KEY);
        return field.getPref(code).isSelected();
    }

    private class ExpTableCriticity
    extends ExpTable {
        private final ItemAbstractTableModel<ListCriticityUtility.CriticityIdentifier> _model;
        private final List<PrefFieldBoolean> _listBoolean;
        private final DoubleFormat _format;

        public ExpTableCriticity(ItemAbstractTableModel<ListCriticityUtility.CriticityIdentifier> model) {
            this._model = model;
            this._listBoolean = ExportCriticity.this.getListPreferencySelected();
            PluginWithOptions pref = ExportCriticity.this._cAppl.getPreferencies().getOptions(GeneralTextPreferencies.PREF_KEY);
            this._format = pref != null && pref instanceof GeneralTextPreferencies ? ((GeneralTextPreferencies)pref).getDoubleFormat() : null;
        }

        @Override
        protected int getColumnCount() {
            return this._listBoolean.size();
        }

        @Override
        protected String getColumnName(int col) {
            return this._listBoolean.get(col).getLabel();
        }

        @Override
        protected int getRowCount() {
            return this._model.getRowCount();
        }

        private String getValueOfEntry(int col, int row) {
            PrefFieldBoolean field = this._listBoolean.get(col);
            Object value = this._model.getValueAt(row, field.getIdxCode());
            String strValue = value == null ? "" : String.valueOf(value);
            switch (field.getIdxCode()) {
                case 11: 
                case 12: {
                    if (strValue.equals(ListCriticityUtility.CriticityResult.OKKO.OK.name()) || strValue.isEmpty() || strValue.equals(String.valueOf(Double.NaN))) break;
                    StringBuilder sb = new StringBuilder();
                    sb.append(ListCriticityUtility.CriticityResult.OKKO.KO.name()).append(" (");
                    sb.append(strValue).append(')');
                    strValue = sb.toString();
                    break;
                }
                case 5: 
                case 6: {
                    if (strValue.equals(ListCriticityUtility.CriticityResult.OKKO.OK.name())) break;
                    StringBuilder sb = new StringBuilder();
                    sb.append(ListCriticityUtility.CriticityResult.OKKO.KO.name()).append(" (");
                    sb.append(col == 6 ? ListCriticityUtility.isConsistencyComputeMsg(ExportCriticity.this._cAppl, this._model.getItem(row)) : ListCriticityUtility.isConsistencyTreeMsg(ExportCriticity.this._cAppl, this._model.getItem(row)));
                    sb.append(')');
                    strValue = sb.toString();
                    break;
                }
                case 8: {
                    if (value == null || !(value instanceof Double)) break;
                    strValue = this._format != null ? this._format.format(((Double)value).doubleValue()) : Double.toString((Double)value);
                }
            }
            return strValue;
        }

        @Override
        protected void writeDocbookEntryAt(DBKOutput output, int col, int row) throws IOException {
            output.write(ExportCriticity.removeHTMLCode(this.getValueOfEntry(col, row)), true);
        }

        @Override
        protected void exportToScribeEntryAt(StringBuilder buffer, int col, int row, int idx) {
            buffer.append(ExportCriticity.removeHTMLCode(this.getValueOfEntry(col, row)));
        }
    }

    private class ExpSectionTableCriticity
    extends ExpSection {
        private final ItemAbstractTableModel<ListCriticityUtility.CriticityIdentifier> _model;

        public ExpSectionTableCriticity(ItemAbstractTableModel<ListCriticityUtility.CriticityIdentifier> item) {
            this._model = item;
        }

        @Override
        protected void writeContentDocbook(DBKOutput output) throws IOException {
            ExpTableCriticity expTable = new ExpTableCriticity(this._model);
            expTable.setContainer(this);
            expTable.writeDocbook(output);
        }

        @Override
        public String getTitle() {
            return ResMsgArbor.getString("KEY_1294");
        }
    }

    private class ExpTableDefinitionCriticity
    extends ExpTable {
        private final List<CriticityCriterion> _listCrits;

        public ExpTableDefinitionCriticity(List<CriticityCriterion> crits) {
            this._listCrits = crits;
        }

        @Override
        protected int getColumnCount() {
            return ListCriticityGenerateCmd.getHeaderCritTable().length;
        }

        @Override
        protected String getColumnName(int col) {
            return ListCriticityGenerateCmd.getHeaderCritTable()[col];
        }

        @Override
        protected int getRowCount() {
            return this._listCrits.size();
        }

        private String getValueOfEntry(int col, int row) {
            String valueToWrite = null;
            CriticityCriterion critID = this._listCrits.get(row);
            switch (col) {
                case 0: {
                    valueToWrite = critID.getName();
                    break;
                }
                case 1: {
                    valueToWrite = String.valueOf(critID.getProbability());
                    break;
                }
                case 2: {
                    valueToWrite = String.valueOf(critID.getOrder());
                    break;
                }
                case 4: {
                    if (Double.isNaN(critID.getLSREvident())) {
                        valueToWrite = "-";
                        break;
                    }
                    valueToWrite = String.valueOf(critID.getLSREvident());
                    break;
                }
                case 3: {
                    if (Double.isNaN(critID.getLSRLatent())) {
                        valueToWrite = "-";
                        break;
                    }
                    valueToWrite = String.valueOf(critID.getLSRLatent());
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            return valueToWrite;
        }

        @Override
        protected void writeDocbookEntryAt(DBKOutput output, int col, int row) throws IOException {
            String valueToWrite = this.getValueOfEntry(col, row);
            if (valueToWrite != null) {
                output.write(valueToWrite, false);
            }
        }

        @Override
        protected void exportToScribeEntryAt(StringBuilder buffer, int col, int row, int idx) {
            String valueToWrite = this.getValueOfEntry(col, row);
            if (valueToWrite != null) {
                buffer.append(valueToWrite);
            }
        }
    }

    private class ExpSubSectionTableDefinitionCriticity
    extends ExpSection {
        private final String _subSectionTitle;
        private final List<CriticityCriterion> _listCriticities;

        public ExpSubSectionTableDefinitionCriticity(String subSectionTitle, List<CriticityCriterion> listCriticities) {
            this._subSectionTitle = subSectionTitle;
            this._listCriticities = listCriticities;
        }

        @Override
        public String getTitle() {
            return this._subSectionTitle;
        }

        @Override
        protected void writeContentDocbook(DBKOutput output) throws IOException {
            ExpTableDefinitionCriticity table = new ExpTableDefinitionCriticity(this._listCriticities);
            table.setContainer(this);
            table.writeDocbook(output);
        }
    }

    private class ExpSectionTableDefinitionCriticity
    extends ExpSection {
        private final String _titleDefinition;
        private final Map<String, List<CriticityCriterion>> _mapProjectNameToCriticity = new LinkedHashMap<String, List<CriticityCriterion>>();

        public ExpSectionTableDefinitionCriticity(ItemAbstractTableModel<ListCriticityUtility.CriticityIdentifier> model) {
            for (int i = 0; i < model.getRowCount(); ++i) {
                ListCriticityUtility.CriticityIdentifier critID = model.getItem(i);
                CriticityCriterion crit = critID.getCriticityCrit();
                if (crit == null) continue;
                String projectName = ListCriticityGenerateCmd.getDBFolderProjectName(critID.getFolder());
                if (this._mapProjectNameToCriticity.get(projectName) == null) {
                    ArrayList setCrits = new ArrayList();
                    this._mapProjectNameToCriticity.put(projectName, setCrits);
                } else if (this._mapProjectNameToCriticity.get(projectName).contains(crit)) continue;
                this._mapProjectNameToCriticity.get(projectName).add(crit);
            }
            if (this._mapProjectNameToCriticity.size() == 1) {
                Map.Entry<String, List<CriticityCriterion>> entry = this._mapProjectNameToCriticity.entrySet().iterator().next();
                this._titleDefinition = ResMsgArbor.msgFormat("KEY_1291", entry.getKey());
            } else {
                this._titleDefinition = ResMsgArbor.getString("KEY_1292");
            }
            this.addInternal();
        }

        private final void addInternal() {
            if (this._mapProjectNameToCriticity.size() == 1) {
                ExpTableDefinitionCriticity table = new ExpTableDefinitionCriticity(this._mapProjectNameToCriticity.entrySet().iterator().next().getValue());
                this.add(table);
            } else {
                for (Map.Entry<String, List<CriticityCriterion>> entry : this._mapProjectNameToCriticity.entrySet()) {
                    String title = entry.getKey();
                    List<CriticityCriterion> listCrits = entry.getValue();
                    ExpSubSectionTableDefinitionCriticity table = new ExpSubSectionTableDefinitionCriticity(title, listCrits);
                    this.add(table);
                }
            }
        }

        @Override
        public String getTitle() {
            return this._titleDefinition;
        }
    }

    private class ExpInfoCriticity
    extends ExpInfo {
        public ExpInfoCriticity(String title) {
            super(title);
            this.setTitle(title);
            this.setAuthor(ExportCriticity.this._cAppl.getDBUser().getName());
            this.setDate(new Date());
        }
    }
}

