/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.faulttree.egli.gui;

import com.dassault.cecilia.core.cecilia.pref.GeneralTextPreferencies;
import com.dassault.cecilia.core.cecilia.pref.Preferencies;
import com.dassault.cecilia.core.plugin.PluginWithOptions;
import com.dassault.cecilia.core.swing.table.JTableTransfertHandler;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.dbobj.CLawManager;
import com.dassault.cecilia.dbobj.faulttree.egli.FTGlobEventAbstract;
import com.dassault.cecilia.dbobj.faulttree.gui.ItemAbstractTableModel;
import com.dassault.cecilia.dbobj.faulttree.gui.ItemDefaultJTable;
import com.dassault.cecilia.dbobj.faulttree.obj.FTEvent;
import com.dassault.cecilia.dbobj.general.attrib.DBAttrib;
import com.dassault.cecilia.dbobj.general.law.Law;
import com.dassault.cecilia.dbobj.general.law.LawFormat;
import com.dassault.cecilia.dbobj.general.law.Param;
import com.dassault.cecilia.dbobj.general.law.ParamValue;
import com.dassault.cecilia.lib.util.format.DoubleFormat;
import com.dassault.cecilia.lib.util.format.DoubleFormatJava;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import java.awt.Component;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.UIResource;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

class EventGlobalListTable
extends ItemDefaultJTable
implements JTableTransfertHandler.HelperConvert {
    CLawManager _lawManager;
    DoubleFormat _format = new DoubleFormatJava();
    long _prefsCode = -1L;

    EventGlobalListTable(ItemAbstractTableModel<FTGlobEventAbstract> model, CeciliaAppl appl) {
        super(model);
        this._lawManager = appl.getDAOFactory().getLawManager();
        this.changePreferencies(appl.getPreferencies());
        this.setTransferHandler(new JTableTransfertHandler());
        this.setAutoResizeMode(0);
        this.setDefaultRenderer(String.class, new EGLDefaultCellRenderer());
        this.setDefaultRenderer(Boolean.class, new EGLBooleanCellRenderer());
        this.setDefaultRenderer(Param.class, new EGLParamCellRenderer());
        this.setDefaultRenderer(Law.class, new EGLLawCellRenderer());
        this.setDefaultRenderer(FTEvent.State.class, new EGLStateCellRenderer());
        this.setDefaultRenderer(FTEvent.Style.class, new EGLStyleCellRenderer());
        this.setDefaultRenderer(DBFolder.class, new EGLFolderCellRenderer());
        this.setDefaultRenderer(Collection.class, new EGLAttributesCellRenderer());
    }

    @Override
    public void createDefaultColumnsFromModel() {
        super.createDefaultColumnsFromModel();
        for (int col = 0; col < this.getColumnCount(); ++col) {
            int width = 10;
            Object infoWidth = this.getModel().getColumnModel().getColumnField(col).getInfo("Width");
            if (infoWidth != null && infoWidth instanceof Number) {
                width = ((Number)infoWidth).intValue();
            }
            this.getColumnModel().getColumn(col).setPreferredWidth(13 * width);
        }
    }

    public void changePreferencies(Preferencies prefs) {
        if (this._prefsCode == prefs.getRefresh()) {
            return;
        }
        this._prefsCode = prefs.getRefresh();
        PluginWithOptions opts = prefs.getOptions(GeneralTextPreferencies.PREF_KEY);
        if (opts != null && opts instanceof GeneralTextPreferencies) {
            GeneralTextPreferencies gpref = (GeneralTextPreferencies)opts;
            this._format = gpref.getDoubleFormat();
        }
    }

    @Override
    public String convertToString(Object obj, int row, int col) {
        if (obj == null) {
            return "";
        }
        if (obj instanceof DBFolder) {
            return ((DBFolder)obj).getRefPath();
        }
        return obj.toString();
    }

    class EGLBooleanCellRenderer
    extends JCheckBox
    implements TableCellRenderer,
    UIResource {
        private final Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);

        public EGLBooleanCellRenderer() {
            this.setHorizontalAlignment(0);
            this.setBorderPainted(true);
            this.setBorderPaintedFlat(true);
            this.setEnabled(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setForeground(table.getSelectionForeground());
                super.setBackground(table.getSelectionBackground());
            } else {
                this.setForeground(table.getForeground());
                this.setBackground(table.getBackground());
            }
            this.setSelected(value != null && (Boolean)value != false);
            if (hasFocus) {
                this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            } else {
                this.setBorder(this.noFocusBorder);
            }
            return this;
        }
    }

    protected class EGLStyleCellRenderer
    extends EGLDefaultCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
            String txt = "-";
            if (value != null) {
                FTEvent.Style style = (FTEvent.Style)((Object)value);
                txt = style.getLabel();
            }
            this.setText(txt);
            return this;
        }
    }

    protected class EGLStateCellRenderer
    extends EGLDefaultCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
            String txt = "-";
            if (value != null && value instanceof FTEvent.State) {
                txt = ((FTEvent.State)((Object)value)).getLabel();
            }
            this.setText(txt);
            return this;
        }
    }

    protected class EGLAttributesCellRenderer
    extends EGLDefaultCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
            StringBuilder buf = new StringBuilder();
            if (value == null) {
                buf.append("-");
            } else {
                Iterator iterAttrib = ((Collection)value).iterator();
                while (iterAttrib.hasNext()) {
                    DBAttrib.Value dbValue = (DBAttrib.Value)iterAttrib.next();
                    dbValue.appendDisplay(buf);
                    if (!iterAttrib.hasNext()) continue;
                    buf.append("; ");
                }
            }
            this.setText(buf.toString());
            return this;
        }
    }

    protected class EGLFolderCellRenderer
    extends EGLDefaultCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
            String txt = "-";
            if (value != null && value instanceof DBFolder) {
                txt = ((DBFolder)value).getRefPath();
            }
            this.setText(txt);
            return this;
        }
    }

    protected class EGLLawCellRenderer
    extends EGLDefaultCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
            String txt = "-";
            if (value != null && value instanceof Law) {
                txt = LawFormat.DEFAULT.format((Law)value, EventGlobalListTable.this._format);
            }
            this.setText(txt);
            return this;
        }
    }

    protected class EGLParamCellRenderer
    extends EGLDefaultCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
            String txt = "-";
            String tooltip = null;
            if (value != null) {
                Param param = (Param)value;
                txt = LawFormat.DEFAULT.format(param, EventGlobalListTable.this._format);
                if (!(param instanceof ParamValue)) {
                    double pval = EventGlobalListTable.this._lawManager.evaluate(param);
                    tooltip = EventGlobalListTable.this._format.format(pval);
                }
            }
            this.setText(txt);
            this.setToolTipText(tooltip);
            return this;
        }
    }

    protected class EGLDefaultCellRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
            col = table.convertColumnIndexToModel(col);
            this.setHorizontalAlignment(EventGlobalListTable.this.getAlignRenderer(table, col));
            return this;
        }
    }
}

