/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.faulttree.egli.io;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.faulttree.egli.FTGlobEventExtract;
import com.dassault.cecilia.dbobj.faulttree.egli.io.EGLIXmlConstant;
import com.dassault.cecilia.dbobj.faulttree.obj.FTEvent;
import com.dassault.cecilia.dbobj.general.attrib.DBAttrib;
import com.dassault.cecilia.dbobj.general.attrib.io.DBAttributesHandlerXml;
import com.dassault.cecilia.dbobj.general.event.io.ParamInspecFlightHandlerXml;
import com.dassault.cecilia.dbobj.general.law.Law;
import com.dassault.cecilia.dbobj.general.law.Param;
import com.dassault.cecilia.dbobj.general.law.io.LawHandlerXml;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.wrap.io.SAXWrapHandler;
import com.dassault.cecilia.lib.util.xmlparser.SAXExtendedHandler;
import java.util.Collection;
import java.util.Map;
import java.util.logging.Logger;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class EGHandlerXml
extends SAXWrapHandler
implements EGLIXmlConstant {
    private static Logger _LOG = Logger.getLogger(EGHandlerXml.class.getPackage().getName());
    protected CECFactory _daoFactory;
    String _name = null;
    String _label = null;
    String _definition = null;
    Law _law = null;
    Param _inspected = null;
    Param _inflight = null;
    DBFolder _dbModelLaw = null;
    DBFolder _dbSubTree = null;
    Collection<DBAttrib.Value> _attributes = null;
    FTEvent.State _ftState = null;
    FTEvent.Style _ftStyle = null;
    DBFolder _dbCcf = null;
    String _genericSuffix = null;
    boolean _genericFlag = false;
    protected String _startEltKey = null;
    protected SAXExtendedHandler _childHandler = null;

    public EGHandlerXml(DBLogs.DBLogsManager manager, Locator locator, CECFactory daoFactory) {
        super(manager, locator);
        this._daoFactory = daoFactory;
    }

    protected String readName(String key, Map<String, String> attrs) throws SAXException {
        return this.readName(key, "name", attrs);
    }

    protected String getName() {
        return this._name;
    }

    private String getMsgName() {
        return new StringBuilder(256).append(ResMsgVoc.getString("VOC_EVENT")).append(" ").append(this.getName()).toString();
    }

    public void startAction(String key, Map<String, String> attrs, boolean startAction) throws SAXException {
        if (this._childHandler != null) {
            this._childHandler.startAction(key, attrs, startAction);
        } else if (startAction) {
            this._startEltKey = key;
            if (attrs.get("name") != null) {
                this._name = this.readName(key, attrs);
            }
            if (attrs.get("isGeneric") != null) {
                this._genericFlag = this.readBoolean(key, "isGeneric", attrs, false, false);
            }
        } else if (!this.startInternalAction(key, attrs)) {
            this.errorElementUnknown(key);
        }
    }

    protected boolean startInternalAction(String key, Map<String, String> attrs) throws SAXException {
        if ("frb".equals(key)) {
            DBFolder dbFolder = this.readDBFolder(key, attrs, this._daoFactory.createFolderDAO(), DBFolder.Family.BTP_MODEL.getRootName(), false);
            if (dbFolder != null && dbFolder.getFamily() != DBFolder.Family.BTP_MODEL) {
                this.warning(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_FOLDER_FAMILY", new Object[]{dbFolder.getRefPath(), DBFolder.Family.BTP_MODEL}), this.getLocator()));
                dbFolder = null;
            }
            if (dbFolder != null) {
                this._dbModelLaw = dbFolder;
            }
        } else if ("ft.link".equals(key)) {
            DBFolder dbFolder;
            if (attrs.get("addIfGeneric") != null) {
                this._genericSuffix = this.readAttr(key, "addIfGeneric", attrs);
            }
            if ((dbFolder = this.readDBFolder(key, attrs, this._daoFactory.createFolderDAO(), DBFolder.Family.PROJECT.getRootName(), false)) != null && dbFolder.getFamily() != DBFolder.Family.PROJECT && dbFolder.getFamilyFlag() != 2 && dbFolder.getFamilyFlag() != 5 && dbFolder.getFamilyFlag() != 3) {
                this.warning(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_FOLDER_FAMILY", new Object[]{dbFolder.getRefPath(), DBFolder.Family.PROJECT}), this.getLocator()));
                dbFolder = null;
            }
            if (dbFolder != null) {
                this._dbSubTree = dbFolder;
            }
        } else if ("law".equals(key)) {
            this._childHandler = new LawHandlerXml(this.getLogManager(), this.getLocator(), this._daoFactory, this._daoFactory.getLawManager()){

                @Override
                protected String getOwnerObject() {
                    return EGHandlerXml.this.getMsgName();
                }
            };
            this._childHandler.startAction(key, attrs, true);
        } else if ("inspected".equals(key)) {
            this._childHandler = new ParamInspecFlightHandlerXml(this.getLogManager(), this.getLocator(), this._daoFactory, this._daoFactory.getLawManager()){

                @Override
                protected String getOwnerObject() {
                    return EGHandlerXml.this.getMsgName();
                }
            };
            this._childHandler.startAction(key, attrs, true);
        } else if ("inflight".equals(key)) {
            this._childHandler = new ParamInspecFlightHandlerXml(this.getLogManager(), this.getLocator(), this._daoFactory, this._daoFactory.getLawManager()){

                @Override
                protected String getOwnerObject() {
                    return EGHandlerXml.this.getMsgName();
                }
            };
            this._childHandler.startAction(key, attrs, true);
        } else if ("attributes".equals(key)) {
            this._childHandler = new DBAttributesHandlerXml(this.getLogManager(), this.getLocator(), this._daoFactory, this.getName());
            this._childHandler.startAction(key, attrs, true);
        } else if ("ft.state".equals(key)) {
            FTEvent.State state = null;
            String attr = this.readAttr(key, "value", attrs);
            if (attr != null && (state = (FTEvent.State)EGHandlerXml.valueOfEnum(FTEvent.State.class, (String)attr.toUpperCase())) == null) {
                this.warning(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_ATTR_FORMAT", key, "value", attr), this.getLocator()));
            }
            if (state != null) {
                this._ftState = state;
            }
        } else if ("ft.style".equals(key)) {
            FTEvent.Style style = null;
            String attr = this.readAttr(key, "value", attrs);
            if (attr != null && (style = (FTEvent.Style)EGHandlerXml.valueOfEnum(FTEvent.Style.class, (String)attr.toUpperCase())) == null) {
                this.warning(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_ATTR_FORMAT", key, "value", attr), this.getLocator()));
            }
            if (style != null) {
                this._ftStyle = style;
            }
        } else if ("ft.ccf".equals(key)) {
            DBFolder dbFolder = this.readDBFolder(key, attrs, this._daoFactory.createFolderDAO(), DBFolder.Family.CCF_MODEL.getRootName(), false);
            if (dbFolder != null && dbFolder.getFamily() != DBFolder.Family.CCF_MODEL) {
                this.warning(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_FOLDER_FAMILY", new Object[]{dbFolder.getRefPath(), DBFolder.Family.CCF_MODEL}), this.getLocator()));
                dbFolder = null;
            }
            if (dbFolder != null) {
                this._dbCcf = dbFolder;
            }
        } else if (!"label".equals(key) && !"ft.define".equals(key)) {
            return false;
        }
        return true;
    }

    public boolean endAction(String key, Map<String, String> attrs, String txt) throws SAXException {
        if (this._childHandler != null) {
            boolean result = this._childHandler.endAction(key, attrs, txt);
            if (result) {
                if ("law".equals(key)) {
                    this._law = ((LawHandlerXml)this._childHandler).getLaw();
                } else if ("inspected".equals(key)) {
                    this._inspected = ((ParamInspecFlightHandlerXml)this._childHandler).getParam();
                } else if ("inflight".equals(key)) {
                    this._inflight = ((ParamInspecFlightHandlerXml)this._childHandler).getParam();
                } else if ("attributes".equals(key)) {
                    this._attributes = ((DBAttributesHandlerXml)this._childHandler).getAttributes();
                } else {
                    _LOG.severe("Erreur interne \u00e0 la fermeture de l'\u00e9l\u00e9ment '" + key + "'");
                }
                this._childHandler = null;
            }
            return false;
        }
        if ("label".equals(key)) {
            this._label = txt;
            return false;
        }
        if ("ft.define".equals(key)) {
            this._definition = txt;
            return false;
        }
        return this._startEltKey.equals(key);
    }

    public void configureEvent(FTGlobEventExtract evt) {
        if (this._label != null && this._label.length() > 0) {
            evt.setComment(this._label);
        }
        if (this._definition != null && this._definition.length() > 0) {
            evt.setDefinition(this._definition);
        }
        if (this._law != null) {
            evt.setLaw(this._law);
        }
        if (this._inspected != null) {
            evt.setInspected(this._inspected);
        }
        if (this._inflight != null) {
            evt.setInflightTested(this._inflight);
        }
        if (this._attributes != null) {
            evt.setAttributes(this._attributes);
        }
        if (this._ftState != null) {
            evt.setState(this._ftState);
        }
        if (this._ftStyle != null) {
            evt.setStyle(this._ftStyle);
        }
        if (this._dbSubTree != null) {
            evt.setSubTree(this._dbSubTree);
        }
        if (this._dbModelLaw != null) {
            evt.setModelLaw(this._dbModelLaw);
        }
        if (this._dbCcf != null) {
            evt.setCCF(this._dbCcf);
        }
        if (this._genericFlag) {
            evt.setGenericFlag(true);
        }
        if (this._genericSuffix != null && this._genericSuffix.length() > 0) {
            evt.setGenericSuffix(this._genericSuffix);
        }
    }
}

