/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.faulttree.ft.gui;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.action.CThread;
import com.dassault.cecilia.core.cecilia.action.UndoManager;
import com.dassault.cecilia.core.cecilia.export.ExpBookUtility;
import com.dassault.cecilia.core.cecilia.export.JChooserFileUtility;
import com.dassault.cecilia.core.cecilia.folder.DBFolderResources;
import com.dassault.cecilia.core.cecilia.pref.Preferencies;
import com.dassault.cecilia.core.plugin.IModel;
import com.dassault.cecilia.core.plugin.InfoDatum;
import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.core.plugin.PlugableModel;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.core.taskmanager.TaskMng;
import com.dassault.cecilia.core.taskmanager.TaskState;
import com.dassault.cecilia.core.taskmanager.TaskThread;
import com.dassault.cecilia.db.DBFactory;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBGlobEvent;
import com.dassault.cecilia.dbobj.faulttree.ResIcoArbor;
import com.dassault.cecilia.dbobj.faulttree.ResMsgArbor;
import com.dassault.cecilia.dbobj.faulttree.TreeInfoCompute;
import com.dassault.cecilia.dbobj.faulttree.config.gui.FTConfigPanel;
import com.dassault.cecilia.dbobj.faulttree.ft.FTEquation;
import com.dassault.cecilia.dbobj.faulttree.ft.export.XPortCfgTree;
import com.dassault.cecilia.dbobj.faulttree.ft.gui.FGContentPanel;
import com.dassault.cecilia.dbobj.faulttree.ft.gui.FTEditPanel;
import com.dassault.cecilia.dbobj.faulttree.ft.gui.FTEquationDatumUtility;
import com.dassault.cecilia.dbobj.faulttree.ft.gui.FTVariableListPanel;
import com.dassault.cecilia.dbobj.faulttree.ft.gui.actions.FTCmd;
import com.dassault.cecilia.dbobj.folder.DBFolderPropertiesPanel;
import com.dassault.cecilia.dbobj.folder.DBFolderThreadClose;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.general.log.gui.DBLogsSimpleDlg;
import com.dassault.cecilia.dbobj.wrap.DBWrapThreadSave;
import com.dassault.cecilia.dbobj.wrap.gui.DBWrapSaveAsDlg;
import com.dassault.cecilia.dbobj.wrap.gui.DBWrapSaveAsDlgWithVirtual;
import com.dassault.cecilia.lib.util.io.FileUtility;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import com.dassault.cecilia.main.cecilia.CeciliaGUI;
import com.dassault.cecilia.main.cecilia.actions.search.SearchAction;
import com.dassault.cecilia.main.cecilia.actions.search.SearchDlg;
import com.dassault.cecilia.main.cecilia.folders.ProjectFolderCreateTreeVersionPanel;
import com.dassault.cecilia.main.cecilia.gui.DBInternalFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class FTEquationFrame
extends DBInternalFrame
implements PlugableModel,
Preferencies.PreferenciesListener {
    private static Logger _LOG = Logger.getLogger(FTEquationFrame.class.getPackage().getName());
    FTEquation _ftEquation;
    CeciliaAppl _application;
    FTEquationDatumUtility _datumUtility;
    JTabbedPane _tabPane = new JTabbedPane();
    FTEditPanel _currentEditPanel = null;
    FGContentPanel _treePanel;
    FTVariableListPanel _evtsPanel;
    FTConfigPanel _cfgsPanel;
    private JButton _ctrlInstanciate;
    CeciliaGUI _gui;
    AbstractAction _actionUndo;
    AbstractAction _actionRedo;

    @Override
    protected String getDBLabel() {
        return ResMsgVoc.getString("VOC_TREE");
    }

    @Override
    public FTEquation getDBWrap() {
        return this._ftEquation;
    }

    @Override
    protected CeciliaAppl getApplication() {
        return this._application;
    }

    public FTEquationFrame(FTEquation ftEquation, CeciliaAppl appl) {
        super(ftEquation.getDBFolder());
        this._ftEquation = ftEquation;
        this._application = appl;
        this.createActions();
        this.makePanel();
        this.setFrameIcon(DBFolderResources.getFrameIcon(ftEquation.getDBFolder()));
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setSize(screenSize.width / 2, screenSize.height / 2);
        this.setVisible(false);
    }

    private void makePanel() {
        if (!this._ftEquation.isBigTree()) {
            this._treePanel = new FGContentPanel(this);
            this._ftEquation.addChangeListener(this._treePanel);
            this._tabPane.addTab(ResMsgVoc.getString("VOC_VIEW"), ResIcoArbor.getImageIcon("GRAPHE_PI"), this._treePanel);
            this._treePanel.make();
            this._ftEquation.addChangeSelectionListener(this._treePanel);
        }
        this._evtsPanel = new FTVariableListPanel(this);
        this._ftEquation.addChangeListener(this._evtsPanel);
        this._tabPane.addTab(ResMsgVoc.getString("VOC_EVENTS"), ResIcoArbor.getImageIcon("LIST_ITEM_PI"), this._evtsPanel);
        this._ftEquation.addChangeSelectionListener(this._evtsPanel);
        this._cfgsPanel = new FTConfigPanel(this);
        this._ftEquation.addChangeListener(this._cfgsPanel);
        this._tabPane.addTab(ResMsgArbor.getString("CFG_DLG_TITLE"), this._cfgsPanel);
        this._tabPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (FTEquationFrame.this._currentEditPanel != null) {
                    FTEquationFrame.this._currentEditPanel.toDoWhenDeActivated();
                }
                FTEquationFrame.this._currentEditPanel = (FTEditPanel)FTEquationFrame.this._tabPane.getSelectedComponent();
                if (FTEquationFrame.this._currentEditPanel != null) {
                    FTEquationFrame.this._currentEditPanel.toDoWhenActivated();
                }
            }
        });
        JPanel content = new JPanel(new BorderLayout());
        this.getContentPane().add(content);
        this._tabPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 5, 10));
        content.add((Component)this._tabPane, "Center");
        content.add(this.createInstanceAndLogsButtonAt(this.createSaveAndClosePanel()), "South");
        this._currentEditPanel = !this._ftEquation.isBigTree() ? this._treePanel : this._evtsPanel;
        this.refreshCtrlInstanciate();
    }

    public FGContentPanel getContentPanel() {
        return this._treePanel;
    }

    public FTEditPanel getCurrentEditPanel() {
        return this._currentEditPanel;
    }

    public void refreshCtrlInstanciate() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                FTEquationFrame.this._ctrlInstanciate.setVisible(FTEquationFrame.this._ftEquation.getManuelInstanciate());
            }
        });
    }

    public void refreshCtrlLogs() {
        DBLogs.DBLevel oldLevel = this.getLogs().getMaxLevel();
        int oldNbr = this.getLogs().getNbrLogs();
        this.updateLogs(this._ftEquation.getWorkingRelations(), oldLevel, oldNbr);
    }

    protected Component createInstanceAndLogsButtonAt(Component panel) {
        this._ctrlInstanciate = new JButton(ResMsgArbor.getString("FT_INSTANCIATE"));
        this._ctrlInstanciate.setToolTipText(ResMsgArbor.getString("FT_INSTANCIATE_TT"));
        this._ctrlInstanciate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!FTEquationFrame.this._ftEquation.getManuelInstanciate()) {
                    FTEquationFrame.this._ctrlInstanciate.setVisible(false);
                } else if (!FTEquationFrame.this._ftEquation.instanciate(true, FTEquationFrame.this.getApplication().getDBUser())) {
                    DBLogsSimpleDlg logsDlg = new DBLogsSimpleDlg(JOptionCecilia.getWindowOf(FTEquationFrame.this._ctrlInstanciate));
                    logsDlg.setDBLogs(FTEquationFrame.this._ftEquation.getInstanciateLogs());
                    logsDlg.setVisible(true);
                } else {
                    FTEquationFrame.this._ftEquation.setManuelInstanciate(false);
                    FTEquationFrame.this._ctrlInstanciate.setVisible(false);
                }
            }
        });
        JPanel panelLog = new JPanel(new GridBagLayout());
        panelLog.add(panel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        panelLog.add((Component)this._ctrlInstanciate, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 2, new Insets(0, 5, 5, 5), 0, 0));
        panelLog.add(this.getLogs().getButLogs(), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 2, new Insets(0, 5, 5, 5), 0, 0));
        return panelLog;
    }

    @Override
    protected boolean withUpdateEdit() {
        return true;
    }

    @Override
    protected void updateEdit() {
        this._cfgsPanel.addValuesInCtrlCriticity();
        DBLogs.DBLevel oldLevel = this.getLogs().getMaxLevel();
        int oldNbr = this.getLogs().getNbrLogs();
        DBLogs.DefaultManager logMng = new DBLogs.DefaultManager(this.getApplication().getDBUser().getLogin(), this._ftEquation.getLogs());
        if (!this._ftEquation.update(this.getApplication(), logMng)) {
            DBLogsSimpleDlg logsDlg = new DBLogsSimpleDlg(JOptionCecilia.getWindowOf(this._ctrlInstanciate));
            logsDlg.setDBLogs(this._ftEquation.getInstanciateLogs());
            logsDlg.setVisible(true);
            this._ftEquation.setManuelInstanciate(true);
        } else {
            this._ftEquation.setManuelInstanciate(false);
            this._ftEquation.defineLockedVariables();
        }
        this._ftEquation.fireChangeDefinitions(null, this);
        this.refreshCtrlInstanciate();
        this.updateLogs(this._ftEquation.getWorkingRelations(), oldLevel, oldNbr);
    }

    @Override
    public boolean isModified() {
        if (super.isModified()) {
            return true;
        }
        return this._ftEquation.isModified();
    }

    @Override
    public void setModified(boolean value) {
        super.setModified(value);
        this._ftEquation.setModified(value);
    }

    @Override
    public boolean toDoWhenClosing() {
        if (!super.toDoWhenClosing()) {
            return false;
        }
        if (!this.verifyTasks()) {
            return false;
        }
        if (!this.verifyClose()) {
            return false;
        }
        new DBFolderThreadClose(this.getDBFolder(), this.getApplication(), this._ctrlClose).realiseDo();
        return true;
    }

    private boolean verifyTasks() {
        TaskMng taskMng = this.getApplication().getPlugable().getTaskManager();
        if (taskMng == null) {
            return true;
        }
        List<TaskThread> currentThreads = taskMng.getTasks(this.getDBFolder().getID());
        if (currentThreads == null) {
            return true;
        }
        if (currentThreads.isEmpty()) {
            return true;
        }
        ArrayList<TaskThread> threads = new ArrayList<TaskThread>(currentThreads.size());
        for (TaskThread taskThread : currentThreads) {
            if (taskThread.state() == TaskState.FINISH) continue;
            threads.add(taskThread);
        }
        if (threads.isEmpty()) {
            return true;
        }
        Object[] options = new Object[]{ResMsgVoc.getString("VOC_YES"), ResMsgVoc.getString("VOC_NO"), ResMsgVoc.getString("VOC_CANCEL")};
        int reponse = JOptionPane.showOptionDialog(JOptionCecilia.getTopContainerOf(this), ResMsgArbor.msgFormat("MSG_ANSWER_STOP_TASK", this.getDBFolder().getRefPath()), ResMsgVoc.getString("VOC_MESSAGE"), 1, 3, null, options, options[0]);
        switch (reponse) {
            case 0: {
                for (TaskThread taskThread : threads) {
                    taskThread.requestStop();
                    taskMng.refreshTask(taskThread);
                }
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                return false;
            }
        }
        return true;
    }

    @Override
    public void toDoWhenBeOpened() {
        super.toDoWhenBeOpened();
        this._application.getPreferencies().addPreferenciesListener(this);
    }

    @Override
    public void changePreferencies(Preferencies prefs) {
        this._evtsPanel.changePreferencies(prefs);
        if (!this._ftEquation.isBigTree()) {
            this._treePanel.changePreferencies(prefs);
        }
    }

    @Override
    public void toDoWhenBeClosed() {
        this._application.getPreferencies().removePreferenciesListener(this);
        this._ftEquation.removeChangeListener(this._cfgsPanel);
        this._ftEquation.removeChangeListener(this._evtsPanel);
        if (!this._ftEquation.isBigTree()) {
            this._ftEquation.removeChangeListener(this._treePanel);
        }
        this._ftEquation.clearInfoComputes();
        super.toDoWhenBeClosed();
    }

    @Override
    protected String getDescription() {
        return "";
    }

    @Override
    public boolean save() {
        if (this.isReadOnly()) {
            return false;
        }
        return this.doSave();
    }

    @Override
    protected boolean doSave() {
        DBWrapThreadSave thSave = new DBWrapThreadSave(this._ftEquation, null, this._application, this._ctrlSave){

            @Override
            protected void setModif(boolean value) {
                FTEquationFrame.this.setModified(value);
            }

            @Override
            protected boolean writeToDAO() {
                if (!super.writeToDAO()) {
                    return false;
                }
                Collection<DBGlobEvent> events = FTEquationFrame.this._ftEquation.createGlobalEvents(FTEquationFrame.this._ftEquation.getDBFolder());
                return FTEquationFrame.this.getApplication().getDAOFactory().createGlobEventDAO().insertAll(FTEquationFrame.this.getDBFolder(), events);
            }
        };
        return this.doSave(thSave);
    }

    @Override
    protected DBWrapSaveAsDlg saveAsPrepareDialog() {
        return new DBWrapSaveAsDlgWithVirtual(JOptionCecilia.getWindowOf(this), this.getApplication(), this.getDBFolder().getFamily()){

            @Override
            protected DBFolderPropertiesPanel createVersionPanel() {
                return new ProjectFolderCreateTreeVersionPanel();
            }
        };
    }

    @Override
    protected DBFolder[] saveAsPrepareFolders(DBWrapSaveAsDlg dlg) {
        if (!dlg.isVersionCreation()) {
            return DBFactory.createModel(dlg.getSelectFolder(), this.getApplication().getDBUser(), dlg.getNewName(), "1.0", this.getDBFolder().getFamily(), this.getDBFolder().getFamilyFlag(), (short)0);
        }
        return super.saveAsPrepareFolders(dlg);
    }

    @Override
    public boolean print() {
        if (this._currentEditPanel != null) {
            return this._currentEditPanel.print();
        }
        return super.print();
    }

    @Override
    public boolean preview() {
        if (this._currentEditPanel != null) {
            return this._currentEditPanel.preview();
        }
        return super.print();
    }

    protected void createActions() {
        this._gui = this._application.getTopWindow();
        this._actionUndo = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                class UndoThread
                extends CThread {
                    public UndoThread(Component c) {
                        super(c);
                    }

                    @Override
                    protected void firstDo() {
                        UndoManager undoMng = FTEquationFrame.this._ftEquation.getUndoManager();
                        if (undoMng.undoable()) {
                            undoMng.undo();
                            if (_LOG.isLoggable(Level.FINEST)) {
                                StringBuilder buffer = new StringBuilder(2048);
                                buffer.append("After UndoManager::undo\n");
                                undoMng.debugTrace(buffer);
                                _LOG.finest(buffer.toString());
                            }
                            FTEquationFrame.this._gui.getDelegateAction("UNDO").setEnabled(undoMng.undoable());
                            FTEquationFrame.this._gui.getDelegateAction("REDO").setEnabled(undoMng.redoable());
                        }
                    }
                }
                UndoThread thread = new UndoThread(FTEquationFrame.this._evtsPanel);
                thread.realiseDo();
            }
        };
        this._actionRedo = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                class RedoThread
                extends CThread {
                    public RedoThread(Component c) {
                        super(c);
                    }

                    @Override
                    protected void firstDo() {
                        UndoManager undoMng = FTEquationFrame.this._ftEquation.getUndoManager();
                        if (undoMng.redoable()) {
                            undoMng.redo();
                            if (_LOG.isLoggable(Level.FINEST)) {
                                StringBuilder buffer = new StringBuilder(2048);
                                buffer.append("After UndoManager::redo\n");
                                undoMng.debugTrace(buffer);
                                _LOG.finest(buffer.toString());
                            }
                            FTEquationFrame.this._gui.getDelegateAction("UNDO").setEnabled(undoMng.undoable());
                            FTEquationFrame.this._gui.getDelegateAction("REDO").setEnabled(undoMng.redoable());
                        }
                    }
                }
                RedoThread thread = new RedoThread(FTEquationFrame.this._evtsPanel);
                thread.realiseDo();
            }
        };
    }

    public void clearHisto() {
        UndoManager undoMng = this._ftEquation.getUndoManager();
        undoMng.clear();
        this._gui.getDelegateAction("UNDO").setEnabled(undoMng.undoable());
        this._gui.getDelegateAction("REDO").setEnabled(undoMng.redoable());
    }

    public void addHisto(FTCmd cmd) {
        UndoManager undoMng = this._ftEquation.getUndoManager();
        undoMng.addCmd(cmd);
        if (_LOG.isLoggable(Level.FINEST)) {
            StringBuilder buffer = new StringBuilder(2048);
            buffer.append("After UndoManager::addCmd\n");
            undoMng.debugTrace(buffer);
            _LOG.finest(buffer.toString());
        }
        this._gui.getDelegateAction("UNDO").setEnabled(undoMng.undoable());
        this._gui.getDelegateAction("REDO").setEnabled(undoMng.redoable());
    }

    @Override
    protected void toDoWhenDeActivated() {
        this._gui.getDelegateAction("UNDO").delDelegate(this._actionUndo).setEnabled(false);
        this._gui.getDelegateAction("REDO").delDelegate(this._actionRedo).setEnabled(false);
        this._gui.setEnabledAction("SEARCH", false);
        ((SearchAction)this._gui.getAction("SEARCH")).saveContextDlg(this._application, this, SearchDlg.SearchType.EVENTS, this.getDBWrap().getRefPath());
        if (this._currentEditPanel != null) {
            this._currentEditPanel.toDoWhenDeActivated();
        }
        super.toDoWhenDeActivated();
    }

    @Override
    protected void toDoWhenActivated() {
        if (this._currentEditPanel != null) {
            this._currentEditPanel.toDoWhenActivated();
        }
        UndoManager undoMng = this._ftEquation.getUndoManager();
        this._gui.getDelegateAction("UNDO").addDelegate(this._actionUndo).setEnabled(undoMng.undoable());
        this._gui.getDelegateAction("REDO").addDelegate(this._actionRedo).setEnabled(undoMng.redoable());
        this._gui.setEnabledAction("SEARCH", true);
        ((SearchAction)this._gui.getAction("SEARCH")).updateContextDlg(this._application, this, SearchDlg.SearchType.EVENTS, this.getDBWrap().getRefPath());
        super.toDoWhenActivated();
    }

    public AbstractAction getActionUndo() {
        return this._actionUndo;
    }

    public AbstractAction getActionRedo() {
        return this._actionRedo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IModel getModel(String key) {
        block12: {
            if (this._currentEditPanel instanceof FTConfigPanel) {
                return null;
            }
            if (key.equals("aralia.file")) {
                IModel.DefaultModel defaultModel;
                block11: {
                    File fileDag = null;
                    fileDag = File.createTempFile("TreeEquation", ".dag");
                    fileDag.deleteOnExit();
                    Writer writerDag = null;
                    try {
                        writerDag = new BufferedWriter(new FileWriter(fileDag));
                        this._ftEquation.setFlags(1);
                        this._ftEquation.writeEqu(writerDag);
                        defaultModel = new IModel.DefaultModel(key, fileDag, this._ftEquation.getTopEvent().getName(), this.getDBFolder().getID());
                        if (writerDag == null) break block11;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (writerDag != null) {
                                writerDag.close();
                            }
                            throw throwable;
                        }
                        catch (IOException ioe) {
                            if (fileDag != null) {
                                fileDag.delete();
                            }
                            break block12;
                        }
                    }
                    writerDag.close();
                }
                return defaultModel;
            }
            JChooserFileUtility.Type type = ExpBookUtility.convertModelKey(key);
            if (type != null) {
                StringBuilder defaultName = new StringBuilder();
                defaultName.append(FileUtility.protectFilename((String)this._ftEquation.getDBFolder().getParent().getName()));
                defaultName.append("(").append(this._ftEquation.getDBFolder().getName()).append(")");
                String optKey = this._currentEditPanel instanceof FGContentPanel ? ".tree" : ".list";
                defaultName.append(optKey);
                File file = ExpBookUtility.selectFile(type, this.getApplication().getPlugable(), this, this._ftEquation.getDBFolder(), optKey, defaultName.toString());
                if (file != null) {
                    XPortCfgTree.TypeExport config = this._currentEditPanel instanceof FGContentPanel ? XPortCfgTree.TypeExport.ONLY_TREE_VIEW : XPortCfgTree.TypeExport.ONLY_LIST_EVENTS;
                    return this._ftEquation.exportDocbookModel(key, this.getApplication(), config, file, null, -1);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TreeInfoCompute getDatum(String key) {
        if (!key.startsWith("Tree.Compute.")) {
            return null;
        }
        if (this._ftEquation.getManuelInstanciate()) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this), ResMsgArbor.getString("FT_INSTANCIATE_ERROR_COMPUTE"), JOptionCecilia.getTopTitleOf(this), 0);
            return null;
        }
        if (this._datumUtility == null) {
            FTEquationFrame fTEquationFrame = this;
            synchronized (fTEquationFrame) {
                this._datumUtility = new FTEquationDatumUtility(this._ftEquation, this, this._application);
            }
        }
        return this._datumUtility.getDatum(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDatum(InfoDatum idatum, Plugable srcPlugable) {
        if (idatum.getModel().getUID() != this._ftEquation.getRefID()) {
            _LOG.info("setDatum(...) with bad ID for equation '" + this._ftEquation.getRefPath() + "'");
            return;
        }
        if (!idatum.getKey().startsWith("Tree.Compute.")) {
            return;
        }
        if (this._datumUtility == null) {
            FTEquationFrame fTEquationFrame = this;
            synchronized (fTEquationFrame) {
                this._datumUtility = new FTEquationDatumUtility(this._ftEquation, this, this._application);
            }
        }
        this._datumUtility.setDatum(idatum);
    }

    @Override
    public String getInfo(String key) {
        return this.getApplication().getPlugable().getInfo(key);
    }
}

