/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.faulttree.ft.gui.actions;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.swing.JDialogCecilia;
import com.dassault.cecilia.dbobj.faulttree.ResMsgArbor;
import com.dassault.cecilia.dbobj.faulttree.obj.FTVariableAbstract;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class SelectPathDlg
extends JDialogCecilia {
    protected final JList _ctrlList = new JList();

    public SelectPathDlg(Window win, List<List<FTVariableAbstract>> paths, FTVariableAbstract ftChild, int selectionMode, String labelStr) {
        super(win, true);
        this._ctrlList.setListData(paths.toArray());
        this._ctrlList.setCellRenderer(this.getDefaultListCellRendererSelectPath());
        this._ctrlList.setSelectionMode(selectionMode);
        this._ctrlList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() < 2) {
                    return;
                }
                if (!SwingUtilities.isLeftMouseButton(e)) {
                    return;
                }
                SelectPathDlg.this.validDialog();
            }
        });
        JScrollPane scroll = new JScrollPane(this._ctrlList);
        scroll.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)scroll, "Center");
        JLabel label = new JLabel(ResMsgArbor.msgFormat(labelStr, ftChild.getName()));
        label.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.getContentPane().add((Component)label, "North");
        this.getContentPane().add((Component)this.createButPanel(true), "South");
        this.init();
        this.pack();
        this.setModal(true);
    }

    protected DefaultListCellRenderer getDefaultListCellRendererSelectPath() {
        return new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                List item = (List)value;
                String parent = null;
                int idxParent = item.size() - 1;
                StringBuilder sb = new StringBuilder();
                sb.append("<html>");
                for (int i = 0; i < item.size(); ++i) {
                    for (int j = i; j > 0; --j) {
                        sb.append("&nbsp;&nbsp;");
                    }
                    if (i == idxParent) {
                        parent = ((FTVariableAbstract)item.get(i)).getName();
                        sb.append("<b>");
                    }
                    sb.append(((FTVariableAbstract)item.get(i)).getName());
                    if (i == idxParent) {
                        sb.append("</b>");
                    }
                    sb.append("<br/>");
                }
                sb.append("</html>");
                if (parent == null) {
                    this.setText("<???>");
                    this.setToolTipText(null);
                } else {
                    this.setText(parent);
                    this.setToolTipText(sb.toString());
                }
                return this;
            }
        };
    }

    @Override
    protected boolean verifyParameters() {
        if (this._ctrlList.getSelectedValue() == null) {
            JOptionPane.showMessageDialog(this.getOwner(), ResMsgArbor.getString("SELECTION_PATH_ERROR"), ResMsgVoc.getString("VOC_ERROR"), 0);
            return false;
        }
        return true;
    }

    public List<List<FTVariableAbstract>> getSelectPath() {
        return this._ctrlList.getSelectedValuesList();
    }

    public void setSelectedParent(FTVariableAbstract ftVar) {
        boolean selected = false;
        for (int i = 0; i < this._ctrlList.getModel().getSize(); ++i) {
            List paths = (List)this._ctrlList.getModel().getElementAt(i);
            if (!((FTVariableAbstract)paths.get(paths.size() - 1)).getName().equals(ftVar.getName())) continue;
            this._ctrlList.setSelectedIndex(i);
            selected = true;
            break;
        }
        if (selected) {
            this._ctrlOK.requestFocus();
        }
    }
}

