/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.faulttree.obj;

import com.dassault.cecilia.dbobj.faulttree.ResMsgArbor;
import com.dassault.cecilia.dbobj.faulttree.obj.FTDefinition;
import com.dassault.cecilia.dbobj.faulttree.obj.FTEquationAbstract;
import com.dassault.cecilia.dbobj.faulttree.obj.FTEvent;
import com.dassault.cecilia.dbobj.faulttree.obj.FTLink;
import com.dassault.cecilia.dbobj.general.law.Law;
import com.dassault.cecilia.lib.util.CopyUtility;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public abstract class FTVariableAbstract {
    private static Logger _LOG = Logger.getLogger(FTVariableAbstract.class.getPackage().getName());
    protected int _flags = 0;
    protected boolean _bSelected = false;
    protected boolean _bRoot = false;
    protected boolean _bLeaf = false;
    protected double _probability = Double.NaN;
    static final Pattern _SIMPLE_ID = Pattern.compile("[A-Za-z][A-Za-z0-9_\\-\\^\\.]*");
    private static Comparator<? super FTVariableAbstract> __COMPARATOR_NAME = new Comparator<FTVariableAbstract>(){

        @Override
        public int compare(FTVariableAbstract o1, FTVariableAbstract o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };
    private static final List<FTEquationAbstract> EMPTY_ORIGINS = new ArrayList<FTEquationAbstract>(0);

    protected FTVariableAbstract() {
    }

    public int getFlags() {
        return this._flags;
    }

    public FTVariableAbstract setFlags(int value) {
        this._flags = value;
        return this;
    }

    public boolean isSelected() {
        return this._bSelected;
    }

    public FTVariableAbstract setSelected(boolean value) {
        this._bSelected = value;
        return this;
    }

    public double getProbability() {
        return this._probability;
    }

    public FTVariableAbstract setProbability(double value) {
        this._probability = value;
        return this;
    }

    public boolean isRoot() {
        return this._bRoot;
    }

    public FTVariableAbstract setRoot(boolean value) {
        this._bRoot = value;
        return this;
    }

    public boolean isLeaf() {
        return this._bLeaf;
    }

    FTVariableAbstract setLeaf(boolean value) {
        this._bLeaf = value;
        return this;
    }

    public abstract FTVariableAbstract getCopy(CopyUtility var1);

    protected void copy(FTVariableAbstract src, CopyUtility util) {
        this._bLeaf = src._bLeaf;
        this._bRoot = src._bRoot;
        this._bSelected = src._bSelected;
        this._flags = src._flags;
        this._probability = src._probability;
    }

    public String toString() {
        return this.getExportName();
    }

    public String printDefine() {
        StringBuilder out = new StringBuilder(128);
        if (this.getLink() != null) {
            out.append(" >: ");
            out.append(this.getLink().getSubTree().getRefPath());
        } else if (this.getDefinition() != null) {
            try {
                this.getDefinition().writeEqu(out);
            }
            catch (IOException ioe) {
                _LOG.log(Level.INFO, "Impossible !", ioe);
            }
        } else if (this.getEvent() != null) {
            Law law = this.getEvent().getLaw();
            if (law != null) {
                out.append(" {law ").append(law.toString()).append("}");
            } else {
                out.append(" {law ???}");
            }
        } else if (this.isLeaf()) {
            out.append(" [leaf]");
        } else if (this.isRoot()) {
            out.append(" [root]");
        } else {
            out.append(" [gate]");
        }
        return out.toString();
    }

    public boolean isIntern() {
        return false;
    }

    public boolean isLocked() {
        return false;
    }

    public abstract String getName();

    public abstract String getLabel();

    public boolean isGeneric() {
        return false;
    }

    public abstract FTEvent getEvent();

    public abstract FTLink getLink();

    public abstract FTDefinition.Type getType();

    public long getInternalID() {
        return -1L;
    }

    public abstract FTDefinition getDefinition();

    public FTVariableAbstract setDefinition(FTDefinition value) {
        throw new UnsupportedOperationException();
    }

    public String getExportName() {
        String name = this.getName();
        if (_SIMPLE_ID.matcher(name).matches()) {
            return name;
        }
        return new StringBuilder(name.length() + 2).append("'").append(name).append("'").toString();
    }

    public void writeEqu(Appendable out) throws IOException {
        if (this.getType() != FTDefinition.Type.VAR) {
            out.append(this.getExportName()).append(" := ");
            this.getDefinition().writeEqu(out);
            out.append(";\n");
            return;
        }
        if (this.isRoot() && this.getDefinition() == null) {
            out.append(this.getExportName()).append(" := 1;\n");
            return;
        }
        if (this.getLink() != null) {
            out.append(this.getExportName()).append(" := 1;\n");
            return;
        }
        this.writeHouseEvent(out);
    }

    public void writeHouseEvent(Appendable out) throws IOException {
        FTEvent ftEvent = this.getEvent();
        if (ftEvent != null) {
            switch (ftEvent.getState()) {
                case TRUE: {
                    out.append(this.getExportName()).append(" := 1;\n");
                    break;
                }
                case FALSE: {
                    out.append(this.getExportName()).append(" := 0;\n");
                    break;
                }
            }
        }
    }

    public static Comparator<? super FTVariableAbstract> getComparatorName() {
        return __COMPARATOR_NAME;
    }

    public boolean isEquivalentTo(FTVariableAbstract other, StringBuilder out) {
        String otherLabel;
        String thisLabel;
        if (other == null) {
            out.append(ResMsgArbor.msgFormat("_MSG_EQUI_VAR_NULL", "<var>", "<null>"));
            return false;
        }
        if (other == this) {
            return true;
        }
        if (this.getLink() != null) {
            if (other.getLink() == null) {
                out.append(ResMsgArbor.msgFormat("_MSG_EQUI_TYPE", this.printDefine(), other.printDefine()));
                return false;
            }
            if (!this.getLink().isEquivalentTo(other.getLink(), out)) {
                return false;
            }
        } else {
            if (other.getLink() != null) {
                out.append(ResMsgArbor.msgFormat("_MSG_EQUI_TYPE", this.printDefine(), other.printDefine()));
                return false;
            }
            if (this.getDefinition() != null) {
                if (other.getDefinition() == null) {
                    out.append(ResMsgArbor.msgFormat("_MSG_EQUI_TYPE", this.printDefine(), other.printDefine()));
                    return false;
                }
                if (!this.getDefinition().isEquivalentTo(other.getDefinition(), out)) {
                    return false;
                }
            } else {
                if (other.getDefinition() != null) {
                    out.append(ResMsgArbor.msgFormat("_MSG_EQUI_TYPE", this.printDefine(), other.printDefine()));
                    return false;
                }
                if (this.getEvent() != null) {
                    if (!this.getEvent().isEquivalentTo(other.getEvent(), out)) {
                        return false;
                    }
                } else if (other.getEvent() != null) {
                    out.append(ResMsgArbor.msgFormat("_MSG_EQUI_EVENT_NULL", "<null>", "<event>"));
                    return false;
                }
            }
        }
        if ((thisLabel = this.getLabel()) == null) {
            thisLabel = "";
        }
        if ((otherLabel = other.getLabel()) == null) {
            otherLabel = "";
        }
        if (!thisLabel.equals(otherLabel)) {
            out.append(ResMsgArbor.msgFormat("_MSG_EQUI_LABEL", thisLabel, otherLabel));
            return false;
        }
        return true;
    }

    public List<FTEquationAbstract> getOrigins() {
        return EMPTY_ORIGINS;
    }

    public String toStringOrigins(FTEquationAbstract defaultEquation) {
        List<FTEquationAbstract> origins = this.getOrigins();
        if (origins.size() == 0) {
            return defaultEquation.getRefPath();
        }
        StringBuilder sb = new StringBuilder(origins.size() * 64);
        for (int i = 0; i < origins.size(); ++i) {
            if (i > 0) {
                sb.append(" <: ");
            }
            sb.append(origins.get(i).getRefPath());
        }
        return sb.toString();
    }

    public boolean findDescendant(FTVariableAbstract finder) {
        if (this.getFlags() != 0) {
            return false;
        }
        this.setFlags(1);
        if (this.getName().equals(finder.getName())) {
            return true;
        }
        FTDefinition ftDef = this.getDefinition();
        if (ftDef != null) {
            for (FTVariableAbstract ftArg : ftDef.getArgs()) {
                if (!ftArg.findDescendant(finder)) continue;
                return true;
            }
        }
        return false;
    }

    public void resetFlagDescendant(int value, boolean withExternal) {
        if (this.getFlags() == value) {
            return;
        }
        this.setFlags(value);
        if (!withExternal && this.getLink() != null) {
            return;
        }
        FTDefinition ftDef = this.getDefinition();
        if (ftDef != null) {
            for (FTVariableAbstract ftArg : ftDef.getArgs()) {
                ftArg.resetFlagDescendant(value, withExternal);
            }
        }
    }

    public boolean isEventTerminal() {
        if (this.getEvent() == null) {
            return false;
        }
        if (this.getLink() != null) {
            return false;
        }
        return !this.isRoot();
    }

    public boolean isEventIntermediate() {
        return !this.isRoot() && this.getEvent() == null;
    }

    public boolean isEventInspected() {
        return this.getEvent() != null && this.getEvent().isInspected();
    }

    public boolean isEventInflightTested() {
        return this.getEvent() != null && this.getEvent().isInflightTested();
    }

    public boolean isEventSubTree() {
        return this.getLink() != null;
    }

    public boolean isEventSubTreeDSF() {
        return this.getLink() != null && this.getLink().isDSF();
    }

    public boolean isEventSubTreeTree() {
        return this.getLink() != null && !this.getLink().isDSF();
    }

    public boolean isEventGSR() {
        return this.isRoot() || this.getDefinition() != null && this.getDefinition().isGSR();
    }

    public abstract String getAbstract();
}

