/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.folder;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.CAppl;
import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.core.cecilia.error.MsgType;
import com.dassault.cecilia.db.DBFactory;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBObjModel;
import com.dassault.cecilia.db.DBObject;
import com.dassault.cecilia.db.dao.DAOObject;
import com.dassault.cecilia.dbobj.ResMsgObj;
import com.dassault.cecilia.dbobj.folder.DBFolderCmdWithError;
import com.dassault.cecilia.dbobj.folder.DBFolderTreeEditable;
import com.dassault.cecilia.lib.util.io.FileUtility;
import java.awt.Component;
import java.awt.HeadlessException;
import java.awt.Image;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import javax.swing.JDialog;
import javax.swing.JFileChooser;

public class AssociatedFileCmdAdd
extends DBFolderCmdWithError {
    private static Logger _LOG = Logger.getLogger(AssociatedFileCmdAdd.class.getPackage().getName());
    protected CAppl _application;
    protected DBFolderTreeEditable _ctrlTree;
    protected DBFolder _dbFolder;
    static JFileChooser _dlgChoose = null;
    File[] _selectedFiles;

    public AssociatedFileCmdAdd(CAppl appl, DBFolderTreeEditable ctrlTree) {
        super(appl, ctrlTree);
        this._application = appl;
        this._ctrlTree = ctrlTree;
    }

    public AssociatedFileCmdAdd setDBFolder(DBFolder dbFolder) {
        this._dbFolder = dbFolder;
        return this;
    }

    private static synchronized JFileChooser getFileChooser(final CAppl appl) {
        if (_dlgChoose == null) {
            _dlgChoose = new JFileChooser(){

                @Override
                protected JDialog createDialog(Component parent) throws HeadlessException {
                    JDialog result = super.createDialog(parent);
                    List<? extends Image> icons = appl.getIcons();
                    if (icons != null) {
                        result.setIconImages(icons);
                    }
                    return result;
                }
            };
            _dlgChoose.setMultiSelectionEnabled(true);
            _dlgChoose.setFileSelectionMode(0);
        }
        return _dlgChoose;
    }

    @Override
    protected boolean prepareDo() {
        if (!this._dbFolder.isVersion()) {
            return false;
        }
        if (this._dbFolder.getObject() == null) {
            return false;
        }
        if (this._dbFolder.isEdited()) {
            this.addError(this._dbFolder, ResMsgObj.msgFormat("MSG_OBJ_ERR_ISEDITED", ResMsgVoc.getString("VOC_THE_MODEL")));
        } else if (this._dbFolder.isLocked()) {
            this.addError(this._dbFolder, ResMsgObj.msgFormat("MSG_OBJ_ERR_ISLOCKED", ResMsgVoc.getString("VOC_THE_MODEL")));
        } else if (this._dbFolder.isFreeze()) {
            this.addError(this._dbFolder, ResMsgObj.msgFormat("MSG_OBJ_ERR_ISFREEZE", ResMsgVoc.getString("VOC_THE_MODEL")));
        } else if (this._dbFolder.isReadOnly()) {
            this.addError(this._dbFolder, ResMsgObj.msgFormat("MSG_OBJ_ERR_ACCESS_WRITE", ResMsgVoc.getString("VOC_THE_MODEL")));
        }
        if (this.withWarnning()) {
            this.displayErrors(this.getErrors());
            return false;
        }
        JFileChooser dlgChoose = AssociatedFileCmdAdd.getFileChooser(this.getAppl());
        if (dlgChoose.showOpenDialog(this.getSource()) != 0) {
            return false;
        }
        this._selectedFiles = dlgChoose.getSelectedFiles();
        DBObject dbObject = this._dbFolder.getObject();
        for (File file : this._selectedFiles) {
            String fileName = "associated.file" + "." + file.getName();
            if (DBFactory.verifyName(fileName) != 0) {
                this.addError(this._dbFolder, MsgType.WARNING, ResMsgObj.msgFormat("MSG_FILE_ASSOCIATED_ERROR_NAME", fileName));
                continue;
            }
            if (dbObject.getModel(fileName) == null) continue;
            this.addError(this._dbFolder, MsgType.WARNING, ResMsgObj.msgFormat("MSG_FILE_ASSOCIATED_FILE_EXIST", file.getName()));
        }
        if (this.withWarnning()) {
            this.displayErrors(this.getErrors());
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void firstDo() {
        block9: {
            DBObject dbObject;
            DAOObject daoObject = this.getAppl().getDAOFactory().createObjectDAO();
            if (daoObject.isFreeze(dbObject = this._dbFolder.getObject())) {
                this.addError(this._dbFolder, ResMsgObj.msgFormat("MSG_OBJ_ERR_ISFREEZE", ResMsgVoc.getString("VOC_THE_MODEL")));
            } else if (daoObject.lock(dbObject, this.getAppl().getDBSession())) {
                try {
                    if (this.insertFiles(dbObject, this._selectedFiles) > 0 && this.getAppl().getDAOFactory().createFolderDAO().update(this._dbFolder)) {
                        this._dbFolder.setMustBeUpdated(true);
                        this.getAppl().refreshDAOFolder();
                    }
                    if (daoObject.unlock(dbObject, this.getAppl().getDBSession())) break block9;
                }
                catch (Throwable throwable) {
                    if (!daoObject.unlock(dbObject, this.getAppl().getDBSession())) {
                        this.addError(this._dbFolder, ResMsgObj.msgFormat("MSG_OBJ_ERR_UNLOCK", ResMsgVoc.getString("VOC_THE_MODEL")));
                    }
                    throw throwable;
                }
                this.addError(this._dbFolder, ResMsgObj.msgFormat("MSG_OBJ_ERR_UNLOCK", ResMsgVoc.getString("VOC_THE_MODEL")));
            } else {
                this.addError(this._dbFolder, ResMsgObj.msgFormat("MSG_OBJ_ERR_LOCK", ResMsgVoc.getString("VOC_THE_MODEL")));
            }
        }
        if (this.withWarnning()) {
            this.displayErrors(this.getErrors());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int insertFiles(DBObject dbObject, File[] selectedFiles) {
        int nbrInsert = 0;
        for (File file : selectedFiles) {
            String fileName = "associated.file" + "." + file.getName();
            DBObjModel dbObjModel = dbObject.getModel(fileName);
            if (dbObjModel != null) {
                this.addError(this._dbFolder, MsgType.WARNING, ResMsgObj.msgFormat("MSG_FILE_ASSOCIATED_FILE_EXIST", file.getName()));
                continue;
            }
            FileInputStream inputStream = null;
            try {
                inputStream = new FileInputStream(file);
                dbObjModel = new DBObjModel();
                dbObjModel.setFormat("ZIP");
                dbObjModel.setNature(fileName);
                ByteArrayOutputStream oStream = new ByteArrayOutputStream((int)(file.length() / 3L));
                DeflaterOutputStream compressOutputStream = new DeflaterOutputStream((OutputStream)oStream, new Deflater(9));
                FileUtility.copyStream((InputStream)inputStream, (OutputStream)compressOutputStream);
                compressOutputStream.close();
                byte[] buffer = oStream.toByteArray();
                dbObjModel.setSize(buffer.length);
                dbObjModel.setStreamToSave(new ByteArrayInputStream(buffer));
                dbObject.addModel(dbObjModel);
                ++nbrInsert;
            }
            catch (Exception e) {
                this.addError(this._dbFolder, MsgType.WARNING, ResMsgObj.msgFormat("MSG_FILE_ASSOCIATED_EXCEPTION", file.getName()));
                _LOG.log(Level.FINE, "Probl\u00e8me lors de l'ajout pour le dossier '" + this._dbFolder.getRefPath() + "' du fichier associ\u00e9 : " + file.getAbsolutePath(), e);
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        _LOG.fine("IOException lors de la fermeture du fichier associ\u00e9:" + file.getName());
                    }
                }
            }
        }
        return nbrInsert;
    }

    @Override
    protected String getTitle() {
        return ResMsgCore.getString("MENU_ADD_FILE");
    }
}

