/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.folder;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.CAppl;
import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.core.cecilia.folder.DBFolderTree;
import com.dassault.cecilia.core.cecilia.folder.DBFolderTreeNode;
import com.dassault.cecilia.core.cecilia.folder.DBFolderTreeNodeFile;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.db.DBAccess;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBObjModel;
import com.dassault.cecilia.db.DBRelation;
import com.dassault.cecilia.db.DBSession;
import com.dassault.cecilia.db.DBUser;
import com.dassault.cecilia.db.dao.DAOFolder;
import com.dassault.cecilia.dbobj.ResMsgObj;
import com.dassault.cecilia.dbobj.folder.DBFolderCmdWithError;
import java.awt.Component;
import java.awt.EventQueue;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.JOptionPane;

public class DBFolderCmdDelete
extends DBFolderCmdWithError {
    private static Logger _LOG = Logger.getLogger(DBFolderCmdDelete.class.getPackage().getName());
    Component _ctrlOwner;
    DBUser _dbUser;
    ArrayList<DBFolderTreeNode> _listTreeNodeFileSelected;
    ArrayList<DBFolder> _listFolderSelected;
    ArrayList<DBFolder> _listFolderOptionnal;
    HashMap<DBFolder, List<DBFolder>> _collectionVersions;
    ArrayList<DBFolder> _collectionNotVersions;
    Set<DBFolder> _setFolderDeleted;
    Set<DBFolder> _setFolderTreated;
    HashMap<DBFolder, Cpt> _parentFolders;

    private void addParentCounter(DBFolder dbParent) {
        Cpt cpt = this._parentFolders.get(dbParent);
        if (cpt == null) {
            cpt = new Cpt();
            this._parentFolders.put(dbParent, cpt);
        }
        ++cpt._cpt;
    }

    private int getParentCounter(DBFolder dbParent) {
        Cpt cpt = this._parentFolders.get(dbParent);
        if (cpt == null) {
            return 0;
        }
        return cpt._cpt;
    }

    @Override
    protected String getTitle() {
        return ResMsgVoc.getString("VOC_INFORMATIONS") + " - " + ResMsgVoc.getString("VOC_DELETE");
    }

    public DBFolderCmdDelete(CAppl appl, DBFolderTree owner, ArrayList<DBFolderTreeNode> selFolders, DBUser user) {
        super(appl, owner);
        this._ctrlOwner = owner;
        this._dbUser = user;
        this._listFolderSelected = new ArrayList();
        Iterator<DBFolderTreeNode> iter = selFolders.iterator();
        while (iter.hasNext()) {
            DBFolderTreeNode node = iter.next();
            if (node instanceof DBFolderTreeNodeFile) continue;
            this._listFolderSelected.add(node.getSource());
            iter.remove();
        }
        this._listTreeNodeFileSelected = selFolders;
        this._setFolderDeleted = new HashSet<DBFolder>();
        this._setFolderTreated = new HashSet<DBFolder>();
        this._listFolderOptionnal = new ArrayList();
        this._collectionVersions = new HashMap();
        this._collectionNotVersions = new ArrayList();
        this._parentFolders = new HashMap();
    }

    @Override
    protected boolean prepareDo() {
        if (this._listFolderSelected.isEmpty() && this._listTreeNodeFileSelected.isEmpty()) {
            return false;
        }
        String first = null;
        int nbr = 0;
        StringBuilder sb = new StringBuilder();
        sb.append("<ul>");
        for (DBFolder dbFolder : this._listFolderSelected) {
            if (first == null) {
                first = dbFolder.getRefPath();
            }
            if (++nbr >= 10) continue;
            sb.append("<li>").append(dbFolder.getRefPath()).append("</li>");
        }
        for (DBFolderTreeNode trFolder : this._listTreeNodeFileSelected) {
            if (!(trFolder instanceof DBFolderTreeNodeFile)) continue;
            DBFolder dbFolder = trFolder.getDBFolder();
            if (first == null) {
                first = dbFolder.getRefPath() + "#" + trFolder.getName();
            }
            if (++nbr >= 10) continue;
            sb.append("<li>").append(dbFolder.getRefPath()).append("#").append(trFolder.getName()).append("</li>");
        }
        if (nbr >= 10) {
            sb.append("<li><b>...</b></li>");
        }
        sb.append("</ul>");
        if (nbr == 0) {
            return false;
        }
        if (nbr == 1) {
            int result = JOptionPane.showConfirmDialog(JOptionCecilia.getTopContainerOf(this.getSource()), ResMsgObj.msgFormat("MSG_FOL_DELETE_CONFIRM_ONE", first), ResMsgCore.getString("TITLE_ASK_CONFIRM"), 0, 3);
            return result == 0;
        }
        int result = JOptionPane.showConfirmDialog(JOptionCecilia.getTopContainerOf(this.getSource()), ResMsgObj.msgFormat("MSG_FOL_DELETE_CONFIRM_MORE", sb.toString()), ResMsgCore.getString("TITLE_ASK_CONFIRM"), 0, 3);
        return result == 0;
    }

    @Override
    protected void firstDo() {
        int i;
        DAOFolder daoFolder = this.getAppl().getDAOFactory().createFolderDAO();
        int nbrDeleteFile = 0;
        for (i = this._listTreeNodeFileSelected.size() - 1; i >= 0; --i) {
            DBFolderTreeNodeFile nodeFile = (DBFolderTreeNodeFile)this._listTreeNodeFileSelected.get(i);
            nbrDeleteFile += this.doDeleteObjModel(nodeFile, daoFolder);
        }
        for (i = this._listFolderSelected.size() - 1; i >= 0; --i) {
            DBFolder dbParent;
            DBFolder dbFolder = this._listFolderSelected.get(i);
            if (!dbFolder.isVersion() || (dbParent = dbFolder.getParent()).isSystem() || this._listFolderSelected.contains(dbParent)) continue;
            this._listFolderOptionnal.add(dbParent);
        }
        this.doPrepareDelete_rec(this._listFolderSelected, daoFolder);
        this.doDeleteVersions(daoFolder);
        this.doDeleteFolders(this._collectionNotVersions, false, daoFolder);
        this.doDeleteFolders(this._listFolderOptionnal, true, daoFolder);
        if (!this._setFolderDeleted.isEmpty() || nbrDeleteFile > 0) {
            this.getAppl().refreshDAOFolder(true);
            final List<DBFolder> selectAtEnd = this.defineSelectAtEnd();
            if (!selectAtEnd.isEmpty()) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ((DBFolderTree)DBFolderCmdDelete.this.getSource()).doSelect(selectAtEnd);
                    }
                });
            }
        }
        if (this.withWarnning()) {
            this.displayErrors(this.getErrors());
        }
    }

    private List<DBFolder> defineSelectAtEnd() {
        DBFolder dbFolder;
        int i;
        ArrayList<DBFolder> result = new ArrayList<DBFolder>();
        for (i = this._listTreeNodeFileSelected.size() - 1; i >= 0; --i) {
            dbFolder = this._listTreeNodeFileSelected.get(i).getSource();
            if (this._setFolderDeleted.contains(dbFolder) || result.contains(dbFolder)) continue;
            result.add(dbFolder);
        }
        for (i = this._listFolderSelected.size() - 1; i >= 0; --i) {
            for (dbFolder = this._listFolderSelected.get(i); dbFolder != null && this._setFolderDeleted.contains(dbFolder); dbFolder = dbFolder.getParent()) {
            }
            if (dbFolder == null || dbFolder.isSystem() || result.contains(dbFolder)) continue;
            result.add(dbFolder);
        }
        return result;
    }

    private int doPrepareDelete_rec(List<DBFolder> folders, DAOFolder daoFolder) {
        String title = ResMsgVoc.getString("VOC_THE_MODEL");
        int nbrDelete = 0;
        for (int i = 0; i < folders.size(); ++i) {
            boolean error;
            DBFolder dbFolder;
            block7: {
                block12: {
                    block8: {
                        block11: {
                            block10: {
                                block9: {
                                    block6: {
                                        dbFolder = folders.get(i);
                                        error = true;
                                        if (daoFolder.getAccessRight(dbFolder, this._dbUser) == DBAccess.Right.WRITE) break block6;
                                        this.addError(dbFolder, ResMsgObj.getString("MSG_FOL_ERR_ACCESS"));
                                        break block7;
                                    }
                                    if (!dbFolder.isVersion()) break block8;
                                    if (!dbFolder.isFreeze()) break block9;
                                    this.addError(dbFolder, ResMsgObj.msgFormat("MSG_OBJ_ERR_ISFREEZE", title));
                                    break block7;
                                }
                                if (!dbFolder.isEdited()) break block10;
                                this.addError(dbFolder, ResMsgObj.msgFormat("MSG_OBJ_ERR_ISEDITED", title));
                                break block7;
                            }
                            if (!dbFolder.isLocked()) break block11;
                            DBSession dbSession = null;
                            if (dbFolder.getObject() != null) {
                                dbSession = dbFolder.getObject().getLockedSession();
                            }
                            this.addError(dbFolder, ResMsgObj.msgFormat("MSG_OBJ_ERR_ISLOCKED", title, dbSession != null ? dbSession.getUser().getLogin() : "???", dbSession == null || dbSession.isActive() ? "" : " ~"));
                            break block7;
                        }
                        if (this.getAppl().getDAOFactory().createRelationDAO().withSourceRelations(dbFolder)) {
                            Collection<DBRelation> dbRelations = this.getAppl().getDAOFactory().createRelationDAO().getSourceRelations(dbFolder);
                            ArrayList<DBFolder> dbSources = new ArrayList<DBFolder>(dbRelations.size());
                            for (DBRelation dbRelation : dbRelations) {
                                dbSources.add(dbRelation.getSource());
                            }
                            this._collectionVersions.put(dbFolder, dbSources);
                        } else {
                            this._collectionVersions.put(dbFolder, new ArrayList());
                        }
                        break block12;
                    }
                    this._collectionNotVersions.add(dbFolder);
                }
                error = false;
            }
            if (error) continue;
            List<DBFolder> children = dbFolder.getChildren();
            if (children == null) {
                children = daoFolder.findChildren(dbFolder);
            }
            if (children.size() == 0) continue;
            this.doPrepareDelete_rec(children, daoFolder);
        }
        return nbrDelete;
    }

    private int doDeleteVersions(DAOFolder daoFolder) {
        int nbrDelete = 0;
        while (!this._collectionVersions.isEmpty()) {
            HashSet<DBFolder> currentFolders = new HashSet<DBFolder>();
            Iterator<Object> iter = this._collectionVersions.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<DBFolder, List<DBFolder>> entry = iter.next();
                if (!entry.getValue().isEmpty()) continue;
                iter.remove();
                currentFolders.add(entry.getKey());
                nbrDelete += this.doDelete(entry.getKey(), false, daoFolder);
            }
            if (currentFolders.isEmpty()) break;
            for (List list : this._collectionVersions.values()) {
                Iterator iter2 = list.iterator();
                while (iter2.hasNext()) {
                    DBFolder candidate = (DBFolder)iter2.next();
                    if (!currentFolders.contains(candidate)) continue;
                    iter2.remove();
                }
            }
        }
        for (DBFolder dbFolder : this._collectionVersions.keySet()) {
            this.addError(dbFolder, ResMsgObj.getString("MSG_FOL_ERR_ISUSED"));
        }
        return nbrDelete;
    }

    private int doDeleteFolders(ArrayList<DBFolder> dbFolders, boolean optionnal, DAOFolder daoFolder) {
        int nbrDelete = 0;
        for (int i = dbFolders.size() - 1; i >= 0; --i) {
            DBFolder dbFolder = dbFolders.get(i);
            nbrDelete += this.doDelete(dbFolder, optionnal, daoFolder);
        }
        return nbrDelete;
    }

    private int doDelete(DBFolder dbFolder, boolean optionnal, DAOFolder daoFolder) {
        String title = ResMsgVoc.getString("VOC_THE_MODEL");
        _LOG.finest("Delete folder - State1: " + dbFolder.getRefPath());
        if (this._setFolderTreated.contains(dbFolder)) {
            return 0;
        }
        _LOG.finest("Delete folder - State2: " + dbFolder.getRefPath());
        this._setFolderTreated.add(dbFolder);
        List<DBFolder> children = dbFolder.getChildren();
        if (children == null) {
            children = daoFolder.findChildren(dbFolder);
        }
        if (children.size() != 0 && this.getParentCounter(dbFolder) < children.size()) {
            if (!optionnal) {
                this.addError(dbFolder, ResMsgObj.getString("MSG_FOL_ERR_NOTEMPTY"));
            }
            return 0;
        }
        _LOG.finest("Delete folder - State3: " + dbFolder.getRefPath());
        if (dbFolder.isFreeze()) {
            this.addError(dbFolder, ResMsgObj.msgFormat("MSG_OBJ_ERR_ISFREEZE", title));
            return 0;
        }
        if (dbFolder.isEdited()) {
            this.addError(dbFolder, ResMsgObj.msgFormat("MSG_OBJ_ERR_ISEDITED", title));
            return 0;
        }
        if (dbFolder.isLocked()) {
            DBSession dbSession = null;
            if (dbFolder.getObject() != null) {
                dbSession = dbFolder.getObject().getLockedSession();
            }
            this.addError(dbFolder, ResMsgObj.msgFormat("MSG_OBJ_ERR_ISLOCKED", title, dbSession != null ? dbSession.getUser().getLogin() : "???", dbSession == null || dbSession.isActive() ? "" : " ~"));
            return 0;
        }
        if (daoFolder.getAccessRight(dbFolder, this._dbUser) != DBAccess.Right.WRITE) {
            this.addError(dbFolder, ResMsgObj.getString("MSG_FOL_ERR_ACCESS"));
            return 0;
        }
        if (this.getAppl().getDAOFactory().createRelationDAO().withSourceRelations(dbFolder)) {
            this.addError(dbFolder, ResMsgObj.getString("MSG_FOL_ERR_ISUSED"));
            return 0;
        }
        if (!daoFolder.delete(dbFolder)) {
            this.addError(dbFolder, ResMsgObj.getString("MSG_FOL_ERR_DELETE"));
            return 0;
        }
        _LOG.finest("Delete folder - State4: " + dbFolder.getRefPath());
        this.addParentCounter(dbFolder.getParent());
        this._setFolderDeleted.add(dbFolder);
        return 1;
    }

    private int doDeleteObjModel(DBFolderTreeNodeFile trNodeFile, DAOFolder daoFolder) {
        String title = ResMsgVoc.getString("VOC_THE_MODEL");
        DBObjModel dbObjModel = trNodeFile.getObjModel();
        DBFolder dbFolder = trNodeFile.getDBFolder();
        _LOG.finest("Delete ObjModel - State1: " + dbFolder.getRefPath() + ", " + dbObjModel.getNature());
        if (dbFolder.isFreeze()) {
            this.addError(dbFolder, ResMsgObj.msgFormat("MSG_OBJ_ERR_ISFREEZE", title));
            return 0;
        }
        if (dbFolder.isEdited()) {
            this.addError(dbFolder, ResMsgObj.msgFormat("MSG_OBJ_ERR_ISEDITED", title));
            return 0;
        }
        if (dbFolder.isLocked()) {
            DBSession dbSession = null;
            if (dbFolder.getObject() != null) {
                dbSession = dbFolder.getObject().getLockedSession();
            }
            this.addError(dbFolder, ResMsgObj.msgFormat("MSG_OBJ_ERR_ISLOCKED", title, dbSession != null ? dbSession.getUser().getLogin() : "???", dbSession == null || dbSession.isActive() ? "" : " ~"));
            return 0;
        }
        if (daoFolder.getAccessRight(dbFolder, this._dbUser) != DBAccess.Right.WRITE) {
            this.addError(dbFolder, ResMsgObj.getString("MSG_FOL_ERR_ACCESS"));
            return 0;
        }
        if (!this.getAppl().getDAOFactory().createObjModelDAO().delete(dbObjModel)) {
            this.addError(dbFolder, ResMsgObj.msgFormat("MSG_OBJMOD_ERR_DELETE", dbObjModel.getNature()));
            return 0;
        }
        File file = trNodeFile.getFile(this.getAppl().getTmpDirectory());
        if (file.exists()) {
            file.delete();
        }
        _LOG.finest("Delete ObjModel - State2: " + dbFolder.getRefPath() + ", " + dbObjModel.getNature());
        return 1;
    }

    static class Cpt {
        int _cpt = 0;

        Cpt() {
        }
    }
}

