/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.folder;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.CAppl;
import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.core.cecilia.action.CCmd;
import com.dassault.cecilia.core.cecilia.dependencies.Generate;
import com.dassault.cecilia.core.cecilia.error.GeneralError;
import com.dassault.cecilia.core.cecilia.folder.gui.DBFolderDlgDisplayError;
import com.dassault.cecilia.core.cecilia.folder.gui.FoldersConfirmDlg;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.db.DBAccess;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBRelation;
import com.dassault.cecilia.db.DBSession;
import com.dassault.cecilia.db.DBUser;
import com.dassault.cecilia.db.dao.DAOFactory;
import com.dassault.cecilia.db.dao.DAOFolder;
import com.dassault.cecilia.db.dao.DAOObject;
import com.dassault.cecilia.dbobj.ResMsgObj;
import com.dassault.cecilia.dbobj.folder.GenerateFreeze;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.general.log.DBLogsWrap;
import java.awt.Component;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class DBFolderCmdFreeze
extends CCmd {
    private static Logger _LOG = Logger.getLogger(DBFolderCmdFreeze.class.getPackage().getName());
    Component _ctrlOwner;
    DBUser _dbUser;
    List<DBFolder> _selFolders;
    boolean _freeze;
    boolean _onSelection = false;
    ArrayList<GeneralError<DBFolder>> _errors = new ArrayList();

    public boolean withWarnning() {
        return !this._errors.isEmpty();
    }

    protected void addError(DBFolder folder, String msg) {
        this._errors.add(new GeneralError<DBFolder>(folder, msg));
    }

    public List<GeneralError<DBFolder>> getErrors() {
        return this._errors;
    }

    private void displayErrors(List<GeneralError<DBFolder>> errors) {
        Window win = SwingUtilities.getWindowAncestor(this._ctrlOwner);
        DBFolderDlgDisplayError dlg = new DBFolderDlgDisplayError(win);
        dlg.setTitle(ResMsgVoc.getString("VOC_ERROR") + " - " + ResMsgVoc.getString("VOC_FREEZE"));
        dlg.setErrors(errors);
        dlg.setModal(true);
        dlg.setLocationRelativeTo(JOptionCecilia.getTopContainerOf(this._ctrlOwner));
        dlg.setVisible(true);
    }

    public DBFolderCmdFreeze(CAppl appl, Component owner, List<DBFolder> selFolders, DBUser user, boolean freeze) {
        super(appl, owner);
        this._ctrlOwner = owner;
        this._selFolders = selFolders;
        this._dbUser = user;
        this._freeze = freeze;
    }

    public void setOnSelection(boolean onSelection) {
        this._onSelection = onSelection;
    }

    protected void recupAllFolderObject(List<DBFolder> folders, Set<DBFolder> recups, Set<DBFolder> treats, DAOFolder daoFolder) {
        for (int i = 0; i < folders.size(); ++i) {
            DBFolder dbFolder = folders.get(i);
            if (treats.contains(dbFolder)) continue;
            treats.add(dbFolder);
            List<DBFolder> children = dbFolder.getChildren();
            if (children == null) {
                children = daoFolder.findChildren(dbFolder);
            }
            this.recupAllFolderObject(children, recups, treats, daoFolder);
            boolean isOk = this._freeze ^ dbFolder.isFreeze();
            if (dbFolder.getObject() == null || !isOk) continue;
            if (dbFolder.isLocked()) {
                DBSession dbSession = dbFolder.getObject().getLockedSession();
                this.addError(dbFolder, ResMsgObj.msgFormat("MSG_OBJ_ERR_ISLOCKED", dbFolder.getRefPath(), dbSession.getUser().getLogin(), dbSession.isActive() ? "" : " ~"));
                continue;
            }
            if (daoFolder.getAccessRight(dbFolder, this._dbUser) != DBAccess.Right.WRITE) {
                this.addError(dbFolder, ResMsgObj.msgFormat("MSG_OBJ_ERR_ACCESS_WRITE", dbFolder.getRefPath()));
                continue;
            }
            recups.add(dbFolder);
        }
    }

    @Override
    protected boolean prepareDo() {
        if (!this._dbUser.isAdmin()) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this.getAppl().getTopWindow()), ResMsgObj.getString("MSG_OBJ_ERR_ACCESS_ADMIN_REQUIRED"), this.getAppl().getTitle(), 0);
            return false;
        }
        return this._freeze || this.getAppl().getDBUser().isMasterAdmin();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void firstDo() {
        Set<DBFolder> folders = new LinkedHashSet<DBFolder>();
        Window win = SwingUtilities.getWindowAncestor(this._ctrlOwner);
        HashSet<DBFolder> treatsRecup = new HashSet<DBFolder>();
        this.recupAllFolderObject(this._selFolders, folders, treatsRecup, this.getAppl().getDAOFactory().createFolderDAO());
        if (this.withWarnning()) {
            _LOG.finest("CmdFreeze-Phase1: Il y a eu un probleme => affichage de(s) erreur(s)");
            this.displayErrors(this.getErrors());
            return;
        }
        if (folders.isEmpty()) {
            return;
        }
        GenerateFreeze generate = new GenerateFreeze(this.getAppl().getDAOFactory(), this._dbUser, this._freeze);
        generate.setDirection(this._freeze ? Generate.Direction.DOWN : Generate.Direction.UP);
        for (DBFolder dbFolder : folders) {
            generate.prepare(dbFolder, dbFolder, null);
        }
        if (generate.withError()) {
            _LOG.finest("CmdFreeze-Phase2: Il y a eu un probleme => affichage de(s) erreur(s)");
            this.displayErrors(generate.getErrors());
            return;
        }
        Set<DBFolder> foldersWithDependencies = generate.getDepends();
        if (!this._freeze && this._onSelection && foldersWithDependencies.size() > 1) {
            int res = JOptionPane.showConfirmDialog(win, ResMsgObj.getString("MSG_FOLDER_UNFREEZE_ASK_FOR_DEPENDENCIES"), ResMsgObj.getString("MSG_FOLDER_UNFREEZE_ASK_FOLDER"), 0, 2);
            if (res != 0) {
                return;
            }
        } else {
            folders = foldersWithDependencies;
        }
        DAOObject daoObject = this.getAppl().getDAOFactory().createObjectDAO();
        DBSession dbSession = this.getAppl().getDBSession();
        ArrayList<DBFolder> foldersLocked = new ArrayList<DBFolder>(folders.size());
        try {
            DBFolder dbFolderErrorLock = null;
            for (DBFolder dbFolder : folders) {
                if (daoObject.lock(dbFolder.getObject(), dbSession)) {
                    foldersLocked.add(dbFolder);
                    continue;
                }
                dbFolderErrorLock = dbFolder;
                break;
            }
            if (dbFolderErrorLock != null) {
                this.addError(dbFolderErrorLock, ResMsgCore.getString("MSG_FOL_DONT_LOCK"));
            } else {
                FreezeConfirmDlg dlg = new FreezeConfirmDlg(win, foldersLocked, this._freeze);
                dlg.setVisible(true);
                if (dlg.getResult()) {
                    DBFolder dbFolder;
                    int i;
                    boolean errorDuringFreeze = false;
                    ArrayList<DBFolder> foldersFreezed = new ArrayList<DBFolder>(folders.size());
                    for (i = 0; i < foldersLocked.size() && !errorDuringFreeze; ++i) {
                        dbFolder = (DBFolder)foldersLocked.get(i);
                        boolean isOk = this._freeze ^ daoObject.isFreeze(dbFolder.getObject());
                        if (!isOk) continue;
                        if (this._freeze) {
                            this.saveFreezeInLog(dbFolder);
                        }
                        if (daoObject.setFreeze(dbFolder.getObject(), this._freeze)) {
                            foldersFreezed.add(dbFolder);
                        } else {
                            this.addError(dbFolder, ResMsgCore.getString("MSG_FOL_DONT_FREEZE"));
                            errorDuringFreeze = true;
                        }
                        if (this._freeze) continue;
                        this.saveFreezeInLog(dbFolder);
                    }
                    if (errorDuringFreeze) {
                        for (i = 0; i < foldersFreezed.size(); ++i) {
                            dbFolder = (DBFolder)foldersFreezed.get(i);
                            if (!daoObject.setFreeze(dbFolder.getObject(), false)) continue;
                            this.addError(dbFolder, ResMsgCore.getString("MSG_FOL_DONT_UNFREEZE"));
                        }
                    }
                }
            }
        }
        finally {
            for (DBFolder dbFolder : foldersLocked) {
                if (daoObject.unlock(dbFolder.getObject(), dbSession)) continue;
                this.addError(dbFolder, ResMsgCore.getString("MSG_FOL_DONT_UNLOCK"));
            }
        }
        if (this.withWarnning()) {
            _LOG.finest("CmdFreeze-Phase3: Il y a eu un probleme => affichage de(s) erreur(s)");
            this.displayErrors(this.getErrors());
        }
        this.getAppl().refreshDAOFolder(true);
    }

    private void saveFreezeInLog(DBFolder dbFolder) {
        DBLogsWrap dbWrap = new DBLogsWrap(dbFolder){

            @Override
            protected Logger getJavaLog() {
                return _LOG;
            }

            @Override
            public Collection<DBRelation> getUseRelations() {
                return null;
            }
        };
        DAOFactory daoFactory = this.getAppl().getDAOFactory();
        if (dbWrap.readFromDAO(daoFactory)) {
            DBLogs dbLogs = dbWrap.getLogs();
            String mess = this._freeze ? ResMsgCore.getString("MSG_LOG_FREEZE") : ResMsgCore.getString("MSG_LOG_UNFREEZE");
            dbLogs.addLog(new Date(), daoFactory.getUserLogin(), DBLogs.DBLevel.INFO, mess);
            if (!dbWrap.writeToDAO(daoFactory, null)) {
                _LOG.warning("Error during save logs of " + dbFolder.getRefPath() + " (freeze operation)");
            }
        }
    }

    static class FreezeConfirmDlg
    extends FoldersConfirmDlg {
        int _nbr;
        String _txt;

        public FreezeConfirmDlg(Window win, Collection<DBFolder> folders, boolean forFreezing) {
            super(win, new ArrayList<DBFolder>(folders));
            this._nbr = folders.size();
            this._txt = ResMsgVoc.getString(forFreezing ? "VOC_FREEZE" : "VOC_UNFREEZE");
            this.refreshLabel();
        }

        @Override
        protected String getLabelTitle() {
            return ResMsgCore.getString("TITLE_ASK_CONFIRM");
        }

        @Override
        protected String getLabelHeader() {
            return ResMsgObj.msgFormat("MSG_FOL_FREEZE_CONFIRM_LIST", this._txt, this._nbr);
        }

        @Override
        protected String getLabelFooter() {
            return ResMsgObj.msgFormat("MSG_FOL_FREEZE_CONFIRM", this._txt);
        }
    }
}

