/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.folder;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.access.AccessRightEditDlg;
import com.dassault.cecilia.core.cecilia.folder.DBFolderResources;
import com.dassault.cecilia.core.cecilia.folder.FolderRenderer;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.core.swing.table.ArrayTableModel;
import com.dassault.cecilia.core.swing.table.JTableTransfertHandler;
import com.dassault.cecilia.db.DBFactory;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBGroup;
import com.dassault.cecilia.db.DBRelation;
import com.dassault.cecilia.db.DBSession;
import com.dassault.cecilia.db.DBUser;
import com.dassault.cecilia.db.dao.DAOFactory;
import com.dassault.cecilia.dbobj.ResMsgObj;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.TableModel;

public class DBFolderPropertiesPanel
extends JPanel {
    private static Logger _LOG = Logger.getLogger(DBFolderPropertiesPanel.class.getPackage().getName());
    private DateFormat _dateFormat = SimpleDateFormat.getDateTimeInstance();
    protected JLabel _ctrlLblQuestion;
    protected JTextField _ctrlPath = new JTextField(30);
    protected JTextField _ctrlName = new JTextField(30);
    protected JTextArea _ctrlComment = new JTextArea(5, 30);
    protected JComboBox _ctrlVersions;
    protected JButton _ctrlAccessRight;
    protected String _strPreviousName;
    protected String _title;
    protected DBFolder _dbFolder;
    boolean _bAdmin;
    DAOFactory _daoFactory;
    boolean _bVisiblePath = true;
    boolean _bReadOnly = false;
    boolean _bWithComment = true;
    boolean _bWithAccess = true;
    boolean _bAccessReadOnly = false;
    boolean _bWithDepends = false;
    boolean _bFamilyTarget = true;
    protected List<DBFolder> _refVersions = null;
    protected List<DBFolder> _curVersions = null;
    boolean _bEditProperties = false;
    boolean _bNameEditable = true;
    boolean _bMake = false;
    JLabel _lblCreate;
    JLabel _lblModif;
    JLabel _ctrlLblCreate;
    JLabel _ctrlLblModif;
    JCheckBox _cbxFreeze;
    JCheckBox _cbxLocked;
    ArrayList<DBFolder> _ctrlDependsList;
    ArrayTableModel<DBFolder> _ctrlDependsModel;
    JTable _ctrlDependsTable;

    public DBFolderPropertiesPanel() {
        super(new BorderLayout());
    }

    public void setDateFormat(DateFormat value) {
        this._dateFormat = value;
    }

    public DBFolderPropertiesPanel setQuestion(String question) {
        if (this._ctrlLblQuestion == null) {
            this._ctrlLblQuestion = new JLabel(question);
        } else {
            this._ctrlLblQuestion.setText(question);
        }
        return this;
    }

    public DBFolderPropertiesPanel setFolder(DBFolder dbFolder) {
        this._dbFolder = dbFolder;
        this._ctrlPath.setText(dbFolder.getParent().getPathUntilSystem(new StringBuilder()).toString());
        this._ctrlName.setText(dbFolder.getName());
        this._ctrlComment.setText(dbFolder.getDescription());
        this._strPreviousName = dbFolder.getName();
        return this;
    }

    public DBFolder getDBFolder() {
        return this._dbFolder;
    }

    public void setTitle(String title) {
        this._title = title;
    }

    public DBFolderPropertiesPanel setUserIsAdmin(boolean admin) {
        this._bAdmin = admin;
        return this;
    }

    public DBFolderPropertiesPanel setDAOFactory(DAOFactory daoFactory) {
        this._daoFactory = daoFactory;
        return this;
    }

    public DBFolderPropertiesPanel setVisiblePath(boolean value) {
        this._bVisiblePath = value;
        return this;
    }

    public boolean isReadOnly() {
        return this._bReadOnly;
    }

    public DBFolderPropertiesPanel setReadOnly(boolean value) {
        this._bReadOnly = value;
        return this;
    }

    public boolean isWithComment() {
        return this._bWithComment;
    }

    public DBFolderPropertiesPanel setWithComment(boolean value) {
        this._bWithComment = value;
        return this;
    }

    public boolean isWithAccess() {
        return this._bWithAccess;
    }

    public DBFolderPropertiesPanel setWithAccess(boolean value) {
        this._bWithAccess = value;
        return this;
    }

    public boolean isAccessReadOnly() {
        return this._bAccessReadOnly;
    }

    public DBFolderPropertiesPanel setAccessReadOnly(boolean value) {
        this._bAccessReadOnly = value;
        return this;
    }

    public boolean isWithDepends() {
        return this._bWithDepends;
    }

    public DBFolderPropertiesPanel setWithDepends(boolean value) {
        this._bWithDepends = value;
        return this;
    }

    public DBFolderPropertiesPanel setFamilyTarget(boolean value) {
        this._bFamilyTarget = value;
        return this;
    }

    public boolean isFamilyTarget() {
        return this._bFamilyTarget;
    }

    public DBFolderPropertiesPanel setVersionsReferencies(List<DBFolder> refVersions, List<DBFolder> curVersions) {
        this._refVersions = refVersions;
        this._curVersions = curVersions;
        if (this._refVersions.isEmpty()) {
            _LOG.warning("Dlg de creation/proprietes pour une version sans version de reference...");
        }
        return this;
    }

    public boolean isVersionTarget() {
        return this._refVersions != null && !this._refVersions.isEmpty();
    }

    public DBFolder getRefVersion() {
        return (DBFolder)this._ctrlVersions.getSelectedItem();
    }

    public DBFolderPropertiesPanel setEditProperties(boolean value) {
        this._bEditProperties = value;
        return this;
    }

    public boolean isEditProperties() {
        return this._bEditProperties;
    }

    public DBFolderPropertiesPanel setNameEditable(boolean value) {
        this._bNameEditable = value;
        return this;
    }

    public boolean isNameEditable() {
        return this._bNameEditable;
    }

    public void doCreate() {
        if (!this._bMake) {
            this._bMake = true;
            this.make();
            if (this._bEditProperties) {
                this.updateProperties();
            }
            if (this._bWithDepends) {
                this.updateDepends();
            }
        }
    }

    private void updateProperties() {
        StringBuilder sb = new StringBuilder(this._dateFormat.format(this._dbFolder.getDateCreate()));
        sb.append(" (").append(this._dbFolder.getUserOwner()).append(")");
        this._ctrlLblCreate.setText(sb.toString());
        sb = new StringBuilder(this._dateFormat.format(this._dbFolder.getDateModify()));
        sb.append(" (").append(this._dbFolder.getUserModify().getLogin()).append(")");
        this._ctrlLblModif.setText(sb.toString());
        this._cbxFreeze.setSelected(this._dbFolder.isFreeze());
        if (this._dbFolder.isLocked()) {
            this._cbxLocked.setSelected(true);
            if (this._dbFolder.getObject() != null && this._dbFolder.getObject().getLockedSession() != null) {
                DBSession dbSes = this._dbFolder.getObject().getLockedSession();
                StringBuilder sb2 = new StringBuilder(this._cbxLocked.getText());
                sb2.append(" [").append(dbSes.getUser().getLogin());
                if (!dbSes.isActive()) {
                    sb2.append("~");
                }
                sb2.append("]");
                this._cbxLocked.setText(sb2.toString());
            }
        } else {
            this._cbxLocked.setSelected(false);
        }
    }

    private void updateDepends() {
        if (this._ctrlDependsList == null) {
            return;
        }
        boolean oldEmpty = this._ctrlDependsList.isEmpty();
        this._ctrlDependsList.clear();
        Collection<DBRelation> relations = this._daoFactory.createRelationDAO().getSourceRelations(this._dbFolder);
        if (relations != null && !relations.isEmpty()) {
            for (DBRelation dbRelation : relations) {
                if (!dbRelation.getDestination().equals(this._dbFolder)) continue;
                this._ctrlDependsList.add(dbRelation.getSource());
            }
        }
        if (oldEmpty && this._ctrlDependsList.isEmpty()) {
            return;
        }
        this._ctrlDependsModel.fireTableDataChanged();
    }

    protected void createControls() {
        this._ctrlPath.setEditable(false);
        this._ctrlPath.setEnabled(false);
        this._ctrlPath.setBorder(null);
        if (this._ctrlLblQuestion == null) {
            this._ctrlLblQuestion = new JLabel("Model");
        }
        this._ctrlComment.setLineWrap(true);
        this._ctrlComment.setTabSize(2);
        this._ctrlComment.setVisible(this.isWithComment());
        this._ctrlAccessRight = new JButton(ResMsgVoc.getString("VOC_RIGHTS_ACCESS"));
        this._ctrlAccessRight.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DBFolderPropertiesPanel.this.editAccessRight();
            }
        });
        this._ctrlAccessRight.setVisible(this.isWithAccess());
    }

    protected Component createCtrlName() {
        if (this.isVersionTarget()) {
            this._ctrlName.setColumns(4);
            if (!this.isEditProperties()) {
                int idxCol = 0;
                JPanel content = new JPanel(new GridBagLayout());
                content.add((Component)this._ctrlName, new GridBagConstraints(idxCol++, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
                content.add((Component)new JPanel(), new GridBagConstraints(idxCol++, 0, 1, 1, 1.0, 0.0, 13, 2, new Insets(0, 0, 0, 0), 0, 0));
                content.add((Component)new JLabel(ResMsgVoc.getString("VOC_VERSION_REFERENCE")), new GridBagConstraints(idxCol++, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
                this._ctrlVersions = new JComboBox<Object>(this._refVersions.toArray());
                this._ctrlVersions.setEditable(false);
                this._ctrlVersions.setSelectedIndex(this._refVersions.size() - 1);
                this._ctrlVersions.setRenderer(new FolderRenderer().setDisplayIcon(false));
                content.add((Component)this._ctrlVersions, new GridBagConstraints(idxCol++, 0, 1, 1, 0.1, 0.0, 13, 2, new Insets(5, 5, 5, 5), 0, 0));
                int version = 1;
                DBFolder lastVersion = this._curVersions.get(this._curVersions.size() - 1);
                try {
                    version = Integer.parseInt(lastVersion.getName());
                }
                catch (NumberFormatException e) {
                    _LOG.info("Cette version n'est pas un entier : " + lastVersion);
                }
                String description = this.getRefVersion().getDescription();
                this._ctrlName.setText(Integer.toString(version + 1));
                this._ctrlComment.setText(description);
                return content;
            }
        }
        this._ctrlName.setEditable(this.isNameEditable());
        return this._ctrlName;
    }

    protected Container createCenterPane() {
        Component otherCtrl;
        JPanel content = new JPanel(new GridBagLayout());
        int y = 0;
        if (this._bVisiblePath) {
            content.add((Component)new JLabel(ResMsgVoc.getString("VOC_PATH")), new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
            content.add((Component)this._ctrlPath, new GridBagConstraints(1, y++, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        }
        content.add((Component)this._ctrlLblQuestion, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        content.add(this.createCtrlName(), new GridBagConstraints(1, y++, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        if (this.isWithComment()) {
            content.add((Component)new JLabel(ResMsgVoc.getString("VOC_COMMENTS")), new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 16, 0, new Insets(5, 5, 5, 5), 0, 0));
        }
        content.add((Component)this._ctrlAccessRight, new GridBagConstraints(1, y++, 1, 1, 0.0, 0.0, 14, 0, new Insets(5, 5, 5, 5), 0, 0));
        if (this.isWithComment()) {
            content.add((Component)new JScrollPane(this._ctrlComment), new GridBagConstraints(0, y++, 2, 1, 1.0, 1.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0));
        }
        if ((otherCtrl = this.createCtrlOther()) != null) {
            content.add(otherCtrl, new GridBagConstraints(0, y++, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        }
        if (this._bEditProperties) {
            content.add(this.createCtrlProperties(), new GridBagConstraints(0, y++, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        }
        if (this._bWithDepends) {
            content.add(this.createCtrlDepends(), new GridBagConstraints(0, y++, 2, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        }
        content.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        if (this.isReadOnly()) {
            this._ctrlName.setEditable(false);
            this._ctrlName.setEnabled(false);
            this._ctrlComment.setEditable(false);
            this._ctrlComment.setEnabled(false);
        }
        return content;
    }

    protected Component createCtrlOther() {
        return null;
    }

    private Component createCtrlProperties() {
        this._ctrlLblCreate = new JLabel("012345678901234");
        this._ctrlLblModif = new JLabel("012345678901234");
        this._cbxFreeze = new JCheckBox(ResMsgVoc.getString("VOC_FREEZE"));
        this._cbxFreeze.setEnabled(false);
        this._cbxLocked = new JCheckBox(ResMsgVoc.getString("VOC_LOCKED"));
        this._cbxLocked.setEnabled(false);
        JPanel panel = new JPanel(new GridBagLayout());
        int posY = 0;
        this._lblCreate = new JLabel(ResMsgVoc.getString("VOC_DATE_CREATE"));
        panel.add((Component)this._lblCreate, new GridBagConstraints(0, posY, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 2, 5, 2), 0, 0));
        panel.add((Component)this._ctrlLblCreate, new GridBagConstraints(1, posY++, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 2, 5, 2), 0, 0));
        this._lblModif = new JLabel(ResMsgVoc.getString("VOC_DATE_MODIF"));
        panel.add((Component)this._lblModif, new GridBagConstraints(0, posY, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 2, 5, 2), 0, 0));
        panel.add((Component)this._ctrlLblModif, new GridBagConstraints(1, posY++, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 2, 5, 2), 0, 0));
        panel.add((Component)this._cbxFreeze, new GridBagConstraints(0, posY, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 2, 5, 2), 0, 0));
        panel.add((Component)this._cbxLocked, new GridBagConstraints(1, posY++, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 2, 5, 2), 0, 0));
        panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ResMsgVoc.getString("VOC_INFORMATIONS")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        return panel;
    }

    private Component createCtrlDepends() {
        this._ctrlDependsList = new ArrayList();
        this._ctrlDependsModel = new ArrayTableModel<DBFolder>(this._ctrlDependsList){

            @Override
            public int getColumnCount() {
                return 1;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                return DBFolderPropertiesPanel.this._ctrlDependsList.get(rowIndex);
            }

            @Override
            public boolean isCellEditable(int r, int c) {
                return false;
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                return DBFolder.class;
            }
        };
        this._ctrlDependsTable = new JDependsTable(this._ctrlDependsModel);
        this._ctrlDependsTable.setPreferredScrollableViewportSize(new Dimension(200, 60));
        this._ctrlDependsTable.setTableHeader(null);
        FolderRenderer renderer = new FolderRenderer(){

            @Override
            protected String convertFolderToTooltip(DBFolder folder) {
                String tip = super.convertFolderToTooltip(folder);
                if (tip == null) {
                    return null;
                }
                return new StringBuilder(tip.length() + 100).append("[").append(DBFolderResources.getTypeModel(folder.getFamily(), folder.getFamilyFlag())).append("] ").append(tip).toString();
            }
        };
        this._ctrlDependsTable.setDefaultRenderer(DBFolder.class, renderer.setDisplayPath(true));
        this._ctrlDependsTable.setTransferHandler(new JTableTransfertHandler());
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)new JScrollPane(this._ctrlDependsTable), "Center");
        panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ResMsgObj.getString("MSG_FOL_WHERE_USED")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        return panel;
    }

    private synchronized void make() {
        this.createControls();
        Container content = this.createCenterPane();
        this.add((Component)content, "Center");
    }

    private void editAccessRight() {
        if (this._daoFactory == null) {
            return;
        }
        AccessRightEditDlg dlg = new AccessRightEditDlg(SwingUtilities.getWindowAncestor(this));
        String name = this._ctrlName.getText().trim();
        if (name.isEmpty()) {
            name = "...";
        }
        this._dbFolder.setName(name);
        DBUser user = null;
        if (this._dbFolder.getUserOwner().isReal()) {
            user = (DBUser)this._dbFolder.getUserOwner();
        } else {
            user = (DBUser)this._daoFactory.createUserDAO().find(this._dbFolder.getUserOwner().getID());
            if (user == null) {
                _LOG.warning("Pas de r\u00e9el DBUser pour le IUser : " + this._dbFolder.getUserOwner());
                return;
            }
        }
        dlg.setUsersAndGroups(Collections.singletonList(user), this._daoFactory.createGroupDAO().findAll());
        dlg.setFolders(Collections.singletonList(this._dbFolder));
        dlg.setDisplayOnlyOwner(true);
        dlg.setReadOnly(this.isAccessReadOnly());
        dlg.makeAndDisplay();
        if (dlg.getResult()) {
            DBGroup selectGroup = dlg.getSelectedOwnerGroup();
            if (selectGroup != null) {
                this._dbFolder.setGroupOwner(selectGroup);
            }
            this._dbFolder.setRightGroup(dlg.getRightForOwnerGroup());
            this._dbFolder.setRightOther(dlg.getRightForOtherUser());
            this._dbFolder.setAccesses(dlg.getAccessesRight());
        }
    }

    protected boolean existAnotherChild(String name) {
        if (this.isEditProperties() && this._strPreviousName.equalsIgnoreCase(name)) {
            return false;
        }
        return this._dbFolder.getParent().findChild(name) != null;
    }

    protected boolean verifyAnotherChild(String name) {
        if (this.existAnotherChild(name)) {
            this._ctrlName.requestFocus();
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this._ctrlName), ResMsgObj.msgFormat("MSG_FOL_ALREADY_CHILD", name), this._title, 0);
            return false;
        }
        return true;
    }

    protected boolean verifyVersion(String name) {
        boolean result = DBFactory.verifyVersion(name);
        if (!result) {
            this._ctrlName.requestFocus();
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this._ctrlName), ResMsgObj.getString("MSG_ERR_VERIFY_VERSION"), this._title, 0);
        }
        return result;
    }

    protected String getFolderName() {
        return this._ctrlName.getText().trim();
    }

    protected boolean verifyName(String name) {
        boolean result = true;
        if (result && DBFactory.verifyName(name) != 0) {
            result = false;
        }
        if (result) {
            switch (this._dbFolder.getFamily()) {
                case OPERATOR: 
                case COMPONENT: 
                case TYPE: 
                case EQUIPMENT: 
                case ATTRIBUTE: 
                case PARAMETER: {
                    if (!DBFactory.verifyNameAltarica(name)) {
                        result = false;
                    }
                    if (!result || !this._dbFolder.isModel() || !DBFactory.isReservedAltarica(name)) break;
                    result = false;
                }
            }
        }
        if (!result) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this._ctrlName), ResMsgObj.getString("MSG_ERR_VERIFY_NAME"), this._title, 0);
        }
        return result;
    }

    protected boolean verifyTargetVersion() {
        DBFolder dbRefVersion;
        if (!this.isEditProperties() && this.isVersionTarget() && !(dbRefVersion = this.getRefVersion()).isFreeze() && (dbRefVersion.isLocked() || dbRefVersion.isEdited())) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this._ctrlVersions), ResMsgObj.getString("MSG_ERR_VERIFY_NAME"), this._title, 0);
            this._ctrlVersions.requestFocus();
            return false;
        }
        return true;
    }

    public boolean verifyParameters() {
        String name = this.getFolderName();
        if (this.isNameEditable()) {
            if (this.isVersionTarget()) {
                if (!this.verifyVersion(name)) {
                    this._ctrlVersions.requestFocus();
                    return false;
                }
            } else if (!this.verifyName(name)) {
                this._ctrlName.requestFocus();
                return false;
            }
            if (!this.verifyAnotherChild(name)) {
                this._ctrlName.requestFocus();
                return false;
            }
        }
        if (!this.verifyTargetVersion()) {
            return false;
        }
        String description = this._ctrlComment.getText();
        if (!DBFactory.verifyDescription(description)) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this._ctrlComment), ResMsgObj.msgFormat("MSG_ERR_DESCRIPTION_FRM", (short)1023), this._title, 0);
            this._ctrlComment.requestFocus();
            return false;
        }
        this._dbFolder.setName(name);
        this._dbFolder.setDescription(description);
        return true;
    }

    public String getTitle() {
        return this._title;
    }

    private static class JDependsTable
    extends JTable
    implements JTableTransfertHandler.HelperConvert {
        public JDependsTable(TableModel model) {
            super(model);
        }

        @Override
        public String convertToString(Object obj, int row, int col) {
            if (obj instanceof DBFolder) {
                StringBuilder sb = new StringBuilder();
                ((DBFolder)obj).getPathUntilSystem(sb);
                return sb.toString();
            }
            if (obj == null) {
                return "";
            }
            return obj.toString();
        }
    }
}

