/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.folder;

import com.dassault.cecilia.core.ResIcoCore;
import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.CAppl;
import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.core.cecilia.folder.DBFolderTree;
import com.dassault.cecilia.core.cecilia.folder.DBFolderTreeModel;
import com.dassault.cecilia.core.cecilia.folder.DBFolderTreeNode;
import com.dassault.cecilia.core.cecilia.folder.DBFolderTreeNodeFile;
import com.dassault.cecilia.core.cecilia.folder.dnd.DBFolderList;
import com.dassault.cecilia.core.cecilia.folder.dnd.DBFolderListTransferable;
import com.dassault.cecilia.core.cecilia.folder.gui.DBObjectDlgDebug;
import com.dassault.cecilia.core.swing.CeciliaAction;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.dbobj.ResMsgObj;
import com.dassault.cecilia.dbobj.folder.AssociatedFileCmdAdd;
import com.dassault.cecilia.dbobj.folder.AssociatedFileCmdEdit;
import com.dassault.cecilia.dbobj.folder.DBFolderCmdDelete;
import com.dassault.cecilia.dbobj.folder.DBFolderCmdFreeze;
import com.dassault.cecilia.dbobj.folder.DBFolderCmdPaste;
import com.dassault.cecilia.dbobj.folder.DBFolderCmdProperty;
import com.dassault.cecilia.io.xml6.CmdAnonymizeXML;
import com.dassault.cecilia.io.xml6.CmdExportXML6;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;

public class DBFolderTreeEditable
extends DBFolderTree {
    static Logger _LOG = Logger.getLogger(DBFolderTreeEditable.class.getPackage().getName());
    public static final String ACTION_ADD = "ACTION_ADD";
    public static final String ACTION_DEL = "ACTION_DEL";
    public static final String ACTION_EDIT = "ACTION_EDIT";
    public static final String ACTION_PROP = "ACTION_PROP";
    public static final String ACTION_COPY = "ACTION_COPY";
    public static final String ACTION_CUT = "ACTION_CUT";
    public static final String ACTION_PASTE = "ACTION_PASTE";
    public static final String ACTION_FREEZE = "ACTION_FREEZE";
    public static final String ACTION_EXPORT = "ACTION_EXPORT";
    public static final String ACTION_ANONYMIZE = "ACTION_ANONYMIZE";
    protected CeciliaAction _ctrlAdd;
    protected CeciliaAction _ctrlDel;
    protected CeciliaAction _ctrlEdit;
    protected CeciliaAction _ctrlProp;
    protected CeciliaAction _ctrlEditWithoutCache;
    protected CeciliaAction _ctrlCopy;
    protected CeciliaAction _ctrlCut;
    protected CeciliaAction _ctrlPaste;
    protected CeciliaAction _ctrlFreeze;
    protected CeciliaAction _ctrlExport;
    protected CeciliaAction _ctrlAnonymize;
    protected CeciliaAction _ctrlAddFolder;
    private static Collection<DBFolder.Family> NOCUT_FOR_FAMILIES = Arrays.asList(DBFolder.Family.BTP_AUTHOR, DBFolder.Family.BTP_APPLICATION, DBFolder.Family.BTP_SUBSTANTIATION);

    public DBFolderTreeEditable(CAppl application, DBFolderTreeModel model, boolean init) {
        super(application, model, false);
        if (init) {
            this.initialize();
        }
    }

    @Override
    protected CAppl getAppl() {
        return (CAppl)super.getAppl();
    }

    @Override
    public DBFolderTree initialize() {
        super.initialize();
        this.addDBTreeActionListener(new DBFolderTree.DBTreeActionListener(){

            @Override
            public void actionPerformed(DBFolderTreeNode selectNode, MouseEvent e) {
                DBFolder dbFolder = selectNode.getDBFolder();
                if (dbFolder.isVersion() || e.isControlDown()) {
                    DBFolderTreeEditable.this.doEdit(selectNode, selectNode.isReadOnly());
                }
            }
        });
        return this;
    }

    @Override
    protected void createActions() {
        super.createActions();
        this._ctrlAdd = new CeciliaAction(ResIcoCore.getImageIcon("BUT_ADD"), ResMsgVoc.getString("VOC_ADD"), ResMsgCore.getString("ACTION_ADD_TTIP")){

            @Override
            public void actionPerformed(ActionEvent e) {
                DBFolderTreeNode selectNode = null;
                if (DBFolderTreeEditable.this.getSelectionCount() == 1) {
                    selectNode = (DBFolderTreeNode)DBFolderTreeEditable.this.getSelectionPath().getLastPathComponent();
                } else if (DBFolderTreeEditable.this.getSelectionCount() == 0 && (selectNode = DBFolderTreeEditable.this._model.getRoot()).getDBFolder().getFamily() == DBFolder.Family.APPLICATION) {
                    selectNode = null;
                }
                if (selectNode == null || selectNode.isReadOnly()) {
                    return;
                }
                DBFolderTreeEditable.this.doInsert(selectNode);
            }
        };
        this._ctrlAdd.setEnabled(true);
        this._mapActions.put(ACTION_ADD, this._ctrlAdd);
        this.getActionMap().put("INSERT", this._ctrlAdd);
        this.getInputMap(0).put(KeyStroke.getKeyStroke("INSERT"), "INSERT");
        this._ctrlAddFolder = new CeciliaAction(ResIcoCore.getImageIcon("BUT_MAIN_FOLDER"), ResMsgCore.getString("MENU_ADD_FOLDER")){

            @Override
            public void actionPerformed(ActionEvent e) {
                DBFolderTreeNode selectNode = DBFolderTreeEditable.this._model.getRoot();
                if (selectNode.getDBFolder().getFamily() != DBFolder.Family.APPLICATION) {
                    DBFolderTreeEditable.this.doInsert(selectNode);
                    DBFolderTreeEditable.this.requestFocus();
                }
            }
        };
        this._ctrlAddFolder.setEnabled(true);
        this._ctrlEdit = new CeciliaAction(ResIcoCore.getImageIcon("BUT_EDIT"), ResMsgVoc.getString("VOC_EDIT"), ResMsgCore.getString("ACTION_EDIT_TTIP")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DBFolderTreeEditable.this.getSelectionCount() == 0) {
                    return;
                }
                DBFolderTreeNode selectNode = (DBFolderTreeNode)DBFolderTreeEditable.this.getSelectionPath().getLastPathComponent();
                DBFolderTreeEditable.this.doEdit(selectNode, selectNode.isReadOnly());
            }
        };
        this._ctrlEdit.setEnabled(false);
        this._mapActions.put(ACTION_EDIT, this._ctrlEdit);
        this.getActionMap().put("ENTER", this._ctrlEdit);
        this.getInputMap(0).put(KeyStroke.getKeyStroke("ENTER"), "ENTER");
        this._ctrlEditWithoutCache = new CeciliaAction(ResMsgObj.getString("CMD_EDIT_WITHOUTCACHE")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DBFolderTreeEditable.this.getSelectionCount() == 0) {
                    return;
                }
                DBFolderTreeNode selectNode = (DBFolderTreeNode)DBFolderTreeEditable.this.getSelectionPath().getLastPathComponent();
                DBFolder folder = DBFolderTreeEditable.this.validEdit(selectNode, true);
                if (folder == null) {
                    return;
                }
                DBFolderTreeEditable.this.getAppl().getDAOFactory().createObjectDAO().putWrap(folder.getObject(), null);
                DBFolderTreeEditable.this.doEdit(selectNode, selectNode.isReadOnly());
            }
        };
        this._ctrlEdit.setEnabled(false);
        this._ctrlDel = new CeciliaAction(ResIcoCore.getImageIcon("BUT_DEL"), ResMsgVoc.getString("VOC_DELETE"), ResMsgCore.getString("ACTION_DEL_TTIP")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DBFolderTreeEditable.this.getSelectionCount() == 0) {
                    return;
                }
                TreePath[] selPaths = DBFolderTreeEditable.this.getSelectionPaths();
                DBFolderTreeEditable.this.doDelete(selPaths);
            }
        };
        this._ctrlDel.setEnabled(false);
        this._mapActions.put(ACTION_DEL, this._ctrlDel);
        this.getActionMap().put("DELETE", this._ctrlDel);
        this.getInputMap(0).put(KeyStroke.getKeyStroke("DELETE"), "DELETE");
        this._ctrlProp = new CeciliaAction(ResMsgVoc.getString("VOC_PROPERTIES")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DBFolderTreeEditable.this.getSelectionCount() == 0) {
                    return;
                }
                DBFolderTreeNode selectNode = (DBFolderTreeNode)DBFolderTreeEditable.this.getSelectionPath().getLastPathComponent();
                DBFolder folder = selectNode.getSource();
                DBFolderTreeEditable.this.doProperties(folder, selectNode.isReadOnly());
            }
        }.setDesc(ResMsgObj.getString("ACTION_PROP_TTIP"));
        this._ctrlProp.setEnabled(false);
        this._mapActions.put(ACTION_PROP, this._ctrlProp);
        this._ctrlCopy = new CeciliaAction(ResIcoCore.getImageIcon("BUT_COPY"), ResMsgVoc.getString("VOC_COPY"), ResMsgCore.getString("ACTION_COPY_TTIP")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DBFolderTreeEditable.this.getSelectionCount() == 0) {
                    return;
                }
                TreePath[] selectPaths = DBFolderTreeEditable.this.getSelectionPaths();
                DBFolderTreeEditable.this.doCopy(false, DBFolderTreeEditable.this.convertTreePathsToFolders(selectPaths));
            }
        };
        this._ctrlCopy.setEnabled(false);
        this._mapActions.put(ACTION_COPY, this._ctrlCopy);
        this.getActionMap().put("COPY", this._ctrlCopy);
        this.getInputMap(0).put(KeyStroke.getKeyStroke("control C"), "COPY");
        this._ctrlCut = new CeciliaAction(ResIcoCore.getImageIcon("BUT_CUT"), ResMsgVoc.getString("VOC_CUT"), ResMsgCore.getString("ACTION_CUT_TTIP")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DBFolderTreeEditable.this.getSelectionCount() == 0) {
                    return;
                }
                TreePath[] selectPaths = DBFolderTreeEditable.this.getSelectionPaths();
                DBFolderTreeEditable.this.doCopy(true, DBFolderTreeEditable.this.convertTreePathsToFolders(selectPaths));
            }
        };
        this._ctrlCut.setEnabled(false);
        this._mapActions.put(ACTION_CUT, this._ctrlCut);
        this.getActionMap().put("CUT", this._ctrlCut);
        this.getInputMap(0).put(KeyStroke.getKeyStroke("control X"), "CUT");
        this._ctrlPaste = new CeciliaAction(ResIcoCore.getImageIcon("BUT_PASTE"), ResMsgVoc.getString("VOC_PASTE"), ResMsgCore.getString("ACTION_PASTE_TTIP")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DBFolderTreeEditable.this.getSelectionCount() > 1) {
                    return;
                }
                if (DBFolderTreeEditable.this.getSelectionCount() == 1) {
                    DBFolderTreeEditable.this.expandPath(DBFolderTreeEditable.this.getSelectionPath());
                    DBFolderTreeNode selectNode = (DBFolderTreeNode)DBFolderTreeEditable.this.getSelectionPath().getLastPathComponent();
                    DBFolderTreeEditable.this.doPaste(selectNode.getSource());
                } else {
                    DBFolderTreeEditable.this.doPaste(DBFolderTreeEditable.this.getModel().getRoot().getDBFolder());
                }
            }
        };
        this._ctrlPaste.setEnabled(false);
        this._mapActions.put(ACTION_PASTE, this._ctrlPaste);
        this.getActionMap().put("PASTE", this._ctrlPaste);
        this.getInputMap(0).put(KeyStroke.getKeyStroke("control V"), "PASTE");
        this._ctrlFreeze = new CeciliaAction(ResIcoCore.getImageIcon("BUT_FREEZE"), ResMsgVoc.getString("VOC_FREEZE"), ResMsgObj.getString("ACTION_FREEZE_TTIP")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DBFolderTreeEditable.this.getSelectionCount() == 0) {
                    return;
                }
                TreePath[] selPaths = DBFolderTreeEditable.this.getSelectionPaths();
                DBFolderTreeEditable.this.doFreeze(selPaths);
            }
        };
        this._ctrlFreeze.setEnabled(false);
        this._mapActions.put(ACTION_FREEZE, this._ctrlFreeze);
        this._ctrlExport = new CeciliaAction(ResIcoCore.getImageIcon("IE_EXPORT"), ResMsgVoc.getString("VOC_EXPORT"), ResMsgObj.getString("ACTION_EXPORT_TTIP")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DBFolderTreeEditable.this.getSelectionCount() == 0) {
                    return;
                }
                TreePath[] selPaths = DBFolderTreeEditable.this.getSelectionPaths();
                DBFolderTreeEditable.this.doExport(selPaths);
            }
        };
        this._ctrlExport.setEnabled(false);
        this._mapActions.put(ACTION_EXPORT, this._ctrlExport);
        this._ctrlAnonymize = new CeciliaAction(ResIcoCore.getImageIcon("IE_EXPORT"), ResMsgVoc.getString("VOC_ANONYMIZE"), ResMsgObj.getString("ACTION_ANONYMIZE_TTIP")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DBFolderTreeEditable.this.getSelectionCount() == 0) {
                    return;
                }
                TreePath[] selPaths = DBFolderTreeEditable.this.getSelectionPaths();
                DBFolderTreeEditable.this.doAnonymize(selPaths);
            }
        };
        this._ctrlAnonymize.setEnabled(false);
        this._mapActions.put(ACTION_ANONYMIZE, this._ctrlAnonymize);
    }

    @Override
    protected void refreshActions() {
        ArrayList<DBFolder> dbSelects;
        int nbrSel;
        TreePath[] selPaths = this.getSelectionPaths();
        DBFolderTreeNode[] selFolders = null;
        if (selPaths != null) {
            selFolders = new DBFolderTreeNode[selPaths.length];
            for (int i = 0; i < selPaths.length; ++i) {
                selFolders[i] = (DBFolderTreeNode)selPaths[i].getLastPathComponent();
            }
        }
        int n = nbrSel = selFolders == null ? 0 : selFolders.length;
        if (nbrSel == 1) {
            DBFolder dbFolder = selFolders[0].getSource();
            boolean isReadOnly = selFolders[0].isReadOnly();
            if (this.isEnabledAddFile(dbFolder)) {
                this._ctrlAdd.setName(ResMsgCore.getString("MENU_ADD_FILE"));
                this._ctrlAdd.setEnabled(!isReadOnly && !(selFolders[0] instanceof DBFolderTreeNodeFile));
            } else {
                this._ctrlAdd.setName(ResMsgVoc.getString("VOC_ADD"));
                this._ctrlAdd.setEnabled(!isReadOnly && !dbFolder.isVersion());
            }
            this._ctrlEdit.setEnabled(this.isEnabledEdit(dbFolder));
            this._ctrlEditWithoutCache.setEnabled(this.isEnabledEdit(dbFolder));
            this._ctrlProp.setEnabled(!dbFolder.isSystem());
            this._ctrlDebug.setEnabled(dbFolder.getObject() != null);
            this._ctrlDependDown.setEnabled(dbFolder.getObject() != null);
            this._ctrlDependUp.setEnabled(dbFolder.getObject() != null);
            this._ctrlCut.setEnabled(!dbFolder.isSystem() && !dbFolder.isReadOnly() && !dbFolder.isVersion() && !NOCUT_FOR_FAMILIES.contains((Object)dbFolder.getFamily()) && dbFolder.getParent() != null && !dbFolder.getParent().isSystem());
        } else {
            if (nbrSel == 0) {
                this._ctrlAdd.setEnabled(this._model.getRoot().getDBFolder().getFamily() != DBFolder.Family.APPLICATION);
            } else {
                this._ctrlAdd.setEnabled(false);
            }
            this._ctrlAdd.setName(ResMsgVoc.getString("VOC_ADD"));
            this._ctrlEdit.setEnabled(false);
            this._ctrlEditWithoutCache.setEnabled(false);
            this._ctrlProp.setEnabled(false);
            this._ctrlDebug.setEnabled(false);
            this._ctrlDependDown.setEnabled(false);
            this._ctrlDependUp.setEnabled(false);
            this._ctrlCut.setEnabled(false);
        }
        this._ctrlAddFolder.setEnabled(true);
        this._ctrlCompareObjects.setEnabled(false);
        if (nbrSel == 2) {
            DBFolder folder1 = selFolders[0].getDBFolder();
            DBFolder folder2 = selFolders[1].getDBFolder();
            boolean sameFamilyFlag = folder1.getFamilyFlag() == folder2.getFamilyFlag();
            boolean bothVersions = folder1.getObject() != null && folder1.getObject() != null && folder1.isVersion() && folder2.isVersion();
            boolean folderWithProps = folder1.getFamily() == DBFolder.Family.BTP_APPLICATION || folder1.getFamily() == DBFolder.Family.BTP_AUTHOR || folder1.getFamily() == DBFolder.Family.BTP_SUBSTANTIATION;
            boolean canBeCompared = sameFamilyFlag && (bothVersions || folderWithProps);
            this._ctrlCompareObjects.setEnabled(canBeCompared);
        }
        boolean oneIsReadOnly = false;
        boolean oneIsNotVersion = false;
        boolean oneIsSystem = false;
        boolean oneIsNotFreeze = false;
        for (int i = 0; i < nbrSel; ++i) {
            boolean bl = oneIsReadOnly = oneIsReadOnly || selFolders[i].isReadOnly() || selFolders[i].getSource().isSystem();
            if (selFolders[i].getSource().isVersion()) {
                boolean bl2 = oneIsNotFreeze = oneIsNotFreeze || this.isEnabledFreeze(selFolders[i].getSource());
            }
            if (!selFolders[i].getSource().isSystem()) {
                oneIsNotVersion = oneIsNotVersion || !selFolders[i].getSource().isVersion();
            } else {
                oneIsSystem = true;
            }
            if (oneIsReadOnly && oneIsNotVersion) break;
        }
        this._ctrlDel.setEnabled(!oneIsReadOnly && nbrSel > 0);
        this._ctrlFreeze.setEnabled(oneIsNotVersion || !oneIsReadOnly && oneIsNotFreeze);
        this._ctrlExport.setEnabled(nbrSel > 0);
        this._ctrlAnonymize.setEnabled(nbrSel > 0);
        this._ctrlExpand.setEnabled(oneIsNotVersion | oneIsSystem);
        this._ctrlCollapse.setEnabled(oneIsNotVersion | oneIsSystem);
        ArrayList<DBFolder> arrayList = dbSelects = selPaths == null ? null : this.convertTreePathsToFolders(selPaths);
        if (dbSelects == null || dbSelects.isEmpty()) {
            this._ctrlCopy.setEnabled(false);
            this._ctrlCut.setEnabled(false);
            this._ctrlPaste.setEnabled(this.canClipboardPaste(this.getModel().getRoot().getDBFolder()));
        } else {
            boolean canBeCopy = false;
            boolean canBeCut = true;
            DBFolder dbParent = null;
            DBFolder.Family dbFamily = null;
            for (DBFolder dbFolder : dbSelects) {
                if (dbParent == null && (dbParent = dbFolder.getParent()) != null) {
                    dbFamily = dbFolder.getFamily();
                }
                if (dbFolder == null) {
                    canBeCut = false;
                    continue;
                }
                if (dbFolder.isSystem()) {
                    canBeCut = false;
                    continue;
                }
                canBeCopy = true;
                if (dbFolder.isReadOnly() || dbFolder.isVersion()) {
                    canBeCut = false;
                    continue;
                }
                if (NOCUT_FOR_FAMILIES.contains((Object)dbFolder.getFamily())) {
                    canBeCut = false;
                    continue;
                }
                if (dbFolder.getParent() == null || dbFolder.getParent().isSystem()) {
                    canBeCut = false;
                    continue;
                }
                if (!dbParent.equals(dbFolder.getParent())) {
                    canBeCut = false;
                    continue;
                }
                if (dbFamily.equals((Object)dbFolder.getFamily())) continue;
                canBeCut = false;
            }
            this._ctrlCopy.setEnabled(canBeCopy);
            this._ctrlCut.setEnabled(canBeCut);
            this._ctrlPaste.setEnabled(this.canClipboardPaste(dbParent));
        }
    }

    protected boolean isEnabledEdit(DBFolder dbFolder) {
        return dbFolder.getObject() != null;
    }

    protected boolean isEnabledFreeze(DBFolder dbFolder) {
        return !dbFolder.isFreeze();
    }

    protected boolean isEnabledAddFile(DBFolder dbFolder) {
        return dbFolder.isVersion() && dbFolder.getObject() != null;
    }

    @Override
    protected JPopupMenu createMenuActions(JPopupMenu popupList) {
        popupList.add(this._ctrlAddFolder);
        popupList.addSeparator();
        popupList.add(this._ctrlAdd);
        popupList.add(this._ctrlEdit);
        popupList.add(this._ctrlDel);
        popupList.add(this._ctrlProp);
        popupList.add(this._ctrlCompareObjects);
        popupList.addSeparator();
        popupList.add(this._ctrlCopy);
        popupList.add(this._ctrlCut);
        popupList.add(this._ctrlPaste);
        popupList.addSeparator();
        popupList.add(this._ctrlExpand);
        popupList.add(this._ctrlCollapse);
        popupList.add(this._ctrlRefresh);
        popupList.addSeparator();
        popupList.add(this._ctrlExport);
        if (this.getAppl().isDebugMode()) {
            popupList.add(this._ctrlAnonymize);
            popupList.addSeparator();
            popupList.add(this._ctrlEditWithoutCache);
            popupList.add(this._ctrlDebug);
            popupList.add(this._ctrlDependDown);
            popupList.add(this._ctrlDependUp);
        }
        popupList.addSeparator();
        popupList.add(this._ctrlFreeze);
        return popupList;
    }

    protected ArrayList<DBFolder> convertTreePathsToFolders(TreePath[] selPaths) {
        ArrayList<DBFolder> selFolders = new ArrayList<DBFolder>();
        for (int i = 0; i < selPaths.length; ++i) {
            DBFolderTreeNode selectNode = (DBFolderTreeNode)selPaths[i].getLastPathComponent();
            if (selectNode instanceof DBFolderTreeNodeFile || selectNode.getSource().isSystem()) continue;
            selFolders.add(selectNode.getSource());
        }
        return selFolders;
    }

    protected void doInsert(DBFolderTreeNode selectNode) {
        DBFolder folder = selectNode.getSource();
        if (folder.isVersion()) {
            this.doInsertFile(folder);
        } else {
            this.doInsert(folder);
        }
    }

    protected void doInsertFile(DBFolder folder) {
        AssociatedFileCmdAdd cmd = new AssociatedFileCmdAdd(this.getAppl(), this);
        cmd.setDBFolder(folder);
        cmd.realiseDo();
    }

    protected void doInsert(DBFolder dbParent) {
        DBFolder.Family familyFolder = dbParent.getFamily();
        if (familyFolder == DBFolder.Family.APPLICATION) {
            return;
        }
        DBFolderCmdProperty cmd = this.createCmdInsert();
        cmd.setDBFolder(dbParent).setDBUser(this._model.getDBUser());
        cmd.realiseDo();
    }

    protected DBFolderCmdProperty createCmdInsert() {
        return new DBFolderCmdProperty(this.getAppl(), this, false);
    }

    protected void doEdit(DBFolderTreeNode selectNode, boolean readOnly) {
        DBFolder folder = this.validEdit(selectNode, true);
        if (folder == null) {
            return;
        }
        this.doEdit(folder, readOnly);
    }

    protected void doEdit(DBFolder folder, boolean readOnly) {
        DBObjectDlgDebug dlg = new DBObjectDlgDebug(SwingUtilities.getWindowAncestor(this));
        dlg.setTitle("Debug - " + this.getAppl().getTitle());
        dlg.setDAOFactory(this.getAppl().getDAOFactory());
        dlg.setSelect(folder);
        dlg.setModal(true);
        dlg.setLocationRelativeTo(JOptionCecilia.getTopContainerOf(this));
        dlg.setVisible(true);
    }

    protected DBFolder validEdit(DBFolderTreeNode selectNode, boolean withObject) {
        if (!this._ctrlEdit.isEnabled()) {
            return null;
        }
        if (selectNode instanceof DBFolderTreeNodeFile) {
            this.doEditFile((DBFolderTreeNodeFile)selectNode);
            return null;
        }
        DBFolder folder = selectNode.getSource();
        if (withObject && folder.getObject() == null) {
            return null;
        }
        return folder;
    }

    private void doEditFile(DBFolderTreeNodeFile selectNode) {
        AssociatedFileCmdEdit cmd = new AssociatedFileCmdEdit(this.getAppl(), (Component)this, selectNode);
        cmd.realiseDo();
    }

    public boolean edit(DBFolder folder, boolean readOnly) {
        DBFolderTreeNode folderNode = this._model.constructPath(folder);
        if (folderNode == null) {
            return false;
        }
        this.doEdit(folder, readOnly || folderNode.isReadOnly());
        return true;
    }

    public boolean editProperties(DBFolder folder, boolean readOnly) {
        DBFolderTreeNode folderNode = this._model.constructPath(folder);
        if (folderNode == null) {
            return false;
        }
        this.doProperties(folder, readOnly || folderNode.isReadOnly());
        return true;
    }

    protected void doDelete(TreePath[] selPaths) {
        ArrayList<DBFolderTreeNode> selFolders = new ArrayList<DBFolderTreeNode>();
        for (int i = 0; i < selPaths.length; ++i) {
            DBFolderTreeNode selectNode = (DBFolderTreeNode)selPaths[i].getLastPathComponent();
            if (selectNode instanceof DBFolderTreeNodeFile) {
                selFolders.add(selectNode);
                continue;
            }
            if (selectNode.getSource().isSystem()) continue;
            selFolders.add(selectNode);
        }
        if (selFolders.size() > 0) {
            this.doDelete(selFolders);
        }
    }

    protected void doDelete(ArrayList<DBFolderTreeNode> selFolders) {
        DBFolderCmdDelete cmd = new DBFolderCmdDelete(this.getAppl(), this, selFolders, this._model.getDBUser());
        cmd.realiseDo();
    }

    protected void doProperties(DBFolder folder, boolean readOnly) {
        if (folder.isSystem()) {
            return;
        }
        DBFolderCmdProperty cmd = new DBFolderCmdProperty(this.getAppl(), this, true);
        cmd.setDBFolder(folder).setDBUser(this._model.getDBUser());
        cmd.realiseDo();
    }

    protected void doFreeze(TreePath[] selPaths) {
        ArrayList<DBFolder> selFolders = this.convertTreePathsToFolders(selPaths);
        if (selFolders.size() == 0) {
            return;
        }
        DBFolderCmdFreeze cmd = new DBFolderCmdFreeze(this.getAppl(), this, selFolders, this._model.getDBUser(), true);
        cmd.realiseDo();
    }

    protected void doExport(TreePath[] selPaths) {
        ArrayList<DBFolder> selFolders = this.convertTreePathsToFolders(selPaths);
        if (selFolders.size() == 0) {
            return;
        }
        CmdExportXML6 cmd = new CmdExportXML6((CeciliaAppl)this.getAppl(), this, selFolders, this._model.getDBUser());
        cmd.realiseDo();
    }

    protected void doAnonymize(TreePath[] selPaths) {
        ArrayList<DBFolder> selFolders = this.convertTreePathsToFolders(selPaths);
        if (selFolders.size() == 0) {
            return;
        }
        CmdAnonymizeXML cmd = new CmdAnonymizeXML((CeciliaAppl)this.getAppl(), this, selFolders, this._model.getDBUser());
        cmd.realiseDo();
    }

    private boolean canClipboardPaste(DBFolder dst) {
        Transferable transferable = this.getAppl().getLocalClipboard(true).getContents(this);
        if (transferable == null) {
            return false;
        }
        if (!transferable.isDataFlavorSupported(DBFolderListTransferable.DB_FLAVOR)) {
            return false;
        }
        DBFolderList dbFolList = null;
        try {
            dbFolList = (DBFolderList)transferable.getTransferData(DBFolderListTransferable.DB_FLAVOR);
        }
        catch (Exception e) {
            _LOG.log(Level.WARNING, "Probleme avec le presse-papier", e);
        }
        DBFolder src = dbFolList.getFolders().iterator().next();
        if (src.getFamily() != dst.getFamily()) {
            return false;
        }
        if (src.isVersion()) {
            if (dbFolList.isCutOperation()) {
                return false;
            }
            if (dst.isVersion()) {
                DBFolder dbParent = dst.getParent();
                if (!dbParent.equals(src.getParent())) {
                    return false;
                }
                if (dbParent.isReadOnly()) {
                    return false;
                }
            } else if (!dst.equals(src.getParent())) {
                return false;
            }
        } else {
            DBFolder dbParent;
            int srcDepth;
            int dstDepth = dst.getDepthUntilSystem();
            if (dstDepth == (srcDepth = src.getDepthUntilSystem()) && (dbParent = dst.getParent()).isReadOnly()) {
                return false;
            }
        }
        return true;
    }

    protected void doCopy(boolean cut, Collection<DBFolder> folders) {
        if (folders.isEmpty()) {
            return;
        }
        if (_LOG.isLoggable(Level.FINER)) {
            LinkedHashSet<String> family = new LinkedHashSet<String>();
            LinkedHashSet<String> pathSyst = new LinkedHashSet<String>();
            for (DBFolder folder : folders) {
                family.add(folder.getFamily().toString().toLowerCase());
                pathSyst.add(folder.getPathUntilSystem(new StringBuilder()).toString());
            }
            _LOG.finer("Clipboard::" + (cut ? "Cut" : "Copy") + "(" + ((Object)family).toString() + ":" + ((Object)pathSyst).toString() + ")");
        }
        try {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            StringBuilder buffer = new StringBuilder(folders.size() * 32);
            for (DBFolder dbFolder : folders) {
                if (buffer.length() > 0) {
                    buffer.append("\n");
                }
                buffer.append(dbFolder.convertToString());
            }
            StringSelection selection = new StringSelection(buffer.toString());
            clipboard.setContents(selection, null);
        }
        catch (IllegalStateException ise) {
            _LOG.info("Le presse-papier Systeme est en cours d'utilisation par une autre application...");
        }
        boolean canAction = true;
        Iterator<DBFolder> iterFolder = folders.iterator();
        DBFolder dbFolder = iterFolder.next();
        DBFolder dbParent = dbFolder.getParent();
        if (dbParent == null) {
            canAction = true;
        } else {
            DBFolder.Family dbFamily = dbFolder.getFamily();
            while (true) {
                canAction &= !dbFolder.isVersion() && !dbFolder.isSystem();
                canAction &= dbParent.equals(dbFolder.getParent());
                canAction &= dbFamily.equals((Object)dbFolder.getFamily());
                if (cut) {
                    canAction &= dbFolder.getParent() != null && !dbFolder.getParent().isSystem();
                }
                if (!canAction || !iterFolder.hasNext()) break;
                dbFolder = iterFolder.next();
            }
        }
        if (!canAction) {
            _LOG.info("L'action de copier|couper l'arborescence n'est pas possible avec les donnees selectionnees.");
            return;
        }
        DBFolderListTransferable transferable = new DBFolderListTransferable(new DBFolderList(cut, folders));
        this.getAppl().getLocalClipboard(true).setContents(transferable, null);
        this._ctrlPaste.setEnabled(this.canClipboardPaste(dbParent));
    }

    protected void doPaste(DBFolder folder) {
        _LOG.finer("Clipboard::Paste(" + folder.getFamily().toString().toLowerCase() + ":" + folder.getPathUntilSystem(new StringBuilder()).toString() + ")");
        if (!this.canClipboardPaste(folder)) {
            _LOG.info("Impossible Clipboard::Paste(" + folder.getFamily().toString().toLowerCase() + ":" + folder.getPathUntilSystem(new StringBuilder()).toString() + ")");
        }
        DBFolderCmdPaste cmd = new DBFolderCmdPaste((CeciliaAppl)this.getAppl(), this, folder, this._model.getDBUser());
        cmd.realiseDo();
    }
}

