/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.folder;

import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.core.cecilia.dependencies.Generate;
import com.dassault.cecilia.core.cecilia.dependencies.Recup;
import com.dassault.cecilia.core.cecilia.error.GeneralError;
import com.dassault.cecilia.db.DBAccess;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBSession;
import com.dassault.cecilia.db.DBUser;
import com.dassault.cecilia.db.dao.DAOFactory;
import com.dassault.cecilia.dbobj.ResMsgObj;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;

public class GenerateFreeze
extends Generate<DBFolder> {
    DBUser _dbUser;
    boolean _forActionFreeze;
    Set<DBFolder> _parentsFolder = new HashSet<DBFolder>();

    public GenerateFreeze(DAOFactory daoFactory, DBUser dbUser, boolean freeze) {
        super(daoFactory);
        this._dbUser = dbUser;
        this._forActionFreeze = freeze;
    }

    protected boolean validParents(DBFolder current, DBFolder origin) {
        DBFolder parent = current.getParent();
        if (parent.isSystem()) {
            return true;
        }
        if (this._parentsFolder.contains(parent)) {
            return true;
        }
        if (!this.validParents(parent, origin)) {
            return false;
        }
        if (this._daoFactory.createFolderDAO().getAccessRight(parent, this._dbUser) == DBAccess.Right.NONE) {
            this.getErrors().add(new GeneralError<DBFolder>(parent, ResMsgCore.msgFormat("MSG_ERR_ACCESS_FOLDER_PARENT_FRM", origin.getRefPath())));
        }
        this._parentsFolder.add(parent);
        return true;
    }

    @Override
    protected Recup<DBFolder> makeRecup(DBFolder.Family family) {
        return new Recup<DBFolder>(family, (Generate)this){

            @Override
            protected boolean isValid(DBFolder dbFolder, DBFolder t) {
                if (!GenerateFreeze.this.validParents(dbFolder, dbFolder)) {
                    return false;
                }
                if (dbFolder.getObject() != null) {
                    if (!(dbFolder.isFreeze() ^ GenerateFreeze.this._forActionFreeze)) {
                        return false;
                    }
                    if (dbFolder.isLocked()) {
                        DBSession dbSession = dbFolder.getObject().getLockedSession();
                        GenerateFreeze.this.getErrors().add(new GeneralError<DBFolder>(dbFolder, ResMsgObj.msgFormat("MSG_OBJ_ERR_ISLOCKED", dbFolder.getRefPath(), dbSession.getUser().getLogin(), dbSession.isActive() ? "" : " ~")));
                    } else if (GenerateFreeze.this._daoFactory.createFolderDAO().getAccessRight(dbFolder, GenerateFreeze.this._dbUser) != DBAccess.Right.WRITE) {
                        GenerateFreeze.this.getErrors().add(new GeneralError<DBFolder>(dbFolder, ResMsgObj.msgFormat("MSG_OBJ_ERR_ACCESS_WRITE", dbFolder.getRefPath())));
                    }
                }
                return true;
            }
        };
    }

    @Override
    protected DBFolder findOrCreate(DBFolder dbDest, DBFolder.Family family) {
        return dbDest;
    }

    public boolean withError() {
        return !this.getErrors().isEmpty();
    }

    public Set<DBFolder> getDepends() {
        LinkedHashSet<DBFolder> folders = new LinkedHashSet<DBFolder>();
        for (DBFolder.Family family : this.getKeys()) {
            Collection familyDepends = this.getValues(family);
            if (familyDepends == null) continue;
            folders.addAll(familyDepends);
        }
        return folders;
    }
}

