/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.general.attrib.gui;

import com.dassault.cecilia.core.cecilia.folder.gui.DBFolderPanelSelect;
import com.dassault.cecilia.core.cecilia.folder.gui.DBFolderPanelSelectFilter;
import com.dassault.cecilia.core.swing.JDialogCecilia;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.dbobj.general.attrib.AttrType;
import com.dassault.cecilia.dbobj.general.attrib.DBAttrib;
import com.dassault.cecilia.dbobj.wrap.DBWrap;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.SwingUtilities;

public class AttributeDlgChooser
extends JDialogCecilia {
    private boolean _withVersion = true;
    private boolean _withAlias = true;
    CeciliaAppl _application;
    DBFolderPanelSelect _ctrlSelect;

    public AttributeDlgChooser setWithVersion(boolean value) {
        this._withVersion = value;
        this._ctrlSelect.resetCache();
        return this;
    }

    public boolean withVersion() {
        return this._withVersion;
    }

    public AttributeDlgChooser setWithAlias(boolean value) {
        this._withAlias = value;
        this._ctrlSelect.resetCache();
        return this;
    }

    public boolean withAlias() {
        return this._withAlias;
    }

    public AttributeDlgChooser(Window owner, String title, CeciliaAppl appl, boolean withAlias) {
        super(owner, title);
        this._application = appl;
        this._withAlias = withAlias;
        this.make(owner);
    }

    private void make(Window owner) {
        this._ctrlSelect = new DBFolderPanelSelectFilterAttribute();
        this._ctrlSelect.getCtrlTree().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() != 2) {
                    return;
                }
                if (!SwingUtilities.isLeftMouseButton(e)) {
                    return;
                }
                DBFolder dbFolder = AttributeDlgChooser.this._ctrlSelect.getSelectFolder(false);
                if (dbFolder == null) {
                    return;
                }
                if (AttributeDlgChooser.this.withVersion() ? !dbFolder.isVersion() : !dbFolder.isModel()) {
                    return;
                }
                AttributeDlgChooser.this.validDialog();
            }
        });
        this._ctrlSelect.getCtrlTree().setVisibleRowCount(15);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this._ctrlSelect, "Center");
        this.getContentPane().add((Component)this.createButPanel(), "South");
        this.init();
        this.pack();
        Dimension size = this.getSize();
        size.width = Math.max(size.width, 250);
        this.setSize(size);
        this.setLocationRelativeTo(JOptionCecilia.getTopContainerOf(owner));
        this.setModal(true);
    }

    @Override
    protected boolean verifyParameters() {
        return this.getSelectFolder() != null;
    }

    public void setSelectFolder(DBFolder dbFolder) {
        this._ctrlSelect.setSelectFolder(dbFolder);
    }

    public DBFolder getSelectFolder() {
        return this._ctrlSelect.getSelectFolder(true);
    }

    @Override
    public void dispose() {
        this._ctrlSelect.dispose();
        super.dispose();
    }

    class DBFolderPanelSelectFilterAttribute
    extends DBFolderPanelSelectFilter {
        DBFolderPanelSelectFilterAttribute() {
            super(AttributeDlgChooser.this._application, DBFolder.Family.ATTRIBUTE);
        }

        @Override
        protected boolean selectThisFolder(DBFolder dbFolder) {
            if (dbFolder.isVersion()) {
                DBWrap dbWrap = AttributeDlgChooser.this._application.getDAOFactory().findOrCreateWrap(dbFolder);
                if (dbWrap == null) {
                    return false;
                }
                if (!(dbWrap instanceof DBAttrib)) {
                    return false;
                }
                return ((DBAttrib)dbWrap).getType() != AttrType.ALIAS;
            }
            if (dbFolder.isModel()) {
                List<DBFolder> children = dbFolder.getChildren();
                if (children == null) {
                    children = AttributeDlgChooser.this._application.getDAOFactory().createFolderDAO().findChildren(dbFolder);
                }
                for (DBFolder dbChild : children) {
                    DBWrap dbWrap = AttributeDlgChooser.this._application.getDAOFactory().findOrCreateWrap(dbChild);
                    if (dbWrap == null || !(dbWrap instanceof DBAttrib) || ((DBAttrib)dbWrap).getType() == AttrType.ALIAS) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean selectFolder(DBFolder dbFolder) {
            if (AttributeDlgChooser.this._withAlias) {
                return true;
            }
            return super.selectFolder(dbFolder);
        }
    }
}

