/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.general.attrib.gui;

import com.dassault.cecilia.core.ResIcoCore;
import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.core.cecilia.dependencies.DependsListener;
import com.dassault.cecilia.core.swing.CeciliaAction;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.core.swing.table.TablePanel;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.dbobj.ResMsgObj;
import com.dassault.cecilia.dbobj.general.attrib.AttrType;
import com.dassault.cecilia.dbobj.general.attrib.DBAttrib;
import com.dassault.cecilia.dbobj.general.attrib.gui.DBAttribValueDlgAdd;
import com.dassault.cecilia.dbobj.general.attrib.gui.DBAttribValueDlgEdit;
import com.dassault.cecilia.dbobj.wrap.DBWrap;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.Box;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class DBAttribValuesTablePanel
extends TablePanel {
    private static DBAttribValueDlgAdd _dlgAddAttribValue = null;
    private static Object _LockerDlgAdd = new Object();
    CeciliaAction _ctrlEdit;
    CeciliaAppl _application;
    boolean _bIsModified = false;
    List<DependsListener> _listeners = new ArrayList<DependsListener>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static DBAttribValueDlgAdd getDlgAddAttribValue(Window win, CeciliaAppl appl) {
        if (_dlgAddAttribValue == null) {
            DBAttribValueDlgAdd dlg = null;
            Object object = _LockerDlgAdd;
            synchronized (object) {
                if (_dlgAddAttribValue == null) {
                    dlg = new DBAttribValueDlgAdd(appl, win);
                }
                if (_dlgAddAttribValue == null) {
                    _dlgAddAttribValue = dlg;
                }
            }
        }
        return _dlgAddAttribValue;
    }

    public DBAttribValuesTablePanel(Window window, CeciliaAppl application) {
        super(window, new DBAttribValuesTableModel(), false);
        this._application = application;
        this.initialise();
    }

    public void setItems(ArrayList<DBAttrib.Value> dbAttribValues) {
        ((DBAttribValuesTableModel)this.getTableModel()).setItems(dbAttribValues);
    }

    @Override
    protected void initialise() {
        this._ctrlEdit = new CeciliaAction(ResIcoCore.getImageIcon("BUT_EDIT"), ResMsgVoc.getString("VOC_EDIT"), ResMsgCore.getString("ACTION_EDIT_TTIP")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DBAttribValuesTablePanel.this._ctrlTable.getSelectedRowCount() > 0) {
                    DBAttribValuesTablePanel.this.editData(DBAttribValuesTablePanel.this._ctrlTable.getSelectedRows());
                }
            }
        };
        super.initialise();
        TableColumn column = null;
        TableModel tableModel = this.getTableModel();
        block5: for (int i = 0; i < tableModel.getColumnCount(); ++i) {
            column = this._ctrlTable.getColumnModel().getColumn(i);
            switch (i) {
                case 0: {
                    column.setPreferredWidth(150);
                    continue block5;
                }
                case 1: {
                    column.setPreferredWidth(75);
                    continue block5;
                }
                case 2: {
                    column.setPreferredWidth(100);
                }
            }
        }
        this._ctrlTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() != 2) {
                    return;
                }
                if (!SwingUtilities.isLeftMouseButton(e)) {
                    return;
                }
                if (DBAttribValuesTablePanel.this._ctrlTable.getSelectedRowCount() > 0) {
                    DBAttribValuesTablePanel.this.editData(DBAttribValuesTablePanel.this._ctrlTable.getSelectedRows());
                }
            }
        });
        this._ctrlTable.setDefaultRenderer(AttrType.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (value instanceof AttrType) {
                    this.setText(((AttrType)((Object)value)).getLabel());
                }
                return this;
            }
        });
        this._ctrlTable.setSelectionMode(2);
    }

    @Override
    protected void createToolBarActions(Container aPanel) {
        aPanel.add(Box.createGlue());
        aPanel.add(this._ctrlAdd.createButton(CeciliaAction.BorderStyle.LIGHT));
        aPanel.add(Box.createRigidArea(CeciliaAction.RIGID_AREA));
        aPanel.add(this._ctrlEdit.createButton(CeciliaAction.BorderStyle.LIGHT));
        aPanel.add(Box.createRigidArea(CeciliaAction.RIGID_AREA));
        aPanel.add(this._ctrlDel.createButton(CeciliaAction.BorderStyle.LIGHT));
    }

    @Override
    protected JPopupMenu createMenuActions(JPopupMenu popupList) {
        popupList.add(this._ctrlAdd);
        popupList.add(this._ctrlEdit);
        popupList.add(this._ctrlDel);
        return popupList;
    }

    @Override
    protected void addData(int viewRow) {
        Window win = SwingUtilities.getWindowAncestor(this._ctrlTable);
        DBAttribValueDlgAdd dlg = DBAttribValuesTablePanel.getDlgAddAttribValue(win, this._application);
        dlg.refreshSelect();
        dlg.setVisible(true);
        if (!dlg.getResult()) {
            return;
        }
        DBAttrib dbAttrib = dlg.getSelectAttrib();
        if (dbAttrib == null) {
            return;
        }
        String value = dlg.getSelectValue();
        if (value == null) {
            return;
        }
        DBAttrib.Value create = dbAttrib.createInstance(value);
        int idx = ((DBAttribValuesTableModel)this.getTableModel()).addItem(create);
        if (idx == -1) {
            String title = ResMsgObj.getString("DBATTRIB_VALUES_TITLE");
            if (win instanceof Frame) {
                title = ((Frame)win).getTitle();
            } else if (win instanceof Dialog) {
                title = ((Dialog)win).getTitle();
            }
            String msg = ResMsgObj.msgFormat("DBATTRIB_VALUES_ERROR_ADD", dbAttrib.getRefPath());
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this._ctrlTable), msg, title, 0);
        } else {
            this.setModified(true);
            int idxView = this._ctrlTable.convertColumnIndexToView(idx);
            this._ctrlTable.getSelectionModel().setSelectionInterval(idxView, idxView);
            this.fireChangeDepends();
        }
    }

    protected void editData(int[] viewRows) {
        if (viewRows.length != 1) {
            return;
        }
        int modelRow = this._ctrlTable.convertRowIndexToModel(viewRows[0]);
        DBAttrib.Value select = ((DBAttribValuesTableModel)this.getTableModel()).getItem(modelRow);
        DBAttrib dbAttrib = null;
        DBWrap dbWrap = this._application.getDAOFactory().findOrCreateWrap(select.getKey().getDBFolder());
        if (dbWrap != null && dbWrap instanceof DBAttrib) {
            dbAttrib = (DBAttrib)dbWrap;
        }
        if (dbAttrib == null || !dbAttrib.equals(select.getKey())) {
            this.delData(viewRows);
            return;
        }
        if (select.getKey().getType() == AttrType.ALIAS) {
            return;
        }
        String value = select.getValue() == null ? "" : select.getValue().toString();
        Window win = SwingUtilities.getWindowAncestor(this._ctrlTable);
        DBAttribValueDlgEdit dlg = new DBAttribValueDlgEdit(win, select.getKey(), value);
        dlg.setVisible(true);
        if (!dlg.getResult()) {
            return;
        }
        String newValue = dlg.getSelectValue();
        if (value.equals(newValue)) {
            return;
        }
        if (!select.setValue(newValue)) {
            String title = ResMsgObj.getString("DBATTRIB_VALUES_TITLE");
            if (win instanceof Frame) {
                title = ((Frame)win).getTitle();
            } else if (win instanceof Dialog) {
                title = ((Dialog)win).getTitle();
            }
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this._ctrlTable), ResMsgObj.getString("DBATTRIB_VALUES_ERROR_CREATE"), title, 0);
        } else {
            this.setModified(true);
            ((DBAttribValuesTableModel)this.getTableModel()).changeItem(select);
            this.fireChangeDepends();
        }
    }

    @Override
    protected void delData(int[] viewRows) {
        if (viewRows.length == 0) {
            return;
        }
        this.setModified(true);
        DBAttribValuesTableModel tableModel = (DBAttribValuesTableModel)this.getTableModel();
        if (viewRows.length == 1) {
            tableModel.delItem(this._ctrlTable.convertRowIndexToModel(viewRows[0]));
        } else {
            int i;
            int[] modelRows = new int[viewRows.length];
            for (i = 0; i < viewRows.length; ++i) {
                modelRows[i] = this._ctrlTable.convertRowIndexToModel(viewRows[i]);
            }
            Arrays.sort(modelRows);
            for (i = modelRows.length - 1; i >= 0; --i) {
                tableModel.delItem(modelRows[i]);
            }
        }
        this.fireChangeDepends();
    }

    @Override
    protected void refreshCtrl() {
        boolean isEnabled = this.isEnabled();
        int nbrSel = this._ctrlTable.getSelectedRowCount();
        this._ctrlAdd.setEnabled(isEnabled);
        this._ctrlEdit.setEnabled(isEnabled && nbrSel == 1);
        this._ctrlDel.setEnabled(isEnabled && nbrSel > 0);
    }

    public boolean isModified() {
        return this._bIsModified;
    }

    public void setModified(boolean value) {
        this._bIsModified = value;
    }

    public void addDependsListener(DependsListener l) {
        if (!this._listeners.contains(l)) {
            this._listeners.add(l);
        }
    }

    public void removeDependsListener(DependsListener l) {
        this._listeners.remove(l);
    }

    protected void fireChangeDepends() {
        for (int i = this._listeners.size() - 1; i >= 0; --i) {
            this._listeners.get(i).changeDepends();
        }
    }

    public static class DBAttribValuesTableModel
    extends AbstractTableModel {
        ArrayList<DBAttrib.Value> _dbAttribValues = new ArrayList();

        DBAttribValuesTableModel() {
        }

        @Override
        public int getRowCount() {
            return this._dbAttribValues.size();
        }

        protected DBAttrib.Value getItem(int row) {
            return this._dbAttribValues.get(row);
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return ResMsgVoc.getString("VOC_NAME");
                }
                case 1: {
                    return ResMsgVoc.getString("VOC_TYPE");
                }
                case 2: {
                    return ResMsgVoc.getString("VOC_VALUE");
                }
            }
            return super.getColumnName(column);
        }

        public Class getColumnClass(int column) {
            switch (column) {
                case 0: {
                    return String.class;
                }
                case 1: {
                    return AttrType.class;
                }
                case 2: {
                    return String.class;
                }
            }
            return super.getColumnClass(column);
        }

        @Override
        public Object getValueAt(int row, int column) {
            switch (column) {
                case 0: {
                    return this.getItem(row).getKey().getRefPath();
                }
                case 1: {
                    return this.getItem(row).getKey().getType();
                }
                case 2: {
                    return this.getItem(row).getValue().toString();
                }
            }
            return null;
        }

        public void setItems(ArrayList<DBAttrib.Value> dbAttribValues) {
            this._dbAttribValues = dbAttribValues;
            this.fireTableDataChanged();
        }

        public int addItem(DBAttrib.Value create) {
            DBFolder dbCreateAttribParent = create.getKey().getDBFolder().getParent();
            int idx = -1;
            for (int i = 0; i < this._dbAttribValues.size(); ++i) {
                DBAttrib.Value current = this._dbAttribValues.get(i);
                if (dbCreateAttribParent.equals(current.getKey().getDBFolder().getParent())) {
                    return -1;
                }
                if (idx != -1 || create.getKey().getRefPath().compareTo(current.getKey().getRefPath()) >= 0) continue;
                idx = i;
            }
            if (idx != -1) {
                this._dbAttribValues.add(idx, create);
            } else {
                idx = this._dbAttribValues.size();
                this._dbAttribValues.add(create);
            }
            this.fireTableRowsInserted(idx, idx);
            return idx;
        }

        public void changeItem(DBAttrib.Value select) {
            int idx = this._dbAttribValues.indexOf(select);
            if (idx != -1) {
                this.fireTableCellUpdated(idx, 2);
            }
        }

        public void delItem(int row) {
            this.fireTableRowsDeleted(row, row);
            this._dbAttribValues.remove(row);
        }
    }
}

