/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.general.icon.gui;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.CAppl;
import com.dassault.cecilia.core.cecilia.error.GeneralError;
import com.dassault.cecilia.core.cecilia.error.MsgType;
import com.dassault.cecilia.core.cecilia.folder.DBFolderTree;
import com.dassault.cecilia.core.cecilia.folder.gui.DBFolderSelectUtility;
import com.dassault.cecilia.core.swing.JDialogCecilia;
import com.dassault.cecilia.core.swing.other.FileFilterExtention;
import com.dassault.cecilia.db.DBFactory;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBObjModel;
import com.dassault.cecilia.db.DBObject;
import com.dassault.cecilia.dbobj.ResMsgObj;
import com.dassault.cecilia.dbobj.folder.DBFolderCmdProperty;
import com.dassault.cecilia.dbobj.folder.DBFolderTreeEditable;
import com.dassault.cecilia.dbobj.general.conflict.DBConflict;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class DBIconCmdInsert
extends DBFolderCmdProperty {
    static JFileChooser _iconFileChooser = null;
    static DlgConflictChoice _iconConflictDlg = null;
    File[] _selectedFiles;
    DBConflict _actionConflict;
    HashMap<String, DBFolder> _hChildren;
    public static final String PROP_DB_IMAG_MAX_LENGTH_DEFAULT = "262144";
    public static final String PROP_DB_IMAG_MAX_LENGTH = "cecilia.db.icon.MaxSize";
    protected static long DB_IMAG_MAX_LENGTH = Math.min(Long.getLong("cecilia.db.icon.MaxSize", Long.parseLong("262144")), Integer.MAX_VALUE);
    ArrayList<GeneralError<DBFolder>> _errors = new ArrayList();

    public DBIconCmdInsert(CAppl appl, DBFolderTreeEditable ctrlTree) {
        super(appl, ctrlTree, false);
    }

    protected static synchronized JFileChooser getIconFileChooser() {
        if (_iconFileChooser == null) {
            _iconFileChooser = new JFileChooser();
            _iconFileChooser.setMultiSelectionEnabled(true);
            FileFilterExtention filter = new FileFilterExtention(ResMsgObj.getString("FILE_IMAGE"), ".gif");
            filter.addExtention(".jpg");
            filter.addExtention(".png");
            _iconFileChooser.setFileFilter(filter);
        }
        return _iconFileChooser;
    }

    protected synchronized DlgConflictChoice getIconConflictDlg(int nbrConflict) {
        if (_iconConflictDlg == null) {
            _iconConflictDlg = new DlgConflictChoice(this._ctrlTree);
        }
        _iconConflictDlg.setNbrConflict(nbrConflict);
        _iconConflictDlg.setChoice(DBConflict.NOTIMPORT);
        return _iconConflictDlg;
    }

    @Override
    protected boolean prepareDo() {
        if (this._dbFolder == null) {
            return false;
        }
        if (!this._dbFolder.isFolder()) {
            return false;
        }
        JFileChooser fileChooser = DBIconCmdInsert.getIconFileChooser();
        int result = fileChooser.showDialog(this._application.getTopWindow(), ResMsgVoc.getString("VOC_SELECT"));
        if (result != 0) {
            return false;
        }
        this._selectedFiles = fileChooser.getSelectedFiles();
        if (this._selectedFiles.length == 0) {
            return false;
        }
        this._hChildren = new HashMap();
        List<DBFolder> lChildren = this._dbFolder.getChildren();
        for (int i = lChildren.size() - 1; i >= 0; --i) {
            DBFolder dbChild = lChildren.get(i);
            this._hChildren.put(dbChild.getName().toLowerCase(), dbChild);
        }
        int nbrConflict = 0;
        for (int i = 0; i < this._selectedFiles.length; ++i) {
            String name = this._selectedFiles[i].getName();
            if (!this._hChildren.containsKey(name.toLowerCase())) continue;
            ++nbrConflict;
        }
        this._actionConflict = DBConflict.NOTIMPORT;
        if (nbrConflict > 0) {
            DlgConflictChoice dlg = this.getIconConflictDlg(nbrConflict);
            dlg.setVisible(true);
            if (!dlg.getResult()) {
                return false;
            }
            this._actionConflict = dlg.getChoice();
            if (this._actionConflict == null) {
                return false;
            }
        }
        return this._actionConflict != DBConflict.NOTIMPORT || nbrConflict != this._selectedFiles.length;
    }

    @Override
    protected void firstDo() {
        ArrayList<DBFolder> lModifs = new ArrayList<DBFolder>();
        for (int idxFile = 0; idxFile < this._selectedFiles.length; ++idxFile) {
            byte[] byteFile;
            String name = this._selectedFiles[idxFile].getName();
            if (this._hChildren.containsKey(name.toLowerCase())) {
                if (this._actionConflict == DBConflict.NOTIMPORT) {
                    this.addError(this._dbFolder, ResMsgObj.msgFormat("ERR_IMAGE_NOTIMPORT", name), MsgType.INFO);
                    continue;
                }
                byteFile = this.readImag(this._selectedFiles[idxFile]);
                if (byteFile == null) {
                    this.addError(this._dbFolder, ResMsgObj.msgFormat("ERR_IMAGE_FORMAT", this._selectedFiles[idxFile]));
                    continue;
                }
                DBFolder dbModel = this._hChildren.get(name.toLowerCase());
                if (dbModel.getChildren() == null) {
                    this._application.getDAOFactory().createFolderDAO().findChildren(dbModel);
                }
                DBFolder dbLastVersion = DBFactory.findLastVersion(dbModel);
                switch (this._actionConflict) {
                    case UPDATE: {
                        DBObject dbObj = dbLastVersion.getObject();
                        if (dbObj.isFreeze()) {
                            this.addError(dbLastVersion, ResMsgObj.msgFormat("MSG_OBJ_ERR_ISFREEZE", name));
                            break;
                        }
                        this.addModelImag(dbObj, this._selectedFiles[idxFile], byteFile);
                        if (!this._application.getDAOFactory().createObjectDAO().update(dbObj)) {
                            this.addError(dbLastVersion, ResMsgObj.msgFormat("ERR_IMAGE_SAVE_DATABASE", name));
                            break;
                        }
                        lModifs.add(dbLastVersion);
                        break;
                    }
                    case NEWVERSION: {
                        String nextVersion = DBFactory.incrementNameVersion(dbLastVersion);
                        DBFolder dbPrepare = DBFactory.createVersion(dbModel, this._dbUser, nextVersion, DBFolder.Family.IMAG, (short)0, (short)0);
                        this.addModelImag(dbPrepare.getObject(), this._selectedFiles[idxFile], byteFile);
                        DBFolder dbCreate = this._application.getDAOFactory().createFolderDAO().create(dbPrepare);
                        if (dbCreate == null) {
                            this.addError(dbPrepare, ResMsgObj.msgFormat("ERR_IMAGE_SAVE_DATABASE", name));
                            break;
                        }
                        dbCreate.setMustBeUpdated(true);
                        lModifs.add(dbCreate);
                    }
                }
                continue;
            }
            byteFile = this.readImag(this._selectedFiles[idxFile]);
            if (byteFile == null) {
                this.addError(this._dbFolder, ResMsgObj.msgFormat("ERR_IMAGE_FORMAT", this._selectedFiles[idxFile]));
                continue;
            }
            DBFolder[] dbPrepare = DBFactory.createModel(this._dbFolder, this._dbUser, name, "1", DBFolder.Family.IMAG, (short)0, (short)0);
            this.addModelImag(dbPrepare[1].getObject(), this._selectedFiles[idxFile], byteFile);
            DBFolder dbCreate = this._application.getDAOFactory().createFolderDAO().create(dbPrepare[0]);
            if (dbCreate == null) {
                this.addError(dbPrepare[0], ResMsgObj.msgFormat("ERR_IMAGE_SAVE_DATABASE", name));
                continue;
            }
            dbCreate.setMustBeUpdated(true);
            lModifs.add(dbCreate);
        }
        if (!lModifs.isEmpty()) {
            this._application.refreshDAOFolder(true);
            SwingUtilities.invokeLater(new DBFolderSelectUtility((DBFolderTree)this._ctrlTree, lModifs));
        }
    }

    protected String findFileExtention(File file) {
        String path = file.getPath();
        int pos = path.lastIndexOf(".");
        if (pos == -1) {
            return null;
        }
        String extention = path.substring(pos + 1);
        if (extention.isEmpty()) {
            return null;
        }
        return extention;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] readImag(File file) {
        Image tkImag;
        String format = this.findFileExtention(file);
        if (format == null) {
            return null;
        }
        if (!((format = format.toUpperCase()).equals(DBObjModel.FORMAT_IMAGE_GIF) || format.equals(DBObjModel.FORMAT_IMAGE_JPG) || format.equals(DBObjModel.FORMAT_IMAGE_PNG))) {
            return null;
        }
        long length = file.length();
        if (length > DB_IMAG_MAX_LENGTH) {
            return null;
        }
        byte[] bytes = new byte[(int)length];
        try (InputStream in = null;){
            in = new BufferedInputStream(new FileInputStream(file));
            in.read(bytes);
        }
        catch (IOException e) {
            e.printStackTrace();
            bytes = null;
        }
        if (bytes != null && (tkImag = Toolkit.getDefaultToolkit().createImage(bytes)) == null) {
            return null;
        }
        return bytes;
    }

    protected boolean addModelImag(DBObject dbObjVersion, File file, byte[] byteFile) {
        String format = this.findFileExtention(file);
        if (format == null) {
            return false;
        }
        DBObjModel model = dbObjVersion.getModel("image");
        if (model == null) {
            model = new DBObjModel().setNature("image");
            dbObjVersion.addModel(model);
        }
        model.setFormat(format.toUpperCase());
        model.setSize(byteFile.length).setStreamToSave(new ByteArrayInputStream(byteFile));
        return true;
    }

    public boolean withWarnning() {
        return !this._errors.isEmpty();
    }

    protected void addError(DBFolder folder, String msg) {
        this._errors.add(new GeneralError<DBFolder>(folder, msg));
    }

    protected void addError(DBFolder folder, String msg, MsgType type) {
        this._errors.add(new GeneralError<DBFolder>(folder, msg, type));
    }

    public List<GeneralError<DBFolder>> getErrors() {
        return this._errors;
    }

    static class DlgConflictChoice
    extends JDialogCecilia {
        JComboBox _ctrlChoice = new JComboBox<DBConflict>(DBConflict.values());
        JLabel _ctrlLabel;

        public DlgConflictChoice(Component owner) {
            super(SwingUtilities.getWindowAncestor(owner), ResMsgObj.getString("TITLE_CONFLICT"), true);
            Dimension size = this._ctrlChoice.getPreferredSize();
            size.width = size.width * 12 / 10;
            this._ctrlChoice.setPreferredSize(size);
            this._ctrlChoice.setRenderer(DBConflict.getListCellRenderer());
            this._ctrlLabel = new JLabel(ResMsgObj.msgFormat("MSG_CONFLICT_QUESTION", 1000));
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)this._ctrlLabel, new GridBagConstraints(0, 0, 1, 1, 100.0, 0.0, 21, 2, new Insets(5, 5, 5, 5), 0, 0));
            panel.add((Component)this._ctrlChoice, new GridBagConstraints(0, 1, 1, 1, 100.0, 0.0, 21, 2, new Insets(5, 5, 5, 5), 0, 0));
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add((Component)panel, "Center");
            this.getContentPane().add((Component)this.createButPanel(), "South");
            this.init();
            this.pack();
            this.setLocationRelativeTo(this.getParent());
        }

        public void setNbrConflict(int nbrConflict) {
            this._ctrlLabel.setText(ResMsgObj.msgFormat("MSG_CONFLICT_QUESTION", nbrConflict));
        }

        public void setChoice(DBConflict value) {
            this._ctrlChoice.setSelectedItem((Object)value);
        }

        public DBConflict getChoice() {
            return (DBConflict)((Object)this._ctrlChoice.getSelectedItem());
        }

        @Override
        protected boolean verifyParameters() {
            return true;
        }
    }
}

