/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.general.ihm;

import com.dassault.cecilia.core.cecilia.action.DelegateAction;
import com.dassault.cecilia.dbobj.general.ihm.IPanelWithSelection;
import com.dassault.cecilia.main.cecilia.CeciliaGUI;
import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.function.Function;
import javax.swing.AbstractAction;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;

public interface IPanelWithZoom
extends IPanelWithSelection {
    public double getZoom();

    public void setZoom(double var1);

    default public JComboBox getGUIZoom() {
        return (JComboBox)this.getGUI().getComponentAction("ZOOM_EDITOR");
    }

    public static class ZoomDecorator {
        private IPanelWithZoom _panelZoom;
        private static double[] ZOOM_LEVEL = new double[]{0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0, 1.25, 1.5, 1.75, 2.0, 2.25, 2.5, 3.0, 3.5, 4.0};
        AbstractAction _actionZoomInc = this.createActionZoom(true);
        AbstractAction _actionZoomDec = this.createActionZoom(false);
        ItemListener _listenerZoomEditor = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 2) {
                    return;
                }
                String input = _panelZoom.getGUIZoom().getSelectedItem().toString();
                if (input.endsWith("%")) {
                    input = input.substring(0, input.lastIndexOf("%"));
                }
                double oldZoom = _panelZoom.getZoom();
                double zoom = Double.NaN;
                try {
                    zoom = Double.parseDouble(input);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (Double.isNaN(zoom)) {
                    return;
                }
                if ((zoom /= 100.0) == _panelZoom.getZoom()) {
                    return;
                }
                if (zoom > ZOOM_LEVEL[ZOOM_LEVEL.length - 1]) {
                    zoom = ZOOM_LEVEL[ZOOM_LEVEL.length - 1];
                } else if (zoom < ZOOM_LEVEL[0]) {
                    zoom = ZOOM_LEVEL[0];
                }
                _panelZoom.setZoom(zoom);
                this.updateZoomView(null, oldZoom < zoom, zoom / oldZoom);
                _panelZoom.getGUIZoom().setSelectedItem(Integer.toString((int)(zoom * 100.0)) + "%");
                this.refreshScroll(false);
            }
        };

        public ZoomDecorator(IPanelWithZoom panelZoom) {
            this._panelZoom = panelZoom;
        }

        public void refreshScroll(boolean raz) {
            if (raz) {
                this._panelZoom.getScrollView().getHorizontalScrollBar().setValue(0);
                this._panelZoom.getScrollView().getVerticalScrollBar().setValue(0);
            }
            this._panelZoom.getScrollView().doLayout();
            this._panelZoom.getScrollView().repaint();
        }

        private void doZoom(Function<Double, Double> zoomFct) {
            double zoom = this._panelZoom.getZoom();
            zoom = zoomFct.apply(zoom);
            this._panelZoom.setZoom(zoom);
            if (this._panelZoom.getGUIZoom() != null) {
                this._panelZoom.getGUIZoom().setSelectedItem(Integer.toString((int)(zoom * 100.0)) + "%");
            }
            this.refreshScroll(false);
        }

        private void doZoomInc() {
            this.doZoom(zoom -> {
                for (int i = 0; i < ZOOM_LEVEL.length - 1; ++i) {
                    if (!(zoom <= ZOOM_LEVEL[i])) continue;
                    return ZOOM_LEVEL[i + 1];
                }
                return zoom;
            });
        }

        private void doZoomDec() {
            this.doZoom(zoom -> {
                for (int i = ZOOM_LEVEL.length - 1; i >= 1; --i) {
                    if (!(zoom >= ZOOM_LEVEL[i])) continue;
                    zoom = ZOOM_LEVEL[i - 1];
                    break;
                }
                return zoom;
            });
        }

        private AbstractAction createActionZoom(final boolean increase) {
            return new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    double oldZoom = _panelZoom.getZoom();
                    if (increase) {
                        this.doZoomInc();
                    } else {
                        this.doZoomDec();
                    }
                    double newZoom = _panelZoom.getZoom();
                    if (oldZoom != newZoom) {
                        this.updateZoomView(null, increase, newZoom / oldZoom);
                    }
                }
            };
        }

        protected void updateZoomView(MouseWheelEvent event, boolean isZooming, double ratio) {
            boolean withGraphs;
            Rectangle rectToSetVisible;
            int xMouse = event != null ? event.getX() : -1;
            int yMouse = event != null ? event.getY() : -1;
            JScrollPane scrollPane = this._panelZoom.getScrollView();
            JComponent contentView = this._panelZoom.getContentView();
            JViewport vp = scrollPane.getViewport();
            Rectangle rectangle = rectToSetVisible = vp == null ? new Rectangle() : vp.getViewRect();
            if (isZooming) {
                contentView.scrollRectToVisible(rectToSetVisible);
                contentView.repaint();
            }
            scrollPane.revalidate();
            int newVertLocSB = -1;
            int newHoriLocSB = -1;
            double halfHeightVertBar = scrollPane.getVerticalScrollBar().getSize().getHeight() / 2.0;
            double halfWidthHoriBar = scrollPane.getHorizontalScrollBar().getSize().getWidth() / 2.0;
            Rectangle selectedGraphRectangle = this._panelZoom.getSelectionRect();
            boolean bl = withGraphs = selectedGraphRectangle != null;
            if (withGraphs) {
                this._panelZoom.locateOnGraphs();
                return;
            }
            if (xMouse != -1 && yMouse != -1) {
                double locX = (vp.getViewRect().getX() + (double)xMouse) * ratio;
                double locY = (vp.getViewRect().getY() + (double)yMouse) * ratio;
                newHoriLocSB = (int)Math.max(locX - halfWidthHoriBar, 0.0);
                newVertLocSB = (int)Math.max(locY - halfHeightVertBar, 0.0);
            } else {
                double middleWidth = (double)contentView.getWidth() / 2.0;
                double middleHeight = (double)contentView.getHeight() / 2.0;
                newHoriLocSB = (int)(middleWidth - halfWidthHoriBar);
                newVertLocSB = (int)(middleHeight - halfHeightVertBar);
            }
            scrollPane.getViewport().setViewPosition(new Point(newHoriLocSB, newVertLocSB));
        }

        public JScrollPane createScrollPane() {
            JScrollPane scrollView = new JScrollPane(this._panelZoom.getContentView(), 20, 30);
            scrollView.getViewport().setScrollMode(0);
            scrollView.addMouseWheelListener(new MouseWheelListener(){

                @Override
                public void mouseWheelMoved(MouseWheelEvent e) {
                    Container parent = SwingUtilities.getAncestorOfClass(JInternalFrame.class, _panelZoom.getContentView());
                    if (parent != null && parent instanceof JInternalFrame && !((JInternalFrame)parent).isSelected()) {
                        return;
                    }
                    if (e.isControlDown()) {
                        int rotation = e.getWheelRotation();
                        double oldZoom = _panelZoom.getZoom();
                        if (rotation > 0) {
                            this.doZoomDec();
                            e.consume();
                        } else if (rotation < 0) {
                            this.doZoomInc();
                            e.consume();
                        }
                        double newZoom = _panelZoom.getZoom();
                        if (oldZoom != newZoom) {
                            this.updateZoomView(e, rotation < 0, newZoom / oldZoom);
                        }
                    }
                }
            });
            return scrollView;
        }

        public void toDoWhenDeActivated() {
            this.doActivate(false);
        }

        public void toDoWhenActivated() {
            this.doActivate(true);
        }

        private void doActivate(boolean activate) {
            CeciliaGUI gui = this._panelZoom.getGUI();
            DelegateAction actionZoomInc = gui.getDelegateAction("ZOOM_INC");
            DelegateAction actionZoomDec = gui.getDelegateAction("ZOOM_DEC");
            if (activate) {
                actionZoomInc.addDelegate(this._actionZoomInc);
                actionZoomDec.addDelegate(this._actionZoomDec);
            } else {
                actionZoomInc.delDelegate(this._actionZoomInc);
                actionZoomDec.delDelegate(this._actionZoomDec);
            }
            actionZoomInc.setEnabled(activate);
            actionZoomDec.setEnabled(activate);
            JComboBox cb = this._panelZoom.getGUIZoom();
            cb.setSelectedItem(activate ? Integer.toString((int)(this._panelZoom.getZoom() * 100.0)) + "%" : "");
            cb.setEnabled(activate);
            if (activate) {
                cb.addItemListener(this._listenerZoomEditor);
            } else {
                cb.removeItemListener(this._listenerZoomEditor);
            }
        }
    }
}

