/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.general.law;

import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.dbobj.general.law.Law;
import com.dassault.cecilia.dbobj.general.law.Param;
import com.dassault.cecilia.dbobj.general.law.ParamFMEA;
import com.dassault.cecilia.dbobj.general.law.ParamLaw;
import com.dassault.cecilia.dbobj.general.law.ParamRef;
import com.dassault.cecilia.dbobj.general.law.ParamValue;
import com.dassault.cecilia.lib.util.format.DoubleFormat;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;

public interface LawFormat {
    public static final LawFormat DEFAULT = new DefaultLawFormat();

    public String format(Law var1, DoubleFormat var2);

    public boolean format(Law var1, DoubleFormat var2, Appendable var3) throws IOException;

    public boolean format(Law var1, DoubleFormat var2, StringBuilder var3);

    public String format(Param var1, DoubleFormat var2);

    public boolean format(Param var1, DoubleFormat var2, Appendable var3) throws IOException;

    public boolean format(Param var1, DoubleFormat var2, StringBuilder var3);

    public static class DefaultLawFormat
    implements LawFormat {
        public String getSeparatorBegin() {
            return " ";
        }

        public String getSeparator() {
            return " ";
        }

        public String getSeparatorEnd() {
            return "";
        }

        public String format(String id) {
            return id;
        }

        @Override
        public final String format(Law law, DoubleFormat dblFormat) {
            StringBuilder buffer = new StringBuilder();
            this.format(law, dblFormat, buffer);
            return buffer.toString();
        }

        @Override
        public boolean format(Law law, DoubleFormat dblFormat, Appendable out) throws IOException {
            StringBuilder buffer = new StringBuilder();
            boolean result = this.format(law, dblFormat, buffer);
            out.append(buffer.toString());
            return result;
        }

        @Override
        public boolean format(Law law, DoubleFormat dblFormat, StringBuilder out) {
            return this.doFormat(dblFormat, out, law.getModifierLaw(), law.getManager().getLaw(law.getID()).getExportDag(), law.getReadOnlyParameters());
        }

        protected boolean doFormat(DoubleFormat dblFormat, StringBuilder out, Law modiferLaw, String exportDag, List<Param> params) {
            if (modiferLaw != null) {
                if (!this.format(modiferLaw, dblFormat, out)) {
                    return false;
                }
                out.append(" ");
            }
            out.append(this.format(exportDag));
            out.append(this.getSeparatorBegin());
            Iterator<Param> iParam = params.iterator();
            while (iParam.hasNext()) {
                if (!this.format(iParam.next(), dblFormat, out)) {
                    return false;
                }
                if (!iParam.hasNext()) continue;
                out.append(this.getSeparator());
            }
            out.append(this.getSeparatorEnd());
            return true;
        }

        @Override
        public String format(Param param, DoubleFormat dblFormat) {
            StringBuilder out = new StringBuilder();
            this.format(param, dblFormat, out);
            return out.toString();
        }

        @Override
        public boolean format(Param param, DoubleFormat dblFormat, Appendable out) throws IOException {
            StringBuilder buffer = new StringBuilder();
            boolean result = this.format(param, dblFormat, buffer);
            out.append(buffer.toString());
            return result;
        }

        @Override
        public boolean format(Param param, DoubleFormat dblFormat, StringBuilder out) {
            if (param instanceof ParamValue) {
                double value = ((ParamValue)param).getValue();
                if (value != Double.MIN_VALUE) {
                    out.append(dblFormat.format(value));
                }
                return true;
            }
            if (param instanceof ParamLaw) {
                Law law = ((ParamLaw)param).getValue();
                if (this.format(law, dblFormat, out)) {
                    return true;
                }
            } else {
                if (param instanceof ParamRef) {
                    DBFolder dbFolder = ((ParamRef)param).getValue();
                    if (dbFolder == null) {
                        out.append("'???'");
                    } else {
                        out.append("'").append(dbFolder.getRefPath()).append("'");
                    }
                    return true;
                }
                if (param instanceof ParamFMEA) {
                    DBFolder dbFolder = ((ParamFMEA)param).getDBFolder();
                    if (dbFolder == null) {
                        out.append("'???'");
                    } else {
                        out.append(dblFormat.format(((ParamFMEA)param).getValueAttribute()));
                        out.append(ParamFMEA.FLAG_FMEA);
                    }
                    return true;
                }
            }
            return false;
        }
    }
}

