/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.general.log;

import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBObjModel;
import com.dassault.cecilia.db.DBObjProperty;
import com.dassault.cecilia.db.DBRelation;
import com.dassault.cecilia.db.DBUser;
import com.dassault.cecilia.db.IUser;
import com.dassault.cecilia.db.IWrap;
import com.dassault.cecilia.db.dao.DAOFactory;
import com.dassault.cecilia.db.dao.DAOObjModel;
import com.dassault.cecilia.dbobj.demo.DemoLimitedException;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.general.log.io.DBLogsHandlerXml;
import com.dassault.cecilia.lib.util.xmlparser.SAXExtendedHandler;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Locator;
import org.xml.sax.helpers.DefaultHandler;

public abstract class DBLogsWrap
implements IWrap {
    private static Logger _LOG = Logger.getLogger(DBLogsWrap.class.getPackage().getName());
    protected DBFolder _dbFolder;
    protected DBLogs _dbLogs;

    protected Logger getJavaLog() {
        return _LOG;
    }

    protected boolean logMsg(String msg, Level lvl) {
        this.getJavaLog().log(lvl, this._dbFolder.getPathUntilSystem(new StringBuilder(msg).append(" : ")).toString());
        return false;
    }

    public DBLogsWrap(DBFolder folder) {
        this._dbFolder = folder;
        this._dbLogs = new DBLogs();
    }

    protected void copy(DBLogsWrap src) {
        this._dbLogs = src.getLogs().getCopy();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DBLogsWrap)) {
            return false;
        }
        DBLogsWrap other = (DBLogsWrap)obj;
        if (this._dbFolder == null) {
            return other.getDBFolder() == null;
        }
        return this._dbFolder.equals(other.getDBFolder());
    }

    public int hashCode() {
        if (this._dbFolder == null) {
            return 7;
        }
        return this._dbFolder.hashCode();
    }

    @Override
    public DBFolder getDBFolder() {
        return this._dbFolder;
    }

    public DBLogs getLogs() {
        return this._dbLogs;
    }

    public short getFamilyFlag() {
        return this.getDBFolder().getFamilyFlag();
    }

    public DBFolder.Family getFamily() {
        return this.getDBFolder().getFamily();
    }

    protected final boolean verifyLegacyFolder() {
        if (this._dbFolder == null) {
            throw new NullPointerException();
        }
        if (this._dbFolder.getFamily() != this.getFamily()) {
            return this.logMsg("Le DBFolder n'est pas de la bonne famille '" + (Object)((Object)this.getFamily()) + "'", Level.INFO);
        }
        if (this.getFamilyFlag() > 0 && this._dbFolder.getFamilyFlag() != this.getFamilyFlag()) {
            return this.logMsg("Le DBFolder n'est pas de la bonne sous-famille '" + this.getFamilyFlag() + "'", Level.INFO);
        }
        if (this._dbFolder.getObject() == null) {
            return this.logMsg("Le DBFolder n'a pas d'objet", Level.INFO);
        }
        return true;
    }

    protected boolean verifyFolder() {
        if (!this.verifyLegacyFolder()) {
            return false;
        }
        if (!this._dbFolder.isVersion()) {
            return this.logMsg("Le DBFolder n'est pas une version", Level.INFO);
        }
        return true;
    }

    protected void readXml(InputStream input, SAXExtendedHandler handler) throws IOException {
        try {
            SAXParserFactory fabrique = SAXParserFactory.newInstance();
            SAXParser parseur = fabrique.newSAXParser();
            parseur.parse(input, (DefaultHandler)handler);
        }
        catch (IOException e) {
            _LOG.log(Level.INFO, "le parseur XML a eu un probleme", e);
            throw e;
        }
        catch (DemoLimitedException e) {
            throw e;
        }
        catch (Exception e) {
            StringBuffer sb = new StringBuffer();
            sb.append(ResMsgCore.getString("MSG_ERR_DBMOD_XML_GENERIC")).append("\n");
            Locator loc = handler.getLocator();
            if (loc != null) {
                sb.append("in [line = ");
                sb.append(loc.getLineNumber());
                sb.append("] [col = ");
                sb.append(loc.getColumnNumber());
                sb.append("]\n");
            }
            sb.append(e.getMessage());
            _LOG.log(Level.INFO, sb.toString(), e);
            throw new IOException(sb.toString());
        }
    }

    public boolean readLogs(DAOFactory cecFactory) {
        if (!this.verifyFolder()) {
            return false;
        }
        String nature = "logs";
        DBObjModel modelLogs = this._dbFolder.getObject().getModel(nature);
        if (modelLogs != null) {
            String format = modelLogs.getFormat();
            if (!"ZML".equals(format) && !"XML".equals(format)) {
                return this.logMsg(ResMsgCore.msgFormat("MSG_ERR_DBMOD_FORMAT", nature, format), Level.INFO);
            }
            InputStream istream = cecFactory.createObjModelDAO().getBinaryStream(modelLogs);
            if (istream == null) {
                return this.logMsg(ResMsgCore.getString("MSG_ERR_DBMOD_READ"), Level.INFO);
            }
            if ("ZML".equals(format)) {
                istream = new InflaterInputStream(istream, new Inflater());
            }
            DBLogsHandlerXml saxHanlder = new DBLogsHandlerXml(null);
            try {
                this.readXml(istream, saxHanlder);
                this._dbLogs = saxHanlder.getLogs();
                return true;
            }
            catch (IOException e) {
                _LOG.log(Level.INFO, this._dbFolder.getPathUntilSystem(new StringBuilder(e.getMessage()).append(" : ")).toString(), e);
                return false;
            }
        }
        return true;
    }

    protected DBLogs.DBLogsManager createReadLogsManager(String login) {
        return new WrapLogsManager(login);
    }

    public boolean readFromDAO(DAOFactory cecFactory) {
        DBLogs.DBLogsManager logMng = this.createReadLogsManager(cecFactory.getUserLogin());
        if (!this.readLogs(cecFactory)) {
            logMng.addLog(DBLogs.DBLevel.ERROR, ResMsgCore.getString("MSG_ERR_DBMOD_STRUCTURAL"));
            return false;
        }
        return true;
    }

    protected DBObjModel writeLogs(DBObjModel model, String nature) {
        StringWriter iwriter = new StringWriter();
        try {
            iwriter.append("<?xml version='1.0'?>\n");
            this._dbLogs.toXML(iwriter, "");
        }
        catch (IOException e) {
            _LOG.log(Level.SEVERE, "Soucis lors de la sauvegarde de '" + nature + "' ...", e);
            return null;
        }
        byte[] ibyte = DAOObjModel.convertToCompressedByte(new ByteArrayInputStream(iwriter.toString().getBytes(StandardCharsets.UTF_8)));
        if (ibyte == null) {
            _LOG.warning("Probleme lors de la compression du flux.");
            return null;
        }
        if (model == null) {
            model = new DBObjModel();
            model.setNature(nature);
        }
        model.setFormat("ZML");
        model.setEncoding("UTF-8");
        model.setSize(ibyte.length);
        model.setStreamToSave(new ByteArrayInputStream(ibyte));
        return model;
    }

    public final DBObjModel writeDBObjLogs(boolean updateIfExist) {
        DBObjModel current = null;
        if (updateIfExist) {
            current = this._dbFolder.getObject().getModel("logs");
        }
        return this.writeLogs(current, "logs");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeToDAO(DAOFactory cecFactory, DBUser dbModifyUser) {
        DBObjModel oldLogs;
        DBObjModel newLogs;
        if (!this.verifyFolder()) {
            return false;
        }
        long oldRelease = Long.MIN_VALUE;
        DBObjProperty releaseProperty = this._dbFolder.getObject().getProperty("object.release");
        if (releaseProperty == null) {
            releaseProperty = new DBObjProperty().setName("object.release").setType("Long").setValue("1");
        } else {
            oldRelease = DBObjProperty.getObjectRelease(releaseProperty);
        }
        DBLogs.Log saveLog = null;
        if (dbModifyUser != null) {
            saveLog = this._dbLogs.addLog(new Date(), dbModifyUser.getLogin(), DBLogs.DBLevel.FINEST, ResMsgCore.msgFormat("MSG_LOG_SAVE", oldRelease == Long.MIN_VALUE ? 1L : oldRelease + 1L, "6.2.1"));
        }
        if ((newLogs = this.writeLogs(oldLogs = this._dbFolder.getObject().getModel("logs"), "logs")) == null) {
            return false;
        }
        this._dbFolder.getObject().addModel(newLogs);
        IUser oldModifyUser = this._dbFolder.getUserModify();
        Date oldModifyDate = this._dbFolder.getDateModify();
        if (oldRelease == Long.MIN_VALUE) {
            this._dbFolder.getObject().addProperty(releaseProperty);
        } else {
            releaseProperty.setValue(Long.toString(oldRelease + 1L));
        }
        Collection<DBRelation> relations = this.getUseRelations();
        if (dbModifyUser != null) {
            this._dbFolder.setUserModify(dbModifyUser);
            this._dbFolder.setDateModify(new Date());
        }
        this._dbFolder.setRelations(relations);
        boolean result = false;
        try {
            if (cecFactory.createFolderDAO().update(this._dbFolder)) {
                cecFactory.createObjectDAO().putWrap(this._dbFolder.getObject(), null);
                result = true;
            }
        }
        finally {
            this._dbFolder.setRelations(null);
            if (!result) {
                if (oldRelease == Long.MIN_VALUE) {
                    this._dbFolder.getObject().delProperty(releaseProperty);
                } else {
                    releaseProperty.setValue(Long.toString(oldRelease));
                }
                this._dbFolder.setUserModify(oldModifyUser);
                this._dbFolder.setDateModify(oldModifyDate);
                if (saveLog != null) {
                    this._dbLogs.removeLog(saveLog);
                }
                if (oldLogs == null) {
                    // empty if block
                }
            }
        }
        return result;
    }

    protected class WrapLogsManager
    implements DBLogs.DBLogsManager {
        String _login;
        Logger _logger;

        WrapLogsManager(String login) {
            this._login = login;
            this._logger = DBLogsWrap.this.getJavaLog();
        }

        public WrapLogsManager(String login, Logger logger) {
            this._login = login;
            this._logger = logger;
        }

        @Override
        public void addLog(DBLogs.DBLevel dbLvl, String msg, boolean bPrivate) {
            DBLogsWrap.this._dbLogs.addLog(new Date(), this._login, dbLvl, msg).setPrivate(bPrivate);
            StringBuilder buffer = new StringBuilder(msg).append(" : ");
            DBLogsWrap.this._dbFolder.getPathUntilSystem(buffer);
            this._logger.log(dbLvl.getJavaLevel(), buffer.toString());
        }

        @Override
        public boolean withLogs(DBLogs.DBLevel limit) {
            return DBLogsWrap.this._dbLogs.withLogs(limit);
        }

        @Override
        public void addLog(DBLogs.Log log) {
            DBLogsWrap.this._dbLogs.addLog(log);
        }
    }
}

