/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.general.log.gui;

import com.dassault.cecilia.core.ResIcoCore;
import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.Util;
import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.core.cecilia.folder.FolderRenderer;
import com.dassault.cecilia.core.swing.CeciliaAction;
import com.dassault.cecilia.core.swing.JDialogCecilia;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.core.swing.table.JTableTransfertHandler;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.dbobj.ResMsgObj;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.general.log.gui.DBLogEditDlg;
import com.dassault.cecilia.lib.util.format.Convertable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.HeadlessException;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;

public class DBLogsDlg
extends JDialogCecilia {
    protected static DateFormat _formatDate = new SimpleDateFormat("YYYY-MM-dd HH:mm:ss");
    boolean _isModified;
    String _user = "???";
    DBFolder _dbFolder = null;
    DBLogs _dbLogs;
    Map<DBFolder, List<DBLogs.Log>> _dependLogs;
    DBLogs.DBLevel _levelFilter;
    List<DBLogs.Log> _listLogs;
    List<DBFolder> _listFolders;
    DBLogsTableModel _tableModel = new DBLogsTableModel();
    JTable _ctrlTable;
    Color _backUnselect;
    Color _backUnselectReadOnly;
    Color _backSelect;
    Color _backSelectReadOnly;
    CeciliaAction _actAdd;
    CeciliaAction _actEdit;
    CeciliaAction _actDeclassified;
    DBLogEditDlg _logDlg;
    JComboBox _ctrlFilter;

    public DBLogsDlg(Window owner, DBLogs.DBLevel levelFilter) throws HeadlessException {
        super(owner, ResMsgCore.getString("TITLE_LOGS"), true);
        this._dbLogs = new DBLogs();
        this._levelFilter = levelFilter;
        this._listLogs = this._dbLogs.getLogs(this._levelFilter);
        this._listFolders = new ArrayList<DBFolder>();
        this.make();
        this.pack();
        this.setLocationRelativeTo(JOptionCecilia.getTopContainerOf(this));
    }

    @Override
    public void dispose() {
        if (this._logDlg != null) {
            DBLogEditDlg tmp = this._logDlg;
            this._logDlg = null;
            tmp.dispose();
        }
    }

    public void setDBLogs(DBLogs dbLogs, DBFolder dbFolder, String user) {
        this._isModified = false;
        this._user = user;
        this._dbLogs = dbLogs;
        this._dbFolder = dbFolder;
    }

    public void addDependLogs(Map<DBFolder, List<DBLogs.Log>> dependLogs) {
        this._dependLogs = dependLogs;
    }

    public void refreshData() {
        this.refreshData(null);
    }

    public int getNbrLogs() {
        this.refreshData(null);
        return this._listLogs.size();
    }

    protected void refreshData(Collection<DBLogs.Log> selectLogs) {
        int size;
        this._listLogs = this._dbLogs.getLogs(this._levelFilter);
        this._listFolders = new ArrayList<DBFolder>(size);
        for (size = this._listLogs.size(); size > 0; --size) {
            this._listFolders.add(this._dbFolder);
        }
        if (this._dependLogs != null && this._dependLogs.size() > 0) {
            for (Map.Entry<DBFolder, List<DBLogs.Log>> depend : this._dependLogs.entrySet()) {
                List<DBLogs.Log> dbLogs = depend.getValue();
                for (int i = 0; i < dbLogs.size(); ++i) {
                    DBLogs.Log log = dbLogs.get(i);
                    if (log.getLevel().compareTo(this._levelFilter) < 0) continue;
                    this._listLogs.add(log);
                    this._listFolders.add(depend.getKey());
                }
            }
        }
        this._tableModel.fireTableDataChanged();
        if (selectLogs != null && !selectLogs.isEmpty()) {
            ListSelectionModel selectModel = this._ctrlTable.getSelectionModel();
            selectModel.clearSelection();
            for (int i = this._listLogs.size() - 1; i >= 0; --i) {
                if (!selectLogs.contains(this._listLogs.get(i))) continue;
                int idxView = this._ctrlTable.convertRowIndexToView(i);
                selectModel.addSelectionInterval(idxView, idxView);
            }
        }
        this.changeSelect();
    }

    private void make() {
        JScrollPane scroll = new JScrollPane(this.createTable());
        scroll.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add(this.createToolbar(), "North");
        this.getContentPane().add((Component)scroll, "Center");
        this.getContentPane().add((Component)this.createButPanelClose(false), "South");
        this.init();
    }

    public boolean isModified() {
        return this._isModified;
    }

    public void setModified(boolean modified) {
        this._isModified = modified;
    }

    private void prepareRenderer(JComponent renderer, boolean isSelected, boolean hasFocus, int row) {
        int rowModel = this._ctrlTable.convertRowIndexToModel(row);
        DBFolder dbFolder = this._listFolders.get(rowModel);
        if (dbFolder == null || !dbFolder.equals(this._dbFolder)) {
            if (isSelected) {
                renderer.setBackground(this._backSelectReadOnly);
            } else {
                renderer.setBackground(this._backUnselectReadOnly);
            }
        } else if (isSelected) {
            renderer.setBackground(this._backSelect);
        } else {
            renderer.setBackground(this._backUnselect);
        }
    }

    private JTable createTable() {
        this._ctrlTable = new DBLogsTable(this._tableModel);
        FolderRenderer folderRenderer = new FolderRenderer(){

            @Override
            protected String convertFolderToText(DBFolder dbFolder) {
                if (dbFolder.equals(DBLogsDlg.this._dbFolder)) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("<HTML><I>").append(dbFolder.getRefPath()).append("</I></HTML>");
                    return sb.toString();
                }
                return dbFolder.getRefPath();
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                DBLogsDlg.this.prepareRenderer(this, isSelected, hasFocus, row);
                return this;
            }
        };
        this._backUnselect = this._ctrlTable.getBackground();
        this._backUnselectReadOnly = this._backUnselect.darker();
        this._backSelect = this._ctrlTable.getSelectionBackground();
        this._backSelectReadOnly = this._backSelect.brighter();
        TableColumn column = null;
        block7: for (int i = 0; i < this._tableModel.getColumnCount(); ++i) {
            column = this._ctrlTable.getColumnModel().getColumn(i);
            switch (i) {
                case 0: {
                    column.setPreferredWidth(200);
                    column.setCellRenderer(folderRenderer);
                    continue block7;
                }
                case 1: {
                    column.setPreferredWidth(75);
                    column.setCellRenderer(new DBLogs.DBLevel.TableDBLevelRenderer(){

                        @Override
                        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
                            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
                            DBLogsDlg.this.prepareRenderer(this, isSelected, hasFocus, row);
                            return this;
                        }
                    });
                    continue block7;
                }
                case 2: {
                    column.setPreferredWidth(120);
                    column.setCellRenderer(new DefaultTableCellRenderer(){

                        @Override
                        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
                            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
                            if (value instanceof Date) {
                                this.setText(_formatDate.format((Date)value));
                            }
                            DBLogsDlg.this.prepareRenderer(this, isSelected, hasFocus, row);
                            return this;
                        }
                    });
                    continue block7;
                }
                case 3: {
                    column.setPreferredWidth(50);
                    column.setCellRenderer(new DefaultTableCellRenderer(){

                        @Override
                        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
                            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
                            DBLogsDlg.this.prepareRenderer(this, isSelected, hasFocus, row);
                            return this;
                        }
                    });
                    continue block7;
                }
                case 4: {
                    column.setPreferredWidth(400);
                    column.setCellRenderer(new DefaultTableCellRenderer(){

                        @Override
                        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
                            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
                            String text = value.toString().trim();
                            if (!text.isEmpty()) {
                                if (text.contains("\n")) {
                                    StringBuilder sb = new StringBuilder(text.length() + 128);
                                    sb.append("<html>");
                                    try {
                                        if (text.length() < 4096) {
                                            Util.appendForHtml(sb, text);
                                        } else {
                                            Util.appendForHtml(sb, text.substring(0, 4096)).append("BR");
                                        }
                                    }
                                    catch (IOException iOException) {
                                        // empty catch block
                                    }
                                    sb.append("</html>");
                                    this.setToolTipText(sb.toString());
                                } else {
                                    this.setToolTipText(text);
                                }
                            }
                            DBLogsDlg.this.prepareRenderer(this, isSelected, hasFocus, row);
                            return this;
                        }
                    });
                }
            }
        }
        TableRowSorter<TableModel> sorter = new TableRowSorter<TableModel>(this._ctrlTable.getModel());
        this._ctrlTable.setRowSorter(sorter);
        ArrayList<RowSorter.SortKey> sortKeys = new ArrayList<RowSorter.SortKey>();
        sortKeys.add(new RowSorter.SortKey(2, SortOrder.DESCENDING));
        sorter.setSortKeys(sortKeys);
        this._ctrlTable.setPreferredScrollableViewportSize(new Dimension(800, 250));
        this._ctrlTable.getSelectionModel().setSelectionMode(2);
        this._ctrlTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                DBLogsDlg.this.changeSelect();
            }
        });
        this._ctrlTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() <= 1) {
                    return;
                }
                if (!SwingUtilities.isLeftMouseButton(e)) {
                    return;
                }
                DBLogsDlg.this._actEdit.actionPerformed(new ActionEvent(DBLogsDlg.this._ctrlTable, 0, ""));
            }
        });
        this._ctrlTable.setTransferHandler(new JTableTransfertHandler());
        return this._ctrlTable;
    }

    private void changeSelect() {
        if (this._actEdit == null) {
            return;
        }
        if (this._ctrlTable.getSelectedRowCount() < 1) {
            this._actEdit.setEnabled(false);
            this._actDeclassified.setEnabled(false);
        } else {
            int nbr = 0;
            boolean edit = false;
            int[] idxView = this._ctrlTable.getSelectedRows();
            for (int i = 0; i < idxView.length; ++i) {
                int idxModel = this._ctrlTable.convertRowIndexToModel(idxView[i]);
                DBLogs.Log log = this._listLogs.get(idxModel);
                if (log.getLevel() == DBLogs.DBLevel.FINEST) continue;
                edit = true;
                if (!this._listFolders.get(idxModel).equals(this._dbFolder) || log.isPrivate()) continue;
                ++nbr;
            }
            this._actEdit.setEnabled(edit);
            this._actDeclassified.setEnabled(nbr > 0);
        }
    }

    private Component createToolbar() {
        this._ctrlFilter = new JComboBox();
        this._ctrlFilter.addItem(DBLogs.DBLevel.INIT);
        this._ctrlFilter.addItem(DBLogs.DBLevel.ERROR);
        this._ctrlFilter.addItem(DBLogs.DBLevel.WARNING);
        this._ctrlFilter.addItem(DBLogs.DBLevel.INFO);
        this._ctrlFilter.addItem(DBLogs.DBLevel.FINE);
        this._ctrlFilter.addItem(DBLogs.DBLevel.FINER);
        this._ctrlFilter.addItem(DBLogs.DBLevel.FINEST);
        this._ctrlFilter.setEditable(false);
        this._ctrlFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DBLogsDlg.this._levelFilter = (DBLogs.DBLevel)((Object)DBLogsDlg.this._ctrlFilter.getSelectedItem());
                DBLogsDlg.this.refreshData(null);
            }
        });
        this._ctrlFilter.setSelectedItem((Object)this._levelFilter);
        this._ctrlFilter.setRenderer(DBLogs.DBLevel.getListCellRenderer());
        this._actAdd = new CeciliaAction(ResIcoCore.getImageIcon("BUT_ADD"), ResMsgVoc.getString("VOC_ADD")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DBLogsDlg.this._logDlg == null) {
                    DBLogsDlg.this._logDlg = new DBLogEditDlg((Window)DBLogsDlg.this);
                }
                DBLogsDlg.this._logDlg.prepareDlg(null, false);
                DBLogsDlg.this._logDlg.setVisible(true);
                if (!DBLogsDlg.this._logDlg.getResult()) {
                    return;
                }
                DBLogs.Log dbLog = DBLogsDlg.this._dbLogs.addLog(new Date(), DBLogsDlg.this._user, DBLogsDlg.this._logDlg.getLevel(), DBLogsDlg.this._logDlg.getMsg());
                DBLogsDlg.this.refreshData(Collections.singleton(dbLog));
                DBLogsDlg.this._isModified = true;
            }
        };
        this._actEdit = new CeciliaAction(ResIcoCore.getImageIcon("BUT_EDIT"), ResMsgVoc.getString("VOC_EDIT")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DBLogsDlg.this._ctrlTable.getSelectedRowCount() != 1) {
                    return;
                }
                int idxView = DBLogsDlg.this._ctrlTable.getSelectedRow();
                int idxModel = DBLogsDlg.this._ctrlTable.convertRowIndexToModel(idxView);
                DBLogs.Log dbLog = DBLogsDlg.this._listLogs.get(idxModel);
                if (DBLogsDlg.this._logDlg == null) {
                    DBLogsDlg.this._logDlg = new DBLogEditDlg((Window)DBLogsDlg.this);
                }
                DBLogsDlg.this._logDlg.prepareDlg(dbLog, !DBLogsDlg.this._listFolders.get(idxModel).equals(DBLogsDlg.this._dbFolder));
                DBLogsDlg.this._logDlg.setVisible(true);
                if (!DBLogsDlg.this._logDlg.getResult()) {
                    return;
                }
                if (DBLogsDlg.this._logDlg.getLevel() == dbLog.getLevel()) {
                    return;
                }
                DBLogsDlg.this._dbLogs.changeLog(dbLog, DBLogsDlg.this._logDlg.getLevel());
                DBLogsDlg.this.refreshData(Collections.singleton(dbLog));
                DBLogsDlg.this._isModified = true;
            }
        };
        this._actDeclassified = new CeciliaAction(ResIcoCore.getImageIcon("BUT_DECLASSIFIED"), ResMsgObj.getString("DLG_LOG_DECLASSIFIED")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DBLogsDlg.this._ctrlTable.getSelectedRowCount() < 1) {
                    return;
                }
                DBLogs.DBLevel curLevel = DBLogs.DBLevel.FINEST;
                int[] idxView = DBLogsDlg.this._ctrlTable.getSelectedRows();
                for (int i = 0; i < idxView.length; ++i) {
                    int idxModel = DBLogsDlg.this._ctrlTable.convertRowIndexToModel(idxView[i]);
                    DBLogs.Log dbLog = DBLogsDlg.this._listLogs.get(idxModel);
                    if (!DBLogsDlg.this._listFolders.get(idxModel).equals(DBLogsDlg.this._dbFolder) || dbLog.isPrivate() || dbLog.getLevel().compareTo(curLevel) <= 0) continue;
                    curLevel = dbLog.getLevel();
                }
                if (curLevel == DBLogs.DBLevel.FINEST) {
                    return;
                }
                class DeclassifiedDlg
                extends JDialogCecilia {
                    JComboBox _ctrlLevel;

                    DeclassifiedDlg(Window win, DBLogs.DBLevel level) {
                        super(win);
                        this._ctrlLevel = new JComboBox();
                        switch (level) {
                            case ERROR: {
                                this._ctrlLevel.addItem(DBLogs.DBLevel.WARNING);
                            }
                            case WARNING: {
                                this._ctrlLevel.addItem(DBLogs.DBLevel.INFO);
                            }
                            case INFO: {
                                this._ctrlLevel.addItem(DBLogs.DBLevel.FINE);
                            }
                            case FINE: {
                                this._ctrlLevel.addItem(DBLogs.DBLevel.FINER);
                            }
                            case FINER: {
                                this._ctrlLevel.addItem(DBLogs.DBLevel.FINEST);
                            }
                        }
                        this._ctrlLevel.setEditable(false);
                        this._ctrlLevel.setSelectedIndex(0);
                        this._ctrlLevel.setRenderer(DBLogs.DBLevel.getListCellRenderer());
                        JPanel centerPanel = new JPanel(new FlowLayout());
                        centerPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
                        centerPanel.add(new JLabel(ResMsgObj.getString("DLG_LOG_DECLASSIFIED")));
                        centerPanel.add(this._ctrlLevel);
                        Container content = this.getContentPane();
                        content.setLayout(new BorderLayout());
                        content.add((Component)centerPanel, "Center");
                        content.add((Component)this.createButPanel(), "South");
                        this.init();
                        this.setModal(true);
                        this.pack();
                        this.setMinimumSize(this.getSize());
                    }

                    @Override
                    protected boolean verifyParameters() {
                        return this.getSelectLevel() != null;
                    }

                    DBLogs.DBLevel getSelectLevel() {
                        return (DBLogs.DBLevel)((Object)this._ctrlLevel.getSelectedItem());
                    }
                }
                DeclassifiedDlg dlg = new DeclassifiedDlg(DBLogsDlg.this, curLevel);
                dlg.setTitle(DBLogsDlg.this.getTitle());
                dlg.setLocationRelativeTo(DBLogsDlg.this);
                dlg.setVisible(true);
                if (!dlg.getResult()) {
                    return;
                }
                curLevel = dlg.getSelectLevel();
                if (curLevel == null) {
                    return;
                }
                int nbr = 0;
                ArrayList<DBLogs.Log> chgLogs = new ArrayList<DBLogs.Log>(idxView.length);
                for (int i = 0; i < idxView.length; ++i) {
                    int idxModel = DBLogsDlg.this._ctrlTable.convertRowIndexToModel(idxView[i]);
                    DBLogs.Log dbLog = DBLogsDlg.this._listLogs.get(idxModel);
                    if (!DBLogsDlg.this._listFolders.get(idxModel).equals(DBLogsDlg.this._dbFolder) || dbLog.getLevel().compareTo(curLevel) <= 0) continue;
                    DBLogsDlg.this._dbLogs.changeLog(dbLog, curLevel);
                    chgLogs.add(dbLog);
                    ++nbr;
                }
                if (nbr > 0) {
                    DBLogsDlg.this.refreshData(chgLogs);
                    DBLogsDlg.this._isModified = true;
                }
            }
        };
        JToolBar toolbar = new JToolBar();
        toolbar.add(new JLabel(ResMsgVoc.getString("VOC_FILTER")));
        toolbar.add(Box.createRigidArea(CeciliaAction.RIGID_AREA));
        toolbar.add(this._ctrlFilter);
        toolbar.add(Box.createGlue());
        toolbar.add(this._actAdd.createButton(CeciliaAction.BorderStyle.LIGHT));
        toolbar.add(Box.createRigidArea(CeciliaAction.RIGID_AREA));
        toolbar.add(this._actEdit.createButton(CeciliaAction.BorderStyle.LIGHT));
        toolbar.add(Box.createRigidArea(CeciliaAction.RIGID_AREA));
        toolbar.add(this._actDeclassified.createButton(CeciliaAction.BorderStyle.LIGHT));
        toolbar.setBorder(CeciliaAction.STANDARD_BORDER);
        return toolbar;
    }

    static class DBLogsTable
    extends JTable
    implements JTableTransfertHandler.HelperConvert {
        DBLogsTable(TableModel model) {
            super(model);
        }

        @Override
        public String convertToString(Object obj, int row, int col) {
            if (obj instanceof Convertable) {
                return ((Convertable)obj).convertToString();
            }
            if (obj instanceof Date) {
                return _formatDate.format((Date)obj);
            }
            return obj.toString();
        }
    }

    class DBLogsTableModel
    extends AbstractTableModel {
        DBLogsTableModel() {
        }

        @Override
        public int getRowCount() {
            return DBLogsDlg.this._listLogs.size();
        }

        @Override
        public int getColumnCount() {
            return 5;
        }

        @Override
        public String getColumnName(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return ResMsgVoc.getString("VOC_PATH");
                }
                case 1: {
                    return ResMsgVoc.getString("VOC_LEVEL");
                }
                case 2: {
                    return ResMsgVoc.getString("VOC_DATE");
                }
                case 3: {
                    return ResMsgVoc.getString("VOC_USER");
                }
                case 4: {
                    return ResMsgVoc.getString("VOC_MESSAGE");
                }
            }
            return "<error>";
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return DBFolder.class;
                }
                case 1: {
                    return DBLogs.DBLevel.class;
                }
                case 2: {
                    return Date.class;
                }
                case 3: {
                    return String.class;
                }
                case 4: {
                    return String.class;
                }
            }
            return String.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return DBLogsDlg.this._listFolders.get(rowIndex);
                }
                case 1: {
                    return DBLogsDlg.this._listLogs.get(rowIndex).getLevel();
                }
                case 2: {
                    DBLogs.Log log = DBLogsDlg.this._listLogs.get(rowIndex);
                    if (log.getModif() != null) {
                        return log.getModif();
                    }
                    return log.getCreate();
                }
                case 3: {
                    return DBLogsDlg.this._listLogs.get(rowIndex).getUser();
                }
                case 4: {
                    return DBLogsDlg.this._listLogs.get(rowIndex).getMessage();
                }
            }
            return null;
        }
    }
}

