/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.general.log.gui;

import com.dassault.cecilia.core.ResIcoCore;
import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.dependencies.Generate;
import com.dassault.cecilia.core.cecilia.dependencies.Recup;
import com.dassault.cecilia.core.cecilia.pref.Preferencies;
import com.dassault.cecilia.core.plugin.PluginWithOptions;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBRelation;
import com.dassault.cecilia.db.dao.DAOFactory;
import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.general.log.GeneralLogsPreferencies;
import com.dassault.cecilia.dbobj.general.log.gui.DBLogsDlg;
import com.dassault.cecilia.dbobj.wrap.DBWrap;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Image;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.SwingUtilities;

public abstract class DBLogsUtility {
    JButton _logsButton = new JButton(ResMsgVoc.getString("VOC_LOGS"));
    DBLogsDlg _logsDlg;
    DBLogs _dbLogs;
    Map<DBFolder, List<DBLogs.Log>> _dependLogs;
    DBLogs.DBLevel _publicMaxLevel = DBLogs.DBLevel.ZERO;
    DBLogs.DBLevel _privateMaxLevel = DBLogs.DBLevel.ZERO;
    static ImageIcon __LOGS_WARNING = null;
    private Date _oldDateLogs = new Date();

    protected abstract DBWrap getWrap();

    protected abstract CECFactory getCECFactory();

    protected abstract Preferencies getPreferencies();

    protected void displayLogs() {
        if (this._logsDlg == null) {
            this._logsDlg = new DBLogsDlg(SwingUtilities.getWindowAncestor(this._logsButton), this.getLogLevel(true, DBLogs.DBLevel.INFO));
            this._logsDlg.setDBLogs(this._dbLogs, this.getWrap().getDBFolder(), this.getCECFactory().getUserLogin());
        }
        this._logsDlg.addDependLogs(this._dependLogs);
        this._logsDlg.refreshData();
        this._logsDlg.setVisible(true);
        if (this._logsDlg.isModified()) {
            this.refreshRelations(this.getWrap().getUseRelations());
        }
    }

    public DBLogs.DBLevel getMaxLevel() {
        return this._publicMaxLevel;
    }

    public boolean isModified() {
        if (this._logsDlg != null) {
            return this._logsDlg.isModified();
        }
        return false;
    }

    public void setModified(boolean modified) {
        if (this._logsDlg != null) {
            this._logsDlg.setModified(modified);
        }
    }

    public DBLogsUtility() {
        this._logsButton.addActionListener(e -> this.displayLogs());
        this.refreshRelations(null);
    }

    private void findLogs(Collection<DBRelation> relations) {
        this._dependLogs = new LinkedHashMap<DBFolder, List<DBLogs.Log>>();
        Generate<DBWrap> deps = new Generate<DBWrap>((DAOFactory)this.getCECFactory()){

            @Override
            protected Recup<DBWrap> makeRecup(DBFolder.Family key) {
                return new Recup<DBWrap>(key, this);
            }

            @Override
            protected DBWrap findOrCreate(DBFolder dbDest, DBFolder.Family family) {
                return DBLogsUtility.this.getCECFactory().findOrCreateWrap(dbDest);
            }
        };
        deps.prepare(this.getWrap().getDBFolder(), this.getWrap(), relations);
        DBLogs.DBLevel levelDep = this.getLogLevel(false, DBLogs.DBLevel.WARNING);
        for (DBFolder.Family key : deps.getKeys()) {
            for (DBWrap dep : deps.getValues(key)) {
                List<DBLogs.Log> logs;
                DBLogs depLogs;
                DBLogs.DBLevel depLevel;
                if (dep.equals(this.getWrap()) || (depLevel = (depLogs = dep.getLogs()).getMaxLevel()).compareTo(levelDep) < 0) continue;
                if (depLevel.compareTo(this._publicMaxLevel) > 0) {
                    this._publicMaxLevel = depLevel;
                }
                if (depLevel.compareTo(this._privateMaxLevel) > 0) {
                    this._privateMaxLevel = depLevel;
                }
                if ((logs = depLogs.getLogs(levelDep)) == null || logs.size() <= 0) continue;
                this._dependLogs.put(dep.getDBFolder(), logs);
            }
        }
    }

    private void updateLevel() {
        this._dbLogs = this.getWrap().getLogs();
        this._publicMaxLevel = this._dbLogs.getMaxLevel(true);
        this._privateMaxLevel = this._dbLogs.getMaxLevel(false);
    }

    private DBLogs.DBLevel getLogLevel(boolean display, DBLogs.DBLevel def) {
        PluginWithOptions pref = this.getPreferencies().getOptions(GeneralLogsPreferencies.PREF_KEY);
        if (pref == null) {
            return def;
        }
        if (!(pref instanceof GeneralLogsPreferencies)) {
            return def;
        }
        if (display) {
            return ((GeneralLogsPreferencies)pref).getLevelDisplay();
        }
        return ((GeneralLogsPreferencies)pref).getLevelDepends();
    }

    public void refreshRelations(Collection<DBRelation> relations) {
        this.updateLevel();
        this.findLogs(relations);
        this.updateButtonVisibility();
    }

    public void refreshButton() {
        this.updateLevel();
        this.updateButtonVisibility();
    }

    private void updateButtonVisibility() {
        boolean visible = this._privateMaxLevel.compareTo(this.getLogLevel(true, DBLogs.DBLevel.INFO)) >= 0;
        this._logsButton.setVisible(visible);
        if (visible) {
            Date lastDateLogs = this._oldDateLogs;
            for (DBLogs.Log log : this._dbLogs.getLogs(DBLogs.DBLevel.FINEST)) {
                if (log.getModif() != null) {
                    if (!lastDateLogs.before(log.getModif())) continue;
                    lastDateLogs = log.getModif();
                    continue;
                }
                if (!lastDateLogs.before(log.getCreate())) continue;
                lastDateLogs = log.getCreate();
            }
            if (lastDateLogs.after(this._oldDateLogs)) {
                this.updateText();
                this._oldDateLogs = lastDateLogs;
            }
        }
        if (this._privateMaxLevel.compareTo(DBLogs.DBLevel.WARNING) >= 0) {
            this._logsButton.setIcon(__LOGS_WARNING);
        } else {
            this._logsButton.setIcon(null);
        }
    }

    public Component getButLogs() {
        return this._logsButton;
    }

    public int getNbrLogs() {
        if (this._logsDlg == null) {
            return this._dbLogs.getLogs(DBLogs.DBLevel.INFO).size() + this._dependLogs.size();
        }
        return this._logsDlg.getNbrLogs();
    }

    private void updateText() {
        final Font oldFont = this._logsButton.getFont();
        final Color oldColor = this._logsButton.getForeground();
        final Timer timer = new Timer();
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                DBLogsUtility.this._logsButton.setFont(oldFont);
                DBLogsUtility.this._logsButton.setForeground(oldColor);
                timer.cancel();
            }
        }, 2000L);
        this._logsButton.setFont(new Font(oldFont.getName(), 1, oldFont.getSize()));
        this._logsButton.setForeground(Color.RED);
    }

    static {
        Image img = ResIcoCore.getInstance().getImage("LOGS_WARNING", 8, 21);
        if (img != null) {
            __LOGS_WARNING = new ImageIcon(img);
        }
    }
}

