/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.general.log.io;

import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.lib.util.xmlparser.SAXExtendedHandler;
import java.util.logging.Logger;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class SAXLogHandler
extends SAXExtendedHandler {
    private static Logger _LOG = Logger.getLogger(SAXLogHandler.class.getPackage().getName());
    DBLogs.DBLogsManager _logManager;

    public SAXLogHandler(DBLogs.DBLogsManager manager) {
        this._logManager = manager;
    }

    protected DBLogs.DBLogsManager getLogManager() {
        return this._logManager;
    }

    public void error(SAXParseException e) throws SAXException {
        if (this._logManager != null) {
            this._logManager.addLog(DBLogs.DBLevel.ERROR, e.getMessage(), false);
        }
        throw e;
    }

    public void warning(SAXParseException e) throws SAXException {
        if (this._logManager != null) {
            this._logManager.addLog(DBLogs.DBLevel.WARNING, e.getMessage(), false);
        } else {
            _LOG.warning(e.getMessage());
        }
    }

    protected void errorElementUnknown(String key) throws SAXException {
        this.error(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_ELEMENT_UNKNOWN", key, ((Object)((Object)this)).getClass().getName()), this.getLocator()));
    }
}

